/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.form.impl.custom;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.cumulus.Forms;
import org.geysermc.cumulus.component.Component;
import org.geysermc.cumulus.component.util.ComponentType;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.form.impl.custom.CustomFormImpl;
import org.geysermc.cumulus.form.util.FormType;
import org.geysermc.cumulus.form.util.impl.FormCodecImpl;
import org.geysermc.cumulus.response.CustomFormResponse;
import org.geysermc.cumulus.response.impl.CustomFormResponseImpl;
import org.geysermc.cumulus.response.result.FormResponseResult;
import org.geysermc.cumulus.util.AbsentComponent;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.cumulus.util.JsonUtils;
import org.geysermc.cumulus.util.impl.FormImageAdaptor;
import org.geysermc.cumulus.util.impl.FormImageImpl;

public final class CustomFormCodec
extends FormCodecImpl<CustomForm, CustomFormResponse> {
    CustomFormCodec() {
        super(CustomForm.class, FormType.CUSTOM_FORM);
    }

    @Override
    protected CustomForm deserializeForm(JsonObject source, JsonDeserializationContext context) {
        String title = JsonUtils.assumeMember(source, "title").getAsString();
        FormImage icon = (FormImage)context.deserialize(source.get("icon"), (Type)((Object)FormImageImpl.class));
        ArrayList<Component> content = new ArrayList<Component>();
        JsonArray contentArray = JsonUtils.assumeMember(source, "content").getAsJsonArray();
        for (JsonElement contentElement : contentArray) {
            String typeName = JsonUtils.assumeMember(contentElement.getAsJsonObject(), "type").getAsString();
            ComponentType type = ComponentType.fromName(typeName);
            if (type == null) {
                throw new JsonParseException("Failed to find Component type " + typeName);
            }
            content.add((Component)context.deserialize(contentElement, Forms.getComponentTypeImpl(type)));
        }
        return new CustomFormImpl(title, icon, content);
    }

    @Override
    protected void serializeForm(CustomForm form, JsonSerializationContext context, JsonObject result) {
        result.addProperty("title", form.title());
        result.add("icon", context.serialize(form.icon()));
        JsonArray content = new JsonArray();
        for (Component component : form.content()) {
            if (component == null) continue;
            content.add(context.serialize(component));
        }
        result.add("content", content);
    }

    @Override
    protected FormResponseResult<CustomFormResponse> deserializeResponse(@NonNull CustomForm form, @NonNull String responseData) {
        JsonArray responses = this.gson.fromJson(responseData, JsonArray.class);
        JsonArray responsesCopy = responses.deepCopy();
        ArrayList<Object> mappedResponse = new ArrayList<Object>();
        ArrayList<ComponentType> types = new ArrayList<ComponentType>();
        List<Component> content = form.content();
        for (int i = 0; i < content.size(); ++i) {
            Component component = content.get(i);
            if (component == null) {
                mappedResponse.add(AbsentComponent.instance());
                continue;
            }
            if (responses.isEmpty()) {
                return FormResponseResult.invalid(-1, "Response doesn't contain enough components");
            }
            try {
                JsonElement response = responses.remove(0);
                mappedResponse.add(this.validateComponent(component, response));
            }
            catch (Exception exception) {
                return FormResponseResult.invalid(i, exception.getMessage());
            }
            types.add(component.type());
        }
        if (!responses.isEmpty()) {
            return FormResponseResult.invalid(-1, "Response contains too many elements");
        }
        return FormResponseResult.valid(CustomFormResponseImpl.of(mappedResponse, responsesCopy, types));
    }

    private Object validateComponent(Component component, JsonElement element) {
        ComponentType type = component.type();
        if (type == ComponentType.LABEL) {
            if (element.isJsonNull()) {
                return null;
            }
            throw new IllegalStateException("Return value of label should be null");
        }
        if (!element.isJsonPrimitive()) {
            throw new IllegalStateException(String.format("Return value of %s should be a json primitive", type.componentName()));
        }
        JsonPrimitive value = element.getAsJsonPrimitive();
        switch (type) {
            case INPUT: {
                if (value.isString()) {
                    return value.getAsString();
                }
                throw new IllegalStateException("Return value of input should be a string");
            }
            case SLIDER: {
                if (value.isNumber()) {
                    return Float.valueOf(value.getAsFloat());
                }
                throw new IllegalStateException("Return value of slider should be a float");
            }
            case STEP_SLIDER: {
                if (value.isNumber()) {
                    return value.getAsInt();
                }
                throw new IllegalStateException("Return value of step slider should be an integer");
            }
            case TOGGLE: {
                if (value.isBoolean()) {
                    return value.getAsBoolean();
                }
                throw new IllegalStateException("Return value of toggle should be a boolean");
            }
            case DROPDOWN: {
                if (value.isNumber()) {
                    return value.getAsInt();
                }
                throw new IllegalStateException("Return value of dropdown should be an integer");
            }
        }
        throw new IllegalStateException("Type " + (Object)((Object)type) + " does not have validation implemented");
    }

    @Override
    protected void initializeGson(GsonBuilder builder) {
        super.initializeGson(builder);
        builder.registerTypeAdapter((Type)((Object)FormImage.class), new FormImageAdaptor());
    }
}

