/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.captions;

import cloud.commandframework.captions.Caption;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class StandardCaptionKeys {
    private static final Collection<Caption> RECOGNIZED_CAPTIONS = new LinkedList<Caption>();
    public static final Caption ARGUMENT_PARSE_FAILURE_NO_INPUT_PROVIDED = StandardCaptionKeys.of("argument.parse.failure.no_input_was_provided");
    public static final Caption ARGUMENT_PARSE_FAILURE_BOOLEAN = StandardCaptionKeys.of("argument.parse.failure.boolean");
    public static final Caption ARGUMENT_PARSE_FAILURE_NUMBER = StandardCaptionKeys.of("argument.parse.failure.number");
    public static final Caption ARGUMENT_PARSE_FAILURE_CHAR = StandardCaptionKeys.of("argument.parse.failure.char");
    public static final Caption ARGUMENT_PARSE_FAILURE_STRING = StandardCaptionKeys.of("argument.parse.failure.string");
    public static final Caption ARGUMENT_PARSE_FAILURE_UUID = StandardCaptionKeys.of("argument.parse.failure.uuid");
    public static final Caption ARGUMENT_PARSE_FAILURE_ENUM = StandardCaptionKeys.of("argument.parse.failure.enum");
    public static final Caption ARGUMENT_PARSE_FAILURE_REGEX = StandardCaptionKeys.of("argument.parse.failure.regex");
    public static final Caption ARGUMENT_PARSE_FAILURE_FLAG_UNKNOWN_FLAG = StandardCaptionKeys.of("argument.parse.failure.flag.unknown");
    public static final Caption ARGUMENT_PARSE_FAILURE_FLAG_DUPLICATE_FLAG = StandardCaptionKeys.of("argument.parse.failure.flag.duplicate_flag");
    public static final Caption ARGUMENT_PARSE_FAILURE_FLAG_NO_FLAG_STARTED = StandardCaptionKeys.of("argument.parse.failure.flag.no_flag_started");
    public static final Caption ARGUMENT_PARSE_FAILURE_FLAG_MISSING_ARGUMENT = StandardCaptionKeys.of("argument.parse.failure.flag.missing_argument");
    public static final Caption ARGUMENT_PARSE_FAILURE_COLOR = StandardCaptionKeys.of("argument.parse.failure.color");

    private StandardCaptionKeys() {
    }

    private static @NonNull Caption of(@NonNull String key) {
        Caption caption = Caption.of(key);
        RECOGNIZED_CAPTIONS.add(caption);
        return caption;
    }

    public static @NonNull Collection<@NonNull Caption> getStandardCaptionKeys() {
        return Collections.unmodifiableCollection(RECOGNIZED_CAPTIONS);
    }
}

