/*
 * Decompiled with CFR 0.152.
 */
package eu.codedsakura.fabrichomes.components;

import eu.codedsakura.fabrichomes.components.HomeComponent;
import eu.codedsakura.fabrichomes.components.IHomeDataComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class HomeDataComponent
implements IHomeDataComponent {
    private final List<HomeComponent> homes = new ArrayList<HomeComponent>();
    private int maxHomes;

    public void readFromNbt(class_2487 tag) {
        this.homes.clear();
        tag.method_10554("homes", 10).forEach(v -> this.homes.add(HomeComponent.readFromNbt((class_2487)v)));
        this.maxHomes = tag.method_10550("maxHomes");
    }

    public void writeToNbt(class_2487 tag) {
        class_2499 homeTag = new class_2499();
        this.homes.forEach(v -> {
            class_2487 ct = new class_2487();
            v.writeToNbt(ct);
            homeTag.add((Object)ct);
        });
        tag.method_10566("homes", (class_2520)homeTag);
        tag.method_10569("maxHomes", this.maxHomes);
    }

    @Override
    public List<HomeComponent> getHomes() {
        return this.homes;
    }

    @Override
    public int getMaxHomes() {
        return this.maxHomes;
    }

    @Override
    public boolean addHome(HomeComponent home) {
        if (this.homes.stream().anyMatch(v -> v.getName().equalsIgnoreCase(home.getName()))) {
            return false;
        }
        return this.homes.add(home);
    }

    @Override
    public boolean removeHome(String name) {
        if (this.homes.stream().noneMatch(v -> v.getName().equalsIgnoreCase(name))) {
            return false;
        }
        return this.homes.removeIf(v -> v.getName().equalsIgnoreCase(name));
    }
}

