/*
 * Decompiled with CFR 0.152.
 */
package eu.codedsakura.fabrichomes;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import eu.codedsakura.fabrichomes.components.HomeComponent;
import eu.codedsakura.fabrichomes.components.IHomeDataComponent;
import eu.codedsakura.fabrichomes.components.PlayerComponentInitializer;
import eu.codedsakura.mods.ConfigUtils;
import eu.codedsakura.mods.TeleportUtils;
import eu.codedsakura.mods.TextUtils;
import eu.codedsakura.mods.fpapiutils.FPAPIUtilsWrapper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FabricHomes
implements ModInitializer {
    public static final Logger logger = LogManager.getLogger((String)"FabricHomes");
    private static final String CONFIG_NAME = "FabricHomes.properties";
    private final HashMap<UUID, Long> recentRequests = new HashMap();
    private ConfigUtils config;

    public void onInitialize() {
        logger.info("Initializing...");
        this.config = new ConfigUtils(FabricLoader.getInstance().getConfigDir().resolve(CONFIG_NAME).toFile(), logger, Arrays.asList(new ConfigUtils.IntegerConfigValue("stand-still", 3, new ConfigUtils.IntegerConfigValue.IntLimits(0), new ConfigUtils.Command("Stand-Still time is %s seconds", "Stand-Still time set to %s seconds")), new ConfigUtils.IntegerConfigValue("cooldown", 30, new ConfigUtils.IntegerConfigValue.IntLimits(0), new ConfigUtils.Command("Cooldown is %s seconds", "Cooldown set to %s seconds")), new ConfigUtils.BooleanConfigValue("bossbar", true, new ConfigUtils.Command("Boss-Bar on: %s", "Boss-Bar is now: %s")), new ConfigUtils.IntegerConfigValue("max-homes", 2, new ConfigUtils.IntegerConfigValue.IntLimits(0), new ConfigUtils.Command("Max available homes is %s", "Max homes set to %s"))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registry, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"home").requires(FPAPIUtilsWrapper.require("fabrichomes.home", true))).executes(ctx -> this.homeInit((CommandContext<class_2168>)ctx, null))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(this::getHomeSuggestions).executes(ctx -> this.homeInit((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sethome").requires(FPAPIUtilsWrapper.require("fabrichomes.sethome", true))).executes(ctx -> this.homeSet((CommandContext<class_2168>)ctx, null))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.homeSet((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delhome").requires(FPAPIUtilsWrapper.require("fabrichomes.delhome", true))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(this::getHomeSuggestions).executes(ctx -> this.homeDel((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"homes").executes(this::homeList)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(FPAPIUtilsWrapper.require("fabrichomes.homes.list", true))).executes(this::homeList)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(FPAPIUtilsWrapper.require("fabrichomes.homes.list_player", 2))).executes(ctx -> this.homeList((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"gui").requires(req -> false)).requires(FPAPIUtilsWrapper.require("fabrichomes.homes.gui", true))).executes(ctx -> 0))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").requires(FPAPIUtilsWrapper.require("fabrichomes.homes.delete", true))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(this::getHomeSuggestions).executes(ctx -> this.homeDel((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(this.config.generateCommand("config", FPAPIUtilsWrapper.require("fabrichomes.confg", 2))));
        });
    }

    private boolean checkCooldown(class_3222 tFrom) {
        long diff;
        if (this.recentRequests.containsKey(tFrom.method_5667()) && (diff = Instant.now().getEpochSecond() - this.recentRequests.get(tFrom.method_5667())) < (long)((Integer)this.config.getValue("cooldown")).intValue()) {
            tFrom.method_7353((class_2561)class_2561.method_43469((String)"You cannot make teleport home for %s more seconds!", (Object[])new Object[]{String.valueOf((long)((Integer)this.config.getValue("cooldown")).intValue() - diff)}).method_27692(class_124.field_1061), false);
            return true;
        }
        return false;
    }

    private CompletableFuture<Suggestions> getHomeSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String start = builder.getRemaining().toLowerCase();
        ((IHomeDataComponent)PlayerComponentInitializer.HOME_DATA.get((Object)((class_2168)context.getSource()).method_44023())).getHomes().stream().map(HomeComponent::getName).sorted(String::compareToIgnoreCase).filter(v -> v.toLowerCase().startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    int homeInit(CommandContext<class_2168> ctx, String name) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (name == null) {
            name = "main";
        }
        String finalName = name;
        Optional<HomeComponent> home = ((IHomeDataComponent)PlayerComponentInitializer.HOME_DATA.get((Object)player)).getHomes().stream().filter(v -> v.getName().equals(finalName)).findFirst();
        if (home.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43470((String)"This home does not exist").method_27692(class_124.field_1061), false);
            return 0;
        }
        if (this.checkCooldown(player)) {
            return 1;
        }
        TeleportUtils.genericTeleport((Boolean)this.config.getValue("bossbar"), ((Integer)this.config.getValue("stand-still")).intValue(), player, () -> {
            player.method_14251(((class_2168)ctx.getSource()).method_9211().method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)((HomeComponent)home.get()).getDimID())), ((HomeComponent)home.get()).getX(), ((HomeComponent)home.get()).getY(), ((HomeComponent)home.get()).geyZ(), ((HomeComponent)home.get()).getYaw(), ((HomeComponent)home.get()).getPitch());
            this.recentRequests.put(player.method_5667(), Instant.now().getEpochSecond());
        });
        return 1;
    }

    int homeSet(CommandContext<class_2168> ctx, String name) throws CommandSyntaxException {
        Optional<HomeComponent> home;
        if (name == null) {
            name = "main";
        }
        if (((IHomeDataComponent)PlayerComponentInitializer.HOME_DATA.get((Object)((class_2168)ctx.getSource()).method_44023())).getHomes().size() >= (Integer)this.config.getValue("max-homes")) {
            ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Home limit reached!").method_27692(class_124.field_1061), false);
            return 1;
        }
        if (((IHomeDataComponent)PlayerComponentInitializer.HOME_DATA.get((Object)((class_2168)ctx.getSource()).method_44023())).addHome(new HomeComponent(((class_2168)ctx.getSource()).method_9222(), ((class_2168)ctx.getSource()).method_44023().method_36455(), ((class_2168)ctx.getSource()).method_44023().method_36454(), ((class_2168)ctx.getSource()).method_9225().method_27983().method_29177(), name))) {
            String finalName = name;
            home = ((IHomeDataComponent)PlayerComponentInitializer.HOME_DATA.get((Object)((class_2168)ctx.getSource()).method_44023())).getHomes().stream().filter(v -> v.getName().equals(finalName)).findFirst();
            if (home.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Something went wrong adding the home!").method_27692(class_124.field_1061), true);
                return 1;
            }
        } else {
            ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Couldn't add the home (probably already exists)!").method_27692(class_124.field_1061), false);
            return 1;
        }
        ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43469((String)"Home %s added successfully!", (Object[])new Object[]{class_2561.method_43470((String)name).method_27694(s -> s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)((HomeComponent)home.get()).toText(((class_2168)ctx.getSource()).method_9211()))).method_10977(class_124.field_1065))}).method_27692(class_124.field_1076), false);
        return 1;
    }

    int homeDel(CommandContext<class_2168> ctx, String name) throws CommandSyntaxException {
        if (((IHomeDataComponent)PlayerComponentInitializer.HOME_DATA.get((Object)((class_2168)ctx.getSource()).method_44023())).removeHome(name)) {
            Optional<HomeComponent> home = ((IHomeDataComponent)PlayerComponentInitializer.HOME_DATA.get((Object)((class_2168)ctx.getSource()).method_44023())).getHomes().stream().filter(v -> v.getName().equals(name)).findFirst();
            if (home.isPresent()) {
                ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Something went wrong removing the home!").method_27692(class_124.field_1061), true);
                return 1;
            }
        } else {
            ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Couldn't remove the home!").method_27692(class_124.field_1061), false);
            return 1;
        }
        ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43469((String)"Home %s deleted successfully!", (Object[])new Object[]{class_2561.method_43470((String)name).method_27692(class_124.field_1065)}).method_27692(class_124.field_1076), false);
        return 1;
    }

    int homeList(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        if (!FPAPIUtilsWrapper.check((class_2168)ctx.getSource(), "fabrichomes.homes.list", true)) {
            return 0;
        }
        return this.homeList(ctx, ((class_2168)ctx.getSource()).method_44023());
    }

    int homeList(CommandContext<class_2168> ctx, class_3222 player) {
        List<HomeComponent> homes = ((IHomeDataComponent)PlayerComponentInitializer.HOME_DATA.get((Object)player)).getHomes();
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        homes.stream().sorted((h1, h2) -> h1.getName().compareToIgnoreCase(h2.getName())).forEach(h -> list.add((class_2561)class_2561.method_43470((String)h.getName()).method_27694(s -> s.method_10958(new class_2558(class_2558.class_2559.field_11750, "/home " + h.getName())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Click to teleport.\n").method_27692(class_124.field_1056)).method_10852((class_2561)h.toText(((class_2168)ctx.getSource()).method_9211())))).method_10977(class_124.field_1065))));
        ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43469((String)"%s/%s:\n", (Object[])new Object[]{homes.size(), this.config.getValue("max-homes")}).method_10852((class_2561)TextUtils.join(list, (class_2561)class_2561.method_43470((String)", "))), false);
        return 1;
    }
}

