/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin.bettermipmaps;

import net.minecraft.class_4725;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_4725.class})
public class MixinMipmapGenerator {
    private static final float[] SRGB_TO_LINEAR = new float[256];

    @Overwrite
    private static int method_24101(int n, int n2, int n3, int n4, boolean bl) {
        return MixinMipmapGenerator.weightedAverageColor(MixinMipmapGenerator.weightedAverageColor(n, n2), MixinMipmapGenerator.weightedAverageColor(n3, n4));
    }

    @Unique
    private static int unpackAlpha(int n) {
        return n >>> 24 & 0xFF;
    }

    @Unique
    private static int weightedAverageColor(int n, int n2) {
        int n3;
        int n4 = MixinMipmapGenerator.unpackAlpha(n);
        if (n4 == (n3 = MixinMipmapGenerator.unpackAlpha(n2))) {
            return MixinMipmapGenerator.averageRgb(n, n2, n4);
        }
        if (n4 == 0) {
            return n2 & 0xFFFFFF | n3 / 4 << 24;
        }
        if (n3 == 0) {
            return n & 0xFFFFFF | n4 / 4 << 24;
        }
        float f = 1.0f / (float)(n4 + n3);
        float f2 = (float)n4 * f;
        float f3 = (float)n3 * f;
        float f4 = MixinMipmapGenerator.unpackLinearComponent(n, 0) * f2;
        float f5 = MixinMipmapGenerator.unpackLinearComponent(n, 8) * f2;
        float f6 = MixinMipmapGenerator.unpackLinearComponent(n, 16) * f2;
        float f7 = MixinMipmapGenerator.unpackLinearComponent(n2, 0) * f3;
        float f8 = MixinMipmapGenerator.unpackLinearComponent(n2, 8) * f3;
        float f9 = MixinMipmapGenerator.unpackLinearComponent(n2, 16) * f3;
        float f10 = f4 + f7;
        float f11 = f5 + f8;
        float f12 = f6 + f9;
        int n5 = (n4 + n3) / 2;
        return MixinMipmapGenerator.packLinearToSrgb(f10, f11, f12, n5);
    }

    @Unique
    private static float unpackLinearComponent(int n, int n2) {
        return SRGB_TO_LINEAR[n >> n2 & 0xFF];
    }

    @Unique
    private static int packLinearToSrgb(float f, float f2, float f3, int n) {
        int n2 = (int)(Math.pow(f, 0.45454545454545453) * 255.0);
        int n3 = (int)(Math.pow(f2, 0.45454545454545453) * 255.0);
        int n4 = (int)(Math.pow(f3, 0.45454545454545453) * 255.0);
        return n << 24 | n4 << 16 | n3 << 8 | n2;
    }

    @Unique
    private static int averageRgb(int n, int n2, int n3) {
        float f = MixinMipmapGenerator.unpackLinearComponent(n, 0);
        float f2 = MixinMipmapGenerator.unpackLinearComponent(n, 8);
        float f3 = MixinMipmapGenerator.unpackLinearComponent(n, 16);
        float f4 = MixinMipmapGenerator.unpackLinearComponent(n2, 0);
        float f5 = MixinMipmapGenerator.unpackLinearComponent(n2, 8);
        float f6 = MixinMipmapGenerator.unpackLinearComponent(n2, 16);
        return MixinMipmapGenerator.packLinearToSrgb((f + f4) / 2.0f, (f2 + f5) / 2.0f, (f3 + f6) / 2.0f, n3);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            MixinMipmapGenerator.SRGB_TO_LINEAR[i] = (float)Math.pow((double)i / 255.0, 2.2);
        }
    }
}

