/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.transform;

import java.util.function.Supplier;
import net.coderbot.iris.shaderpack.transform.StringTransformations;
import net.coderbot.iris.shaderpack.transform.Transformations;

class Tests {
    Tests() {
    }

    public static void main(String[] stringArray) {
        Tests.test("basic injection", "#version\n//Injected\n//After", () -> {
            StringTransformations stringTransformations = new StringTransformations("#version\n//After");
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "//Injected");
            return stringTransformations.toString();
        });
        Tests.test("inject with content before #version", "// Example prefix\n\n#version\n//Injected\n//After", () -> {
            StringTransformations stringTransformations = new StringTransformations("// Example prefix\n\n#version\n//After");
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "//Injected");
            return stringTransformations.toString();
        });
        Tests.test("multiple injections", "// Example prefix\n\n#version\n//Injected\n//After", () -> {
            StringTransformations stringTransformations = new StringTransformations("// Example prefix\n\n#version\n//After");
            stringTransformations.injectLine(Transformations.InjectionPoint.DEFINES, "//Injected");
            return stringTransformations.toString();
        });
    }

    private static <T> void test(String string, T t, Supplier<T> supplier) {
        T t2;
        try {
            t2 = supplier.get();
        }
        catch (Throwable throwable) {
            System.err.println("Test \"" + string + "\" failed with an exception:");
            throwable.printStackTrace();
            return;
        }
        if (!t.equals(t2)) {
            System.err.println("Test \"" + string + "\" failed: Expected " + t + ", got " + t2);
        } else {
            System.out.println("Test \"" + string + "\" passed");
        }
    }
}

