/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.IntSupplier;
import net.coderbot.iris.gl.uniform.Uniform;
import net.coderbot.iris.gl.uniform.ValueUpdateNotifier;

public class IntUniform
extends Uniform {
    private int cachedValue = 0;
    private final IntSupplier value;

    IntUniform(int n, IntSupplier intSupplier) {
        this(n, intSupplier, null);
    }

    IntUniform(int n, IntSupplier intSupplier, ValueUpdateNotifier valueUpdateNotifier) {
        super(n, valueUpdateNotifier);
        this.value = intSupplier;
    }

    @Override
    public void update() {
        this.updateValue();
        if (this.notifier != null) {
            this.notifier.setListener(this::updateValue);
        }
    }

    private void updateValue() {
        int n = this.value.getAsInt();
        if (this.cachedValue != n) {
            this.cachedValue = n;
            RenderSystem.glUniform1i((int)this.location, (int)n);
        }
    }
}

