/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.utils;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.wesley1808.servercore.common.ServerCore;
import me.wesley1808.servercore.common.utils.ChunkManager;
import me.wesley1808.servercore.common.utils.DynamicManager;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5562;

public final class Statistics {
    public static ImmutableList<class_1297> getAllEntities() {
        return Statistics.getAll(class_3218::method_27909);
    }

    public static ImmutableList<class_5562> getAllBlockEntities() {
        return Statistics.getAll(level -> level.field_27082);
    }

    public static Map<String, Integer> getEntitiesByType(Iterable<class_1297> entities) {
        return Statistics.getByType(entities, entity -> class_1299.method_5890((class_1299)entity.method_5864()).toString());
    }

    public static Map<String, Integer> getBlockEntitiesByType(Iterable<class_5562> blockEntities) {
        return Statistics.getByType(blockEntities, class_5562::method_31706);
    }

    public static Map<String, Integer> getEntitiesByPlayer(Iterable<class_3222> players) {
        return Statistics.getByPlayer(players, Statistics::getEntitiesNear);
    }

    public static Map<String, Integer> getBlockEntitiesByPlayer(Iterable<class_3222> players) {
        return Statistics.getByPlayer(players, Statistics::getBlockEntitiesNear);
    }

    private static <T> ImmutableList<T> getAll(Function<class_3218, Iterable<T>> function) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (class_3218 level : ServerCore.getServer().method_3738()) {
            builder.addAll(function.apply(level));
        }
        return builder.build();
    }

    private static <T> Map<String, Integer> getByType(Iterable<T> iterable, Function<T, String> function) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (T value : iterable) {
            map.addTo((Object)function.apply(value), 1);
        }
        return map;
    }

    private static Map<String, Integer> getByPlayer(Iterable<class_3222> players, Function<class_3222, List<?>> function) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (class_3222 player : players) {
            map.put((Object)player.method_5820(), function.apply(player).size());
        }
        return map;
    }

    public static ImmutableList<class_1297> getEntitiesNear(class_3222 player) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (class_1297 entity : player.method_14220().method_27909()) {
            if (!Statistics.isNearby((class_1657)player, entity.method_31476())) continue;
            builder.add((Object)entity);
        }
        return builder.build();
    }

    public static ImmutableList<class_5562> getBlockEntitiesNear(class_3222 player) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (class_5562 blockEntity : player.field_6002.field_27082) {
            if (!Statistics.isNearby((class_1657)player, new class_1923(blockEntity.method_31705()))) continue;
            builder.add((Object)blockEntity);
        }
        return builder.build();
    }

    public static int getLoadedChunkCount() {
        int count = 0;
        for (class_3218 level : ServerCore.getServer().method_3738()) {
            for (class_3193 holder : level.method_14178().field_17254.method_17264()) {
                if (!ChunkManager.isChunkLoaded(holder)) continue;
                ++count;
            }
        }
        return count;
    }

    private static boolean isNearby(class_1657 player, class_1923 pos) {
        return player.method_31476().method_24022(pos) <= DynamicManager.getViewDistance();
    }
}

