/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.utils;

import java.math.BigDecimal;
import me.lucko.spark.api.SparkProvider;
import me.lucko.spark.api.statistic.StatisticWindow;
import me.lucko.spark.api.statistic.misc.DoubleAverageInfo;
import me.lucko.spark.api.statistic.types.GenericStatistic;
import me.wesley1808.servercore.common.ServerCore;
import me.wesley1808.servercore.common.config.tables.CommandConfig;
import me.wesley1808.servercore.common.config.tables.DynamicConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1923;
import net.minecraft.class_1934;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;

public final class DynamicManager {
    private static final boolean SPARK_LOADED = FabricLoader.getInstance().isModLoaded("spark");
    private static final BigDecimal VALUE = new BigDecimal("0.1");
    private static BigDecimal mobcapModifier = new BigDecimal(String.valueOf(DynamicConfig.MAX_MOBCAP.get()));
    private static GenericStatistic<DoubleAverageInfo, StatisticWindow.MillisPerTick> tickStatistics;
    private static double averageTickTime;
    private static int viewDistance;
    private static int simulationDistance;
    private static int chunkTickDistance;

    public static void initValues(class_3324 playerList) {
        viewDistance = playerList.method_14568();
        simulationDistance = playerList.method_38651();
        chunkTickDistance = DynamicConfig.MAX_CHUNK_TICK_DISTANCE.get();
        if (DynamicConfig.ENABLED.get().booleanValue()) {
            int maxViewDistance = DynamicConfig.MAX_VIEW_DISTANCE.get();
            int maxSimDistance = DynamicConfig.MAX_SIMULATION_DISTANCE.get();
            if (viewDistance > maxViewDistance) {
                DynamicManager.modifyViewDistance(maxViewDistance);
            }
            if (simulationDistance > maxSimDistance) {
                DynamicManager.modifySimulationDistance(maxSimDistance);
            }
        }
    }

    public static void update(MinecraftServer server) {
        DynamicManager.updateValues(server);
        DynamicManager.runPerformanceChecks(server);
    }

    private static void updateValues(MinecraftServer server) {
        if (server.method_3780() % 20 == 0) {
            if (SPARK_LOADED && tickStatistics == null) {
                tickStatistics = SparkProvider.get().mspt();
            }
            averageTickTime = tickStatistics != null ? ((DoubleAverageInfo)tickStatistics.poll((Enum)StatisticWindow.MillisPerTick.SECONDS_10)).median() : (double)server.method_3830();
        }
    }

    private static void runPerformanceChecks(MinecraftServer server) {
        if (DynamicConfig.ENABLED.get().booleanValue()) {
            double targetMspt = DynamicConfig.TARGET_MSPT.get().intValue();
            double upperBound = targetMspt + 5.0;
            double lowerBound = Math.max(targetMspt - 5.0, 2.0);
            if (server.method_3780() % (DynamicConfig.VIEW_DISTANCE_UPDATE_RATE.get() * 20) == 0) {
                DynamicManager.checkViewDistance(upperBound, lowerBound);
            }
            if (server.method_3780() % (DynamicConfig.UPDATE_RATE.get() * 20) == 0) {
                DynamicManager.checkSimulationDistance(upperBound, lowerBound);
                DynamicManager.checkMobcaps(upperBound, lowerBound);
                DynamicManager.checkChunkTickDistance(upperBound, lowerBound);
            }
        }
    }

    private static void checkChunkTickDistance(double upperBound, double lowerBound) {
        if (averageTickTime > upperBound && chunkTickDistance > DynamicConfig.MIN_CHUNK_TICK_DISTANCE.get()) {
            --chunkTickDistance;
        } else if (averageTickTime < lowerBound && chunkTickDistance < DynamicConfig.MAX_CHUNK_TICK_DISTANCE.get() && mobcapModifier.doubleValue() >= DynamicConfig.MAX_MOBCAP.get()) {
            ++chunkTickDistance;
        }
    }

    private static void checkMobcaps(double upperBound, double lowerBound) {
        if (averageTickTime > upperBound && mobcapModifier.doubleValue() > DynamicConfig.MIN_MOBCAP.get() && chunkTickDistance <= DynamicConfig.MIN_CHUNK_TICK_DISTANCE.get()) {
            mobcapModifier = mobcapModifier.subtract(VALUE);
        } else if (averageTickTime < lowerBound && mobcapModifier.doubleValue() < DynamicConfig.MAX_MOBCAP.get() && simulationDistance >= DynamicConfig.MAX_SIMULATION_DISTANCE.get()) {
            mobcapModifier = mobcapModifier.add(VALUE);
        }
    }

    private static void checkSimulationDistance(double upperBound, double lowerBound) {
        if (averageTickTime > upperBound && simulationDistance > DynamicConfig.MIN_SIMULATION_DISTANCE.get() && mobcapModifier.doubleValue() <= DynamicConfig.MIN_MOBCAP.get()) {
            DynamicManager.modifySimulationDistance(simulationDistance - 1);
        } else if (averageTickTime < lowerBound && simulationDistance < DynamicConfig.MAX_SIMULATION_DISTANCE.get() && viewDistance >= DynamicConfig.MAX_VIEW_DISTANCE.get()) {
            DynamicManager.modifySimulationDistance(simulationDistance + 1);
        }
    }

    private static void checkViewDistance(double upperBound, double lowerBound) {
        if (averageTickTime > upperBound && viewDistance > DynamicConfig.MIN_VIEW_DISTANCE.get() && simulationDistance <= DynamicConfig.MIN_SIMULATION_DISTANCE.get()) {
            DynamicManager.modifyViewDistance(viewDistance - 1);
        } else if (averageTickTime < lowerBound && viewDistance < DynamicConfig.MAX_VIEW_DISTANCE.get()) {
            DynamicManager.modifyViewDistance(viewDistance + 1);
        }
    }

    public static void modifyViewDistance(int distance) {
        ServerCore.getServer().method_3760().method_14608(distance);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            class_310.method_1551().field_1690.method_42503().method_41748((Object)distance);
        }
    }

    public static void modifySimulationDistance(int distance) {
        ServerCore.getServer().method_3760().method_38650(distance);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            class_310.method_1551().field_1690.method_42510().method_41748((Object)distance);
        }
    }

    public static boolean shouldTickChunk(class_1923 pos, class_3218 level) {
        if (chunkTickDistance >= viewDistance) {
            return true;
        }
        for (class_3222 player : level.method_18456()) {
            if (player.field_13974.method_14257() == class_1934.field_9219 || player.method_31476().method_24022(pos) > chunkTickDistance) continue;
            return true;
        }
        return false;
    }

    public static String createStatusReport(String title) {
        return title + "\n" + CommandConfig.STATUS_CONTENT.get().replace("${version}", ServerCore.getVersion()).replace("${mobcap_modifier}", DynamicManager.getModifierAsString()).replace("${view_distance}", String.valueOf(viewDistance)).replace("${simulation_distance}", String.valueOf(simulationDistance)).replace("${chunk_tick_distance}", String.valueOf(chunkTickDistance));
    }

    public static void setModifier(BigDecimal modifier) {
        mobcapModifier = modifier;
    }

    public static double getAverageTickTime() {
        return averageTickTime;
    }

    public static int getViewDistance() {
        return viewDistance;
    }

    public static void setViewDistance(int distance) {
        viewDistance = distance;
    }

    public static int getSimulationDistance() {
        return simulationDistance;
    }

    public static void setSimulationDistance(int distance) {
        simulationDistance = distance;
    }

    public static int getChunkTickDistance() {
        return chunkTickDistance;
    }

    public static void setChunkTickDistance(int distance) {
        chunkTickDistance = distance;
    }

    public static double getMobcapModifier() {
        return mobcapModifier.doubleValue();
    }

    public static String getModifierAsString() {
        return String.format("%.1f", mobcapModifier.doubleValue());
    }

    static {
        averageTickTime = 0.0;
    }
}

