/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.utils;

import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import me.wesley1808.servercore.common.ServerCore;
import me.wesley1808.servercore.common.config.tables.ActivationRangeConfig;
import me.wesley1808.servercore.common.interfaces.activation_range.ActivationEntity;
import me.wesley1808.servercore.common.interfaces.activation_range.IGoalSelector;
import me.wesley1808.servercore.common.interfaces.activation_range.ILevel;
import me.wesley1808.servercore.common.interfaces.activation_range.IPathFinderMob;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1307;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1420;
import net.minecraft.class_1421;
import net.minecraft.class_1429;
import net.minecraft.class_1472;
import net.minecraft.class_1480;
import net.minecraft.class_1501;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1528;
import net.minecraft.class_1538;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1571;
import net.minecraft.class_1621;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1671;
import net.minecraft.class_1672;
import net.minecraft.class_1685;
import net.minecraft.class_1690;
import net.minecraft.class_1700;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3763;
import net.minecraft.class_3855;
import net.minecraft.class_3857;
import net.minecraft.class_4095;
import net.minecraft.class_4168;
import net.minecraft.class_4466;
import net.minecraft.class_4760;
import net.minecraft.class_7260;

public final class ActivationRange {
    private static final class_4168[] VILLAGER_PANIC_IMMUNITIES = new class_4168[]{class_4168.field_19043, class_4168.field_19042, class_4168.field_19041, class_4168.field_18599};

    public static ActivationType initializeEntityActivationType(class_1297 entity) {
        if (entity instanceof class_3763) {
            return ActivationType.RAIDER;
        }
        if (entity instanceof class_1480) {
            return ActivationType.WATER;
        }
        if (entity instanceof class_1646) {
            return ActivationType.VILLAGER;
        }
        if (entity.method_5864() == class_1299.field_6051 || entity.method_5864() == class_1299.field_6071) {
            return ActivationType.ZOMBIE;
        }
        if (entity instanceof class_1548 || entity instanceof class_1621 || entity instanceof class_4760) {
            return ActivationType.MONSTER_BELOW;
        }
        if (entity instanceof class_1307) {
            return ActivationType.FLYING;
        }
        if (entity instanceof class_1569) {
            return ActivationType.MONSTER;
        }
        if (entity instanceof class_1296 || entity instanceof class_1421) {
            return ActivationType.ANIMAL;
        }
        if (entity instanceof class_1314) {
            return ActivationType.NEUTRAL;
        }
        return ActivationType.MISC;
    }

    public static boolean isExcluded(class_1297 entity) {
        return ((ActivationEntity)entity).getActivationType().activationRange.getAsInt() <= 0 || entity instanceof class_1657 || entity instanceof class_3857 || entity instanceof class_1510 || entity instanceof class_1508 || entity instanceof class_1528 || entity instanceof class_3855 || entity instanceof class_1538 || entity instanceof class_1541 || entity instanceof class_1511 || entity instanceof class_1671 || entity instanceof class_1672 || entity instanceof class_1685 || entity instanceof class_1571 || entity instanceof class_7260 || entity instanceof class_1700;
    }

    public static void activateEntities(class_3218 level) {
        int maxRange = Integer.MIN_VALUE;
        for (ActivationType type : ActivationType.values()) {
            maxRange = Math.max(type.activationRange.getAsInt(), maxRange);
        }
        ILevel info = (ILevel)level;
        info.setRemainingAnimals(Math.min(info.getRemainingAnimals() + 1, ActivationRangeConfig.ANIMAL_WAKEUP_MAX.get()));
        info.setRemainingVillagers(Math.min(info.getRemainingVillagers() + 1, ActivationRangeConfig.VILLAGER_WAKEUP_MAX.get()));
        info.setRemainingMonsters(Math.min(info.getRemainingMonsters() + 1, ActivationRangeConfig.MONSTER_WAKEUP_MAX.get()));
        info.setRemainingFlying(Math.min(info.getRemainingFlying() + 1, ActivationRangeConfig.FLYING_WAKEUP_MAX.get()));
        maxRange = Math.min((ServerCore.getServer().method_3760().method_14568() << 4) - 8, maxRange);
        for (class_3222 player : level.method_18456()) {
            class_238 maxBB;
            if (player.method_7325()) continue;
            if (ActivationRangeConfig.USE_VERTICAL_RANGE.get().booleanValue()) {
                maxBB = player.method_5829().method_1009((double)maxRange, 128.0, (double)maxRange);
                for (ActivationType type : ActivationType.values()) {
                    type.boundingBox = player.method_5829().method_1014((double)type.activationRange.getAsInt());
                    if (type.extraHeightUp) {
                        type.boundingBox = type.boundingBox.method_1012(0.0, 96.0, 0.0);
                    }
                    if (!type.extraHeightDown) continue;
                    type.boundingBox = type.boundingBox.method_1012(0.0, -96.0, 0.0);
                }
            } else {
                maxBB = player.method_5829().method_1009((double)maxRange, 256.0, (double)maxRange);
                for (ActivationType type : ActivationType.values()) {
                    int range = type.activationRange.getAsInt();
                    type.boundingBox = player.method_5829().method_1009((double)range, 256.0, (double)range);
                }
            }
            for (class_1297 entity : level.method_8335((class_1297)player, maxBB)) {
                ActivationRange.activateEntity(entity);
            }
        }
    }

    private static void activateEntity(class_1297 entity) {
        ActivationEntity activationEntity = (ActivationEntity)entity;
        int currentTick = ServerCore.getServer().method_3780();
        if (currentTick > activationEntity.getActivatedTick() && (activationEntity.isExcluded() || activationEntity.getActivationType().boundingBox.method_994(entity.method_5829()))) {
            activationEntity.setActivatedTick(currentTick + 19);
        }
    }

    public static int checkEntityImmunities(class_1297 entity) {
        int inactiveWakeUpImmunity = ActivationRange.checkInactiveWakeup(entity);
        if (inactiveWakeUpImmunity > -1) {
            return inactiveWakeUpImmunity;
        }
        if (entity.method_20802() > 0) {
            return 2;
        }
        ActivationEntity activationEntity = (ActivationEntity)entity;
        if (activationEntity.getActivatedImmunityTick() >= ServerCore.getServer().method_3780()) {
            return 1;
        }
        if (!entity.method_5805()) {
            return 40;
        }
        ActivationType type = activationEntity.getActivationType();
        if (entity.method_5799() && entity.method_5675() && type != ActivationType.ANIMAL && type != ActivationType.FLYING && type != ActivationType.VILLAGER && type != ActivationType.WATER && !(entity instanceof class_1690)) {
            return 100;
        }
        if (entity instanceof class_1542 || entity instanceof class_1303) {
            class_243 movement = entity.method_18798();
            if (movement.field_1352 != 0.0 || movement.field_1350 != 0.0 || movement.field_1351 > 0.0) {
                return 20;
            }
        }
        if (!(entity instanceof class_1665)) {
            if (!(entity.method_24828() || entity.method_5799() || entity instanceof class_1307 || entity instanceof class_1420)) {
                return 10;
            }
        } else {
            class_1665 projectile = (class_1665)entity;
            if (!projectile.field_7588) {
                return 1;
            }
        }
        if (entity instanceof class_1309) {
            class_1548 creeper;
            class_1501 llama;
            class_1308 mob;
            class_1309 living = (class_1309)entity;
            if (living.field_6282 || !living.method_6026().isEmpty() || living.method_6101()) {
                return 1;
            }
            if (entity instanceof class_1308 && (mob = (class_1308)entity).method_5968() != null) {
                return 20;
            }
            if (entity instanceof class_4466) {
                class_4466 bee = (class_4466)entity;
                class_2338 movingTarget = ((IPathFinderMob)bee).getMovingTarget();
                if (bee.method_29511() || bee.method_23884() != null && bee.method_23884().equals((Object)movingTarget) || bee.method_21778() != null && bee.method_21778().equals((Object)movingTarget)) {
                    return 20;
                }
            }
            if (entity instanceof class_1646) {
                int immunityAfter;
                class_1646 villager = (class_1646)entity;
                class_4095 brain = villager.method_18868();
                if (ActivationRangeConfig.VILLAGER_TICK_PANIC.get().booleanValue()) {
                    for (class_4168 activity : VILLAGER_PANIC_IMMUNITIES) {
                        if (!brain.method_18906(activity)) continue;
                        return 100;
                    }
                }
                if ((immunityAfter = ActivationRangeConfig.VILLAGER_WORK_IMMUNITY_AFTER.get().intValue()) > 0 && ServerCore.getServer().method_3780() - activationEntity.getActivatedTick() >= immunityAfter && brain.method_18906(class_4168.field_18596)) {
                    return ActivationRangeConfig.VILLAGER_WORK_IMMUNITY_FOR.get();
                }
            }
            if (entity instanceof class_1501 && (llama = (class_1501)entity).method_6805()) {
                return 1;
            }
            if (entity instanceof class_1429) {
                class_1472 sheep;
                class_1429 animal = (class_1429)entity;
                if (animal.method_6109() || animal.method_6479()) {
                    return 5;
                }
                if (entity instanceof class_1472 && (sheep = (class_1472)entity).method_6629()) {
                    return 1;
                }
            }
            if (entity instanceof class_1548 && (creeper = (class_1548)entity).method_7000()) {
                return 20;
            }
            if (entity instanceof class_1308) {
                mob = (class_1308)entity;
                if (((IGoalSelector)mob.field_6185).hasTasks()) {
                    return 0;
                }
            }
        }
        return -1;
    }

    public static boolean checkIfActive(class_1297 entity) {
        boolean active;
        ActivationEntity activationEntity = (ActivationEntity)entity;
        if (ActivationRange.shouldTick(entity, activationEntity)) {
            return true;
        }
        int currentTick = ServerCore.getServer().method_3780();
        boolean bl = active = activationEntity.getActivatedTick() >= currentTick;
        if (!active) {
            if ((currentTick - activationEntity.getActivatedTick() - 1) % 20 == 0) {
                int immunity = ActivationRange.checkEntityImmunities(entity);
                if (immunity >= 0) {
                    activationEntity.setActivatedTick(currentTick + immunity);
                    return true;
                }
                return activationEntity.getActivationType().tickInactive.getAsBoolean();
            }
        } else if (ActivationRangeConfig.SKIP_NON_IMMUNE.get().booleanValue() && activationEntity.getFullTickCount() % 4 == 0 && ActivationRange.checkEntityImmunities(entity) < 0) {
            return false;
        }
        return active;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldTick(class_1297 entity, ActivationEntity activationEntity) {
        if (ActivationRangeConfig.ENABLED.get() == false) return true;
        if (activationEntity.isExcluded()) return true;
        if (entity.field_5963) return true;
        if (entity.method_30230()) return true;
        if (entity.field_6012 < 200) {
            if (activationEntity.getActivationType() == ActivationType.MISC) return true;
        }
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            if (mob.field_6202 instanceof class_1657) return true;
        }
        if (!(entity instanceof class_1309)) return false;
        class_1309 living = (class_1309)entity;
        if (living.field_6235 <= 0) return false;
        return true;
    }

    private static int checkInactiveWakeup(class_1297 entity) {
        ActivationEntity activationEntity = (ActivationEntity)entity;
        ActivationType type = activationEntity.getActivationType();
        ILevel info = (ILevel)entity.field_6002;
        long inactiveFor = ServerCore.getServer().method_3780() - activationEntity.getActivatedTick();
        if (type == ActivationType.VILLAGER) {
            if (inactiveFor > (long)(ActivationRangeConfig.VILLAGER_WAKEUP_INTERVAL.get() * 20) && info.getRemainingVillagers() > 0) {
                info.setRemainingVillagers(info.getRemainingVillagers() - 1);
                return 100;
            }
        } else if (type == ActivationType.ANIMAL || type == ActivationType.NEUTRAL) {
            if (inactiveFor > (long)(ActivationRangeConfig.ANIMAL_WAKEUP_INTERVAL.get() * 20) && info.getRemainingAnimals() > 0) {
                info.setRemainingAnimals(info.getRemainingAnimals() - 1);
                return 100;
            }
        } else if (type == ActivationType.FLYING) {
            if (inactiveFor > (long)(ActivationRangeConfig.FLYING_WAKEUP_INTERVAL.get() * 20) && info.getRemainingFlying() > 0) {
                info.setRemainingFlying(info.getRemainingFlying() - 1);
                return 100;
            }
        } else if ((type == ActivationType.MONSTER || type == ActivationType.MONSTER_BELOW || type == ActivationType.RAIDER || type == ActivationType.ZOMBIE) && inactiveFor > (long)(ActivationRangeConfig.MONSTER_WAKEUP_INTERVAL.get() * 20) && info.getRemainingMonsters() > 0) {
            info.setRemainingMonsters(info.getRemainingMonsters() - 1);
            return 100;
        }
        return -1;
    }

    public static void updateAge(class_1296 mob) {
        int age = mob.method_5618();
        if (age < 0) {
            mob.method_5614(age + 1);
        } else if (age > 0) {
            mob.method_5614(age - 1);
        }
    }

    public static void updateGoalSelectors(class_1308 mob) {
        if (((IGoalSelector)mob.field_6201).inactiveTick()) {
            mob.field_6201.method_6275();
        }
        if (((IGoalSelector)mob.field_6185).inactiveTick()) {
            mob.field_6185.method_6275();
        }
    }

    public static enum ActivationType {
        VILLAGER(ActivationRangeConfig.VILLAGER_ACTIVATION_RANGE::get, ActivationRangeConfig.VILLAGER_TICK_INACTIVE::get),
        ZOMBIE(ActivationRangeConfig.ZOMBIE_ACTIVATION_RANGE::get, ActivationRangeConfig.ZOMBIE_TICK_INACTIVE::get, true, false),
        MONSTER(ActivationRangeConfig.MONSTER_ACTIVATION_RANGE::get, ActivationRangeConfig.MONSTER_TICK_INACTIVE::get, true, false),
        MONSTER_BELOW(ActivationRangeConfig.MONSTER_ACTIVATION_RANGE::get, ActivationRangeConfig.MONSTER_TICK_INACTIVE::get, true, true),
        NEUTRAL(ActivationRangeConfig.NEUTRAL_ACTIVATION_RANGE::get, ActivationRangeConfig.NEUTRAL_TICK_INACTIVE::get),
        ANIMAL(ActivationRangeConfig.ANIMAL_ACTIVATION_RANGE::get, ActivationRangeConfig.ANIMAL_TICK_INACTIVE::get),
        WATER(ActivationRangeConfig.WATER_ACTIVATION_RANGE::get, ActivationRangeConfig.WATER_TICK_INACTIVE::get),
        FLYING(ActivationRangeConfig.FLYING_ACTIVATION_RANGE::get, ActivationRangeConfig.FLYING_TICK_INACTIVE::get, true, false),
        RAIDER(ActivationRangeConfig.RAIDER_ACTIVATION_RANGE::get, ActivationRangeConfig.RAIDER_TICK_INACTIVE::get, true, false),
        MISC(ActivationRangeConfig.MISC_ACTIVATION_RANGE::get, ActivationRangeConfig.MISC_TICK_INACTIVE::get);

        private final IntSupplier activationRange;
        private final BooleanSupplier tickInactive;
        private final boolean extraHeightUp;
        private final boolean extraHeightDown;
        private class_238 boundingBox = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

        private ActivationType(IntSupplier activationRange, BooleanSupplier tickInactive, boolean extraHeightUp, boolean extraHeightDown) {
            this.activationRange = activationRange;
            this.tickInactive = tickInactive;
            this.extraHeightUp = extraHeightUp;
            this.extraHeightDown = extraHeightDown;
        }

        private ActivationType(IntSupplier activationRange, BooleanSupplier tickInactive) {
            this(activationRange, tickInactive, false, false);
        }
    }
}

