/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.services;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import eu.pb4.placeholders.api.PlaceholderHandler;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import me.wesley1808.servercore.common.utils.DynamicManager;
import me.wesley1808.servercore.common.utils.Statistics;
import net.minecraft.class_2960;

public final class PlaceHolders {
    private static final Cache<String, String> CACHE = CacheBuilder.newBuilder().expireAfterWrite(50L, TimeUnit.MILLISECONDS).build();

    public static void register() {
        PlaceHolders.register("view_distance", (ctx, arg) -> PlaceholderResult.value((String)String.valueOf(DynamicManager.getViewDistance())));
        PlaceHolders.register("simulation_distance", (ctx, arg) -> PlaceholderResult.value((String)String.valueOf(DynamicManager.getSimulationDistance())));
        PlaceHolders.register("chunk_tick_distance", (ctx, arg) -> PlaceholderResult.value((String)String.valueOf(DynamicManager.getChunkTickDistance())));
        PlaceHolders.register("mobcap_multiplier", (ctx, arg) -> PlaceholderResult.value((String)DynamicManager.getModifierAsString()));
        PlaceHolders.register("chunk_count", (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                return PlaceHolders.cachedValue("chunk_count", () -> String.valueOf(Statistics.getLoadedChunkCount()));
            }
            return PlaceholderResult.value((String)String.valueOf(Statistics.getLoadedChunkCount()));
        });
        PlaceHolders.register("entity_count", (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                if ("player".equals(arg)) {
                    return PlaceholderResult.value((String)String.valueOf(Statistics.getEntitiesNear(ctx.player()).size()));
                }
                return PlaceHolders.cachedValue("entity_count", () -> String.valueOf(Statistics.getAllEntities().size()));
            }
            return PlaceholderResult.value((String)String.valueOf(Statistics.getAllEntities().size()));
        });
        PlaceHolders.register("block_entity_count", (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                if ("player".equals(arg)) {
                    return PlaceholderResult.value((String)String.valueOf(Statistics.getBlockEntitiesNear(ctx.player()).size()));
                }
                return PlaceHolders.cachedValue("block_entity_count", () -> String.valueOf(Statistics.getAllBlockEntities().size()));
            }
            return PlaceholderResult.value((String)String.valueOf(Statistics.getAllBlockEntities().size()));
        });
    }

    private static PlaceholderResult cachedValue(String key, Callable<String> valueLoader) {
        try {
            return PlaceholderResult.value((String)((String)CACHE.get((Object)key, valueLoader)));
        }
        catch (ExecutionException ex) {
            return PlaceholderResult.invalid((String)("Failed to get value for key: " + key));
        }
    }

    private static void register(String name, PlaceholderHandler handler) {
        Placeholders.register((class_2960)new class_2960("servercore", name), (PlaceholderHandler)handler);
    }
}

