/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.client.utils;

import dev.isxander.debugify.client.DebugifyClient;
import dev.isxander.debugify.config.DebugifyConfig;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.BugFixData;
import dev.isxander.debugify.fixes.FixCategory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ConfigGuiHelper {
    public static class_437 createConfigGui(DebugifyConfig config, class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setTitle((class_2561)class_2561.method_43471((String)"debugify.name")).setSavingRunnable(config::save).setParentScreen(parent);
        HashMap<FixCategory, ConfigCategory> fixCategories = new HashMap<FixCategory, ConfigCategory>();
        HashMap<ConfigCategory, Map> fixSubCategories = new HashMap<ConfigCategory, Map>();
        for (FixCategory fixCategory : FixCategory.values()) {
            ConfigCategory configCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)fixCategory.getDisplayName()));
            if (fixCategory == FixCategory.GAMEPLAY) {
                configCategory.addEntry((AbstractConfigListEntry)builder.entryBuilder().startTextDescription((class_2561)class_2561.method_43471((String)"debugify.gameplay.warning").method_27692(class_124.field_1061)).build());
                configCategory.addEntry((AbstractConfigListEntry)builder.entryBuilder().startBooleanToggle((class_2561)class_2561.method_43471((String)"debugify.gameplay.enable_in_multiplayer"), config.gameplayFixesInMultiplayer).setSaveConsumer(enabled -> {
                    config.gameplayFixesInMultiplayer = enabled;
                }).build());
            }
            fixCategories.put(fixCategory, configCategory);
            HashMap<BugFix.Env, SubCategoryBuilder> subCategories2 = new HashMap<BugFix.Env, SubCategoryBuilder>();
            for (BugFix.Env env : BugFix.Env.values()) {
                SubCategoryBuilder subCategoryBuilder = builder.entryBuilder().startSubCategory((class_2561)class_2561.method_43471((String)env.getDisplayName()));
                subCategories2.put(env, subCategoryBuilder);
            }
            fixSubCategories.put(configCategory, subCategories2);
        }
        config.getBugFixes().forEach((bug, enabled) -> {
            SubCategoryBuilder subcategory = (SubCategoryBuilder)((Map)fixSubCategories.get(fixCategories.get((Object)bug.category()))).get((Object)bug.env());
            BooleanToggleBuilder entry = builder.entryBuilder().startBooleanToggle((class_2561)class_2561.method_43470((String)bug.bugId()), enabled.booleanValue()).setSaveConsumer(toggled -> config.getBugFixes().replace((BugFixData)bug, (Boolean)toggled)).setDefaultValue(bug.enabledByDefault()).setErrorSupplier(b -> {
                List<String> conflicts = bug.getActiveConflicts();
                if (!b.booleanValue() || conflicts.isEmpty()) {
                    return Optional.empty();
                }
                if (conflicts.size() == 1) {
                    return Optional.of(class_2561.method_43469((String)"debugify.error.conflict.single", (Object[])new Object[]{bug.bugId(), conflicts.get(0)}));
                }
                return Optional.of(class_2561.method_43469((String)"debugify.error.conflict.multiple", (Object[])new Object[]{bug.bugId(), String.join((CharSequence)", ", conflicts)}));
            }).requireRestart();
            if (DebugifyClient.bugFixDescriptionCache.has(bug.bugId())) {
                entry.setTooltip(new class_2561[]{class_2561.method_43470((String)DebugifyClient.bugFixDescriptionCache.get(bug.bugId()))});
            }
            subcategory.add((AbstractConfigListEntry)entry.build());
        });
        fixSubCategories.forEach((category, subCategories) -> subCategories.forEach((env, subCategoryBuilder) -> category.addEntry((AbstractConfigListEntry)subCategoryBuilder.build())));
        ConfigCategory miscCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"debugify.misc"));
        BooleanListEntry defaultDisabledEntry = builder.entryBuilder().startBooleanToggle((class_2561)class_2561.method_43471((String)"debugify.misc.default_disabled"), config.defaultDisabled).setTooltip(new class_2561[]{class_2561.method_43471((String)"debugify.misc.default_disabled.description")}).setSaveConsumer(toggled -> {
            config.defaultDisabled = toggled;
        }).setDefaultValue(false).build();
        miscCategory.addEntry((AbstractConfigListEntry)defaultDisabledEntry);
        return builder.build();
    }
}

