/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.config.cloth;

import ca.fxco.moreculling.config.cloth.AbstractDynamicEntry;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDynamicBuilder<T, A extends AbstractConfigListEntry<T>>
extends FieldBuilder<T, A> {
    @Nullable
    protected Consumer<T> saveConsumer = null;
    @Nullable
    protected BiConsumer<AbstractDynamicEntry<T>, T> changeConsumer = null;
    @NotNull
    protected Function<T, Optional<class_2561[]>> tooltipSupplier = bool -> Optional.empty();
    private T value = null;
    private boolean locked = false;

    protected AbstractDynamicBuilder(class_2561 fieldNameKey) {
        this(fieldNameKey, (class_2561)class_2561.method_43471((String)"text.cloth-config.reset_value"));
    }

    protected AbstractDynamicBuilder(class_2561 fieldNameKey, class_2561 resetButtonKey) {
        super(resetButtonKey, fieldNameKey);
    }

    protected final T getValue() {
        return this.value;
    }

    protected final boolean getLocked() {
        return this.locked;
    }

    protected final void setLocked(boolean locked) {
        this.locked = locked;
    }

    public AbstractDynamicBuilder<T, A> setModIncompatibility(boolean isLoaded, String modId) {
        if (isLoaded) {
            this.setTooltip(new class_2561[]{class_2561.method_43469((String)"moreculling.config.optionDisabled", (Object[])new Object[]{modId})});
            this.locked = true;
            this.saveConsumer = null;
            this.changeConsumer = null;
            this.requireRestart(false);
        }
        return this;
    }

    public AbstractDynamicBuilder<T, A> setModLimited(boolean isLoaded, class_2561 limitedMessage) {
        if (isLoaded) {
            Optional<class_2561[]> currentTooltips = this.tooltipSupplier.apply(this.value);
            if (currentTooltips.isEmpty()) {
                this.setTooltip(limitedMessage);
            } else {
                class_2561[] tooltips = currentTooltips.get();
                class_2561[] newArray = new class_2561[tooltips.length + 1];
                for (int i = 0; i < tooltips.length; ++i) {
                    newArray[i] = tooltips[i];
                }
                newArray[tooltips.length] = limitedMessage;
                this.setTooltip(newArray);
            }
        }
        return this;
    }

    public AbstractDynamicBuilder<T, A> setValue(T value) {
        Objects.requireNonNull(value);
        this.value = value;
        return this;
    }

    public AbstractDynamicBuilder<T, A> setErrorSupplier(@Nullable Function<T, Optional<class_2561>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return this;
    }

    public AbstractDynamicBuilder<T, A> requireRestart() {
        if (!this.locked) {
            this.requireRestart(true);
        }
        return this;
    }

    public AbstractDynamicBuilder<T, A> setSaveConsumer(Consumer<T> saveConsumer) {
        if (!this.locked) {
            this.saveConsumer = saveConsumer;
        }
        return this;
    }

    public AbstractDynamicBuilder<T, A> setChangeConsumer(BiConsumer<AbstractDynamicEntry<T>, T> changeConsumer) {
        if (!this.locked) {
            this.changeConsumer = changeConsumer;
        }
        return this;
    }

    public AbstractDynamicBuilder<T, A> setDefaultValue(Supplier<T> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public AbstractDynamicBuilder<T, A> setDefaultValue(T defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    public AbstractDynamicBuilder<T, A> setTooltip(class_2561 ... tooltip) {
        if (!this.locked) {
            this.tooltipSupplier = val -> Optional.ofNullable(tooltip);
        }
        return this;
    }

    public AbstractDynamicBuilder<T, A> setTooltipSupplier(@NotNull Function<T, Optional<class_2561[]>> tooltipSupplier) {
        if (!this.locked) {
            this.tooltipSupplier = tooltipSupplier;
        }
        return this;
    }

    public AbstractDynamicBuilder<T, A> setTooltipSupplier(@NotNull Supplier<Optional<class_2561[]>> tooltipSupplier) {
        if (!this.locked) {
            this.tooltipSupplier = val -> (Optional)tooltipSupplier.get();
        }
        return this;
    }

    @NotNull
    public final A build() {
        Objects.requireNonNull(this.value);
        return this.runBuild();
    }

    public abstract A runBuild();
}

