/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo;

import com.github.nyuppo.compat.Clicker;
import com.github.nyuppo.compat.IPNClicker;
import com.github.nyuppo.compat.VanillaClicker;
import com.github.nyuppo.config.ClothConfigHotbarCycleConfig;
import com.github.nyuppo.config.DefaultHotbarCycleConfig;
import com.github.nyuppo.config.HotbarCycleConfig;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3675;
import net.minecraft.class_636;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotbarCycleClient
implements ClientModInitializer {
    private static class_304 cycleKeyBinding;
    private static class_304 singleCycleKeyBinding;
    private static final HotbarCycleConfig CONFIG;
    private static Clicker clicker;
    public static final Logger LOGGER;

    public static HotbarCycleConfig getConfig() {
        return CONFIG;
    }

    public static class_304 getCycleKeyBinding() {
        return cycleKeyBinding;
    }

    public static class_304 getSingleCycleKeyBinding() {
        return singleCycleKeyBinding;
    }

    public void onInitializeClient() {
        clicker = HotbarCycleClient.getClicker();
        cycleKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.hotbarcycle.cycle", class_3675.class_307.field_1668, 72, "category.hotbarcycle.keybinds"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (cycleKeyBinding.method_1436()) {
                if (client.field_1724 == null || CONFIG.getHoldAndScroll()) continue;
                HotbarCycleClient.shiftRows(client);
            }
        });
        singleCycleKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.hotbarcycle.single_cycle", class_3675.class_307.field_1668, 74, "category.hotbarcycle.keybinds"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (singleCycleKeyBinding.method_1436()) {
                if (client.field_1724 == null || client.field_1724.method_31548() == null || CONFIG.getHoldAndScroll()) continue;
                HotbarCycleClient.shiftSingle(client, client.field_1724.method_31548().field_7545);
            }
        });
    }

    public static void shiftRows(class_310 client) {
        int i;
        class_636 interactionManager = client.field_1761;
        if (interactionManager == null || client.field_1724 == null) {
            return;
        }
        if (CONFIG.getReverseCycleDirection() ? CONFIG.getEnableRow1() : CONFIG.getEnableRow3()) {
            for (i = 0; i < 9; ++i) {
                if (!HotbarCycleClient.isColumnEnabled(i)) continue;
                clicker.swap(client, (!CONFIG.getReverseCycleDirection() ? 9 : 27) + i, i);
            }
        }
        if (CONFIG.getEnableRow2()) {
            for (i = 0; i < 9; ++i) {
                if (!HotbarCycleClient.isColumnEnabled(i)) continue;
                clicker.swap(client, 18 + i, i);
            }
        }
        if (CONFIG.getReverseCycleDirection() ? CONFIG.getEnableRow3() : CONFIG.getEnableRow1()) {
            for (i = 0; i < 9; ++i) {
                if (!HotbarCycleClient.isColumnEnabled(i)) continue;
                clicker.swap(client, (!CONFIG.getReverseCycleDirection() ? 27 : 9) + i, i);
            }
        }
        if (CONFIG.getPlaySound()) {
            client.field_1724.method_17356(class_3417.field_17481, class_3419.field_15250, 0.5f, 1.5f);
        }
    }

    public static void shiftRows(class_310 client, boolean reverseBypass) {
        int i;
        class_636 interactionManager = client.field_1761;
        if (interactionManager == null || client.field_1724 == null) {
            return;
        }
        if (reverseBypass ? CONFIG.getEnableRow1() : CONFIG.getEnableRow3()) {
            for (i = 0; i < 9; ++i) {
                if (!HotbarCycleClient.isColumnEnabled(i)) continue;
                clicker.swap(client, (!reverseBypass ? 9 : 27) + i, i);
            }
        }
        if (CONFIG.getEnableRow2()) {
            for (i = 0; i < 9; ++i) {
                if (!HotbarCycleClient.isColumnEnabled(i)) continue;
                clicker.swap(client, 18 + i, i);
            }
        }
        if (reverseBypass ? CONFIG.getEnableRow3() : CONFIG.getEnableRow1()) {
            for (i = 0; i < 9; ++i) {
                if (!HotbarCycleClient.isColumnEnabled(i)) continue;
                clicker.swap(client, (!reverseBypass ? 27 : 9) + i, i);
            }
        }
        if (CONFIG.getPlaySound()) {
            client.field_1724.method_17356(class_3417.field_17481, class_3419.field_15250, 0.5f, 1.5f);
        }
    }

    public static void shiftSingle(class_310 client, int hotbarSlot) {
        class_636 interactionManager = client.field_1761;
        if (interactionManager == null || client.field_1724 == null) {
            return;
        }
        if (CONFIG.getReverseCycleDirection() ? CONFIG.getEnableRow1() : CONFIG.getEnableRow3()) {
            clicker.swap(client, (!CONFIG.getReverseCycleDirection() ? 9 : 27) + hotbarSlot, hotbarSlot);
        }
        if (CONFIG.getEnableRow2()) {
            clicker.swap(client, 18 + hotbarSlot, hotbarSlot);
        }
        if (CONFIG.getReverseCycleDirection() ? CONFIG.getEnableRow3() : CONFIG.getEnableRow1()) {
            clicker.swap(client, (!CONFIG.getReverseCycleDirection() ? 27 : 9) + hotbarSlot, hotbarSlot);
        }
        if (CONFIG.getPlaySound()) {
            client.field_1724.method_17356(class_3417.field_17481, class_3419.field_15250, 0.5f, 1.8f);
        }
    }

    public static void shiftSingle(class_310 client, int hotbarSlot, boolean reverseBypass) {
        class_636 interactionManager = client.field_1761;
        if (interactionManager == null || client.field_1724 == null) {
            return;
        }
        if (reverseBypass ? CONFIG.getEnableRow1() : CONFIG.getEnableRow3()) {
            clicker.swap(client, (!reverseBypass ? 9 : 27) + hotbarSlot, hotbarSlot);
        }
        if (CONFIG.getEnableRow2()) {
            clicker.swap(client, 18 + hotbarSlot, hotbarSlot);
        }
        if (reverseBypass ? CONFIG.getEnableRow3() : CONFIG.getEnableRow1()) {
            clicker.swap(client, (!reverseBypass ? 27 : 9) + hotbarSlot, hotbarSlot);
        }
        if (CONFIG.getPlaySound()) {
            client.field_1724.method_17356(class_3417.field_17481, class_3419.field_15250, 0.5f, 1.8f);
        }
    }

    private static Clicker getClicker() {
        if (FabricLoader.getInstance().isModLoaded("inventoryprofilesnext")) {
            LOGGER.info("Inventory Profiles Next was found, switching to compatible clicker!");
            return new IPNClicker();
        }
        return new VanillaClicker();
    }

    private static boolean isColumnEnabled(int columnIndex) {
        return switch (columnIndex) {
            case 0 -> CONFIG.getEnableColumn0();
            case 1 -> CONFIG.getEnableColumn1();
            case 2 -> CONFIG.getEnableColumn2();
            case 3 -> CONFIG.getEnableColumn3();
            case 4 -> CONFIG.getEnableColumn4();
            case 5 -> CONFIG.getEnableColumn5();
            case 6 -> CONFIG.getEnableColumn6();
            case 7 -> CONFIG.getEnableColumn7();
            case 8 -> CONFIG.getEnableColumn8();
            default -> false;
        };
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"hotbarcycle");
        CONFIG = FabricLoader.getInstance().isModLoaded("cloth-config") ? (HotbarCycleConfig)AutoConfig.register(ClothConfigHotbarCycleConfig.class, GsonConfigSerializer::new).getConfig() : new DefaultHotbarCycleConfig();
    }
}

