/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.math2d;

import kotlin.Metadata;
import org.anti_ad.mc.common.math2d.Line;
import org.anti_ad.mc.common.math2d.LineKt;
import org.anti_ad.mc.common.math2d.Point;
import org.anti_ad.mc.common.math2d.Rectangle;
import org.anti_ad.mc.common.math2d.Size;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0019\u0010\u0002\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0004\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0013\u0010\u0006\u001a\u00020\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0005\u001a\u0013\u0010\u0007\u001a\u00020\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0005\u001a\u0011\u0010\b\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\b\u0010\u0005\u001a\u0011\u0010\u000b\u001a\u00020\n*\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0011\u0010\r\u001a\u00020\t*\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0011\u0010\u000f\u001a\u00020\n*\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0011\u0010\u000f\u001a\u00020\t*\u00020\t\u00a2\u0006\u0004\b\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/anti_ad/mc/common/math2d/Rectangle;", "other", "intersect", "(Lorg/anti_ad/mc/common/math2d/Rectangle;Lorg/anti_ad/mc/common/math2d/Rectangle;)Lorg/anti_ad/mc/common/math2d/Rectangle;", "normalize", "(Lorg/anti_ad/mc/common/math2d/Rectangle;)Lorg/anti_ad/mc/common/math2d/Rectangle;", "normalizeHeight", "normalizeWidth", "positiveOrEmpty", "Lorg/anti_ad/mc/common/math2d/Size;", "Lorg/anti_ad/mc/common/math2d/Point;", "toPoint", "(Lorg/anti_ad/mc/common/math2d/Size;)Lorg/anti_ad/mc/common/math2d/Point;", "toSize", "(Lorg/anti_ad/mc/common/math2d/Point;)Lorg/anti_ad/mc/common/math2d/Size;", "transpose", "(Lorg/anti_ad/mc/common/math2d/Point;)Lorg/anti_ad/mc/common/math2d/Point;", "(Lorg/anti_ad/mc/common/math2d/Size;)Lorg/anti_ad/mc/common/math2d/Size;", "common"})
public final class Rect2dKt {
    @NotNull
    public static final Size toSize(@NotNull Point point) {
        return new Size(point.getX(), point.getY());
    }

    @NotNull
    public static final Point transpose(@NotNull Point point) {
        return new Point(point.getY(), point.getX());
    }

    @NotNull
    public static final Point toPoint(@NotNull Size size) {
        return new Point(size.getWidth(), size.getHeight());
    }

    @NotNull
    public static final Size transpose(@NotNull Size size) {
        return new Size(size.getHeight(), size.getWidth());
    }

    @NotNull
    public static final Rectangle intersect(@NotNull Rectangle object, @NotNull Rectangle object2) {
        object = LineKt.getDiagonal(Rect2dKt.normalize((Rectangle)object));
        int n2 = ((Line)object).component1();
        int n3 = ((Line)object).component2();
        int n4 = ((Line)object).component3();
        int n5 = ((Line)object).component4();
        object2 = LineKt.getDiagonal(Rect2dKt.normalize((Rectangle)object2));
        int n6 = ((Line)object2).component1();
        int n7 = ((Line)object2).component2();
        int n8 = ((Line)object2).component3();
        int n9 = ((Line)object2).component4();
        n2 = Math.max(n2, n6);
        n3 = Math.max(n3, n7);
        n4 = Math.min(n4, n8);
        n5 = Math.min(n5, n9);
        return Rect2dKt.positiveOrEmpty(LineKt.toRectangle(new Line(n2, n3, n4, n5)));
    }

    @NotNull
    public static final Rectangle positiveOrEmpty(@NotNull Rectangle rectangle) {
        if (rectangle.getWidth() > 0 && rectangle.getHeight() > 0) {
            return rectangle;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    private static final Rectangle normalizeWidth(Rectangle rectangle) {
        if (rectangle.getWidth() >= 0) {
            return rectangle;
        }
        return new Rectangle(rectangle.getX() + rectangle.getWidth(), rectangle.getY(), -rectangle.getWidth(), rectangle.getHeight());
    }

    private static final Rectangle normalizeHeight(Rectangle rectangle) {
        if (rectangle.getHeight() >= 0) {
            return rectangle;
        }
        return new Rectangle(rectangle.getX(), rectangle.getY() + rectangle.getHeight(), rectangle.getWidth(), -rectangle.getHeight());
    }

    @NotNull
    public static final Rectangle normalize(@NotNull Rectangle rectangle) {
        return Rect2dKt.normalizeHeight(Rect2dKt.normalizeWidth(rectangle));
    }
}

