/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.input;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.anti_ad.mc.common.Log;
import org.anti_ad.mc.common.config.IConfigElementObject$DefaultImpls;
import org.anti_ad.mc.common.input.ConfigKeybindSettings;
import org.anti_ad.mc.common.input.GlobalInputHandler;
import org.anti_ad.mc.common.input.IKeybind;
import org.anti_ad.mc.common.input.IKeybind$WhenMappings;
import org.anti_ad.mc.common.input.KeybindSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=3, xi=48)
public final class IKeybind$DefaultImpls {
    public static boolean isActivated(@NotNull IKeybind iKeybind) {
        return GlobalInputHandler.INSTANCE.isActivated(iKeybind.getKeyCodes(), iKeybind.getSettings());
    }

    public static boolean isPressing(@NotNull IKeybind iKeybind) {
        return GlobalInputHandler.INSTANCE.isPressing(iKeybind.getKeyCodes(), iKeybind.getSettings());
    }

    @NotNull
    public static String getDisplayText(@NotNull IKeybind iKeybind) {
        switch (IKeybind$WhenMappings.$EnumSwitchMapping$0[iKeybind.getSettings().getModifierKey().ordinal()]) {
            case 1: {
                return IKeybind.Companion.getDisplayText(iKeybind.getKeyCodes());
            }
            case 2: {
                return IKeybind.Companion.getDisplayTextModifier(iKeybind.getKeyCodes());
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public static boolean isKeyCodesModified(@NotNull IKeybind iKeybind) {
        return !Intrinsics.areEqual((Object)iKeybind.getDefaultKeyCodes(), (Object)iKeybind.getKeyCodes());
    }

    public static boolean isSettingsModified(@NotNull IKeybind iKeybind) {
        return !Intrinsics.areEqual((Object)iKeybind.getDefaultSettings(), (Object)iKeybind.getSettings());
    }

    public static boolean isModified(@NotNull IKeybind iKeybind) {
        return iKeybind.isKeyCodesModified() || iKeybind.isSettingsModified();
    }

    public static void resetKeyCodesToDefault(@NotNull IKeybind iKeybind) {
        IKeybind iKeybind2 = iKeybind;
        iKeybind2.setKeyCodes(iKeybind2.getDefaultKeyCodes());
    }

    public static void resetSettingsToDefault(@NotNull IKeybind iKeybind) {
        IKeybind iKeybind2 = iKeybind;
        iKeybind2.setSettings(iKeybind2.getDefaultSettings());
    }

    public static void resetToDefault(@NotNull IKeybind iKeybind) {
        iKeybind.resetKeyCodesToDefault();
        iKeybind.resetSettingsToDefault();
    }

    @NotNull
    public static ConfigKeybindSettings toConfigElement(@NotNull IKeybind iKeybind, @NotNull KeybindSettings keybindSettings) {
        return new ConfigKeybindSettings(iKeybind.getDefaultSettings(), keybindSettings);
    }

    @NotNull
    public static JsonObject toJsonElement(@NotNull IKeybind iKeybind, @NotNull KeybindSettings keybindSettings) {
        return iKeybind.toConfigElement(keybindSettings).toJsonElement();
    }

    @NotNull
    public static KeybindSettings fromJsonElement(@NotNull IKeybind iConfigElementObject, @NotNull KeybindSettings keybindSettings, @NotNull JsonElement jsonElement) {
        iConfigElementObject = iConfigElementObject.toConfigElement(keybindSettings);
        ((ConfigKeybindSettings)iConfigElementObject).fromJsonElement(jsonElement);
        return ((ConfigKeybindSettings)iConfigElementObject).getSettings();
    }

    @NotNull
    public static JsonObject toJsonElement(@NotNull IKeybind object) {
        Map map;
        Map map2 = map = (Map)new LinkedHashMap();
        if (object.isKeyCodesModified()) {
            map2.put("keys", JsonElementKt.JsonPrimitive((String)IKeybind.Companion.getStorageString(object.getKeyCodes())));
        }
        if (object.isSettingsModified()) {
            Object object2 = object;
            map2.put("settings", object2.toJsonElement(object2.getSettings()));
        }
        object = map;
        return new JsonObject((Map)object);
    }

    public static void fromJsonObject(@NotNull IKeybind iKeybind, @NotNull JsonObject jsonObject) {
        try {
            JsonElement jsonElement;
            JsonElement jsonElement2 = (JsonElement)jsonObject.get((Object)"settings");
            if (jsonElement2 != null) {
                jsonElement = jsonElement2;
                IKeybind iKeybind2 = iKeybind;
                iKeybind2.setSettings(iKeybind2.fromJsonElement(iKeybind.getSettings(), jsonElement));
            }
            JsonElement jsonElement3 = (JsonElement)jsonObject.get((Object)"keys");
            if (jsonElement3 != null) {
                jsonElement = jsonElement3;
                iKeybind.setKeyCodes(IKeybind.Companion.getKeyCodes(JsonElementKt.getJsonPrimitive((JsonElement)jsonElement).getContent()));
                return;
            }
            return;
        }
        catch (Exception exception) {
            Log.INSTANCE.warn("Failed to set config value for 'keys' from the JSON element '" + jsonObject.get((Object)"keys") + '\'');
            return;
        }
    }

    public static void fromJsonElement(@NotNull IKeybind iKeybind, @NotNull JsonElement jsonElement) {
        IConfigElementObject$DefaultImpls.fromJsonElement(iKeybind, jsonElement);
    }
}

