/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.zoomify;

import dev.isxander.zoomify.config.ZoomifySettings;
import dev.isxander.zoomify.utils.TransitionType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_3532;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010$\u001a\u00020\u0004\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\u0006J\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001bR\u0016\u0010\u001f\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001bR\u0016\u0010 \u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010\u001bR\u0016\u0010!\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010\u001bR\u0014\u0010$\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010\u001bR\u0016\u0010%\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010\"\u00a8\u0006("}, d2={"Ldev/isxander/zoomify/ZoomHelper;", "", "", "tickDelta", "", "getInitialZoomMultiplier", "(F)D", "getScrollZoomDivisor", "getZoomDivisor", "", "reset", "()V", "", "zooming", "", "scrollTiers", "lastFrameDuration", "tick", "(ZID)V", "tickInitial", "(ZD)V", "tickScroll", "(ID)V", "Ldev/isxander/zoomify/utils/TransitionType;", "activeTransition", "Ldev/isxander/zoomify/utils/TransitionType;", "initialInterpolation", "D", "lastScrollTier", "I", "prevInitialInterpolation", "prevScrollInterpolation", "resetInterpolation", "resetting", "Z", "scrollInterpolation", "starting", "zoomingLastTick", "<init>", "(D)V", "Zoomify"})
public final class ZoomHelper {
    private final double starting;
    private double prevInitialInterpolation;
    private double initialInterpolation;
    private boolean zoomingLastTick;
    private TransitionType activeTransition;
    private double prevScrollInterpolation;
    private double scrollInterpolation;
    private int lastScrollTier;
    private boolean resetting;
    private double resetInterpolation;

    public ZoomHelper(double starting) {
        this.starting = starting;
    }

    public /* synthetic */ ZoomHelper(double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 1.0;
        }
        this(d);
    }

    public final void tick(boolean zooming, int scrollTiers, double lastFrameDuration) {
        this.tickInitial(zooming, lastFrameDuration);
        this.tickScroll(scrollTiers, lastFrameDuration);
    }

    public static /* synthetic */ void tick$default(ZoomHelper zoomHelper, boolean bl, int n, double d, int n2, Object object) {
        if ((n2 & 4) != 0) {
            d = 0.05;
        }
        zoomHelper.tick(bl, n, d);
    }

    private final void tickInitial(boolean zooming, double lastFrameDuration) {
        if (zooming && !this.zoomingLastTick) {
            this.resetting = false;
        }
        double targetZoom = zooming ? 1.0 : 0.0;
        TransitionType transition = ZoomifySettings.INSTANCE.getZoomTransition();
        this.activeTransition = ZoomifySettings.INSTANCE.getZoomTransition();
        this.prevInitialInterpolation = this.initialInterpolation;
        TransitionType transitionType = this.activeTransition;
        if (transitionType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeTransition");
            transitionType = null;
        }
        if (transitionType == TransitionType.INSTANT) {
            this.initialInterpolation = targetZoom;
        } else if (targetZoom > this.initialInterpolation) {
            this.activeTransition = transition;
            if (ZoomifySettings.INSTANCE.getZoomOppositeTransitionOut() && !this.zoomingLastTick && transition.hasInverse()) {
                this.prevInitialInterpolation = transition.inverse(transition.opposite().apply(this.prevInitialInterpolation));
                this.initialInterpolation = transition.inverse(transition.opposite().apply(this.initialInterpolation));
            }
            this.initialInterpolation += lastFrameDuration / ZoomifySettings.INSTANCE.getZoomInTime();
            this.initialInterpolation = RangesKt.coerceAtMost((double)this.initialInterpolation, (double)targetZoom);
        } else if (targetZoom < this.initialInterpolation) {
            if (ZoomifySettings.INSTANCE.getZoomOppositeTransitionOut()) {
                TransitionType transitionType2 = this.activeTransition;
                if (transitionType2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"activeTransition");
                    transitionType2 = null;
                }
                this.activeTransition = transitionType2.opposite();
                if (this.zoomingLastTick) {
                    TransitionType transitionType3 = this.activeTransition;
                    if (transitionType3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"activeTransition");
                        transitionType3 = null;
                    }
                    if (transitionType3.hasInverse()) {
                        TransitionType transitionType4 = this.activeTransition;
                        if (transitionType4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"activeTransition");
                            transitionType4 = null;
                        }
                        this.prevInitialInterpolation = transitionType4.inverse(transition.apply(this.prevInitialInterpolation));
                        TransitionType transitionType5 = this.activeTransition;
                        if (transitionType5 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"activeTransition");
                            transitionType5 = null;
                        }
                        this.initialInterpolation = transitionType5.inverse(transition.apply(this.initialInterpolation));
                    }
                }
            }
            this.initialInterpolation -= lastFrameDuration / ZoomifySettings.INSTANCE.getZoomOutTime();
            this.initialInterpolation = RangesKt.coerceAtLeast((double)this.initialInterpolation, (double)targetZoom);
        }
        this.zoomingLastTick = zooming;
    }

    private final void tickScroll(int scrollTiers, double lastFrameDuration) {
        if (scrollTiers > this.lastScrollTier) {
            this.resetting = false;
        }
        double targetZoom = (double)scrollTiers / (double)30;
        double curvature = 0.3;
        double exp = 1.0 / (1.0 - curvature);
        targetZoom = (double)2 * (Math.pow(targetZoom, exp) / (Math.pow(targetZoom, exp) + Math.pow((double)2 - targetZoom, exp)));
        this.prevScrollInterpolation = this.scrollInterpolation;
        double smoothness = class_3532.method_16436((double)((double)ZoomifySettings.INSTANCE.getScrollZoomSmoothness() / 100.0), (double)1.0, (double)0.1);
        if (this.scrollInterpolation < targetZoom) {
            this.scrollInterpolation += (targetZoom - this.scrollInterpolation) * smoothness / 0.05 * lastFrameDuration;
            this.scrollInterpolation = RangesKt.coerceAtMost((double)this.scrollInterpolation, (double)targetZoom);
        } else if (this.scrollInterpolation > targetZoom) {
            this.scrollInterpolation -= (this.scrollInterpolation - targetZoom) * smoothness / 0.05 * lastFrameDuration;
            this.scrollInterpolation = RangesKt.coerceAtLeast((double)this.scrollInterpolation, (double)targetZoom);
        }
        this.lastScrollTier = scrollTiers;
    }

    public final double getZoomDivisor(float tickDelta) {
        double d;
        double initialMultiplier = this.getInitialZoomMultiplier(tickDelta);
        double scrollDivisor = this.getScrollZoomDivisor(tickDelta);
        double it = d = 1.0 / initialMultiplier + scrollDivisor;
        boolean bl = false;
        if (this.initialInterpolation == 0.0 && this.scrollInterpolation == 0.0) {
            this.resetting = false;
        }
        if (!this.resetting) {
            this.resetInterpolation = 1.0 / it;
        }
        return d;
    }

    public static /* synthetic */ double getZoomDivisor$default(ZoomHelper zoomHelper, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        return zoomHelper.getZoomDivisor(f);
    }

    private final double getInitialZoomMultiplier(float tickDelta) {
        TransitionType transitionType = this.activeTransition;
        if (transitionType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeTransition");
            transitionType = null;
        }
        return class_3532.method_16436((double)transitionType.apply(class_3532.method_16436((double)tickDelta, (double)this.prevInitialInterpolation, (double)this.initialInterpolation)), (double)(1.0 / this.starting), (double)(!this.resetting ? 1.0 / (double)ZoomifySettings.INSTANCE.getInitialZoom() : this.resetInterpolation));
    }

    /*
     * WARNING - void declaration
     */
    private final double getScrollZoomDivisor(float tickDelta) {
        void var2_2;
        double it = class_3532.method_16436((double)class_3532.method_16436((double)tickDelta, (double)this.prevScrollInterpolation, (double)this.scrollInterpolation), (double)0.0, (double)((double)30 * ((double)ZoomifySettings.INSTANCE.getScrollZoomAmount() * 3.0)));
        boolean bl = false;
        return this.resetting ? 0.0 : var2_2;
    }

    public final void reset() {
        if (this.scrollInterpolation > 0.0) {
            this.resetting = true;
            this.scrollInterpolation = 0.0;
            this.prevScrollInterpolation = 0.0;
        }
    }

    public ZoomHelper() {
        this(0.0, 1, null);
    }
}

