/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam;

import java.util.HashMap;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5498;
import net.minecraft.class_743;
import net.minecraft.class_744;
import net.xolt.freecam.config.ModConfig;
import net.xolt.freecam.util.FreeCamera;

public class Freecam
implements ClientModInitializer {
    public static final class_310 MC = class_310.method_1551();
    private static class_304 freecamBind;
    private static class_304 playerControlBind;
    private static boolean enabled;
    private static boolean persistentCameraEnabled;
    private static boolean playerControlEnabled;
    private static Integer activePersistentCamera;
    private static FreeCamera freeCamera;
    private static HashMap<Integer, FreeCamera> persistentCameras;

    public void onInitializeClient() {
        ModConfig.init();
        freecamBind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.freecam.toggle", class_3675.class_307.field_1668, 293, "category.freecam.freecam"));
        playerControlBind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.freecam.playerControl", class_3675.class_307.field_1668, -1, "category.freecam.freecam"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (freecamBind.method_1434()) {
                for (class_304 hotbarKey : Freecam.MC.field_1690.field_1852) {
                    while (hotbarKey.method_1436()) {
                        Freecam.togglePersistentCamera(hotbarKey.method_1429().method_1444());
                        while (freecamBind.method_1436()) {
                        }
                    }
                }
            } else if (freecamBind.method_1436()) {
                Freecam.toggle();
                while (freecamBind.method_1436()) {
                }
            }
            while (playerControlBind.method_1436()) {
                Freecam.switchControls();
            }
        });
    }

    public static void toggle() {
        if (persistentCameraEnabled) {
            Freecam.togglePersistentCamera(activePersistentCamera);
        } else {
            if (enabled) {
                Freecam.onDisableFreecam();
            } else {
                Freecam.onEnableFreecam();
            }
            enabled = !enabled;
        }
    }

    public static void togglePersistentCamera() {
        Freecam.togglePersistentCamera(activePersistentCamera);
    }

    private static void togglePersistentCamera(int keyCode) {
        if (persistentCameraEnabled) {
            if (activePersistentCamera.equals(keyCode)) {
                Freecam.onDisablePersistentCamera(keyCode);
                persistentCameraEnabled = false;
            } else {
                Freecam.onDisable();
                Freecam.persistentCameras.get((Object)Freecam.activePersistentCamera).field_3913 = new class_744();
                Freecam.onEnablePersistentCamera(keyCode);
            }
        } else {
            if (enabled) {
                Freecam.toggle();
            }
            Freecam.onEnablePersistentCamera(keyCode);
            persistentCameraEnabled = true;
        }
    }

    public static void switchControls() {
        if (Freecam.isEnabled()) {
            if (playerControlEnabled) {
                Freecam.getFreeCamera().field_3913 = new class_743(Freecam.MC.field_1690);
            } else {
                Freecam.MC.field_1724.field_3913 = new class_743(Freecam.MC.field_1690);
                Freecam.getFreeCamera().field_3913 = new class_744();
            }
            playerControlEnabled = !playerControlEnabled;
        }
    }

    private static void onEnablePersistentCamera(int keyCode) {
        Freecam.onEnable();
        FreeCamera persistentCamera = persistentCameras.get(keyCode);
        boolean chunkLoaded = false;
        if (persistentCamera != null) {
            class_1923 chunkPos = persistentCamera.method_31476();
            chunkLoaded = Freecam.MC.field_1687.method_2935().method_12123(chunkPos.field_9181, chunkPos.field_9180);
        }
        if (persistentCamera == null || !chunkLoaded) {
            persistentCamera = new FreeCamera();
            persistentCameras.put(keyCode, persistentCamera);
            persistentCamera.spawn();
        }
        persistentCamera.field_3913 = new class_743(Freecam.MC.field_1690);
        MC.method_1504((class_1297)persistentCamera);
        activePersistentCamera = keyCode;
        if (ModConfig.INSTANCE.notifyPersistent) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.enablePersistent").method_27693("" + activePersistentCamera % 48), true);
        }
    }

    private static void onDisablePersistentCamera(int keyCode) {
        Freecam.onDisable();
        Freecam.persistentCameras.get((Object)Integer.valueOf((int)keyCode)).field_3913 = new class_744();
        if (Freecam.MC.field_1724 != null && ModConfig.INSTANCE.notifyPersistent) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.disablePersistent").method_27693("" + activePersistentCamera % 48), true);
        }
        activePersistentCamera = null;
    }

    private static void onEnableFreecam() {
        Freecam.onEnable();
        freeCamera = new FreeCamera();
        freeCamera.spawn();
        MC.method_1504((class_1297)freeCamera);
        if (ModConfig.INSTANCE.notifyFreecam) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.enable"), true);
        }
    }

    private static void onDisableFreecam() {
        Freecam.onDisable();
        freeCamera.despawn();
        freeCamera = null;
        if (Freecam.MC.field_1724 != null && ModConfig.INSTANCE.notifyFreecam) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.disable"), true);
        }
    }

    private static void onEnable() {
        Freecam.MC.field_1730 = false;
        Freecam.MC.field_1773.method_35768(ModConfig.INSTANCE.showHand);
        if (Freecam.MC.field_1773.method_19418().method_19333()) {
            Freecam.MC.field_1690.method_31043(class_5498.field_26664);
        }
    }

    private static void onDisable() {
        Freecam.MC.field_1730 = true;
        Freecam.MC.field_1773.method_35768(true);
        MC.method_1504((class_1297)Freecam.MC.field_1724);
        playerControlEnabled = false;
        if (Freecam.MC.field_1724 != null) {
            Freecam.MC.field_1724.field_3913 = new class_743(Freecam.MC.field_1690);
        }
    }

    public static void clearPersistentCameras() {
        persistentCameras = new HashMap();
    }

    public static FreeCamera getFreeCamera() {
        FreeCamera result = null;
        if (enabled) {
            result = freeCamera;
        } else if (persistentCameraEnabled) {
            result = persistentCameras.get(activePersistentCamera);
        }
        return result;
    }

    public static class_304 getFreecamBind() {
        return freecamBind;
    }

    public static boolean isEnabled() {
        return enabled || persistentCameraEnabled;
    }

    public static boolean isFreecamEnabled() {
        return enabled;
    }

    public static boolean isPersistentCameraEnabled() {
        return persistentCameraEnabled;
    }

    public static boolean isPlayerControlEnabled() {
        return playerControlEnabled;
    }

    public static boolean canUseCheats() {
        return Freecam.MC.field_1724.method_5687(2) || Freecam.MC.field_1724.method_7337() || MC.method_1542();
    }

    static {
        enabled = false;
        persistentCameraEnabled = false;
        playerControlEnabled = false;
        activePersistentCamera = null;
        persistentCameras = new HashMap();
    }
}

