/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

public class Color4f {
    public static final Color4f ZERO = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    public final float r;
    public final float g;
    public final float b;
    public final float a;
    public final int intValue;

    public Color4f(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public Color4f(float r, float g, float b, float a) {
        if (r == -0.0f) {
            r = 0.0f;
        }
        if (g == -0.0f) {
            g = 0.0f;
        }
        if (b == -0.0f) {
            b = 0.0f;
        }
        if (a == -0.0f) {
            a = 0.0f;
        }
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.intValue = (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }

    public static Color4f fromColor(int color) {
        float alpha = (float)((color & 0xFF000000) >>> 24) / 255.0f;
        return Color4f.fromColor(color, alpha);
    }

    public static Color4f fromColor(int color, float alpha) {
        float r = (float)((color & 0xFF0000) >>> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >>> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Color4f(r, g, b, alpha);
    }

    public static Color4f fromColor(Color4f color, float alpha) {
        return new Color4f(color.r, color.g, color.b, alpha);
    }
}

