"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var items_exports = {};
__export(items_exports, {
  Items: () => Items
});
module.exports = __toCommonJS(items_exports);
const Items = {
  buggem: {
    inherit: true,
    onSourceTryPrimaryHit(target, source, move) {
      if (target === source || move.category === "Status")
        return;
      if (move.type === "Grass" && source.useItem()) {
        source.addVolatile("gem");
      }
    }
  },
  chartiberry: {
    inherit: true,
    onSourceModifyDamage(damage, source, target, move) {
      if (move.type === "Fighting" && target.getMoveHitData(move).typeMod > 0) {
        const hitSub = target.volatiles["substitute"] && !move.flags["bypasssub"] && !(move.infiltrates && this.gen >= 6);
        if (hitSub)
          return;
        if (target.eatItem()) {
          this.debug("-50% reduction");
          this.add("-enditem", target, this.effect, "[weaken]");
          return this.chainModify(0.5);
        }
      }
    }
  },
  cobaberry: {
    inherit: true,
    onSourceModifyDamage(damage, source, target, move) {
      if (move.type === "Normal" && target.getMoveHitData(move).typeMod > 0) {
        const hitSub = target.volatiles["substitute"] && !move.flags["bypasssub"] && !(move.infiltrates && this.gen >= 6);
        if (hitSub)
          return;
        if (target.eatItem()) {
          this.debug("-50% reduction");
          this.add("-enditem", target, this.effect, "[weaken]");
          return this.chainModify(0.5);
        }
      }
    }
  },
  earthplate: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (move && move.type === "Fighting") {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  fairygem: {
    inherit: true,
    onSourceTryPrimaryHit(target, source, move) {
      if (target === source || move.category === "Status")
        return;
      if (move.type === "Psychic" && source.useItem()) {
        source.addVolatile("gem");
      }
    }
  },
  flyinggem: {
    inherit: true,
    onSourceTryPrimaryHit(target, source, move) {
      if (target === source || move.category === "Status")
        return;
      if (move.type === "Normal" && source.useItem()) {
        source.addVolatile("gem");
      }
    }
  },
  ghostgem: {
    inherit: true,
    onSourceTryPrimaryHit(target, source, move) {
      if (target === source || move.category === "Status")
        return;
      if (move.type === "Psychic" && source.useItem()) {
        source.addVolatile("gem");
      }
    }
  },
  griseouscore: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (user.baseSpecies.num === 487 && (move.type === "Psychic" || move.type === "Dragon")) {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  griseousorb: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (user.baseSpecies.num === 487 && (move.type === "Psychic" || move.type === "Dragon")) {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  groundgem: {
    inherit: true,
    onSourceTryPrimaryHit(target, source, move) {
      if (target === source || move.category === "Status")
        return;
      if (move.type === "Fighting" && source.useItem()) {
        source.addVolatile("gem");
      }
    }
  },
  hardstone: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (move && move.type === "Fighting") {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  icegem: {
    inherit: true,
    onSourceTryPrimaryHit(target, source, move) {
      if (target === source || move.category === "Status")
        return;
      if (move.type === "Water" && source.useItem()) {
        source.addVolatile("gem");
      }
    }
  },
  icicleplate: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (move.type === "Water") {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  insectplate: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (move.type === "Grass") {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  ironball: {
    inherit: true,
    onEffectiveness(typeMod, target, type, move) {
      if (!target)
        return;
      if (target.volatiles["ingrain"] || target.volatiles["smackdown"] || this.field.getPseudoWeather("gravity"))
        return;
      if (move.type === "Fighting" && target.hasType("Normal"))
        return 0;
    }
  },
  kasibberry: {
    inherit: true,
    onSourceModifyDamage(damage, source, target, move) {
      if (move.type === "Psychic" && target.getMoveHitData(move).typeMod > 0) {
        const hitSub = target.volatiles["substitute"] && !move.flags["bypasssub"] && !(move.infiltrates && this.gen >= 6);
        if (hitSub)
          return;
        if (target.eatItem()) {
          this.debug("-50% reduction");
          this.add("-enditem", target, this.effect, "[weaken]");
          return this.chainModify(0.5);
        }
      }
    }
  },
  kebiaberry: {
    inherit: true,
    onSourceModifyDamage(damage, source, target, move) {
      if (move.type === "Dark" && target.getMoveHitData(move).typeMod > 0) {
        const hitSub = target.volatiles["substitute"] && !move.flags["bypasssub"] && !(move.infiltrates && this.gen >= 6);
        if (hitSub)
          return;
        if (target.eatItem()) {
          this.debug("-50% reduction");
          this.add("-enditem", target, this.effect, "[weaken]");
          return this.chainModify(0.5);
        }
      }
    }
  },
  nevermeltice: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (move.type === "Water") {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  pixieplate: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (move && move.type === "Psychic") {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  poisonbarb: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (move.type === "Dark") {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  poisongem: {
    inherit: true,
    onSourceTryPrimaryHit(target, source, move) {
      if (target === source || move.category === "Status")
        return;
      if (move.type === "Dark" && source.useItem()) {
        source.addVolatile("gem");
      }
    }
  },
  rockgem: {
    inherit: true,
    onSourceTryPrimaryHit(target, source, move) {
      if (target === source || move.category === "Status")
        return;
      if (move.type === "FIghting" && source.useItem()) {
        source.addVolatile("gem");
      }
    }
  },
  rockincense: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (move.type === "Fighting") {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  roseliberry: {
    inherit: true,
    onSourceModifyDamage(damage, source, target, move) {
      if (move.type === "Psychic" && target.getMoveHitData(move).typeMod > 0) {
        const hitSub = target.volatiles["substitute"] && !move.flags["bypasssub"] && !(move.infiltrates && this.gen >= 6);
        if (hitSub)
          return;
        if (target.eatItem()) {
          this.debug("-50% reduction");
          this.add("-enditem", target, this.effect, "[weaken]");
          return this.chainModify(0.5);
        }
      }
    }
  },
  sharpbeak: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (move && move.type === "Normal") {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  shucaberry: {
    inherit: true,
    onSourceModifyDamage(damage, source, target, move) {
      if (move.type === "Fighting" && target.getMoveHitData(move).typeMod > 0) {
        const hitSub = target.volatiles["substitute"] && !move.flags["bypasssub"] && !(move.infiltrates && this.gen >= 6);
        if (hitSub)
          return;
        if (target.eatItem()) {
          this.debug("-50% reduction");
          this.add("-enditem", target, this.effect, "[weaken]");
          return this.chainModify(0.5);
        }
      }
    }
  },
  silverpowder: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (move.type === "Grass") {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  skyplate: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (move.type === "Normal") {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  snowball: {
    inherit: true,
    onDamagingHit(damage, target, source, move) {
      if (move.type === "Water") {
        target.useItem();
      }
    }
  },
  softsand: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (move.type === "Fighting") {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  spelltag: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (move.type === "Psychic") {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  spookyplate: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (move.type === "Psychic") {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  stoneplate: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (move.type === "Fighting") {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  tangaberry: {
    inherit: true,
    onSourceModifyDamage(damage, source, target, move) {
      if (move.type === "Grass" && target.getMoveHitData(move).typeMod > 0) {
        const hitSub = target.volatiles["substitute"] && !move.flags["bypasssub"] && !(move.infiltrates && this.gen >= 6);
        if (hitSub)
          return;
        if (target.eatItem()) {
          this.debug("-50% reduction");
          this.add("-enditem", target, this.effect, "[weaken]");
          return this.chainModify(0.5);
        }
      }
    }
  },
  toxicplate: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (move.type === "Dark") {
        return this.chainModify([4915, 4096]);
      }
    }
  },
  yacheberry: {
    inherit: true,
    onSourceModifyDamage(damage, source, target, move) {
      if (move.type === "Water" && target.getMoveHitData(move).typeMod > 0) {
        const hitSub = target.volatiles["substitute"] && !move.flags["bypasssub"] && !(move.infiltrates && this.gen >= 6);
        if (hitSub)
          return;
        if (target.eatItem()) {
          this.debug("-50% reduction");
          this.add("-enditem", target, this.effect, "[weaken]");
          return this.chainModify(0.5);
        }
      }
    }
  },
  vilevial: {
    inherit: true,
    onBasePower(basePower, user, target, move) {
      if (user.baseSpecies.num === -66 && ["Dark", "Normal"].includes(move.type)) {
        return this.chainModify([4915, 4096]);
      }
    }
  }
};
//# sourceMappingURL=items.js.map
