/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.tinyremapper.api;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.tinyremapper.api.TrEnvironment;
import net.fabricmc.tinyremapper.api.TrField;
import net.fabricmc.tinyremapper.api.TrMember;
import net.fabricmc.tinyremapper.api.TrMethod;
import org.objectweb.asm.ClassVisitor;

public interface TrClass {
    public TrEnvironment getEnvironment();

    public String getName();

    public String getSuperName();

    public List<String> getInterfaceNames();

    public String getSignature();

    public int getAccess();

    public TrClass getSuperClass();

    public List<? extends TrClass> getInterfaces();

    public Collection<? extends TrClass> getParents();

    public Collection<? extends TrClass> getChildren();

    public TrField getField(String var1, String var2);

    public TrMethod getMethod(String var1, String var2);

    public Collection<? extends TrField> getFields();

    public Collection<? extends TrMethod> getMethods();

    public Collection<? extends TrMember> getMembers();

    public Collection<TrField> getFields(String var1, String var2, boolean var3, Predicate<TrField> var4, Collection<TrField> var5);

    public Collection<TrMethod> getMethods(String var1, String var2, boolean var3, Predicate<TrMethod> var4, Collection<TrMethod> var5);

    public TrField resolveField(String var1, String var2);

    public TrMethod resolveMethod(String var1, String var2);

    public Collection<TrField> resolveFields(String var1, String var2, boolean var3, Predicate<TrField> var4, Collection<TrField> var5);

    public Collection<TrMethod> resolveMethods(String var1, String var2, boolean var3, Predicate<TrMethod> var4, Collection<TrMethod> var5);

    public boolean isAssignableFrom(TrClass var1);

    public void accept(ClassVisitor var1, int var2);

    default public boolean isPublic() {
        return (this.getAccess() & 1) != 0;
    }

    default public boolean isFinal() {
        return (this.getAccess() & 0x10) != 0;
    }

    default public boolean isInterface() {
        return (this.getAccess() & 0x200) != 0;
    }

    default public boolean isAbstract() {
        return (this.getAccess() & 0x400) != 0;
    }

    default public boolean isSynthetic() {
        return (this.getAccess() & 0x1000) != 0;
    }

    default public boolean isAnnotation() {
        return (this.getAccess() & 0x2000) != 0;
    }

    default public boolean isEnum() {
        return (this.getAccess() & 0x4000) != 0;
    }

    default public boolean isRecord() {
        return (this.getAccess() & 0x10000) != 0;
    }

    default public boolean isModule() {
        return (this.getAccess() & 0x8000) != 0;
    }
}

