/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.accesswidener;

import net.fabricmc.accesswidener.AccessWidenerReader;
import net.fabricmc.accesswidener.AccessWidenerVisitor;

public class ForwardingVisitor
implements AccessWidenerVisitor {
    private final AccessWidenerVisitor[] visitors;

    public ForwardingVisitor(AccessWidenerVisitor ... visitors) {
        this.visitors = (AccessWidenerVisitor[])visitors.clone();
    }

    @Override
    public void visitHeader(String namespace) {
        for (AccessWidenerVisitor visitor : this.visitors) {
            visitor.visitHeader(namespace);
        }
    }

    @Override
    public void visitClass(String name, AccessWidenerReader.AccessType access, boolean transitive) {
        for (AccessWidenerVisitor visitor : this.visitors) {
            visitor.visitClass(name, access, transitive);
        }
    }

    @Override
    public void visitMethod(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
        for (AccessWidenerVisitor visitor : this.visitors) {
            visitor.visitMethod(owner, name, descriptor, access, transitive);
        }
    }

    @Override
    public void visitField(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
        for (AccessWidenerVisitor visitor : this.visitors) {
            visitor.visitField(owner, name, descriptor, access, transitive);
        }
    }
}

