/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.launch.knot;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.fabricmc.loader.impl.util.log.LogLevel;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.logging.Level;
import org.spongepowered.asm.logging.LoggerAdapterAbstract;

final class MixinLogger
extends LoggerAdapterAbstract {
    private static final Map<String, ILogger> LOGGER_MAP = new ConcurrentHashMap<String, ILogger>();
    private static final Map<Level, LogLevel> LEVEL_MAP = MixinLogger.createLevelMap();
    private final LogCategory logCategory;

    static ILogger get(String name) {
        return LOGGER_MAP.computeIfAbsent(name, MixinLogger::new);
    }

    MixinLogger(String name) {
        super(name);
        this.logCategory = LogCategory.create(name.replace("mixin", LogCategory.MIXIN.name).replace(".", "/"));
    }

    public String getType() {
        return "Fabric Mixin Logger";
    }

    public void catching(Level level, Throwable t) {
        this.log(level, "Catching ".concat(t.toString()), t);
    }

    public void log(Level level, String message, Object ... params) {
        LogLevel fabricLevel = MixinLogger.translateLevel(level);
        if (!Log.shouldLog(fabricLevel, this.logCategory)) {
            return;
        }
        Throwable exc = null;
        if (params != null && params.length > 0) {
            if (message == null) {
                if (params[0] instanceof Throwable) {
                    exc = (Throwable)params[0];
                }
            } else {
                StringBuilder sb = new StringBuilder(message.length() + 20);
                int paramIdx = 0;
                boolean escaped = false;
                int max = message.length();
                for (int i = 0; i < max; ++i) {
                    char c = message.charAt(i);
                    if (escaped) {
                        sb.append(c);
                        escaped = false;
                        continue;
                    }
                    if (c == '\\' && i + 1 < max) {
                        escaped = true;
                        continue;
                    }
                    if (c == '{' && i + 1 < max && message.charAt(i + 1) == '}' && paramIdx < params.length) {
                        Object param;
                        if ((param = params[paramIdx++]) == null) {
                            sb.append("null");
                        } else if (param.getClass().isArray()) {
                            String val = Arrays.deepToString(new Object[]{param});
                            sb.append(val, 1, val.length() - 1);
                        } else {
                            sb.append(param);
                        }
                        ++i;
                        continue;
                    }
                    sb.append(c);
                }
                message = sb.toString();
                if (paramIdx < params.length && params[params.length - 1] instanceof Throwable) {
                    exc = (Throwable)params[params.length - 1];
                }
            }
        }
        Log.log(fabricLevel, this.logCategory, message, exc);
    }

    public void log(Level level, String message, Throwable t) {
        Log.log(MixinLogger.translateLevel(level), this.logCategory, message, t);
    }

    public <T extends Throwable> T throwing(T t) {
        this.log(Level.ERROR, "Throwing ".concat(t.toString()), t);
        return t;
    }

    private static LogLevel translateLevel(Level level) {
        return LEVEL_MAP.getOrDefault(level, LogLevel.INFO);
    }

    private static Map<Level, LogLevel> createLevelMap() {
        EnumMap<Level, LogLevel> ret = new EnumMap<Level, LogLevel>(Level.class);
        ret.put(Level.FATAL, LogLevel.ERROR);
        ret.put(Level.ERROR, LogLevel.ERROR);
        ret.put(Level.WARN, LogLevel.WARN);
        ret.put(Level.INFO, LogLevel.INFO);
        ret.put(Level.DEBUG, LogLevel.DEBUG);
        ret.put(Level.TRACE, LogLevel.TRACE);
        return ret;
    }
}

