/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarsplitter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.internal.Strings;

public class ConsoleTool {
    private static OutputStream NULL_OUTPUT = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    };
    private static byte[] BUFFER = new byte[1024];

    public static void main(String[] args) throws IOException {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec inputO = parser.accepts("input").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec slimO = parser.accepts("slim").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec dataO = parser.accepts("data").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec extraO = parser.accepts("extra").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec srgO = parser.accepts("srg").withRequiredArg().ofType(File.class);
        try {
            OptionSet options = parser.parse(args);
            File input = (File)options.valueOf((OptionSpec)inputO);
            File slim = (File)options.valueOf((OptionSpec)slimO);
            File data = options.has((OptionSpec)dataO) ? (File)options.valueOf((OptionSpec)dataO) : null;
            File extra = options.has((OptionSpec)extraO) ? (File)options.valueOf((OptionSpec)extraO) : null;
            boolean merge = data == null;
            ConsoleTool.log("Splitter: ");
            ConsoleTool.log("  Input:    " + input);
            ConsoleTool.log("  Input:    " + input);
            ConsoleTool.log("  Slim:     " + slim);
            ConsoleTool.log("  Data:     " + data);
            ConsoleTool.log("  Extra:    " + extra);
            if (merge) {
                ConsoleTool.log("  Including data in extra");
            }
            HashSet<String> whitelist = new HashSet<String>();
            if (options.has((OptionSpec)srgO)) {
                for (File dir : options.valuesOf((OptionSpec)srgO)) {
                    ConsoleTool.log("  SRG:   " + dir);
                    List lines = Files.lines(Paths.get(dir.getAbsolutePath(), new String[0])).map(line -> line.split("#")[0]).filter(l -> !Strings.isNullOrEmpty((String)l.trim())).collect(Collectors.toList());
                    lines.stream().filter(line -> !line.startsWith("\t") || line.indexOf(58) != -1 && line.startsWith("CL:")).map(line -> line.indexOf(58) != -1 ? line.substring(4).split(" ") : line.split(" ")).filter(pts -> ((String[])pts).length == 2 && !pts[0].endsWith("/")).forEach(pts -> whitelist.add(pts[0]));
                }
            }
            String inputSha = ConsoleTool.sha1(input, true);
            String srgSha = ConsoleTool.sha1(whitelist);
            ConsoleTool.log("  InputSha: " + inputSha);
            ConsoleTool.log("  SrgSha:   " + srgSha);
            slim = ConsoleTool.checkOutput("Slim", slim, inputSha, srgSha);
            data = ConsoleTool.checkOutput("Data", data, inputSha, srgSha);
            if (extra != null) {
                if (whitelist.isEmpty()) {
                    throw new IllegalArgumentException("--extra argument specified with no --srg class list");
                }
                extra = ConsoleTool.checkOutput("Extra", extra, inputSha, srgSha, merge ? "\nMerge: true" : null);
            } else if (merge) {
                throw new IllegalArgumentException("You must specify --extra if you do not specify --data");
            }
            if (slim == null && data == null && extra == null) {
                ConsoleTool.log("All files up to date");
                return;
            }
            ConsoleTool.log("Splitting: ");
            try (ZipInputStream zinput = new ZipInputStream(new FileInputStream(input));
                 ZipOutputStream zslim = new ZipOutputStream(slim == null ? NULL_OUTPUT : new FileOutputStream(slim));
                 ZipOutputStream zdata = new ZipOutputStream(data == null ? NULL_OUTPUT : new FileOutputStream(data));
                 ZipOutputStream zextra = new ZipOutputStream(extra == null ? NULL_OUTPUT : new FileOutputStream(extra));){
                ZipEntry entry;
                while ((entry = zinput.getNextEntry()) != null) {
                    if (entry.getName().endsWith(".class")) {
                        String key = entry.getName().substring(0, entry.getName().length() - 6);
                        if (whitelist.isEmpty() || whitelist.contains(key)) {
                            ConsoleTool.log("  Slim  " + entry.getName());
                            ConsoleTool.copy(entry, zinput, zslim);
                            continue;
                        }
                        ConsoleTool.log("  Extra " + entry.getName());
                        ConsoleTool.copy(entry, zinput, zextra);
                        continue;
                    }
                    ConsoleTool.log("  Data  " + entry.getName());
                    ConsoleTool.copy(entry, zinput, merge ? zextra : zdata);
                }
            }
            ConsoleTool.writeCache(slim, inputSha, srgSha);
            ConsoleTool.writeCache(data, inputSha, srgSha);
            ConsoleTool.writeCache(extra, inputSha, srgSha);
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }

    private static void copy(ZipEntry entry, InputStream input, ZipOutputStream output) throws IOException {
        ZipEntry _new = new ZipEntry(entry.getName());
        _new.setTime(628041600000L);
        output.putNextEntry(_new);
        int read = -1;
        while ((read = input.read(BUFFER)) != -1) {
            output.write(BUFFER, 0, read);
        }
    }

    private static void writeCache(File file, String inputSha, String srgSha) throws IOException {
        if (file == null) {
            return;
        }
        File cacheFile = new File(file.getAbsolutePath() + ".cache");
        byte[] cache = ("Input: " + inputSha + "\nSrg: " + srgSha + "\nOutput: " + ConsoleTool.sha1(file, false)).getBytes();
        Files.write(cacheFile.toPath(), cache, new OpenOption[0]);
    }

    private static File checkOutput(String name, File file, String inputSha, String srgSha) throws IOException {
        return ConsoleTool.checkOutput(name, file, inputSha, srgSha, null);
    }

    private static File checkOutput(String name, File file, String inputSha, String srgSha, String extra) throws IOException {
        if (file == null) {
            return null;
        }
        File cacheFile = new File(file.getAbsolutePath() + ".cache");
        if (cacheFile.exists()) {
            byte[] data = Files.readAllBytes(cacheFile.toPath());
            byte[] cache = ("Input: " + inputSha + "\nSrg: " + srgSha + "\nOutput: " + ConsoleTool.sha1(file, false) + (extra == null ? "" : extra)).getBytes();
            if (Arrays.equals(cache, data) && file.exists()) {
                ConsoleTool.log("  " + name + " Cache Hit");
                return null;
            }
            ConsoleTool.log("  " + name + " Cache Miss");
            if (!cacheFile.delete()) {
                throw new IOException("Could not delete file: " + cacheFile);
            }
        }
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete file: " + file);
        }
        File parent = file.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Could not make prent folders: " + parent);
        }
        return file;
    }

    public static void log(String message) {
        System.out.println(message);
    }

    private static String sha1(Set<String> data) throws IOException {
        if (data.isEmpty()) {
            return "empty";
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            data.stream().sorted().forEach(e -> digest.update(e.getBytes()));
            return new BigInteger(1, digest.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String sha1(File path, boolean allowCache) throws IOException {
        if (!path.exists()) {
            return "missing";
        }
        File shaFile = new File(path.getAbsolutePath() + ".sha");
        if (allowCache && shaFile.exists()) {
            return Files.lines(shaFile.toPath()).findFirst().orElse("");
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            try (FileInputStream input = new FileInputStream(path);){
                int read = -1;
                while ((read = ((InputStream)input).read(BUFFER)) != -1) {
                    digest.update(BUFFER, 0, read);
                }
                String string = new BigInteger(1, digest.digest()).toString(16);
                return string;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

