/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installertools;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.ProgressMeter;
import net.md_5.specialsource.SpecialSource;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JarProvider;
import net.md_5.specialsource.provider.JointProvider;
import net.minecraftforge.installertools.Task;
import net.minecraftforge.installertools.util.HashFunction;
import net.minecraftforge.installertools.util.VersionJson;

public class DeobfRealms
extends Task {
    @Override
    public void process(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec mapO = parser.accepts("map").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec mcpO = parser.accepts("mcp").withRequiredArg().ofType(String.class).required();
        ArgumentAcceptingOptionSpec mcJarO = parser.accepts("mc").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec jsonO = parser.accepts("json").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec libsO = parser.accepts("libs").withRequiredArg().ofType(File.class);
        try {
            OptionSet options = parser.parse(args);
            File map = (File)options.valueOf((OptionSpec)mapO);
            String mcp = (String)options.valueOf((OptionSpec)mcpO);
            File mcJar = (File)options.valueOf((OptionSpec)mcJarO);
            File json = options.has((OptionSpec)jsonO) ? (File)options.valueOf((OptionSpec)jsonO) : new File(mcJar.getAbsolutePath().substring(0, mcJar.getAbsolutePath().length() - 4) + ".json");
            File libs = options.has((OptionSpec)libsO) ? (File)options.valueOf((OptionSpec)libsO) : new File(mcJar.getParentFile().getParentFile().getParentFile(), "libraries");
            this.log("Jar:  " + mcJar);
            if (mcJar.getName().contains("server")) {
                this.log("Detected server jar, skipping client-only DEOBF_REALMS processor");
                return;
            }
            this.log("Map:  " + map);
            this.log("MCP:  " + mcp);
            this.log("Json: " + json);
            this.log("Libs: " + libs);
            if (!map.exists()) {
                this.error("Missing required Map: " + map);
            }
            if (!mcJar.exists()) {
                this.error("Missing required MC jar: " + mcJar);
            }
            if (!json.exists()) {
                this.error("Missing required Json: " + json);
            }
            if (!libs.exists()) {
                this.error("Missing required Library Directory: " + libs);
            }
            this.log("Loading Json: " + json);
            VersionJson jsonData = VersionJson.load(json);
            if (jsonData.libraries == null) {
                this.log("No libraries, assuming no realms in this version");
                return;
            }
            this.log("Scanning Libraries: ");
            VersionJson.Library realms = null;
            for (VersionJson.Library tmp : jsonData.libraries) {
                this.log("  " + tmp.name);
                if (!"com.mojang".equals(tmp.getArtifact().getGroup()) || !"realms".equals(tmp.getArtifact().getName())) continue;
                realms = tmp;
                break;
            }
            if (realms == null) {
                this.log("No \"com.mojang:realms\" library found, assuming realms disabled for this version.");
                return;
            }
            VersionJson.LibraryDownload artifact = realms.downloads == null ? null : realms.downloads.artifact;
            String path = artifact == null ? realms.getArtifact().getPath() : realms.downloads.artifact.path;
            File vanilla = new File(libs, path);
            File target = new File(libs, path.substring(0, path.length() - 4) + '-' + mcp + ".jar");
            if (target.exists()) {
                this.log("Target \"" + target.getAbsolutePath() + "\" exists, Assuming job done");
                return;
            }
            if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
                this.error("Can not create parent directory \"" + target.getParentFile().getAbsolutePath() + "\" Aborting.");
            }
            if (!vanilla.exists()) {
                if (artifact == null || artifact.url == null) {
                    this.error("Can not downloaad missing realms jar \"" + vanilla.getAbsolutePath() + "\" and no download information avalible.");
                }
                if (!this.download(vanilla, artifact.url.toString(), artifact.sha1)) {
                    this.error("Failed to download realms jar");
                }
            }
            JarMapping mapping = new JarMapping();
            mapping.loadMappings(map);
            this.setVerbose();
            try (Jar vanillaJar = Jar.init((File)vanilla);
                 Jar mcSSJar = Jar.init((File)mcJar);){
                JointProvider inheritanceProviders = new JointProvider();
                inheritanceProviders.add((InheritanceProvider)new JarProvider(vanillaJar));
                inheritanceProviders.add((InheritanceProvider)new JarProvider(mcSSJar));
                mapping.setFallbackInheritanceProvider((InheritanceProvider)inheritanceProviders);
                JarRemapper remapper = new JarRemapper(mapping);
                try {
                    remapper.remapJar(vanillaJar, target);
                }
                catch (IOException e) {
                    if (target.exists()) {
                        target.delete();
                    }
                    throw new RuntimeException(e);
                }
            }
            this.log("Process complete");
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }

    private void setVerbose() {
        try {
            ProgressMeter.printInterval = 10.0;
            Field verbose = SpecialSource.class.getDeclaredField("verbose");
            verbose.setAccessible(true);
            verbose.set(null, true);
        }
        catch (Throwable e) {
            this.log("Could not set verbose. Log may appear to freeze, it's not.");
        }
    }

    private boolean download(File target, String url, String targetSha1) {
        this.log("  Downloading library from " + url);
        try {
            URLConnection connection = this.getConnection(url);
            if (connection != null) {
                Files.copy(connection.getInputStream(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                if (targetSha1 != null) {
                    String actualSha1 = HashFunction.SHA1.hashNullable(target);
                    if (targetSha1.equals(actualSha1)) {
                        this.log("    Download completed: Checksum validated.");
                        return true;
                    }
                    this.log("    Download failed: Checksum invalid, deleting file:");
                    this.log("      Expected: " + targetSha1);
                    this.log("      Actual:   " + actualSha1);
                    if (!target.delete()) {
                        this.log("      Failed to delete file, aborting.");
                        return false;
                    }
                }
                this.log("    Download completed: No checksum, Assuming valid.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private URLConnection getConnection(String address) {
        try {
            int MAX = 3;
            URL url = new URL(address);
            URLConnection connection = null;
            for (int x = 0; x < MAX; ++x) {
                connection = url.openConnection();
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                if (!(connection instanceof HttpURLConnection)) break;
                HttpURLConnection hcon = (HttpURLConnection)connection;
                hcon.setInstanceFollowRedirects(false);
                int res = hcon.getResponseCode();
                if (res != 301 && res != 302) break;
                String location = hcon.getHeaderField("Location");
                hcon.disconnect();
                if (x == MAX - 1) {
                    this.log("Invalid number of redirects: " + location);
                    return null;
                }
                this.log("Following redirect: " + location);
                url = new URL(url, location);
            }
            return connection;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

