/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.progress;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.progress.ClientVisualization;
import org.lwjgl.glfw.GLFW;

public enum EarlyProgressVisualization {
    INSTANCE;

    private Visualization visualization;

    public Runnable accept(Dist dist, boolean isData) {
        return this.accept(dist, isData, null);
    }

    public Runnable accept(Dist dist, boolean isData, @Nullable String mcVersion) {
        this.visualization = !isData && dist.isClient() && Boolean.parseBoolean(System.getProperty("fml.earlyprogresswindow", "true")) ? new ClientVisualization() : new NoVisualization();
        return this.visualization.start(mcVersion);
    }

    public long handOffWindow(IntSupplier width, IntSupplier height, Supplier<String> title, LongSupplier monitor) {
        return this.visualization.handOffWindow(width, height, title, monitor);
    }

    public void updateFBSize(IntConsumer width, IntConsumer height) {
        this.visualization.updateFBSize(width, height);
    }

    private static class NoVisualization
    implements Visualization {
        private NoVisualization() {
        }

        @Override
        public Runnable start(@Nullable String mcVersion) {
            return () -> {};
        }
    }

    static interface Visualization {
        public Runnable start(@Nullable String var1);

        default public long handOffWindow(final IntSupplier width, final IntSupplier height, final Supplier<String> title, final LongSupplier monitorSupplier) {
            return new LongSupplier(){

                @Override
                public long getAsLong() {
                    return GLFW.glfwCreateWindow((int)width.getAsInt(), (int)height.getAsInt(), (CharSequence)((CharSequence)title.get()), (long)monitorSupplier.getAsLong(), (long)0L);
                }
            }.getAsLong();
        }

        default public void updateFBSize(IntConsumer width, IntConsumer height) {
        }
    }
}

