/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarrotBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.JumpController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class RabbitEntity
extends AnimalEntity {
    private static final DataParameter<Integer> field_184773_bv = EntityDataManager.func_187226_a(RabbitEntity.class, DataSerializers.field_187192_b);
    private static final ResourceLocation field_200611_bx = new ResourceLocation("killer_bunny");
    private int field_175540_bm;
    private int field_175535_bn;
    private boolean field_175537_bp;
    private int field_175538_bq;
    private int field_175541_bs;

    public RabbitEntity(EntityType<? extends RabbitEntity> p_i50247_1_, World p_i50247_2_) {
        super(p_i50247_1_, p_i50247_2_);
        this.field_70767_i = new JumpHelperController(this);
        this.field_70765_h = new MoveHelperController(this);
        this.func_175515_b(0.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal(this, 2.2));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199804_a(Items.field_151172_bF, Items.field_151150_bK, Blocks.field_196605_bc), false));
        this.field_70714_bg.func_75776_a(4, new AvoidEntityGoal<PlayerEntity>(this, PlayerEntity.class, 8.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(4, new AvoidEntityGoal<WolfEntity>(this, WolfEntity.class, 10.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(4, new AvoidEntityGoal<MonsterEntity>(this, MonsterEntity.class, 4.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(5, (Goal)new RaidFarmGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 10.0f));
    }

    protected float func_175134_bD() {
        if (!(this.field_70123_F || this.field_70765_h.func_75640_a() && this.field_70765_h.func_179919_e() > this.func_226278_cu_() + 0.5)) {
            Path path = this.field_70699_by.func_75505_d();
            if (path != null && !path.func_75879_b()) {
                Vector3d vector3d = path.func_75878_a((Entity)((Object)this));
                if (vector3d.field_72448_b > this.func_226278_cu_() + 0.5) {
                    return 0.5f;
                }
            }
            return this.field_70765_h.func_75638_b() <= 0.6 ? 0.2f : 0.3f;
        }
        return 0.5f;
    }

    protected void func_70664_aZ() {
        double d1;
        super.func_70664_aZ();
        double d0 = this.field_70765_h.func_75638_b();
        if (d0 > 0.0 && (d1 = RabbitEntity.func_213296_b((Vector3d)this.func_213322_ci())) < 0.01) {
            this.func_213309_a(0.1f, new Vector3d(0.0, 0.0, 1.0));
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_175521_o(float p_175521_1_) {
        return this.field_175535_bn == 0 ? 0.0f : ((float)this.field_175540_bm + p_175521_1_) / (float)this.field_175535_bn;
    }

    public void func_175515_b(double p_175515_1_) {
        this.func_70661_as().func_75489_a(p_175515_1_);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), p_175515_1_);
    }

    public void func_70637_d(boolean p_70637_1_) {
        super.func_70637_d(p_70637_1_);
        if (p_70637_1_) {
            this.func_184185_a(this.func_184771_da(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void func_184770_cZ() {
        this.func_70637_d(true);
        this.field_175535_bn = 10;
        this.field_175540_bm = 0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184773_bv, 0);
    }

    @Override
    public void func_70619_bc() {
        if (this.field_175538_bq > 0) {
            --this.field_175538_bq;
        }
        if (this.field_175541_bs > 0) {
            this.field_175541_bs -= this.field_70146_Z.nextInt(3);
            if (this.field_175541_bs < 0) {
                this.field_175541_bs = 0;
            }
        }
        if (this.field_70122_E) {
            JumpHelperController rabbitentity$jumphelpercontroller;
            LivingEntity livingentity;
            if (!this.field_175537_bp) {
                this.func_70637_d(false);
                this.func_175517_cu();
            }
            if (this.func_175531_cl() == 99 && this.field_175538_bq == 0 && (livingentity = this.func_70638_az()) != null && this.func_70068_e(livingentity) < 16.0) {
                this.func_175533_a(livingentity.func_226277_ct_(), livingentity.func_226281_cx_());
                this.field_70765_h.func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), this.field_70765_h.func_75638_b());
                this.func_184770_cZ();
                this.field_175537_bp = true;
            }
            if (!(rabbitentity$jumphelpercontroller = (JumpHelperController)this.field_70767_i).func_180067_c()) {
                if (this.field_70765_h.func_75640_a() && this.field_175538_bq == 0) {
                    Path path = this.field_70699_by.func_75505_d();
                    Vector3d vector3d = new Vector3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                    if (path != null && !path.func_75879_b()) {
                        vector3d = path.func_75878_a((Entity)((Object)this));
                    }
                    this.func_175533_a(vector3d.field_72450_a, vector3d.field_72449_c);
                    this.func_184770_cZ();
                }
            } else if (!rabbitentity$jumphelpercontroller.func_180065_d()) {
                this.func_175518_cr();
            }
        }
        this.field_175537_bp = this.field_70122_E;
    }

    public boolean func_230269_aK_() {
        return false;
    }

    private void func_175533_a(double p_175533_1_, double p_175533_3_) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(p_175533_3_ - this.func_226281_cx_()), (double)(p_175533_1_ - this.func_226277_ct_())) * 57.2957763671875) - 90.0f;
    }

    private void func_175518_cr() {
        ((JumpHelperController)this.field_70767_i).func_180066_a(true);
    }

    private void func_175520_cs() {
        ((JumpHelperController)this.field_70767_i).func_180066_a(false);
    }

    private void func_175530_ct() {
        this.field_175538_bq = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
    }

    private void func_175517_cu() {
        this.func_175530_ct();
        this.func_175520_cs();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_175540_bm != this.field_175535_bn) {
            ++this.field_175540_bm;
        } else if (this.field_175535_bn != 0) {
            this.field_175540_bm = 0;
            this.field_175535_bn = 0;
            this.func_70637_d(false);
        }
    }

    public static AttributeModifierMap.MutableAttribute func_234224_eJ_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 3.0).func_233815_a_(Attributes.field_233821_d_, 0.3f);
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("RabbitType", this.func_175531_cl());
        p_213281_1_.func_74768_a("MoreCarrotTicks", this.field_175541_bs);
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.func_175529_r(p_70037_1_.func_74762_e("RabbitType"));
        this.field_175541_bs = p_70037_1_.func_74762_e("MoreCarrotTicks");
    }

    protected SoundEvent func_184771_da() {
        return SoundEvents.field_187824_en;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187816_ej;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187822_em;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187820_el;
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        if (this.func_175531_cl() == 99) {
            this.func_184185_a(SoundEvents.field_187818_ek, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            return p_70652_1_.func_70097_a(DamageSource.func_76358_a((LivingEntity)((Object)this)), 8.0f);
        }
        return p_70652_1_.func_70097_a(DamageSource.func_76358_a((LivingEntity)((Object)this)), 3.0f);
    }

    public SoundCategory func_184176_by() {
        return this.func_175531_cl() == 99 ? SoundCategory.HOSTILE : SoundCategory.NEUTRAL;
    }

    @Override
    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        return this.func_180431_b(p_70097_1_) ? false : super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    private boolean func_175525_a(Item p_175525_1_) {
        return p_175525_1_ == Items.field_151172_bF || p_175525_1_ == Items.field_151150_bK || p_175525_1_ == Blocks.field_196605_bc.func_199767_j();
    }

    public RabbitEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        RabbitEntity rabbitentity = EntityType.field_200736_ab.func_200721_a(p_241840_1_);
        int i = this.func_213610_a(p_241840_1_);
        if (this.field_70146_Z.nextInt(20) != 0) {
            i = p_241840_2_ instanceof RabbitEntity && this.field_70146_Z.nextBoolean() ? ((RabbitEntity)p_241840_2_).func_175531_cl() : this.func_175531_cl();
        }
        rabbitentity.func_175529_r(i);
        return rabbitentity;
    }

    @Override
    public boolean func_70877_b(ItemStack p_70877_1_) {
        return this.func_175525_a(p_70877_1_.func_77973_b());
    }

    public int func_175531_cl() {
        return this.field_70180_af.func_187225_a(field_184773_bv);
    }

    public void func_175529_r(int p_175529_1_) {
        if (p_175529_1_ == 99) {
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(8.0);
            this.field_70714_bg.func_75776_a(4, (Goal)new EvilAttackGoal(this));
            this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), PlayerEntity.class, true));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), WolfEntity.class, true));
            if (!this.func_145818_k_()) {
                this.func_200203_b((ITextComponent)new TranslationTextComponent(Util.func_200697_a("entity", field_200611_bx)));
            }
        }
        this.field_70180_af.func_187227_b(field_184773_bv, p_175529_1_);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        int i = this.func_213610_a((IWorld)p_213386_1_);
        if (p_213386_4_ instanceof RabbitData) {
            i = ((RabbitData)((Object)p_213386_4_)).field_179427_a;
        } else {
            p_213386_4_ = new RabbitData(i);
        }
        this.func_175529_r(i);
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    private int func_213610_a(IWorld p_213610_1_) {
        Biome biome = p_213610_1_.func_226691_t_(this.func_233580_cy_());
        int i = this.field_70146_Z.nextInt(100);
        if (biome.func_201851_b() == Biome.RainType.SNOW) {
            return i < 80 ? 1 : 3;
        }
        if (biome.func_201856_r() == Biome.Category.DESERT) {
            return 4;
        }
        return i < 50 ? 0 : (i < 90 ? 5 : 2);
    }

    public static boolean func_223321_c(EntityType<RabbitEntity> p_223321_0_, IWorld p_223321_1_, SpawnReason p_223321_2_, BlockPos p_223321_3_, Random p_223321_4_) {
        BlockState blockstate = p_223321_1_.func_180495_p(p_223321_3_.func_177977_b());
        return (blockstate.func_203425_a(Blocks.field_196658_i) || blockstate.func_203425_a(Blocks.field_150433_aE) || blockstate.func_203425_a(Blocks.field_150354_m)) && p_223321_1_.func_226659_b_(p_223321_3_, 0) > 8;
    }

    private boolean func_175534_cv() {
        return this.field_175541_bs == 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 1) {
            this.func_233569_aL_();
            this.field_175535_bn = 10;
            this.field_175540_bm = 0;
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, 0.6f * this.func_70047_e(), this.func_213311_cf() * 0.4f);
    }

    static class RaidFarmGoal
    extends MoveToBlockGoal {
        private final RabbitEntity field_179500_c;
        private boolean field_179498_d;
        private boolean field_179499_e;

        public RaidFarmGoal(RabbitEntity p_i45860_1_) {
            super((CreatureEntity)p_i45860_1_, (double)0.7f, 16);
            this.field_179500_c = p_i45860_1_;
        }

        public boolean func_75250_a() {
            if (this.field_179496_a <= 0) {
                if (!ForgeEventFactory.getMobGriefingEvent((World)this.field_179500_c.field_70170_p, (Entity)((Object)this.field_179500_c))) {
                    return false;
                }
                this.field_179499_e = false;
                this.field_179498_d = this.field_179500_c.func_175534_cv();
                this.field_179498_d = true;
            }
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            return this.field_179499_e && super.func_75253_b();
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.field_179500_c.func_70671_ap().func_75650_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)(this.field_179494_b.func_177956_o() + 1), (double)this.field_179494_b.func_177952_p() + 0.5, 10.0f, (float)this.field_179500_c.func_70646_bf());
            if (this.func_179487_f()) {
                World world = this.field_179500_c.field_70170_p;
                BlockPos blockpos = this.field_179494_b.func_177984_a();
                BlockState blockstate = world.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                if (this.field_179499_e && block instanceof CarrotBlock) {
                    Integer integer = (Integer)blockstate.func_177229_b((Property)CarrotBlock.field_176488_a);
                    if (integer == 0) {
                        world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 2);
                        world.func_225521_a_(blockpos, true, (Entity)((Object)this.field_179500_c));
                    } else {
                        world.func_180501_a(blockpos, (BlockState)((Object)blockstate.func_206870_a((Property)CarrotBlock.field_176488_a, Integer.valueOf(integer - 1))), 2);
                        world.func_217379_c(2001, blockpos, Block.func_196246_j(blockstate));
                    }
                    this.field_179500_c.field_175541_bs = 40;
                }
                this.field_179499_e = false;
                this.field_179496_a = 10;
            }
        }

        protected boolean func_179488_a(IWorldReader p_179488_1_, BlockPos p_179488_2_) {
            BlockState blockstate;
            Block block = p_179488_1_.func_180495_p(p_179488_2_).func_177230_c();
            if (block == Blocks.field_150458_ak && this.field_179498_d && !this.field_179499_e && (block = (blockstate = p_179488_1_.func_180495_p(p_179488_2_ = p_179488_2_.func_177984_a())).func_177230_c()) instanceof CarrotBlock && ((CarrotBlock)block).func_185525_y(blockstate)) {
                this.field_179499_e = true;
                return true;
            }
            return false;
        }
    }

    public static class RabbitData
    extends AgeableEntity.AgeableData {
        public final int field_179427_a;

        public RabbitData(int p_i45864_1_) {
            super(1.0f);
            this.field_179427_a = p_i45864_1_;
        }
    }

    static class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        private final RabbitEntity field_179486_b;

        public PanicGoal(RabbitEntity p_i45861_1_, double p_i45861_2_) {
            super((CreatureEntity)p_i45861_1_, p_i45861_2_);
            this.field_179486_b = p_i45861_1_;
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.field_179486_b.func_175515_b(this.field_75265_b);
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final RabbitEntity field_179929_g;
        private double field_188492_j;

        public MoveHelperController(RabbitEntity p_i45862_1_) {
            super((MobEntity)((Object)p_i45862_1_));
            this.field_179929_g = p_i45862_1_;
        }

        public void func_75641_c() {
            if (this.field_179929_g.field_70122_E && !this.field_179929_g.field_70703_bu && !((JumpHelperController)this.field_179929_g.field_70767_i).func_180067_c()) {
                this.field_179929_g.func_175515_b(0.0);
            } else if (this.func_75640_a()) {
                this.field_179929_g.func_175515_b(this.field_188492_j);
            }
            super.func_75641_c();
        }

        public void func_75642_a(double p_75642_1_, double p_75642_3_, double p_75642_5_, double p_75642_7_) {
            if (this.field_179929_g.func_70090_H()) {
                p_75642_7_ = 1.5;
            }
            super.func_75642_a(p_75642_1_, p_75642_3_, p_75642_5_, p_75642_7_);
            if (p_75642_7_ > 0.0) {
                this.field_188492_j = p_75642_7_;
            }
        }
    }

    public class JumpHelperController
    extends JumpController {
        private final RabbitEntity field_180070_c;
        private boolean field_180068_d;

        public JumpHelperController(RabbitEntity p_i45863_2_) {
            super((MobEntity)((Object)p_i45863_2_));
            this.field_180070_c = p_i45863_2_;
        }

        public boolean func_180067_c() {
            return this.field_75662_b;
        }

        public boolean func_180065_d() {
            return this.field_180068_d;
        }

        public void func_180066_a(boolean p_180066_1_) {
            this.field_180068_d = p_180066_1_;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                this.field_180070_c.func_184770_cZ();
                this.field_75662_b = false;
            }
        }
    }

    static class EvilAttackGoal
    extends MeleeAttackGoal {
        public EvilAttackGoal(RabbitEntity p_i45867_1_) {
            super((CreatureEntity)p_i45867_1_, 1.4, true);
        }

        @Override
        protected double func_179512_a(LivingEntity p_179512_1_) {
            return 4.0f + p_179512_1_.func_213311_cf();
        }
    }

    static class AvoidEntityGoal<T extends LivingEntity>
    extends net.minecraft.entity.ai.goal.AvoidEntityGoal<T> {
        private final RabbitEntity field_179511_d;

        public AvoidEntityGoal(RabbitEntity p_i46403_1_, Class<T> p_i46403_2_, float p_i46403_3_, double p_i46403_4_, double p_i46403_6_) {
            super((CreatureEntity)p_i46403_1_, p_i46403_2_, p_i46403_3_, p_i46403_4_, p_i46403_6_);
            this.field_179511_d = p_i46403_1_;
        }

        public boolean func_75250_a() {
            return this.field_179511_d.func_175531_cl() != 99 && super.func_75250_a();
        }
    }
}

