/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.lighting;

import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.BlockLightStorage;
import net.minecraft.world.lighting.LightEngine;
import org.apache.commons.lang3.mutable.MutableInt;

public final class BlockLightEngine
extends LightEngine<BlockLightStorage.StorageMap, BlockLightStorage> {
    private static final Direction[] field_215636_d = Direction.values();
    private final BlockPos.Mutable field_215637_e = new BlockPos.Mutable();

    public BlockLightEngine(IChunkLightProvider p_i51301_1_) {
        super(p_i51301_1_, LightType.BLOCK, new BlockLightStorage(p_i51301_1_));
    }

    private int func_215635_d(long worldPos) {
        int i = BlockPos.func_218290_b((long)worldPos);
        int j = BlockPos.func_218274_c((long)worldPos);
        int k = BlockPos.func_218282_d((long)worldPos);
        IBlockReader iblockreader = this.field_215625_a.func_217202_b(i >> 4, k >> 4);
        return iblockreader != null ? iblockreader.func_217298_h((BlockPos)this.field_215637_e.func_181079_c(i, j, k)) : 0;
    }

    @Override
    protected int func_215480_b(long startPos, long endPos, int startLevel) {
        VoxelShape voxelshape1;
        int k;
        int j;
        if (endPos == Long.MAX_VALUE) {
            return 15;
        }
        if (startPos == Long.MAX_VALUE) {
            return startLevel + 15 - this.func_215635_d(endPos);
        }
        if (startLevel >= 15) {
            return startLevel;
        }
        int i = Integer.signum(BlockPos.func_218290_b((long)endPos) - BlockPos.func_218290_b((long)startPos));
        Direction direction = Direction.func_218383_a(i, j = Integer.signum(BlockPos.func_218274_c((long)endPos) - BlockPos.func_218274_c((long)startPos)), k = Integer.signum(BlockPos.func_218282_d((long)endPos) - BlockPos.func_218282_d((long)startPos)));
        if (direction == null) {
            return 15;
        }
        MutableInt mutableint = new MutableInt();
        BlockState blockstate = this.func_227468_a_(endPos, mutableint);
        if (mutableint.getValue() >= 15) {
            return 15;
        }
        BlockState blockstate1 = this.func_227468_a_(startPos, null);
        VoxelShape voxelshape = this.func_223405_a(blockstate1, startPos, direction);
        return VoxelShapes.func_223416_b((VoxelShape)voxelshape, (VoxelShape)(voxelshape1 = this.func_223405_a(blockstate, endPos, direction.func_176734_d()))) ? 15 : startLevel + Math.max(1, mutableint.getValue());
    }

    @Override
    protected void func_215478_a(long pos, int level, boolean isDecreasing) {
        long i = SectionPos.func_218162_e((long)pos);
        for (Direction direction : field_215636_d) {
            long j = BlockPos.func_218289_a((long)pos, (Direction)direction);
            long k = SectionPos.func_218162_e((long)j);
            if (i != k && !((BlockLightStorage)this.field_215627_c).func_215518_g(k)) continue;
            this.func_215475_b(pos, j, level, isDecreasing);
        }
    }

    @Override
    protected int func_215477_a(long pos, long excludedSourcePos, int level) {
        int i = level;
        if (Long.MAX_VALUE != excludedSourcePos) {
            int j = this.func_215480_b(Long.MAX_VALUE, pos, 0);
            if (level > j) {
                i = j;
            }
            if (i == 0) {
                return i;
            }
        }
        long j1 = SectionPos.func_218162_e((long)pos);
        NibbleArray nibblearray = ((BlockLightStorage)this.field_215627_c).func_215520_a(j1, true);
        for (Direction direction : field_215636_d) {
            long l;
            NibbleArray nibblearray1;
            long k = BlockPos.func_218289_a((long)pos, (Direction)direction);
            if (k == excludedSourcePos || (nibblearray1 = j1 == (l = SectionPos.func_218162_e((long)k)) ? nibblearray : ((BlockLightStorage)this.field_215627_c).func_215520_a(l, true)) == null) continue;
            int i1 = this.func_215480_b(k, pos, this.func_215622_a(nibblearray1, k));
            if (i > i1) {
                i = i1;
            }
            if (i != 0) continue;
            return i;
        }
        return i;
    }

    @Override
    public void func_215623_a(BlockPos p_215623_1_, int p_215623_2_) {
        ((BlockLightStorage)this.field_215627_c).func_215532_c();
        this.func_215469_a(Long.MAX_VALUE, p_215623_1_.func_218275_a(), 15 - p_215623_2_, true);
    }

    @Override
    public int queuedUpdateSize() {
        return ((BlockLightStorage)this.field_215627_c).queuedUpdateSize();
    }
}

