/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.border;

import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicLike;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.border.BorderStatus;
import net.minecraft.world.border.IBorderListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WorldBorder {
    private final List<IBorderListener> field_177758_a = Lists.newArrayList();
    private double field_177763_i = 0.2;
    private double field_177760_j = 5.0;
    private int field_177761_k = 15;
    private int field_177759_l = 5;
    private double field_177756_b;
    private double field_177757_c;
    private int field_177762_h = 29999984;
    private IBorderInfo field_212674_i = new StationaryBorderInfo(6.0E7);
    public static final Serializer field_235925_b_ = new Serializer(0.0, 0.0, 0.2, 5.0, 5, 15, 6.0E7, 0L, 0.0);

    public boolean func_177746_a(BlockPos pos) {
        return (double)(pos.func_177958_n() + 1) > this.func_177726_b() && (double)pos.func_177958_n() < this.func_177728_d() && (double)(pos.func_177952_p() + 1) > this.func_177736_c() && (double)pos.func_177952_p() < this.func_177733_e();
    }

    public boolean func_177730_a(ChunkPos range) {
        return (double)range.func_180332_e() > this.func_177726_b() && (double)range.func_180334_c() < this.func_177728_d() && (double)range.func_180330_f() > this.func_177736_c() && (double)range.func_180333_d() < this.func_177733_e();
    }

    public boolean func_177743_a(AxisAlignedBB bb) {
        return bb.field_72336_d > this.func_177726_b() && bb.field_72340_a < this.func_177728_d() && bb.field_72334_f > this.func_177736_c() && bb.field_72339_c < this.func_177733_e();
    }

    public double func_177745_a(Entity entityIn) {
        return this.func_177729_b(entityIn.func_226277_ct_(), entityIn.func_226281_cx_());
    }

    public VoxelShape func_222521_a() {
        return this.field_212674_i.func_222517_m();
    }

    public double func_177729_b(double x, double z) {
        double d0 = z - this.func_177736_c();
        double d1 = this.func_177733_e() - z;
        double d2 = x - this.func_177726_b();
        double d3 = this.func_177728_d() - x;
        double d4 = Math.min(d2, d3);
        d4 = Math.min(d4, d0);
        return Math.min(d4, d1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BorderStatus func_177734_a() {
        return this.field_212674_i.func_212655_i();
    }

    public double func_177726_b() {
        return this.field_212674_i.func_212658_a();
    }

    public double func_177736_c() {
        return this.field_212674_i.func_212656_c();
    }

    public double func_177728_d() {
        return this.field_212674_i.func_212654_b();
    }

    public double func_177733_e() {
        return this.field_212674_i.func_212648_d();
    }

    public double func_230316_a_() {
        return this.field_177756_b;
    }

    public double func_230317_b_() {
        return this.field_177757_c;
    }

    public void func_177739_c(double x, double z) {
        this.field_177756_b = x;
        this.field_177757_c = z;
        this.field_212674_i.func_212653_k();
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177693_a(this, x, z);
        }
    }

    public double func_177741_h() {
        return this.field_212674_i.func_212647_e();
    }

    public long func_177732_i() {
        return this.field_212674_i.func_212657_g();
    }

    public double func_177751_j() {
        return this.field_212674_i.func_212650_h();
    }

    public void func_177750_a(double newSize) {
        this.field_212674_i = new StationaryBorderInfo(newSize);
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177694_a(this, newSize);
        }
    }

    public void func_177738_a(double oldSize, double newSize, long time) {
        this.field_212674_i = oldSize == newSize ? new StationaryBorderInfo(newSize) : new MovingBorderInfo(oldSize, newSize, time);
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177692_a(this, oldSize, newSize, time);
        }
    }

    protected List<IBorderListener> func_177735_k() {
        return Lists.newArrayList(this.field_177758_a);
    }

    public void func_177737_a(IBorderListener listener) {
        this.field_177758_a.add(listener);
    }

    public void removeListener(IBorderListener listener) {
        this.field_177758_a.remove(listener);
    }

    public void func_177725_a(int size) {
        this.field_177762_h = size;
        this.field_212674_i.func_212652_j();
    }

    public int func_177722_l() {
        return this.field_177762_h;
    }

    public double func_177742_m() {
        return this.field_177760_j;
    }

    public void func_177724_b(double bufferSize) {
        this.field_177760_j = bufferSize;
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177695_c(this, bufferSize);
        }
    }

    public double func_177727_n() {
        return this.field_177763_i;
    }

    public void func_177744_c(double newAmount) {
        this.field_177763_i = newAmount;
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177696_b(this, newAmount);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_177749_o() {
        return this.field_212674_i.func_212649_f();
    }

    public int func_177740_p() {
        return this.field_177761_k;
    }

    public void func_177723_b(int warningTime) {
        this.field_177761_k = warningTime;
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177691_a(this, warningTime);
        }
    }

    public int func_177748_q() {
        return this.field_177759_l;
    }

    public void func_177747_c(int warningDistance) {
        this.field_177759_l = warningDistance;
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177690_b(this, warningDistance);
        }
    }

    public void func_212673_r() {
        this.field_212674_i = this.field_212674_i.func_212651_l();
    }

    public Serializer func_235927_t_() {
        return new Serializer(this);
    }

    public void func_235926_a_(Serializer serializer) {
        this.func_177739_c(serializer.func_235937_a_(), serializer.func_235940_b_());
        this.func_177744_c(serializer.func_235941_c_());
        this.func_177724_b(serializer.func_235942_d_());
        this.func_177747_c(serializer.func_235943_e_());
        this.func_177723_b(serializer.func_235944_f_());
        if (serializer.func_235946_h_() > 0L) {
            this.func_177738_a(serializer.func_235945_g_(), serializer.func_235947_i_(), serializer.func_235946_h_());
        } else {
            this.func_177750_a(serializer.func_235945_g_());
        }
    }

    class StationaryBorderInfo
    implements IBorderInfo {
        private final double field_212667_b;
        private double field_212668_c;
        private double field_212669_d;
        private double field_212670_e;
        private double field_212671_f;
        private VoxelShape field_222518_g;

        public StationaryBorderInfo(double size) {
            this.field_212667_b = size;
            this.func_212665_m();
        }

        @Override
        public double func_212658_a() {
            return this.field_212668_c;
        }

        @Override
        public double func_212654_b() {
            return this.field_212670_e;
        }

        @Override
        public double func_212656_c() {
            return this.field_212669_d;
        }

        @Override
        public double func_212648_d() {
            return this.field_212671_f;
        }

        @Override
        public double func_212647_e() {
            return this.field_212667_b;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public BorderStatus func_212655_i() {
            return BorderStatus.STATIONARY;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public double func_212649_f() {
            return 0.0;
        }

        @Override
        public long func_212657_g() {
            return 0L;
        }

        @Override
        public double func_212650_h() {
            return this.field_212667_b;
        }

        private void func_212665_m() {
            this.field_212668_c = Math.max(WorldBorder.this.func_230316_a_() - this.field_212667_b / 2.0, (double)(-WorldBorder.this.field_177762_h));
            this.field_212669_d = Math.max(WorldBorder.this.func_230317_b_() - this.field_212667_b / 2.0, (double)(-WorldBorder.this.field_177762_h));
            this.field_212670_e = Math.min(WorldBorder.this.func_230316_a_() + this.field_212667_b / 2.0, (double)WorldBorder.this.field_177762_h);
            this.field_212671_f = Math.min(WorldBorder.this.func_230317_b_() + this.field_212667_b / 2.0, (double)WorldBorder.this.field_177762_h);
            this.field_222518_g = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.field_216389_a, (VoxelShape)VoxelShapes.func_197873_a((double)Math.floor(this.func_212658_a()), (double)Double.NEGATIVE_INFINITY, (double)Math.floor(this.func_212656_c()), (double)Math.ceil(this.func_212654_b()), (double)Double.POSITIVE_INFINITY, (double)Math.ceil(this.func_212648_d())), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        }

        @Override
        public void func_212652_j() {
            this.func_212665_m();
        }

        @Override
        public void func_212653_k() {
            this.func_212665_m();
        }

        @Override
        public IBorderInfo func_212651_l() {
            return this;
        }

        @Override
        public VoxelShape func_222517_m() {
            return this.field_222518_g;
        }
    }

    public static class Serializer {
        private final double field_235928_a_;
        private final double field_235929_b_;
        private final double field_235930_c_;
        private final double field_235931_d_;
        private final int field_235932_e_;
        private final int field_235933_f_;
        private final double field_235934_g_;
        private final long field_235935_h_;
        private final double field_235936_i_;

        private Serializer(double centerX, double centerZ, double damagePerBlock, double damageBuffer, int warningDistance, int warningTime, double size, long sizeLerpTime, double sizeLerpTarget) {
            this.field_235928_a_ = centerX;
            this.field_235929_b_ = centerZ;
            this.field_235930_c_ = damagePerBlock;
            this.field_235931_d_ = damageBuffer;
            this.field_235932_e_ = warningDistance;
            this.field_235933_f_ = warningTime;
            this.field_235934_g_ = size;
            this.field_235935_h_ = sizeLerpTime;
            this.field_235936_i_ = sizeLerpTarget;
        }

        private Serializer(WorldBorder border) {
            this.field_235928_a_ = border.func_230316_a_();
            this.field_235929_b_ = border.func_230317_b_();
            this.field_235930_c_ = border.func_177727_n();
            this.field_235931_d_ = border.func_177742_m();
            this.field_235932_e_ = border.func_177748_q();
            this.field_235933_f_ = border.func_177740_p();
            this.field_235934_g_ = border.func_177741_h();
            this.field_235935_h_ = border.func_177732_i();
            this.field_235936_i_ = border.func_177751_j();
        }

        public double func_235937_a_() {
            return this.field_235928_a_;
        }

        public double func_235940_b_() {
            return this.field_235929_b_;
        }

        public double func_235941_c_() {
            return this.field_235930_c_;
        }

        public double func_235942_d_() {
            return this.field_235931_d_;
        }

        public int func_235943_e_() {
            return this.field_235932_e_;
        }

        public int func_235944_f_() {
            return this.field_235933_f_;
        }

        public double func_235945_g_() {
            return this.field_235934_g_;
        }

        public long func_235946_h_() {
            return this.field_235935_h_;
        }

        public double func_235947_i_() {
            return this.field_235936_i_;
        }

        public static Serializer func_235938_a_(DynamicLike<?> dynamic, Serializer defaultIn) {
            double d0 = dynamic.get("BorderCenterX").asDouble(defaultIn.field_235928_a_);
            double d1 = dynamic.get("BorderCenterZ").asDouble(defaultIn.field_235929_b_);
            double d2 = dynamic.get("BorderSize").asDouble(defaultIn.field_235934_g_);
            long i = dynamic.get("BorderSizeLerpTime").asLong(defaultIn.field_235935_h_);
            double d3 = dynamic.get("BorderSizeLerpTarget").asDouble(defaultIn.field_235936_i_);
            double d4 = dynamic.get("BorderSafeZone").asDouble(defaultIn.field_235931_d_);
            double d5 = dynamic.get("BorderDamagePerBlock").asDouble(defaultIn.field_235930_c_);
            int j = dynamic.get("BorderWarningBlocks").asInt(defaultIn.field_235932_e_);
            int k = dynamic.get("BorderWarningTime").asInt(defaultIn.field_235933_f_);
            return new Serializer(d0, d1, d5, d4, j, k, d2, i, d3);
        }

        public void func_235939_a_(CompoundNBT nbt) {
            nbt.func_74780_a("BorderCenterX", this.field_235928_a_);
            nbt.func_74780_a("BorderCenterZ", this.field_235929_b_);
            nbt.func_74780_a("BorderSize", this.field_235934_g_);
            nbt.func_74772_a("BorderSizeLerpTime", this.field_235935_h_);
            nbt.func_74780_a("BorderSafeZone", this.field_235931_d_);
            nbt.func_74780_a("BorderDamagePerBlock", this.field_235930_c_);
            nbt.func_74780_a("BorderSizeLerpTarget", this.field_235936_i_);
            nbt.func_74780_a("BorderWarningBlocks", this.field_235932_e_);
            nbt.func_74780_a("BorderWarningTime", this.field_235933_f_);
        }
    }

    class MovingBorderInfo
    implements IBorderInfo {
        private final double field_212660_b;
        private final double field_212661_c;
        private final long field_212662_d;
        private final long field_212663_e;
        private final double field_212664_f;

        private MovingBorderInfo(double oldSize, double newSize, long transitionTime) {
            this.field_212660_b = oldSize;
            this.field_212661_c = newSize;
            this.field_212664_f = transitionTime;
            this.field_212663_e = Util.func_211177_b();
            this.field_212662_d = this.field_212663_e + transitionTime;
        }

        @Override
        public double func_212658_a() {
            return Math.max(WorldBorder.this.func_230316_a_() - this.func_212647_e() / 2.0, (double)(-WorldBorder.this.field_177762_h));
        }

        @Override
        public double func_212656_c() {
            return Math.max(WorldBorder.this.func_230317_b_() - this.func_212647_e() / 2.0, (double)(-WorldBorder.this.field_177762_h));
        }

        @Override
        public double func_212654_b() {
            return Math.min(WorldBorder.this.func_230316_a_() + this.func_212647_e() / 2.0, (double)WorldBorder.this.field_177762_h);
        }

        @Override
        public double func_212648_d() {
            return Math.min(WorldBorder.this.func_230317_b_() + this.func_212647_e() / 2.0, (double)WorldBorder.this.field_177762_h);
        }

        @Override
        public double func_212647_e() {
            double d0 = (double)(Util.func_211177_b() - this.field_212663_e) / this.field_212664_f;
            return d0 < 1.0 ? MathHelper.func_219803_d((double)d0, (double)this.field_212660_b, (double)this.field_212661_c) : this.field_212661_c;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public double func_212649_f() {
            return Math.abs(this.field_212660_b - this.field_212661_c) / (double)(this.field_212662_d - this.field_212663_e);
        }

        @Override
        public long func_212657_g() {
            return this.field_212662_d - Util.func_211177_b();
        }

        @Override
        public double func_212650_h() {
            return this.field_212661_c;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public BorderStatus func_212655_i() {
            return this.field_212661_c < this.field_212660_b ? BorderStatus.SHRINKING : BorderStatus.GROWING;
        }

        @Override
        public void func_212653_k() {
        }

        @Override
        public void func_212652_j() {
        }

        @Override
        public IBorderInfo func_212651_l() {
            IBorderInfo iBorderInfo;
            if (this.func_212657_g() <= 0L) {
                WorldBorder worldBorder = WorldBorder.this;
                worldBorder.getClass();
                iBorderInfo = worldBorder.new StationaryBorderInfo(this.field_212661_c);
            } else {
                iBorderInfo = this;
            }
            return iBorderInfo;
        }

        @Override
        public VoxelShape func_222517_m() {
            return VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.field_216389_a, (VoxelShape)VoxelShapes.func_197873_a((double)Math.floor(this.func_212658_a()), (double)Double.NEGATIVE_INFINITY, (double)Math.floor(this.func_212656_c()), (double)Math.ceil(this.func_212654_b()), (double)Double.POSITIVE_INFINITY, (double)Math.ceil(this.func_212648_d())), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        }
    }

    static interface IBorderInfo {
        public double func_212658_a();

        public double func_212654_b();

        public double func_212656_c();

        public double func_212648_d();

        public double func_212647_e();

        @OnlyIn(value=Dist.CLIENT)
        public double func_212649_f();

        public long func_212657_g();

        public double func_212650_h();

        @OnlyIn(value=Dist.CLIENT)
        public BorderStatus func_212655_i();

        public void func_212652_j();

        public void func_212653_k();

        public IBorderInfo func_212651_l();

        public VoxelShape func_222517_m();
    }
}

