/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.data.TagsProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgeItemTagsProvider
extends ItemTagsProvider {
    public ForgeItemTagsProvider(DataGenerator gen, BlockTagsProvider blockTagProvider, ExistingFileHelper existingFileHelper) {
        super(gen, blockTagProvider, "forge", existingFileHelper);
    }

    public void func_200432_c() {
        this.func_240522_a_(Tags.Items.BONES).func_240532_a_((Object)Items.field_151103_aS);
        this.func_240522_a_(Tags.Items.BOOKSHELVES).func_240532_a_((Object)Items.field_221651_bN);
        this.func_240521_a_(Tags.Blocks.CHESTS, Tags.Items.CHESTS);
        this.func_240521_a_(Tags.Blocks.CHESTS_ENDER, Tags.Items.CHESTS_ENDER);
        this.func_240521_a_(Tags.Blocks.CHESTS_TRAPPED, Tags.Items.CHESTS_TRAPPED);
        this.func_240521_a_(Tags.Blocks.CHESTS_WOODEN, Tags.Items.CHESTS_WOODEN);
        this.func_240521_a_(Tags.Blocks.COBBLESTONE, Tags.Items.COBBLESTONE);
        this.func_240522_a_(Tags.Items.CROPS).addTags(new ITag.INamedTag[]{Tags.Items.CROPS_BEETROOT, Tags.Items.CROPS_CARROT, Tags.Items.CROPS_NETHER_WART, Tags.Items.CROPS_POTATO, Tags.Items.CROPS_WHEAT});
        this.func_240522_a_(Tags.Items.CROPS_BEETROOT).func_240532_a_((Object)Items.field_185164_cV);
        this.func_240522_a_(Tags.Items.CROPS_CARROT).func_240532_a_((Object)Items.field_151172_bF);
        this.func_240522_a_(Tags.Items.CROPS_NETHER_WART).func_240532_a_((Object)Items.field_151075_bm);
        this.func_240522_a_(Tags.Items.CROPS_POTATO).func_240532_a_((Object)Items.field_151174_bG);
        this.func_240522_a_(Tags.Items.CROPS_WHEAT).func_240532_a_((Object)Items.field_151015_O);
        this.func_240522_a_(Tags.Items.DUSTS).addTags(new ITag.INamedTag[]{Tags.Items.DUSTS_GLOWSTONE, Tags.Items.DUSTS_PRISMARINE, Tags.Items.DUSTS_REDSTONE});
        this.func_240522_a_(Tags.Items.DUSTS_GLOWSTONE).func_240532_a_((Object)Items.field_151114_aO);
        this.func_240522_a_(Tags.Items.DUSTS_PRISMARINE).func_240532_a_((Object)Items.field_179562_cC);
        this.func_240522_a_(Tags.Items.DUSTS_REDSTONE).func_240532_a_((Object)Items.field_151137_ax);
        this.addColored(arg_0 -> ForgeItemTagsProvider.lambda$addTags$0(this.func_240522_a_(Tags.Items.DYES), arg_0), Tags.Items.DYES, "{color}_dye");
        this.func_240522_a_(Tags.Items.EGGS).func_240532_a_((Object)Items.field_151110_aK);
        this.func_240521_a_(Tags.Blocks.END_STONES, Tags.Items.END_STONES);
        this.func_240522_a_(Tags.Items.ENDER_PEARLS).func_240532_a_((Object)Items.field_151079_bi);
        this.func_240522_a_(Tags.Items.FEATHERS).func_240532_a_((Object)Items.field_151008_G);
        this.func_240521_a_(Tags.Blocks.FENCE_GATES, Tags.Items.FENCE_GATES);
        this.func_240521_a_(Tags.Blocks.FENCE_GATES_WOODEN, Tags.Items.FENCE_GATES_WOODEN);
        this.func_240521_a_(Tags.Blocks.FENCES, Tags.Items.FENCES);
        this.func_240521_a_(Tags.Blocks.FENCES_NETHER_BRICK, Tags.Items.FENCES_NETHER_BRICK);
        this.func_240521_a_(Tags.Blocks.FENCES_WOODEN, Tags.Items.FENCES_WOODEN);
        this.func_240522_a_(Tags.Items.GEMS).addTags(new ITag.INamedTag[]{Tags.Items.GEMS_DIAMOND, Tags.Items.GEMS_EMERALD, Tags.Items.GEMS_LAPIS, Tags.Items.GEMS_PRISMARINE, Tags.Items.GEMS_QUARTZ});
        this.func_240522_a_(Tags.Items.GEMS_DIAMOND).func_240532_a_((Object)Items.field_151045_i);
        this.func_240522_a_(Tags.Items.GEMS_EMERALD).func_240532_a_((Object)Items.field_151166_bC);
        this.func_240522_a_(Tags.Items.GEMS_LAPIS).func_240532_a_((Object)Items.field_196128_bn);
        this.func_240522_a_(Tags.Items.GEMS_PRISMARINE).func_240532_a_((Object)Items.field_179563_cD);
        this.func_240522_a_(Tags.Items.GEMS_QUARTZ).func_240532_a_((Object)Items.field_151128_bU);
        this.func_240521_a_(Tags.Blocks.GLASS, Tags.Items.GLASS);
        this.func_240521_a_Colored(Tags.Blocks.GLASS, Tags.Items.GLASS);
        this.func_240521_a_(Tags.Blocks.GLASS_PANES, Tags.Items.GLASS_PANES);
        this.func_240521_a_Colored(Tags.Blocks.GLASS_PANES, Tags.Items.GLASS_PANES);
        this.func_240521_a_(Tags.Blocks.GRAVEL, Tags.Items.GRAVEL);
        this.func_240522_a_(Tags.Items.GUNPOWDER).func_240532_a_((Object)Items.field_151016_H);
        this.func_240522_a_(Tags.Items.HEADS).func_240534_a_((Object[])new Item[]{Items.field_196185_dy, Items.field_196151_dA, Items.field_196184_dx, Items.field_196182_dv, Items.field_196183_dw, Items.field_196186_dz});
        this.func_240522_a_(Tags.Items.INGOTS).addTags(new ITag.INamedTag[]{Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_GOLD, Tags.Items.INGOTS_BRICK, Tags.Items.INGOTS_NETHER_BRICK, Tags.Items.INGOTS_NETHERITE});
        this.func_240522_a_(Tags.Items.INGOTS_BRICK).func_240532_a_((Object)Items.field_151118_aC);
        this.func_240522_a_(Tags.Items.INGOTS_GOLD).func_240532_a_((Object)Items.field_151043_k);
        this.func_240522_a_(Tags.Items.INGOTS_IRON).func_240532_a_((Object)Items.field_151042_j);
        this.func_240522_a_(Tags.Items.INGOTS_NETHERITE).func_240532_a_((Object)Items.field_234759_km_);
        this.func_240522_a_(Tags.Items.INGOTS_NETHER_BRICK).func_240532_a_((Object)Items.field_196154_dH);
        this.func_240522_a_(Tags.Items.LEATHER).func_240532_a_((Object)Items.field_151116_aA);
        this.func_240522_a_(Tags.Items.MUSHROOMS).func_240534_a_((Object[])new Item[]{Items.field_221692_bh, Items.field_221694_bi});
        this.func_240522_a_(Tags.Items.NETHER_STARS).func_240532_a_((Object)Items.field_151156_bN);
        this.func_240521_a_(Tags.Blocks.NETHERRACK, Tags.Items.NETHERRACK);
        this.func_240522_a_(Tags.Items.NUGGETS).addTags(new ITag.INamedTag[]{Tags.Items.NUGGETS_IRON, Tags.Items.NUGGETS_GOLD});
        this.func_240522_a_(Tags.Items.NUGGETS_IRON).func_240532_a_((Object)Items.field_191525_da);
        this.func_240522_a_(Tags.Items.NUGGETS_GOLD).func_240532_a_((Object)Items.field_151074_bl);
        this.func_240521_a_(Tags.Blocks.OBSIDIAN, Tags.Items.OBSIDIAN);
        this.func_240521_a_(Tags.Blocks.ORES, Tags.Items.ORES);
        this.func_240521_a_(Tags.Blocks.ORES_COAL, Tags.Items.ORES_COAL);
        this.func_240521_a_(Tags.Blocks.ORES_DIAMOND, Tags.Items.ORES_DIAMOND);
        this.func_240521_a_(Tags.Blocks.ORES_EMERALD, Tags.Items.ORES_EMERALD);
        this.func_240521_a_(Tags.Blocks.ORES_GOLD, Tags.Items.ORES_GOLD);
        this.func_240521_a_(Tags.Blocks.ORES_IRON, Tags.Items.ORES_IRON);
        this.func_240521_a_(Tags.Blocks.ORES_LAPIS, Tags.Items.ORES_LAPIS);
        this.func_240521_a_(Tags.Blocks.ORES_QUARTZ, Tags.Items.ORES_QUARTZ);
        this.func_240521_a_(Tags.Blocks.ORES_REDSTONE, Tags.Items.ORES_REDSTONE);
        this.func_240521_a_(Tags.Blocks.ORES_NETHERITE_SCRAP, Tags.Items.ORES_NETHERITE_SCRAP);
        this.func_240522_a_(Tags.Items.RODS).addTags(new ITag.INamedTag[]{Tags.Items.RODS_BLAZE, Tags.Items.RODS_WOODEN});
        this.func_240522_a_(Tags.Items.RODS_BLAZE).func_240532_a_((Object)Items.field_151072_bj);
        this.func_240522_a_(Tags.Items.RODS_WOODEN).func_240532_a_((Object)Items.field_151055_y);
        this.func_240521_a_(Tags.Blocks.SAND, Tags.Items.SAND);
        this.func_240521_a_(Tags.Blocks.SAND_COLORLESS, Tags.Items.SAND_COLORLESS);
        this.func_240521_a_(Tags.Blocks.SAND_RED, Tags.Items.SAND_RED);
        this.func_240521_a_(Tags.Blocks.SANDSTONE, Tags.Items.SANDSTONE);
        this.func_240522_a_(Tags.Items.SEEDS).addTags(new ITag.INamedTag[]{Tags.Items.SEEDS_BEETROOT, Tags.Items.SEEDS_MELON, Tags.Items.SEEDS_PUMPKIN, Tags.Items.SEEDS_WHEAT});
        this.func_240522_a_(Tags.Items.SEEDS_BEETROOT).func_240532_a_((Object)Items.field_185163_cU);
        this.func_240522_a_(Tags.Items.SEEDS_MELON).func_240532_a_((Object)Items.field_151081_bc);
        this.func_240522_a_(Tags.Items.SEEDS_PUMPKIN).func_240532_a_((Object)Items.field_151080_bb);
        this.func_240522_a_(Tags.Items.SEEDS_WHEAT).func_240532_a_((Object)Items.field_151014_N);
        this.func_240522_a_(Tags.Items.SHEARS).func_240532_a_((Object)Items.field_151097_aZ);
        this.func_240522_a_(Tags.Items.SLIMEBALLS).func_240532_a_((Object)Items.field_151123_aH);
        this.func_240521_a_(Tags.Blocks.STAINED_GLASS, Tags.Items.STAINED_GLASS);
        this.func_240521_a_(Tags.Blocks.STAINED_GLASS_PANES, Tags.Items.STAINED_GLASS_PANES);
        this.func_240521_a_(Tags.Blocks.STONE, Tags.Items.STONE);
        this.func_240521_a_(Tags.Blocks.STORAGE_BLOCKS, Tags.Items.STORAGE_BLOCKS);
        this.func_240521_a_(Tags.Blocks.STORAGE_BLOCKS_COAL, Tags.Items.STORAGE_BLOCKS_COAL);
        this.func_240521_a_(Tags.Blocks.STORAGE_BLOCKS_DIAMOND, Tags.Items.STORAGE_BLOCKS_DIAMOND);
        this.func_240521_a_(Tags.Blocks.STORAGE_BLOCKS_EMERALD, Tags.Items.STORAGE_BLOCKS_EMERALD);
        this.func_240521_a_(Tags.Blocks.STORAGE_BLOCKS_GOLD, Tags.Items.STORAGE_BLOCKS_GOLD);
        this.func_240521_a_(Tags.Blocks.STORAGE_BLOCKS_IRON, Tags.Items.STORAGE_BLOCKS_IRON);
        this.func_240521_a_(Tags.Blocks.STORAGE_BLOCKS_LAPIS, Tags.Items.STORAGE_BLOCKS_LAPIS);
        this.func_240521_a_(Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Tags.Items.STORAGE_BLOCKS_QUARTZ);
        this.func_240521_a_(Tags.Blocks.STORAGE_BLOCKS_REDSTONE, Tags.Items.STORAGE_BLOCKS_REDSTONE);
        this.func_240521_a_(Tags.Blocks.STORAGE_BLOCKS_NETHERITE, Tags.Items.STORAGE_BLOCKS_NETHERITE);
        this.func_240522_a_(Tags.Items.STRING).func_240532_a_((Object)Items.field_151007_F);
    }

    private void addColored(Consumer<ITag.INamedTag<Item>> consumer, ITag.INamedTag<Item> group, String pattern) {
        String prefix = group.func_230234_a_().func_110623_a().toUpperCase(Locale.ENGLISH) + '_';
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation key = new ResourceLocation("minecraft", pattern.replace("{color}", color.func_176762_d()));
            ITag.INamedTag<Item> tag = this.getForgeItemTag(prefix + color.func_176762_d());
            Item item = ForgeRegistries.ITEMS.getValue(key);
            if (item == null || item == Items.field_190931_a) {
                throw new IllegalStateException("Unknown vanilla item: " + key.toString());
            }
            this.func_240522_a_(tag).func_240532_a_((Object)item);
            consumer.accept(tag);
        }
    }

    private void func_240521_a_Colored(ITag.INamedTag<Block> blockGroup, ITag.INamedTag<Item> itemGroup) {
        String blockPre = blockGroup.func_230234_a_().func_110623_a().toUpperCase(Locale.ENGLISH) + '_';
        String itemPre = itemGroup.func_230234_a_().func_110623_a().toUpperCase(Locale.ENGLISH) + '_';
        for (DyeColor color : DyeColor.values()) {
            ITag.INamedTag<Block> from = this.getForgeBlockTag(blockPre + color.func_176762_d());
            ITag.INamedTag<Item> to = this.getForgeItemTag(itemPre + color.func_176762_d());
            this.func_240521_a_(from, to);
        }
        this.func_240521_a_(this.getForgeBlockTag(blockPre + "colorless"), this.getForgeItemTag(itemPre + "colorless"));
    }

    private ITag.INamedTag<Block> getForgeBlockTag(String name) {
        try {
            name = name.toUpperCase(Locale.ENGLISH);
            return (ITag.INamedTag)Tags.Blocks.class.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(Tags.Blocks.class.getName() + " is missing tag name: " + name);
        }
    }

    private ITag.INamedTag<Item> getForgeItemTag(String name) {
        try {
            name = name.toUpperCase(Locale.ENGLISH);
            return (ITag.INamedTag)Tags.Items.class.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(Tags.Items.class.getName() + " is missing tag name: " + name);
        }
    }

    public String func_200397_b() {
        return "Forge Item Tags";
    }

    private static /* synthetic */ void lambda$addTags$0(TagsProvider.Builder rec$, ITag.INamedTag xva$0) {
        rec$.addTags(new ITag.INamedTag[]{xva$0});
    }
}

