/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.PortalInfo;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.SpawnLocationHelper;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.HorseInventoryContainer;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.AbstractMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.item.crafting.ServerRecipeBook;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.network.play.server.SCameraPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SCloseWindowPacket;
import net.minecraft.network.play.server.SCombatPacket;
import net.minecraft.network.play.server.SDestroyEntitiesPacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SMerchantOffersPacket;
import net.minecraft.network.play.server.SOpenBookWindowPacket;
import net.minecraft.network.play.server.SOpenHorseWindowPacket;
import net.minecraft.network.play.server.SOpenSignMenuPacket;
import net.minecraft.network.play.server.SOpenWindowPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SPlayerLookPacket;
import net.minecraft.network.play.server.SRemoveEntityEffectPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SSendResourcePackPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetExperiencePacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.network.play.server.SSpawnPlayerPacket;
import net.minecraft.network.play.server.SUnloadChunkPacket;
import net.minecraft.network.play.server.SUpdateHealthPacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.network.play.server.SWindowItemsPacket;
import net.minecraft.network.play.server.SWindowPropertyPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.state.Property;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ServerCooldownTracker;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.util.text.filter.IChatFilter;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPlayerEntity
extends PlayerEntity
implements IContainerListener {
    private static final Logger field_147102_bM = LogManager.getLogger();
    public ServerPlayNetHandler field_71135_a;
    public final MinecraftServer field_71133_b;
    public final PlayerInteractionManager field_71134_c;
    private final List<Integer> field_71130_g = Lists.newLinkedList();
    private final PlayerAdvancements field_192042_bX;
    private final ServerStatisticsManager field_147103_bO;
    private float field_130068_bO = Float.MIN_VALUE;
    private int field_184852_bV = Integer.MIN_VALUE;
    private int field_184853_bW = Integer.MIN_VALUE;
    private int field_184854_bX = Integer.MIN_VALUE;
    private int field_184855_bY = Integer.MIN_VALUE;
    private int field_184856_bZ = Integer.MIN_VALUE;
    private float field_71149_ch = -1.0E8f;
    private int field_71146_ci = -99999999;
    private boolean field_71147_cj = true;
    private int field_71144_ck = -99999999;
    private int field_147101_bU = 60;
    private ChatVisibility field_71143_cn;
    private boolean field_71140_co = true;
    private long field_143005_bX = Util.func_211177_b();
    private Entity field_175401_bS;
    private boolean field_184851_cj;
    private boolean field_192040_cp;
    private final ServerRecipeBook field_192041_cq = new ServerRecipeBook();
    private Vector3d field_193107_ct;
    private int field_193108_cu;
    private boolean field_193109_cv;
    @Nullable
    private Vector3d field_193110_cw;
    private SectionPos field_213851_cv = SectionPos.func_218154_a((int)0, (int)0, (int)0);
    private RegistryKey<World> field_241137_cq_ = World.field_234918_g_;
    @Nullable
    private BlockPos field_241138_cr_;
    private boolean field_241139_cs_;
    private float field_242108_cn;
    @Nullable
    private final IChatFilter field_244528_co;
    public int field_71139_cq;
    public boolean field_71137_h;
    public int field_71138_i;
    public boolean field_71136_j;
    private String language = "en_us";

    public ServerPlayerEntity(MinecraftServer p_i45285_1_, ServerWorld p_i45285_2_, GameProfile p_i45285_3_, PlayerInteractionManager p_i45285_4_) {
        super(p_i45285_2_, p_i45285_2_.func_241135_u_(), p_i45285_2_.func_242107_v(), p_i45285_3_);
        p_i45285_4_.field_73090_b = this;
        this.field_71134_c = p_i45285_4_;
        this.field_71133_b = p_i45285_1_;
        this.field_147103_bO = p_i45285_1_.func_184103_al().func_152602_a(this);
        this.field_192042_bX = p_i45285_1_.func_184103_al().func_192054_h(this);
        this.field_70138_W = 1.0f;
        this.func_205734_a(p_i45285_2_);
        this.field_244528_co = p_i45285_1_.func_244435_a(this);
    }

    private void func_205734_a(ServerWorld p_205734_1_) {
        BlockPos blockpos = p_205734_1_.func_241135_u_();
        if (p_205734_1_.func_230315_m_().func_218272_d() && p_205734_1_.func_73046_m().func_240793_aU_().func_76077_q() != GameType.ADVENTURE) {
            long k;
            long l;
            int i = Math.max(0, this.field_71133_b.func_184108_a(p_205734_1_));
            int j = MathHelper.func_76128_c((double)p_205734_1_.func_175723_af().func_177729_b(blockpos.func_177958_n(), blockpos.func_177952_p()));
            if (j < i) {
                i = j;
            }
            if (j <= 1) {
                i = 1;
            }
            int i1 = (l = (k = (long)(i * 2 + 1)) * k) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            int j1 = this.func_205735_q(i1);
            int k1 = new Random().nextInt(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i2 = (k1 + j1 * l1) % i1;
                int j2 = i2 % (i * 2 + 1);
                int k2 = i2 / (i * 2 + 1);
                BlockPos blockpos1 = SpawnLocationHelper.func_241092_a_((ServerWorld)p_205734_1_, (int)(blockpos.func_177958_n() + j2 - i), (int)(blockpos.func_177952_p() + k2 - i), (boolean)false);
                if (blockpos1 == null) continue;
                this.func_174828_a(blockpos1, 0.0f, 0.0f);
                if (!p_205734_1_.func_226669_j_(this)) {
                    continue;
                }
                break;
            }
        } else {
            this.func_174828_a(blockpos, 0.0f, 0.0f);
            while (!p_205734_1_.func_226669_j_(this) && this.func_226278_cu_() < 255.0) {
                this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_());
            }
        }
    }

    private int func_205735_q(int p_205735_1_) {
        return p_205735_1_ <= 16 ? p_205735_1_ - 1 : 17;
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_150297_b("playerGameType", 99)) {
            if (this.func_184102_h().func_104056_am()) {
                this.field_71134_c.func_241820_a(this.func_184102_h().func_71265_f(), GameType.NOT_SET);
            } else {
                this.field_71134_c.func_241820_a(GameType.func_77146_a((int)p_70037_1_.func_74762_e("playerGameType")), p_70037_1_.func_150297_b("previousPlayerGameType", 3) ? GameType.func_77146_a((int)p_70037_1_.func_74762_e("previousPlayerGameType")) : GameType.NOT_SET);
            }
        }
        if (p_70037_1_.func_150297_b("enteredNetherPosition", 10)) {
            CompoundNBT compoundnbt = p_70037_1_.func_74775_l("enteredNetherPosition");
            this.field_193110_cw = new Vector3d(compoundnbt.func_74769_h("x"), compoundnbt.func_74769_h("y"), compoundnbt.func_74769_h("z"));
        }
        this.field_192040_cp = p_70037_1_.func_74767_n("seenCredits");
        if (p_70037_1_.func_150297_b("recipeBook", 10)) {
            this.field_192041_cq.func_192825_a(p_70037_1_.func_74775_l("recipeBook"), this.field_71133_b.func_199529_aN());
        }
        if (this.func_70608_bn()) {
            this.func_213366_dy();
        }
        if (p_70037_1_.func_150297_b("SpawnX", 99) && p_70037_1_.func_150297_b("SpawnY", 99) && p_70037_1_.func_150297_b("SpawnZ", 99)) {
            this.field_241138_cr_ = new BlockPos(p_70037_1_.func_74762_e("SpawnX"), p_70037_1_.func_74762_e("SpawnY"), p_70037_1_.func_74762_e("SpawnZ"));
            this.field_241139_cs_ = p_70037_1_.func_74767_n("SpawnForced");
            this.field_242108_cn = p_70037_1_.func_74760_g("SpawnAngle");
            if (p_70037_1_.func_74764_b("SpawnDimension")) {
                this.field_241137_cq_ = World.field_234917_f_.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)p_70037_1_.func_74781_a("SpawnDimension")).resultOrPartial(arg_0 -> ((Logger)field_147102_bM).error(arg_0)).orElse(World.field_234918_g_);
            }
        }
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("playerGameType", this.field_71134_c.func_73081_b().func_77148_a());
        p_213281_1_.func_74768_a("previousPlayerGameType", this.field_71134_c.func_241815_c_().func_77148_a());
        p_213281_1_.func_74757_a("seenCredits", this.field_192040_cp);
        if (this.field_193110_cw != null) {
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74780_a("x", this.field_193110_cw.field_72450_a);
            compoundnbt.func_74780_a("y", this.field_193110_cw.field_72448_b);
            compoundnbt.func_74780_a("z", this.field_193110_cw.field_72449_c);
            p_213281_1_.func_218657_a("enteredNetherPosition", compoundnbt);
        }
        Entity entity1 = this.func_184208_bv();
        Entity entity = this.func_184187_bx();
        if (entity != null && entity1 != this && entity1.func_200601_bK()) {
            CompoundNBT compoundnbt1 = new CompoundNBT();
            CompoundNBT compoundnbt2 = new CompoundNBT();
            entity1.func_70039_c(compoundnbt2);
            compoundnbt1.func_186854_a("Attach", entity.func_110124_au());
            compoundnbt1.func_218657_a("Entity", compoundnbt2);
            p_213281_1_.func_218657_a("RootVehicle", compoundnbt1);
        }
        p_213281_1_.func_218657_a("recipeBook", this.field_192041_cq.func_192824_e());
        p_213281_1_.func_74778_a("Dimension", this.field_70170_p.func_234923_W_().func_240901_a_().toString());
        if (this.field_241138_cr_ != null) {
            p_213281_1_.func_74768_a("SpawnX", this.field_241138_cr_.func_177958_n());
            p_213281_1_.func_74768_a("SpawnY", this.field_241138_cr_.func_177956_o());
            p_213281_1_.func_74768_a("SpawnZ", this.field_241138_cr_.func_177952_p());
            p_213281_1_.func_74757_a("SpawnForced", this.field_241139_cs_);
            p_213281_1_.func_74776_a("SpawnAngle", this.field_242108_cn);
            ResourceLocation.field_240908_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.field_241137_cq_.func_240901_a_()).resultOrPartial(arg_0 -> ((Logger)field_147102_bM).error(arg_0)).ifPresent(p_241148_1_ -> p_213281_1_.func_218657_a("SpawnDimension", (INBT)p_241148_1_));
        }
    }

    public void func_195394_a(int p_195394_1_) {
        float f = this.func_71050_bK();
        float f1 = (f - 1.0f) / f;
        this.field_71106_cc = MathHelper.func_76131_a((float)((float)p_195394_1_ / f), (float)0.0f, (float)f1);
        this.field_71144_ck = -1;
    }

    public void func_195399_b(int p_195399_1_) {
        this.field_71068_ca = p_195399_1_;
        this.field_71144_ck = -1;
    }

    @Override
    public void func_82242_a(int p_82242_1_) {
        super.func_82242_a(p_82242_1_);
        this.field_71144_ck = -1;
    }

    @Override
    public void func_192024_a(ItemStack p_192024_1_, int p_192024_2_) {
        super.func_192024_a(p_192024_1_, p_192024_2_);
        this.field_71144_ck = -1;
    }

    public void func_71116_b() {
        this.field_71070_bA.func_75132_a(this);
    }

    @Override
    public void func_152111_bt() {
        super.func_152111_bt();
        this.field_71135_a.func_147359_a((IPacket<?>)new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTER_COMBAT));
    }

    @Override
    public void func_152112_bu() {
        super.func_152112_bu();
        this.field_71135_a.func_147359_a((IPacket<?>)new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.END_COMBAT));
    }

    @Override
    protected void func_191955_a(BlockState p_191955_1_) {
        CriteriaTriggers.field_192124_d.func_192193_a(this, p_191955_1_);
    }

    @Override
    protected CooldownTracker func_184815_l() {
        return new ServerCooldownTracker(this);
    }

    @Override
    public void func_70071_h_() {
        this.field_71134_c.func_73075_a();
        --this.field_147101_bU;
        if (this.field_70172_ad > 0) {
            --this.field_70172_ad;
        }
        this.field_71070_bA.func_75142_b();
        if (!this.field_70170_p.field_72995_K && !this.field_71070_bA.func_75145_c(this)) {
            this.func_71053_j();
            this.field_71070_bA = this.field_71069_bz;
        }
        while (!this.field_71130_g.isEmpty()) {
            int i = Math.min(this.field_71130_g.size(), Integer.MAX_VALUE);
            int[] aint = new int[i];
            Iterator<Integer> iterator = this.field_71130_g.iterator();
            int j = 0;
            while (iterator.hasNext() && j < i) {
                aint[j++] = iterator.next();
                iterator.remove();
            }
            this.field_71135_a.func_147359_a((IPacket<?>)new SDestroyEntitiesPacket(aint));
        }
        Entity entity = this.func_175398_C();
        if (entity != this) {
            if (entity.func_70089_S()) {
                this.func_70080_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
                this.func_71121_q().func_72863_F().func_217221_a(this);
                if (this.func_226564_dU_()) {
                    this.func_175399_e(this);
                }
            } else {
                this.func_175399_e(this);
            }
        }
        CriteriaTriggers.field_193135_v.func_193182_a(this);
        if (this.field_193107_ct != null) {
            CriteriaTriggers.field_193133_t.func_193162_a(this, this.field_193107_ct, this.field_70173_aa - this.field_193108_cu);
        }
        this.field_192042_bX.func_192741_b(this);
    }

    public void func_71127_g() {
        try {
            if (!this.func_175149_v() || this.field_70170_p.func_175667_e(this.func_233580_cy_())) {
                super.func_70071_h_();
            }
            for (int i = 0; i < this.field_71071_by.func_70302_i_(); ++i) {
                IPacket ipacket;
                ItemStack itemstack = this.field_71071_by.func_70301_a(i);
                if (!itemstack.func_77973_b().func_77643_m_() || (ipacket = ((AbstractMapItem)itemstack.func_77973_b()).func_150911_c(itemstack, this.field_70170_p, (PlayerEntity)this)) == null) continue;
                this.field_71135_a.func_147359_a(ipacket);
            }
            if (this.func_110143_aJ() != this.field_71149_ch || this.field_71146_ci != this.field_71100_bB.func_75116_a() || this.field_71100_bB.func_75115_e() == 0.0f != this.field_71147_cj) {
                this.field_71135_a.func_147359_a((IPacket<?>)new SUpdateHealthPacket(this.func_110143_aJ(), this.field_71100_bB.func_75116_a(), this.field_71100_bB.func_75115_e()));
                this.field_71149_ch = this.func_110143_aJ();
                this.field_71146_ci = this.field_71100_bB.func_75116_a();
                boolean bl = this.field_71147_cj = this.field_71100_bB.func_75115_e() == 0.0f;
            }
            if (this.func_110143_aJ() + this.func_110139_bj() != this.field_130068_bO) {
                this.field_130068_bO = this.func_110143_aJ() + this.func_110139_bj();
                this.func_184849_a(ScoreCriteria.field_96638_f, MathHelper.func_76123_f((float)this.field_130068_bO));
            }
            if (this.field_71100_bB.func_75116_a() != this.field_184852_bV) {
                this.field_184852_bV = this.field_71100_bB.func_75116_a();
                this.func_184849_a(ScoreCriteria.field_186698_h, MathHelper.func_76123_f((float)this.field_184852_bV));
            }
            if (this.func_70086_ai() != this.field_184853_bW) {
                this.field_184853_bW = this.func_70086_ai();
                this.func_184849_a(ScoreCriteria.field_186699_i, MathHelper.func_76123_f((float)this.field_184853_bW));
            }
            if (this.func_70658_aO() != this.field_184854_bX) {
                this.field_184854_bX = this.func_70658_aO();
                this.func_184849_a(ScoreCriteria.field_186700_j, MathHelper.func_76123_f((float)this.field_184854_bX));
            }
            if (this.field_71067_cb != this.field_184856_bZ) {
                this.field_184856_bZ = this.field_71067_cb;
                this.func_184849_a(ScoreCriteria.field_186701_k, MathHelper.func_76123_f((float)this.field_184856_bZ));
            }
            if (this.field_71068_ca != this.field_184855_bY) {
                this.field_184855_bY = this.field_71068_ca;
                this.func_184849_a(ScoreCriteria.field_186702_l, MathHelper.func_76123_f((float)this.field_184855_bY));
            }
            if (this.field_71067_cb != this.field_71144_ck) {
                this.field_71144_ck = this.field_71067_cb;
                this.field_71135_a.func_147359_a((IPacket<?>)new SSetExperiencePacket(this.field_71106_cc, this.field_71067_cb, this.field_71068_ca));
            }
            if (this.field_70173_aa % 20 == 0) {
                CriteriaTriggers.field_192135_o.func_192215_a(this);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Ticking player");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Player being ticked");
            this.func_85029_a(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    private void func_184849_a(ScoreCriteria p_184849_1_, int p_184849_2_) {
        this.func_96123_co().func_197893_a(p_184849_1_, this.func_195047_I_(), p_195397_1_ -> p_195397_1_.func_96647_c(p_184849_2_));
    }

    @Override
    public void func_70645_a(DamageSource p_70645_1_) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)p_70645_1_)) {
            return;
        }
        boolean flag = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223609_l);
        if (flag) {
            ITextComponent itextcomponent = this.func_110142_aN().func_151521_b();
            this.field_71135_a.func_211148_a((IPacket<?>)new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTITY_DIED, itextcomponent), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)p_212356_2_ -> {
                if (!p_212356_2_.isSuccess()) {
                    int i = 256;
                    String s = itextcomponent.func_212636_a(256);
                    TranslationTextComponent itextcomponent1 = new TranslationTextComponent("death.attack.message_too_long", new StringTextComponent(s).func_240699_a_(TextFormatting.YELLOW));
                    IFormattableTextComponent itextcomponent2 = new TranslationTextComponent("death.attack.even_more_magic", this.func_145748_c_()).func_240700_a_(arg_0 -> ServerPlayerEntity.func_212357_a_((ITextComponent)itextcomponent1, arg_0));
                    this.field_71135_a.func_147359_a((IPacket<?>)new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTITY_DIED, (ITextComponent)itextcomponent2));
                }
            }));
            Team team = this.func_96124_cp();
            if (team != null && team.func_178771_j() != Team.Visible.ALWAYS) {
                if (team.func_178771_j() == Team.Visible.HIDE_FOR_OTHER_TEAMS) {
                    this.field_71133_b.func_184103_al().func_177453_a(this, itextcomponent);
                } else if (team.func_178771_j() == Team.Visible.HIDE_FOR_OWN_TEAM) {
                    this.field_71133_b.func_184103_al().func_177452_b(this, itextcomponent);
                }
            } else {
                this.field_71133_b.func_184103_al().func_232641_a_(itextcomponent, ChatType.SYSTEM, Util.field_240973_b_);
            }
        } else {
            this.field_71135_a.func_147359_a((IPacket<?>)new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTITY_DIED));
        }
        this.func_192030_dh();
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_234895_F_)) {
            this.func_241157_eT_();
        }
        if (!this.func_175149_v()) {
            this.func_213345_d(p_70645_1_);
        }
        this.func_96123_co().func_197893_a(ScoreCriteria.field_96642_c, this.func_195047_I_(), Score::func_96648_a);
        LivingEntity livingentity = this.func_94060_bK();
        if (livingentity != null) {
            this.func_71029_a(Stats.field_199091_i.func_199076_b(livingentity.func_200600_R()));
            livingentity.func_191956_a(this, this.field_70744_aE, p_70645_1_);
            this.func_226298_f_(livingentity);
        }
        this.field_70170_p.func_72960_a(this, (byte)3);
        this.func_195066_a(Stats.field_188069_A);
        this.func_175145_a(Stats.field_199092_j.func_199076_b(Stats.field_188098_h));
        this.func_175145_a(Stats.field_199092_j.func_199076_b(Stats.field_203284_n));
        this.func_70066_B();
        this.func_70052_a(0, false);
        this.func_110142_aN().func_94549_h();
    }

    private void func_241157_eT_() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.func_233580_cy_()).func_72314_b(32.0, 10.0, 32.0);
        this.field_70170_p.func_225317_b(MobEntity.class, axisalignedbb).stream().filter(p_241155_0_ -> p_241155_0_ instanceof IAngerable).forEach(p_241145_1_ -> ((IAngerable)p_241145_1_).func_233681_b_((PlayerEntity)this));
    }

    @Override
    public void func_191956_a(Entity p_191956_1_, int p_191956_2_, DamageSource p_191956_3_) {
        if (p_191956_1_ != this) {
            super.func_191956_a(p_191956_1_, p_191956_2_, p_191956_3_);
            this.func_85039_t(p_191956_2_);
            String s = this.func_195047_I_();
            String s1 = p_191956_1_.func_195047_I_();
            this.func_96123_co().func_197893_a(ScoreCriteria.field_96640_e, s, Score::func_96648_a);
            if (p_191956_1_ instanceof PlayerEntity) {
                this.func_195066_a(Stats.field_75932_A);
                this.func_96123_co().func_197893_a(ScoreCriteria.field_96639_d, s, Score::func_96648_a);
            } else {
                this.func_195066_a(Stats.field_188070_B);
            }
            this.func_195398_a(s, s1, ScoreCriteria.field_197913_m);
            this.func_195398_a(s1, s, ScoreCriteria.field_197914_n);
            CriteriaTriggers.field_192122_b.func_192211_a(this, p_191956_1_, p_191956_3_);
        }
    }

    private void func_195398_a(String p_195398_1_, String p_195398_2_, ScoreCriteria[] p_195398_3_) {
        int i;
        ScorePlayerTeam scoreplayerteam = this.func_96123_co().func_96509_i(p_195398_2_);
        if (scoreplayerteam != null && (i = scoreplayerteam.func_178775_l().func_175746_b()) >= 0 && i < p_195398_3_.length) {
            this.func_96123_co().func_197893_a(p_195398_3_[i], p_195398_1_, Score::func_96648_a);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        boolean flag;
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        boolean bl = flag = this.field_71133_b.func_71262_S() && this.func_175400_cq() && "fall".equals(p_70097_1_.field_76373_n);
        if (!flag && this.field_147101_bU > 0 && p_70097_1_ != DamageSource.field_76380_i) {
            return false;
        }
        if (p_70097_1_ instanceof EntityDamageSource) {
            AbstractArrowEntity abstractarrowentity;
            Entity entity1;
            Entity entity = p_70097_1_.func_76346_g();
            if (entity instanceof PlayerEntity && !this.func_96122_a((PlayerEntity)entity)) {
                return false;
            }
            if (entity instanceof AbstractArrowEntity && (entity1 = (abstractarrowentity = (AbstractArrowEntity)((Object)entity)).func_234616_v_()) instanceof PlayerEntity && !this.func_96122_a((PlayerEntity)entity1)) {
                return false;
            }
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    @Override
    public boolean func_96122_a(PlayerEntity p_96122_1_) {
        return !this.func_175400_cq() ? false : super.func_96122_a(p_96122_1_);
    }

    private boolean func_175400_cq() {
        return this.field_71133_b.func_71219_W();
    }

    @Override
    @Nullable
    protected PortalInfo func_241829_a(ServerWorld p_241829_1_) {
        PortalInfo portalinfo = super.func_241829_a(p_241829_1_);
        if (portalinfo != null && this.field_70170_p.func_234923_W_() == World.field_234918_g_ && p_241829_1_.func_234923_W_() == World.field_234920_i_) {
            Vector3d vector3d = portalinfo.field_222505_a.func_72441_c(0.0, -1.0, 0.0);
            return new PortalInfo(vector3d, Vector3d.field_186680_a, 90.0f, 0.0f);
        }
        return portalinfo;
    }

    @Override
    @Nullable
    public Entity changeDimension(ServerWorld p_241206_1_, ITeleporter teleporter) {
        if (!ForgeHooks.onTravelToDimension((Entity)this, p_241206_1_.func_234923_W_())) {
            return null;
        }
        this.field_184851_cj = true;
        ServerWorld serverworld = this.func_71121_q();
        RegistryKey<World> registrykey = serverworld.func_234923_W_();
        if (registrykey == World.field_234920_i_ && p_241206_1_.func_234923_W_() == World.field_234918_g_ && teleporter.isVanilla()) {
            this.func_213319_R();
            this.func_71121_q().removePlayer(this, true);
            if (!this.field_71136_j) {
                this.field_71136_j = true;
                this.field_71135_a.func_147359_a((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241768_e_, this.field_192040_cp ? 0.0f : 1.0f));
                this.field_192040_cp = true;
            }
            return this;
        }
        IWorldInfo iworldinfo = p_241206_1_.func_72912_H();
        this.field_71135_a.func_147359_a((IPacket<?>)new SRespawnPacket(p_241206_1_.func_230315_m_(), p_241206_1_.func_234923_W_(), BiomeManager.func_235200_a_((long)p_241206_1_.func_72905_C()), this.field_71134_c.func_73081_b(), this.field_71134_c.func_241815_c_(), p_241206_1_.func_234925_Z_(), p_241206_1_.func_241109_A_(), true));
        this.field_71135_a.func_147359_a((IPacket<?>)new SServerDifficultyPacket(iworldinfo.func_176130_y(), iworldinfo.func_176123_z()));
        PlayerList playerlist = this.field_71133_b.func_184103_al();
        playerlist.func_187243_f(this);
        serverworld.removeEntity(this, true);
        this.revive();
        PortalInfo portalinfo = teleporter.getPortalInfo((Entity)this, p_241206_1_, this::func_241829_a);
        if (portalinfo != null) {
            Entity e = teleporter.placeEntity((Entity)this, serverworld, p_241206_1_, this.field_70177_z, spawnPortal -> {
                serverworld.func_217381_Z().func_76320_a("moving");
                if (registrykey == World.field_234918_g_ && p_241206_1_.func_234923_W_() == World.field_234919_h_) {
                    this.field_193110_cw = this.func_213303_ch();
                } else if (spawnPortal.booleanValue() && p_241206_1_.func_234923_W_() == World.field_234920_i_) {
                    this.func_242110_a(p_241206_1_, new BlockPos(portalinfo.field_222505_a));
                }
                serverworld.func_217381_Z().func_76319_b();
                serverworld.func_217381_Z().func_76320_a("placing");
                this.func_70029_a(p_241206_1_);
                p_241206_1_.func_217447_b(this);
                this.func_70101_b(portalinfo.field_242960_c, portalinfo.field_242961_d);
                this.func_225653_b_(portalinfo.field_222505_a.field_72450_a, portalinfo.field_222505_a.field_72448_b, portalinfo.field_222505_a.field_72449_c);
                serverworld.func_217381_Z().func_76319_b();
                this.func_213846_b(serverworld);
                return this;
            });
            if (e != this) {
                throw new IllegalArgumentException(String.format("Teleporter %s returned not the player entity but instead %s, expected PlayerEntity %s", new Object[]{teleporter, e, this}));
            }
            this.field_71134_c.func_73080_a(p_241206_1_);
            this.field_71135_a.func_147359_a((IPacket<?>)new SPlayerAbilitiesPacket(this.field_71075_bZ));
            playerlist.func_72354_b(this, p_241206_1_);
            playerlist.func_72385_f(this);
            for (EffectInstance effectinstance : this.func_70651_bq()) {
                this.field_71135_a.func_147359_a((IPacket<?>)new SPlayEntityEffectPacket(this.func_145782_y(), effectinstance));
            }
            if (teleporter.playTeleportSound(this, serverworld, p_241206_1_)) {
                this.field_71135_a.func_147359_a((IPacket<?>)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
            }
            this.field_71144_ck = -1;
            this.field_71149_ch = -1.0f;
            this.field_71146_ci = -1;
            BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)this, registrykey, p_241206_1_.func_234923_W_());
        }
        return this;
    }

    private void func_242110_a(ServerWorld p_242110_1_, BlockPos p_242110_2_) {
        BlockPos.Mutable blockpos$mutable = p_242110_2_.func_239590_i_();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int k = -1; k < 3; ++k) {
                    BlockState blockstate = k == -1 ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P();
                    p_242110_1_.func_175656_a((BlockPos)blockpos$mutable.func_189533_g((Vector3i)p_242110_2_).func_196234_d(j, k, i), blockstate);
                }
            }
        }
    }

    @Override
    protected Optional<TeleportationRepositioner.Result> func_241830_a(ServerWorld p_241830_1_, BlockPos p_241830_2_, boolean p_241830_3_) {
        Optional<TeleportationRepositioner.Result> optional = super.func_241830_a(p_241830_1_, p_241830_2_, p_241830_3_);
        if (optional.isPresent()) {
            return optional;
        }
        Direction.Axis direction$axis = this.field_70170_p.func_180495_p(this.field_242271_ac).func_235903_d_((Property)NetherPortalBlock.field_176550_a).orElse(Direction.Axis.X);
        Optional<TeleportationRepositioner.Result> optional1 = p_241830_1_.func_85176_s().func_242956_a(p_241830_2_, direction$axis);
        if (!optional1.isPresent()) {
            field_147102_bM.error("Unable to create a portal, likely target out of worldborder");
        }
        return optional1;
    }

    private void func_213846_b(ServerWorld p_213846_1_) {
        RegistryKey<World> registrykey = p_213846_1_.func_234923_W_();
        RegistryKey<World> registrykey1 = this.field_70170_p.func_234923_W_();
        CriteriaTriggers.field_193134_u.func_233551_a_(this, registrykey, registrykey1);
        if (registrykey == World.field_234919_h_ && registrykey1 == World.field_234918_g_ && this.field_193110_cw != null) {
            CriteriaTriggers.field_193131_B.func_193168_a(this, this.field_193110_cw);
        }
        if (registrykey1 != World.field_234919_h_) {
            this.field_193110_cw = null;
        }
    }

    @Override
    public boolean func_174827_a(ServerPlayerEntity p_174827_1_) {
        if (p_174827_1_.func_175149_v()) {
            return this.func_175398_C() == this;
        }
        return this.func_175149_v() ? false : super.func_174827_a(p_174827_1_);
    }

    private void func_147097_b(TileEntity p_147097_1_) {
        SUpdateTileEntityPacket supdatetileentitypacket;
        if (p_147097_1_ != null && (supdatetileentitypacket = p_147097_1_.func_189518_D_()) != null) {
            this.field_71135_a.func_147359_a((IPacket<?>)supdatetileentitypacket);
        }
    }

    @Override
    public void func_71001_a(Entity p_71001_1_, int p_71001_2_) {
        super.func_71001_a(p_71001_1_, p_71001_2_);
        this.field_71070_bA.func_75142_b();
    }

    @Override
    public Either<PlayerEntity.SleepResult, Unit> func_213819_a(BlockPos p_213819_1_) {
        Optional<BlockPos> optAt = Optional.of(p_213819_1_);
        PlayerEntity.SleepResult ret = ForgeEventFactory.onPlayerSleepInBed((PlayerEntity)this, optAt);
        if (ret != null) {
            return Either.left((Object)((Object)ret));
        }
        Direction direction = (Direction)((Object)this.field_70170_p.func_180495_p(p_213819_1_).func_177229_b((Property)HorizontalBlock.field_185512_D));
        if (!this.func_70608_bn() && this.func_70089_S()) {
            if (!this.field_70170_p.func_230315_m_().func_236043_f_()) {
                return Either.left((Object)((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_HERE));
            }
            if (!this.func_241147_a_(p_213819_1_, direction)) {
                return Either.left((Object)((Object)PlayerEntity.SleepResult.TOO_FAR_AWAY));
            }
            if (this.func_241156_b_(p_213819_1_, direction)) {
                return Either.left((Object)((Object)PlayerEntity.SleepResult.OBSTRUCTED));
            }
            this.func_242111_a(this.field_70170_p.func_234923_W_(), p_213819_1_, this.field_70177_z, false, true);
            if (!ForgeEventFactory.fireSleepingTimeCheck((PlayerEntity)this, optAt)) {
                return Either.left((Object)((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_NOW));
            }
            if (!this.func_184812_l_()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)p_213819_1_);
                List<MonsterEntity> list = this.field_70170_p.func_175647_a(MonsterEntity.class, new AxisAlignedBB(vector3d.func_82615_a() - 8.0, vector3d.func_82617_b() - 5.0, vector3d.func_82616_c() - 8.0, vector3d.func_82615_a() + 8.0, vector3d.func_82617_b() + 5.0, vector3d.func_82616_c() + 8.0), p_241146_1_ -> p_241146_1_.func_230292_f_((PlayerEntity)this));
                if (!list.isEmpty()) {
                    return Either.left((Object)((Object)PlayerEntity.SleepResult.NOT_SAFE));
                }
            }
            Either either = super.func_213819_a(p_213819_1_).ifRight(p_241144_1_ -> {
                this.func_195066_a(Stats.field_188064_ad);
                CriteriaTriggers.field_192136_p.func_192215_a(this);
            });
            ((ServerWorld)this.field_70170_p).func_72854_c();
            return either;
        }
        return Either.left((Object)((Object)PlayerEntity.SleepResult.OTHER_PROBLEM));
    }

    @Override
    public void func_213342_e(BlockPos p_213342_1_) {
        this.func_175145_a(Stats.field_199092_j.func_199076_b(Stats.field_203284_n));
        super.func_213342_e(p_213342_1_);
    }

    private boolean func_241147_a_(BlockPos p_241147_1_, Direction p_241147_2_) {
        if (p_241147_2_ == null) {
            return false;
        }
        return this.func_241158_g_(p_241147_1_) || this.func_241158_g_(p_241147_1_.func_177972_a(p_241147_2_.func_176734_d()));
    }

    private boolean func_241158_g_(BlockPos p_241158_1_) {
        Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)p_241158_1_);
        return Math.abs(this.func_226277_ct_() - vector3d.func_82615_a()) <= 3.0 && Math.abs(this.func_226278_cu_() - vector3d.func_82617_b()) <= 2.0 && Math.abs(this.func_226281_cx_() - vector3d.func_82616_c()) <= 3.0;
    }

    private boolean func_241156_b_(BlockPos p_241156_1_, Direction p_241156_2_) {
        BlockPos blockpos = p_241156_1_.func_177984_a();
        return !this.func_207401_g(blockpos) || !this.func_207401_g(blockpos.func_177972_a(p_241156_2_.func_176734_d()));
    }

    @Override
    public void func_225652_a_(boolean p_225652_1_, boolean p_225652_2_) {
        if (this.func_70608_bn()) {
            this.func_71121_q().func_72863_F().func_217216_a(this, (IPacket<?>)new SAnimateHandPacket((Entity)this, 2));
        }
        super.func_225652_a_(p_225652_1_, p_225652_2_);
        if (this.field_71135_a != null) {
            this.field_71135_a.func_147364_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    @Override
    public boolean func_184205_a(Entity p_184205_1_, boolean p_184205_2_) {
        Entity entity = this.func_184187_bx();
        if (!super.func_184205_a(p_184205_1_, p_184205_2_)) {
            return false;
        }
        Entity entity1 = this.func_184187_bx();
        if (entity1 != entity && this.field_71135_a != null) {
            this.field_71135_a.func_147364_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
        return true;
    }

    @Override
    public void func_184210_p() {
        Entity entity = this.func_184187_bx();
        super.func_184210_p();
        Entity entity1 = this.func_184187_bx();
        if (entity1 != entity && this.field_71135_a != null) {
            this.field_71135_a.func_147364_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    @Override
    public boolean func_180431_b(DamageSource p_180431_1_) {
        return super.func_180431_b(p_180431_1_) || this.func_184850_K() || this.field_71075_bZ.field_75102_a && p_180431_1_ == DamageSource.field_82727_n;
    }

    @Override
    protected void func_184231_a(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
    }

    @Override
    protected void func_184594_b(BlockPos p_184594_1_) {
        if (!this.func_175149_v()) {
            super.func_184594_b(p_184594_1_);
        }
    }

    public void func_71122_b(double p_71122_1_, boolean p_71122_3_) {
        BlockPos blockpos = this.func_226268_ag_();
        if (this.field_70170_p.func_175667_e(blockpos)) {
            super.func_184231_a(p_71122_1_, p_71122_3_, this.field_70170_p.func_180495_p(blockpos), blockpos);
        }
    }

    @Override
    public void func_175141_a(SignTileEntity p_175141_1_) {
        p_175141_1_.func_145912_a((PlayerEntity)this);
        this.field_71135_a.func_147359_a((IPacket<?>)new SOpenSignMenuPacket(p_175141_1_.func_174877_v()));
    }

    public void func_71117_bO() {
        this.field_71139_cq = this.field_71139_cq % 100 + 1;
    }

    @Override
    public OptionalInt func_213829_a(@Nullable INamedContainerProvider p_213829_1_) {
        if (p_213829_1_ == null) {
            return OptionalInt.empty();
        }
        if (this.field_71070_bA != this.field_71069_bz) {
            this.func_71053_j();
        }
        this.func_71117_bO();
        Container container = p_213829_1_.createMenu(this.field_71139_cq, this.field_71071_by, (PlayerEntity)this);
        if (container == null) {
            if (this.func_175149_v()) {
                this.func_146105_b((ITextComponent)new TranslationTextComponent("container.spectatorCantOpen").func_240699_a_(TextFormatting.RED), true);
            }
            return OptionalInt.empty();
        }
        this.field_71135_a.func_147359_a((IPacket<?>)new SOpenWindowPacket(container.field_75152_c, container.func_216957_a(), p_213829_1_.func_145748_c_()));
        container.func_75132_a(this);
        this.field_71070_bA = container;
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)this, this.field_71070_bA));
        return OptionalInt.of(this.field_71139_cq);
    }

    @Override
    public void func_213818_a(int p_213818_1_, MerchantOffers p_213818_2_, int p_213818_3_, int p_213818_4_, boolean p_213818_5_, boolean p_213818_6_) {
        this.field_71135_a.func_147359_a((IPacket<?>)new SMerchantOffersPacket(p_213818_1_, p_213818_2_, p_213818_3_, p_213818_4_, p_213818_5_, p_213818_6_));
    }

    @Override
    public void func_184826_a(AbstractHorseEntity p_184826_1_, IInventory p_184826_2_) {
        if (this.field_71070_bA != this.field_71069_bz) {
            this.func_71053_j();
        }
        this.func_71117_bO();
        this.field_71135_a.func_147359_a((IPacket<?>)new SOpenHorseWindowPacket(this.field_71139_cq, p_184826_2_.func_70302_i_(), p_184826_1_.func_145782_y()));
        this.field_71070_bA = new HorseInventoryContainer(this.field_71139_cq, this.field_71071_by, p_184826_2_, p_184826_1_);
        this.field_71070_bA.func_75132_a(this);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)this, this.field_71070_bA));
    }

    @Override
    public void func_184814_a(ItemStack p_184814_1_, Hand p_184814_2_) {
        Item item = p_184814_1_.func_77973_b();
        if (item == Items.field_151164_bB) {
            if (WrittenBookItem.func_220050_a((ItemStack)p_184814_1_, (CommandSource)this.func_195051_bN(), (PlayerEntity)this)) {
                this.field_71070_bA.func_75142_b();
            }
            this.field_71135_a.func_147359_a((IPacket<?>)new SOpenBookWindowPacket(p_184814_2_));
        }
    }

    @Override
    public void func_184824_a(CommandBlockTileEntity p_184824_1_) {
        p_184824_1_.func_184252_d(true);
        this.func_147097_b((TileEntity)p_184824_1_);
    }

    public void func_71111_a(Container p_71111_1_, int p_71111_2_, ItemStack p_71111_3_) {
        if (!(p_71111_1_.func_75139_a(p_71111_2_) instanceof CraftingResultSlot)) {
            if (p_71111_1_ == this.field_71069_bz) {
                CriteriaTriggers.field_192125_e.func_234803_a_(this, this.field_71071_by, p_71111_3_);
            }
            if (!this.field_71137_h) {
                this.field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(p_71111_1_.field_75152_c, p_71111_2_, p_71111_3_));
            }
        }
    }

    public void func_71120_a(Container p_71120_1_) {
        this.func_71110_a(p_71120_1_, p_71120_1_.func_75138_a());
    }

    public void func_71110_a(Container p_71110_1_, NonNullList<ItemStack> p_71110_2_) {
        this.field_71135_a.func_147359_a((IPacket<?>)new SWindowItemsPacket(p_71110_1_.field_75152_c, p_71110_2_));
        this.field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(-1, -1, this.field_71071_by.func_70445_o()));
    }

    public void func_71112_a(Container p_71112_1_, int p_71112_2_, int p_71112_3_) {
        this.field_71135_a.func_147359_a((IPacket<?>)new SWindowPropertyPacket(p_71112_1_.field_75152_c, p_71112_2_, p_71112_3_));
    }

    @Override
    public void func_71053_j() {
        this.field_71135_a.func_147359_a((IPacket<?>)new SCloseWindowPacket(this.field_71070_bA.field_75152_c));
        this.func_71128_l();
    }

    public void func_71113_k() {
        if (!this.field_71137_h) {
            this.field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(-1, -1, this.field_71071_by.func_70445_o()));
        }
    }

    public void func_71128_l() {
        this.field_71070_bA.func_75134_a(this);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Close((PlayerEntity)this, this.field_71070_bA));
        this.field_71070_bA = this.field_71069_bz;
    }

    public void func_110430_a(float p_110430_1_, float p_110430_2_, boolean p_110430_3_, boolean p_110430_4_) {
        if (this.func_184218_aH()) {
            if (p_110430_1_ >= -1.0f && p_110430_1_ <= 1.0f) {
                this.field_70702_br = p_110430_1_;
            }
            if (p_110430_2_ >= -1.0f && p_110430_2_ <= 1.0f) {
                this.field_191988_bg = p_110430_2_;
            }
            this.field_70703_bu = p_110430_3_;
            this.func_226284_e_(p_110430_4_);
        }
    }

    @Override
    public void func_71064_a(Stat<?> p_71064_1_, int p_71064_2_) {
        this.field_147103_bO.func_150871_b((PlayerEntity)this, p_71064_1_, p_71064_2_);
        this.func_96123_co().func_197893_a(p_71064_1_, this.func_195047_I_(), p_195396_1_ -> p_195396_1_.func_96649_a(p_71064_2_));
    }

    @Override
    public void func_175145_a(Stat<?> p_175145_1_) {
        this.field_147103_bO.func_150873_a((PlayerEntity)this, p_175145_1_, 0);
        this.func_96123_co().func_197893_a(p_175145_1_, this.func_195047_I_(), Score::func_197891_c);
    }

    @Override
    public int func_195065_a(Collection<IRecipe<?>> p_195065_1_) {
        return this.field_192041_cq.func_197926_a(p_195065_1_, this);
    }

    @Override
    public void func_193102_a(ResourceLocation[] p_193102_1_) {
        ArrayList list = Lists.newArrayList();
        for (ResourceLocation resourcelocation : p_193102_1_) {
            this.field_71133_b.func_199529_aN().func_215367_a(resourcelocation).ifPresent(list::add);
        }
        this.func_195065_a(list);
    }

    @Override
    public int func_195069_b(Collection<IRecipe<?>> p_195069_1_) {
        return this.field_192041_cq.func_197925_b(p_195069_1_, this);
    }

    @Override
    public void func_195068_e(int p_195068_1_) {
        super.func_195068_e(p_195068_1_);
        this.field_71144_ck = -1;
    }

    public void func_71123_m() {
        this.field_193109_cv = true;
        this.func_184226_ay();
        if (this.func_70608_bn()) {
            this.func_225652_a_(true, false);
        }
    }

    public boolean func_193105_t() {
        return this.field_193109_cv;
    }

    public void func_71118_n() {
        this.field_71149_ch = -1.0E8f;
    }

    @Override
    public void func_146105_b(ITextComponent p_146105_1_, boolean p_146105_2_) {
        this.field_71135_a.func_147359_a((IPacket<?>)new SChatPacket(p_146105_1_, p_146105_2_ ? ChatType.GAME_INFO : ChatType.CHAT, Util.field_240973_b_));
    }

    @Override
    protected void func_71036_o() {
        if (!this.field_184627_bm.func_190926_b() && this.func_184587_cr()) {
            this.field_71135_a.func_147359_a((IPacket<?>)new SEntityStatusPacket((Entity)this, 9));
            super.func_71036_o();
        }
    }

    @Override
    public void func_200602_a(EntityAnchorArgument.Type p_200602_1_, Vector3d p_200602_2_) {
        super.func_200602_a(p_200602_1_, p_200602_2_);
        this.field_71135_a.func_147359_a((IPacket<?>)new SPlayerLookPacket(p_200602_1_, p_200602_2_.field_72450_a, p_200602_2_.field_72448_b, p_200602_2_.field_72449_c));
    }

    public void func_200618_a(EntityAnchorArgument.Type p_200618_1_, Entity p_200618_2_, EntityAnchorArgument.Type p_200618_3_) {
        Vector3d vector3d = p_200618_3_.func_201017_a(p_200618_2_);
        super.func_200602_a(p_200618_1_, vector3d);
        this.field_71135_a.func_147359_a((IPacket<?>)new SPlayerLookPacket(p_200618_1_, p_200618_2_, p_200618_3_));
    }

    public void func_193104_a(ServerPlayerEntity p_193104_1_, boolean p_193104_2_) {
        if (p_193104_2_) {
            this.field_71071_by.func_70455_b(p_193104_1_.field_71071_by);
            this.func_70606_j(p_193104_1_.func_110143_aJ());
            this.field_71100_bB = p_193104_1_.field_71100_bB;
            this.field_71068_ca = p_193104_1_.field_71068_ca;
            this.field_71067_cb = p_193104_1_.field_71067_cb;
            this.field_71106_cc = p_193104_1_.field_71106_cc;
            this.func_85040_s(p_193104_1_.func_71037_bA());
            this.field_242271_ac = p_193104_1_.field_242271_ac;
        } else if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) || p_193104_1_.func_175149_v()) {
            this.field_71071_by.func_70455_b(p_193104_1_.field_71071_by);
            this.field_71068_ca = p_193104_1_.field_71068_ca;
            this.field_71067_cb = p_193104_1_.field_71067_cb;
            this.field_71106_cc = p_193104_1_.field_71106_cc;
            this.func_85040_s(p_193104_1_.func_71037_bA());
        }
        this.field_175152_f = p_193104_1_.field_175152_f;
        this.field_71078_a = p_193104_1_.field_71078_a;
        this.func_184212_Q().func_187227_b(field_184827_bp, p_193104_1_.func_184212_Q().func_187225_a(field_184827_bp));
        this.field_71144_ck = -1;
        this.field_71149_ch = -1.0f;
        this.field_71146_ci = -1;
        this.field_192041_cq.func_193824_a((RecipeBook)p_193104_1_.field_192041_cq);
        this.field_71130_g.addAll(p_193104_1_.field_71130_g);
        this.field_192040_cp = p_193104_1_.field_192040_cp;
        this.field_193110_cw = p_193104_1_.field_193110_cw;
        this.func_192029_h(p_193104_1_.func_192023_dk());
        this.func_192031_i(p_193104_1_.func_192025_dl());
        CompoundNBT old = p_193104_1_.getPersistentData();
        if (old.func_74764_b("PlayerPersisted")) {
            this.getPersistentData().func_218657_a("PlayerPersisted", old.func_74781_a("PlayerPersisted"));
        }
        ForgeEventFactory.onPlayerClone((PlayerEntity)this, (PlayerEntity)p_193104_1_, (!p_193104_2_ ? 1 : 0) != 0);
    }

    @Override
    protected void func_70670_a(EffectInstance p_70670_1_) {
        super.func_70670_a(p_70670_1_);
        this.field_71135_a.func_147359_a((IPacket<?>)new SPlayEntityEffectPacket(this.func_145782_y(), p_70670_1_));
        if (p_70670_1_.func_188419_a() == Effects.field_188424_y) {
            this.field_193108_cu = this.field_70173_aa;
            this.field_193107_ct = this.func_213303_ch();
        }
        CriteriaTriggers.field_193139_z.func_193153_a(this);
    }

    @Override
    protected void func_70695_b(EffectInstance p_70695_1_, boolean p_70695_2_) {
        super.func_70695_b(p_70695_1_, p_70695_2_);
        this.field_71135_a.func_147359_a((IPacket<?>)new SPlayEntityEffectPacket(this.func_145782_y(), p_70695_1_));
        CriteriaTriggers.field_193139_z.func_193153_a(this);
    }

    @Override
    protected void func_70688_c(EffectInstance p_70688_1_) {
        super.func_70688_c(p_70688_1_);
        this.field_71135_a.func_147359_a((IPacket<?>)new SRemoveEntityEffectPacket(this.func_145782_y(), p_70688_1_.func_188419_a()));
        if (p_70688_1_.func_188419_a() == Effects.field_188424_y) {
            this.field_193107_ct = null;
        }
        CriteriaTriggers.field_193139_z.func_193153_a(this);
    }

    @Override
    public void func_70634_a(double p_70634_1_, double p_70634_3_, double p_70634_5_) {
        this.field_71135_a.func_147364_a(p_70634_1_, p_70634_3_, p_70634_5_, this.field_70177_z, this.field_70125_A);
    }

    @Override
    public void func_225653_b_(double p_225653_1_, double p_225653_3_, double p_225653_5_) {
        this.func_70634_a(p_225653_1_, p_225653_3_, p_225653_5_);
        this.field_71135_a.func_184342_d();
    }

    @Override
    public void func_71009_b(Entity p_71009_1_) {
        this.func_71121_q().func_72863_F().func_217216_a(this, (IPacket<?>)new SAnimateHandPacket(p_71009_1_, 4));
    }

    @Override
    public void func_71047_c(Entity p_71047_1_) {
        this.func_71121_q().func_72863_F().func_217216_a(this, (IPacket<?>)new SAnimateHandPacket(p_71047_1_, 5));
    }

    @Override
    public void func_71016_p() {
        if (this.field_71135_a != null) {
            this.field_71135_a.func_147359_a((IPacket<?>)new SPlayerAbilitiesPacket(this.field_71075_bZ));
            this.func_175135_B();
        }
    }

    public ServerWorld func_71121_q() {
        return (ServerWorld)this.field_70170_p;
    }

    @Override
    public void func_71033_a(GameType p_71033_1_) {
        if (!ForgeHooks.onChangeGameMode((PlayerEntity)this, (GameType)this.field_71134_c.func_73081_b(), (GameType)p_71033_1_)) {
            return;
        }
        this.field_71134_c.func_73076_a(p_71033_1_);
        this.field_71135_a.func_147359_a((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241767_d_, (float)p_71033_1_.func_77148_a()));
        if (p_71033_1_ == GameType.SPECTATOR) {
            this.func_192030_dh();
            this.func_184210_p();
        } else {
            this.func_175399_e(this);
        }
        this.func_71016_p();
        this.func_175136_bO();
    }

    @Override
    public boolean func_175149_v() {
        return this.field_71134_c.func_73081_b() == GameType.SPECTATOR;
    }

    @Override
    public boolean func_184812_l_() {
        return this.field_71134_c.func_73081_b() == GameType.CREATIVE;
    }

    @Override
    public void func_145747_a(ITextComponent p_145747_1_, UUID p_145747_2_) {
        this.func_241151_a_(p_145747_1_, ChatType.SYSTEM, p_145747_2_);
    }

    public void func_241151_a_(ITextComponent p_241151_1_, ChatType p_241151_2_, UUID p_241151_3_) {
        this.field_71135_a.func_211148_a((IPacket<?>)new SChatPacket(p_241151_1_, p_241151_2_, p_241151_3_), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)p_241149_4_ -> {
            if (!(p_241149_4_.isSuccess() || p_241151_2_ != ChatType.GAME_INFO && p_241151_2_ != ChatType.SYSTEM)) {
                int i = 256;
                String s = p_241151_1_.func_212636_a(256);
                IFormattableTextComponent itextcomponent = new StringTextComponent(s).func_240699_a_(TextFormatting.YELLOW);
                this.field_71135_a.func_147359_a((IPacket<?>)new SChatPacket((ITextComponent)new TranslationTextComponent("multiplayer.message_not_delivered", itextcomponent).func_240699_a_(TextFormatting.RED), ChatType.SYSTEM, p_241151_3_));
            }
        }));
    }

    public String func_71114_r() {
        String s = this.field_71135_a.field_147371_a.func_74430_c().toString();
        s = s.substring(s.indexOf("/") + 1);
        return s.substring(0, s.indexOf(":"));
    }

    public void func_147100_a(CClientSettingsPacket p_147100_1_) {
        this.field_71143_cn = p_147100_1_.func_149523_e();
        this.field_71140_co = p_147100_1_.func_149520_f();
        this.func_184212_Q().func_187227_b(field_184827_bp, (byte)p_147100_1_.func_149521_d());
        this.func_184212_Q().func_187227_b(field_184828_bq, (byte)(p_147100_1_.func_186991_f() != HandSide.LEFT ? 1 : 0));
        this.language = p_147100_1_.func_149524_c();
    }

    public ChatVisibility func_147096_v() {
        return this.field_71143_cn;
    }

    public void func_175397_a(String p_175397_1_, String p_175397_2_) {
        this.field_71135_a.func_147359_a((IPacket<?>)new SSendResourcePackPacket(p_175397_1_, p_175397_2_));
    }

    @Override
    protected int func_184840_I() {
        return this.field_71133_b.func_211833_a(this.func_146103_bH());
    }

    public void func_143004_u() {
        this.field_143005_bX = Util.func_211177_b();
    }

    public ServerStatisticsManager func_147099_x() {
        return this.field_147103_bO;
    }

    public ServerRecipeBook func_192037_E() {
        return this.field_192041_cq;
    }

    public void func_152339_d(Entity p_152339_1_) {
        if (p_152339_1_ instanceof PlayerEntity) {
            this.field_71135_a.func_147359_a((IPacket<?>)new SDestroyEntitiesPacket(new int[]{p_152339_1_.func_145782_y()}));
        } else {
            this.field_71130_g.add(p_152339_1_.func_145782_y());
        }
    }

    public void func_184848_d(Entity p_184848_1_) {
        this.field_71130_g.remove((Object)p_184848_1_.func_145782_y());
    }

    @Override
    protected void func_175135_B() {
        if (this.func_175149_v()) {
            this.func_175133_bi();
            this.func_82142_c(true);
        } else {
            super.func_175135_B();
        }
    }

    public Entity func_175398_C() {
        return this.field_175401_bS == null ? this : this.field_175401_bS;
    }

    public void func_175399_e(Entity p_175399_1_) {
        Entity entity = this.func_175398_C();
        Entity entity2 = this.field_175401_bS = p_175399_1_ == null ? this : p_175399_1_;
        if (entity != this.field_175401_bS) {
            this.field_71135_a.func_147359_a((IPacket<?>)new SCameraPacket(this.field_175401_bS));
            this.func_70634_a(this.field_175401_bS.func_226277_ct_(), this.field_175401_bS.func_226278_cu_(), this.field_175401_bS.func_226281_cx_());
        }
    }

    @Override
    protected void func_184173_H() {
        if (!this.field_184851_cj) {
            super.func_184173_H();
        }
    }

    @Override
    public void func_71059_n(Entity p_71059_1_) {
        if (this.field_71134_c.func_73081_b() == GameType.SPECTATOR) {
            this.func_175399_e(p_71059_1_);
        } else {
            super.func_71059_n(p_71059_1_);
        }
    }

    public long func_154331_x() {
        return this.field_143005_bX;
    }

    @Nullable
    public ITextComponent func_175396_E() {
        return null;
    }

    @Override
    public void func_184609_a(Hand p_184609_1_) {
        super.func_184609_a(p_184609_1_);
        this.func_184821_cY();
    }

    public boolean func_184850_K() {
        return this.field_184851_cj;
    }

    public void func_184846_L() {
        this.field_184851_cj = false;
    }

    public PlayerAdvancements func_192039_O() {
        return this.field_192042_bX;
    }

    public void func_200619_a(ServerWorld p_200619_1_, double p_200619_2_, double p_200619_4_, double p_200619_6_, float p_200619_8_, float p_200619_9_) {
        this.func_175399_e(this);
        this.func_184210_p();
        if (p_200619_1_ == this.field_70170_p) {
            this.field_71135_a.func_147364_a(p_200619_2_, p_200619_4_, p_200619_6_, p_200619_8_, p_200619_9_);
        } else if (ForgeHooks.onTravelToDimension((Entity)this, p_200619_1_.func_234923_W_())) {
            ServerWorld serverworld = this.func_71121_q();
            IWorldInfo iworldinfo = p_200619_1_.func_72912_H();
            this.field_71135_a.func_147359_a((IPacket<?>)new SRespawnPacket(p_200619_1_.func_230315_m_(), p_200619_1_.func_234923_W_(), BiomeManager.func_235200_a_((long)p_200619_1_.func_72905_C()), this.field_71134_c.func_73081_b(), this.field_71134_c.func_241815_c_(), p_200619_1_.func_234925_Z_(), p_200619_1_.func_241109_A_(), true));
            this.field_71135_a.func_147359_a((IPacket<?>)new SServerDifficultyPacket(iworldinfo.func_176130_y(), iworldinfo.func_176123_z()));
            this.field_71133_b.func_184103_al().func_187243_f(this);
            serverworld.removePlayer(this, true);
            this.revive();
            this.func_70012_b(p_200619_2_, p_200619_4_, p_200619_6_, p_200619_8_, p_200619_9_);
            this.func_70029_a(p_200619_1_);
            p_200619_1_.func_217446_a(this);
            this.func_213846_b(serverworld);
            this.field_71135_a.func_147364_a(p_200619_2_, p_200619_4_, p_200619_6_, p_200619_8_, p_200619_9_);
            this.field_71134_c.func_73080_a(p_200619_1_);
            this.field_71133_b.func_184103_al().func_72354_b(this, p_200619_1_);
            this.field_71133_b.func_184103_al().func_72385_f(this);
            BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)this, serverworld.func_234923_W_(), p_200619_1_.func_234923_W_());
        }
    }

    @Nullable
    public BlockPos func_241140_K_() {
        return this.field_241138_cr_;
    }

    public float func_242109_L() {
        return this.field_242108_cn;
    }

    public RegistryKey<World> func_241141_L_() {
        return this.field_241137_cq_;
    }

    public boolean func_241142_M_() {
        return this.field_241139_cs_;
    }

    public void func_242111_a(RegistryKey<World> p_242111_1_, @Nullable BlockPos p_242111_2_, float p_242111_3_, boolean p_242111_4_, boolean p_242111_5_) {
        if (ForgeEventFactory.onPlayerSpawnSet((PlayerEntity)this, p_242111_2_ == null ? World.field_234918_g_ : p_242111_1_, (BlockPos)p_242111_2_, (boolean)p_242111_4_)) {
            return;
        }
        if (p_242111_2_ != null) {
            boolean flag;
            boolean bl = flag = p_242111_2_.equals((Object)this.field_241138_cr_) && p_242111_1_.equals(this.field_241137_cq_);
            if (p_242111_5_ && !flag) {
                this.func_145747_a((ITextComponent)new TranslationTextComponent("block.minecraft.set_spawn"), Util.field_240973_b_);
            }
            this.field_241138_cr_ = p_242111_2_;
            this.field_241137_cq_ = p_242111_1_;
            this.field_242108_cn = p_242111_3_;
            this.field_241139_cs_ = p_242111_4_;
        } else {
            this.field_241138_cr_ = null;
            this.field_241137_cq_ = World.field_234918_g_;
            this.field_242108_cn = 0.0f;
            this.field_241139_cs_ = false;
        }
    }

    public void func_213844_a(ChunkPos p_213844_1_, IPacket<?> p_213844_2_, IPacket<?> p_213844_3_) {
        this.field_71135_a.func_147359_a(p_213844_3_);
        this.field_71135_a.func_147359_a(p_213844_2_);
    }

    public void func_213845_a(ChunkPos p_213845_1_) {
        if (this.func_70089_S()) {
            this.field_71135_a.func_147359_a((IPacket<?>)new SUnloadChunkPacket(p_213845_1_.field_77276_a, p_213845_1_.field_77275_b));
        }
    }

    public SectionPos func_213842_M() {
        return this.field_213851_cv;
    }

    public void func_213850_a(SectionPos p_213850_1_) {
        this.field_213851_cv = p_213850_1_;
    }

    @Override
    public void func_213823_a(SoundEvent p_213823_1_, SoundCategory p_213823_2_, float p_213823_3_, float p_213823_4_) {
        this.field_71135_a.func_147359_a((IPacket<?>)new SPlaySoundEffectPacket(p_213823_1_, p_213823_2_, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), p_213823_3_, p_213823_4_));
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnPlayerPacket((PlayerEntity)this);
    }

    @Override
    public ItemEntity func_146097_a(ItemStack p_146097_1_, boolean p_146097_2_, boolean p_146097_3_) {
        ItemEntity itementity = super.func_146097_a(p_146097_1_, p_146097_2_, p_146097_3_);
        if (itementity == null) {
            return null;
        }
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.field_70170_p.func_217376_c(itementity);
        }
        ItemStack itemstack = itementity.func_92059_d();
        if (p_146097_3_) {
            if (!itemstack.func_190926_b()) {
                this.func_71064_a(Stats.field_188068_aj.func_199076_b(itemstack.func_77973_b()), p_146097_1_.func_190916_E());
            }
            this.func_195066_a(Stats.field_75952_v);
        }
        return itementity;
    }

    public String getLanguage() {
        return this.language;
    }

    @Nullable
    public IChatFilter func_244529_Q() {
        return this.field_244528_co;
    }

    private static /* synthetic */ Style func_212357_a_(ITextComponent itextcomponent1, Style p_212357_1_) {
        return p_212357_1_.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)itextcomponent1));
    }
}

