/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.CrashReportExtender;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModList {
    private static Logger LOGGER = LogManager.getLogger();
    private static ModList INSTANCE;
    private final List<ModFileInfo> modFiles;
    private final List<ModInfo> sortedList;
    private final Map<String, ModFileInfo> fileById;
    private List<ModContainer> mods;
    private Map<String, ModContainer> indexedMods;
    private List<ModFileScanData> modFileScanData;

    private ModList(List<ModFile> modFiles, List<ModInfo> sortedList) {
        this.modFiles = modFiles.stream().map(ModFile::getModFileInfo).map(ModFileInfo.class::cast).collect(Collectors.toList());
        this.sortedList = sortedList.stream().map(ModInfo.class::cast).collect(Collectors.toList());
        this.fileById = this.modFiles.stream().map(ModFileInfo::getMods).flatMap(Collection::stream).map(ModInfo.class::cast).collect(Collectors.toMap(ModInfo::getModId, ModInfo::getOwningFile));
        CrashReportExtender.registerCrashCallable("Mod List", this::crashReport);
    }

    private String getModContainerState(String modId) {
        return this.getModContainerById(modId).map(ModContainer::getCurrentState).map(Object::toString).orElse("NONE");
    }

    private String fileToLine(ModFile mf) {
        return String.format("%-50.50s|%-30.30s|%-30.30s|%-20.20s|%-10.10s|Manifest: %s", mf.getFileName(), ((IModInfo)mf.getModInfos().get(0)).getDisplayName(), ((IModInfo)mf.getModInfos().get(0)).getModId(), ((IModInfo)mf.getModInfos().get(0)).getVersion(), this.getModContainerState(((IModInfo)mf.getModInfos().get(0)).getModId()), ((ModFileInfo)mf.getModFileInfo()).getCodeSigningFingerprint().orElse("NOSIGNATURE"));
    }

    private String crashReport() {
        return "\n" + this.applyForEachModFile(this::fileToLine).collect(Collectors.joining("\n\t\t", "\t\t", ""));
    }

    public static ModList of(List<ModFile> modFiles, List<ModInfo> sortedList) {
        INSTANCE = new ModList(modFiles, sortedList);
        return INSTANCE;
    }

    public static ModList get() {
        return INSTANCE;
    }

    private static ForkJoinWorkerThread newForkJoinWorkerThread(ForkJoinPool pool) {
        ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
        thread.setName("modloading-worker-" + thread.getPoolIndex());
        thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        return thread;
    }

    public List<ModFileInfo> getModFiles() {
        return this.modFiles;
    }

    public ModFileInfo getModFileById(String modid) {
        return this.fileById.get(modid);
    }

    <T extends Event> Function<Executor, CompletableFuture<List<Throwable>>> futureVisitor(ModLoadingStage.EventGenerator<T> eventGenerator, BiFunction<ModLoadingStage, Throwable, ModLoadingStage> stateChange) {
        return executor -> ModList.gather(this.mods.stream().map(mod -> ModContainer.buildTransitionHandler(mod, eventGenerator, stateChange, executor)).collect(Collectors.toList())).thenComposeAsync(ModList::completableFutureFromExceptionList, (Executor)executor);
    }

    static CompletionStage<List<Throwable>> completableFutureFromExceptionList(List<? extends Map.Entry<?, Throwable>> t) {
        if (t.stream().noneMatch(e -> e.getValue() != null)) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        List<Throwable> throwables = t.stream().filter(e -> e.getValue() != null).map(Map.Entry::getValue).collect(Collectors.toList());
        CompletableFuture<List<Throwable>> cf = new CompletableFuture<List<Throwable>>();
        RuntimeException accumulator = new RuntimeException();
        cf.completeExceptionally(accumulator);
        throwables.forEach(exception -> {
            if (exception instanceof CompletionException) {
                exception = exception.getCause();
            }
            if (exception.getSuppressed().length != 0) {
                Arrays.stream(exception.getSuppressed()).forEach(accumulator::addSuppressed);
            } else {
                accumulator.addSuppressed((Throwable)exception);
            }
        });
        return cf;
    }

    static <V> CompletableFuture<List<Map.Entry<V, Throwable>>> gather(List<? extends CompletableFuture<? extends V>> futures) {
        ArrayList list = new ArrayList(futures.size());
        CompletableFuture[] results = new CompletableFuture[futures.size()];
        futures.forEach(future -> {
            int i = list.size();
            list.add(null);
            results[i] = future.whenComplete((result, exception) -> {
                Map.Entry cfr_ignored_0 = list.set(i, new AbstractMap.SimpleImmutableEntry<Object, Throwable>(result, (Throwable)exception));
            });
        });
        return ((CompletableFuture)CompletableFuture.allOf(results).handle((r, th) -> null)).thenApply(res -> list);
    }

    void setLoadedMods(List<ModContainer> modContainers) {
        this.mods = modContainers;
        this.indexedMods = modContainers.stream().collect(Collectors.toMap(ModContainer::getModId, Function.identity()));
    }

    public <T> Optional<T> getModObjectById(String modId) {
        return this.getModContainerById(modId).map(ModContainer::getMod).map(o -> o);
    }

    public Optional<? extends ModContainer> getModContainerById(String modId) {
        return Optional.ofNullable(this.indexedMods.get(modId));
    }

    public Optional<? extends ModContainer> getModContainerByObject(Object obj) {
        return this.mods.stream().filter(mc -> mc.getMod() == obj).findFirst();
    }

    public List<ModInfo> getMods() {
        return this.sortedList;
    }

    public boolean isLoaded(String modTarget) {
        return this.indexedMods.containsKey(modTarget);
    }

    public int size() {
        return this.mods.size();
    }

    public List<ModFileScanData> getAllScanData() {
        if (this.modFileScanData == null) {
            this.modFileScanData = this.sortedList.stream().map(ModInfo::getOwningFile).filter(Objects::nonNull).map(ModFileInfo::getFile).distinct().map(ModFile::getScanResult).collect(Collectors.toList());
        }
        return this.modFileScanData;
    }

    public void forEachModFile(Consumer<ModFile> fileConsumer) {
        this.modFiles.stream().map(ModFileInfo::getFile).forEach(fileConsumer);
    }

    public <T> Stream<T> applyForEachModFile(Function<ModFile, T> function) {
        return this.modFiles.stream().map(ModFileInfo::getFile).map(function);
    }

    public void forEachModContainer(BiConsumer<String, ModContainer> modContainerConsumer) {
        this.indexedMods.forEach(modContainerConsumer);
    }

    public <T> Stream<T> applyForEachModContainer(Function<ModContainer, T> function) {
        return this.indexedMods.values().stream().map(function);
    }

    private static class UncaughtModLoadingException
    extends ModLoadingException {
        public UncaughtModLoadingException(ModLoadingStage stage, Throwable originalException) {
            super(null, stage, "fml.modloading.uncaughterror", originalException, new Object[0]);
        }
    }
}

