/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.merchant.villager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.GolemLastSeenSensor;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.ai.brain.task.VillagerTasks;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.GossipManager;
import net.minecraft.village.GossipType;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.Logger;

public class VillagerEntity
extends AbstractVillagerEntity
implements IReputationTracking,
IVillagerDataHolder {
    private static final DataParameter<VillagerData> field_213775_bC = EntityDataManager.func_187226_a(VillagerEntity.class, DataSerializers.field_218813_q);
    public static final Map<Item, Integer> field_213788_bA = ImmutableMap.of((Object)((Object)Items.field_151025_P), (Object)4, (Object)((Object)Items.field_151174_bG), (Object)1, (Object)((Object)Items.field_151172_bF), (Object)1, (Object)((Object)Items.field_185164_cV), (Object)1);
    private static final Set<Item> field_213776_bD = ImmutableSet.of((Object)((Object)Items.field_151025_P), (Object)((Object)Items.field_151174_bG), (Object)((Object)Items.field_151172_bF), (Object)((Object)Items.field_151015_O), (Object)((Object)Items.field_151014_N), (Object)((Object)Items.field_185164_cV), (Object[])new Item[]{Items.field_185163_cU});
    private int field_70961_j;
    private boolean field_213777_bF;
    @Nullable
    private PlayerEntity field_213778_bG;
    private byte field_213781_bL;
    private final GossipManager field_213782_bM = new GossipManager();
    private long field_213783_bN;
    private long field_223362_bL;
    private int field_213784_bO;
    private long field_213785_bP;
    private int field_223725_bO;
    private long field_223726_bP;
    private boolean field_234542_bL_;
    private static final ImmutableList<MemoryModuleType<?>> field_213786_bQ = ImmutableList.of(MemoryModuleType.field_220941_b, MemoryModuleType.field_220942_c, MemoryModuleType.field_234101_d_, MemoryModuleType.field_220943_d, MemoryModuleType.field_220945_f, MemoryModuleType.field_220946_g, MemoryModuleType.field_220947_h, MemoryModuleType.field_220948_i, MemoryModuleType.field_220949_j, MemoryModuleType.field_234102_l_, MemoryModuleType.field_234076_J_, MemoryModuleType.field_220950_k, (Object[])new MemoryModuleType[]{MemoryModuleType.field_220951_l, MemoryModuleType.field_220952_m, MemoryModuleType.field_220953_n, MemoryModuleType.field_220954_o, MemoryModuleType.field_225462_q, MemoryModuleType.field_220956_q, MemoryModuleType.field_220957_r, MemoryModuleType.field_220958_s, MemoryModuleType.field_220959_t, MemoryModuleType.field_220944_e, MemoryModuleType.field_220961_v, MemoryModuleType.field_220962_w, MemoryModuleType.field_223021_x, MemoryModuleType.field_223543_y, MemoryModuleType.field_226332_A_, MemoryModuleType.field_223544_z, MemoryModuleType.field_242309_E});
    private static final ImmutableList<SensorType<? extends Sensor<? super VillagerEntity>>> field_213787_bR = ImmutableList.of(SensorType.field_220998_b, SensorType.field_220999_c, SensorType.field_234129_b_, SensorType.field_221001_e, SensorType.field_221002_f, SensorType.field_221003_g, SensorType.field_221004_h, SensorType.field_221005_i, SensorType.field_242317_j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<VillagerEntity, PointOfInterestType>> field_213774_bB = ImmutableMap.of(MemoryModuleType.field_220941_b, (p_213769_0_, p_213769_1_) -> p_213769_1_ == PointOfInterestType.field_221069_q, MemoryModuleType.field_220942_c, (p_213771_0_, p_213771_1_) -> p_213771_0_.func_213700_eh().func_221130_b().func_221149_b() == p_213771_1_, MemoryModuleType.field_234101_d_, (p_213772_0_, p_213772_1_) -> PointOfInterestType.field_221071_s.test((PointOfInterestType)((Object)p_213772_1_)), MemoryModuleType.field_220943_d, (p_234546_0_, p_234546_1_) -> p_234546_1_ == PointOfInterestType.field_221070_r);

    public VillagerEntity(EntityType<? extends VillagerEntity> p_i50182_1_, World p_i50182_2_) {
        this(p_i50182_1_, p_i50182_2_, VillagerType.field_221175_c);
    }

    public VillagerEntity(EntityType<? extends VillagerEntity> p_i50183_1_, World p_i50183_2_, VillagerType p_i50183_3_) {
        super(p_i50183_1_, p_i50183_2_);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_70661_as().func_212239_d(true);
        this.func_98053_h(true);
        this.func_213753_a(this.func_213700_eh().func_221134_a(p_i50183_3_).func_221126_a(VillagerProfession.field_221151_a));
    }

    public Brain<VillagerEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    protected Brain.BrainCodec<VillagerEntity> func_230289_cH_() {
        return Brain.func_233705_a_(field_213786_bQ, field_213787_bR);
    }

    protected Brain<?> func_213364_a(Dynamic<?> p_213364_1_) {
        Brain brain = this.func_230289_cH_().func_233748_a_(p_213364_1_);
        this.func_213744_a((Brain<VillagerEntity>)brain);
        return brain;
    }

    public void func_213770_a(ServerWorld p_213770_1_) {
        Brain<VillagerEntity> brain = this.func_213375_cj();
        brain.func_218227_b(p_213770_1_, (LivingEntity)((Object)this));
        this.field_213378_br = brain.func_218185_f();
        this.func_213744_a(this.func_213375_cj());
    }

    private void func_213744_a(Brain<VillagerEntity> p_213744_1_) {
        VillagerProfession villagerprofession = this.func_213700_eh().func_221130_b();
        if (this.func_70631_g_()) {
            p_213744_1_.func_218203_a(Schedule.field_221385_c);
            p_213744_1_.func_218208_a(Activity.field_221368_d, VillagerTasks.func_220645_a((float)0.5f));
        } else {
            p_213744_1_.func_218203_a(Schedule.field_221386_d);
            p_213744_1_.func_233700_a_(Activity.field_221367_c, VillagerTasks.func_220639_b((VillagerProfession)villagerprofession, (float)0.5f), (Set)ImmutableSet.of((Object)Pair.of(MemoryModuleType.field_220942_c, (Object)MemoryModuleStatus.VALUE_PRESENT)));
        }
        p_213744_1_.func_218208_a(Activity.field_221365_a, VillagerTasks.func_220638_a((VillagerProfession)villagerprofession, (float)0.5f));
        p_213744_1_.func_233700_a_(Activity.field_221370_f, VillagerTasks.func_220637_d((VillagerProfession)villagerprofession, (float)0.5f), (Set)ImmutableSet.of((Object)Pair.of(MemoryModuleType.field_220943_d, (Object)MemoryModuleStatus.VALUE_PRESENT)));
        p_213744_1_.func_218208_a(Activity.field_221369_e, VillagerTasks.func_220635_c((VillagerProfession)villagerprofession, (float)0.5f));
        p_213744_1_.func_218208_a(Activity.field_221366_b, VillagerTasks.func_220641_e((VillagerProfession)villagerprofession, (float)0.5f));
        p_213744_1_.func_218208_a(Activity.field_221371_g, VillagerTasks.func_220636_f((VillagerProfession)villagerprofession, (float)0.5f));
        p_213744_1_.func_218208_a(Activity.field_221373_i, VillagerTasks.func_220642_g((VillagerProfession)villagerprofession, (float)0.5f));
        p_213744_1_.func_218208_a(Activity.field_221372_h, VillagerTasks.func_220640_h((VillagerProfession)villagerprofession, (float)0.5f));
        p_213744_1_.func_218208_a(Activity.field_221374_j, VillagerTasks.func_220644_i((VillagerProfession)villagerprofession, (float)0.5f));
        p_213744_1_.func_218199_a((Set)ImmutableSet.of((Object)((Object)Activity.field_221365_a)));
        p_213744_1_.func_218200_b(Activity.field_221366_b);
        p_213744_1_.func_218202_a(Activity.field_221366_b);
        p_213744_1_.func_218211_a(this.field_70170_p.func_72820_D(), this.field_70170_p.func_82737_E());
    }

    protected void func_175500_n() {
        super.func_175500_n();
        if (this.field_70170_p instanceof ServerWorld) {
            this.func_213770_a((ServerWorld)this.field_70170_p);
        }
    }

    public static AttributeModifierMap.MutableAttribute func_234551_eU_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233819_b_, 48.0);
    }

    public boolean func_234552_eW_() {
        return this.field_234542_bL_;
    }

    protected void func_70619_bc() {
        Raid raid;
        this.field_70170_p.func_217381_Z().func_76320_a("villagerBrain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, (LivingEntity)((Object)this));
        this.field_70170_p.func_217381_Z().func_76319_b();
        if (this.field_234542_bL_) {
            this.field_234542_bL_ = false;
        }
        if (!this.func_213716_dX() && this.field_70961_j > 0) {
            --this.field_70961_j;
            if (this.field_70961_j <= 0) {
                if (this.field_213777_bF) {
                    this.func_175554_cu();
                    this.field_213777_bF = false;
                }
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 0));
            }
        }
        if (this.field_213778_bG != null && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217489_a(IReputationType.field_221033_e, this.field_213778_bG, this);
            this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)14);
            this.field_213778_bG = null;
        }
        if (!this.func_175446_cd() && this.field_70146_Z.nextInt(100) == 0 && (raid = ((ServerWorld)this.field_70170_p).func_217475_c_(this.func_233580_cy_())) != null && raid.func_221333_v() && !raid.func_221319_a()) {
            this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)42);
        }
        if (this.func_213700_eh().func_221130_b() == VillagerProfession.field_221151_a && this.func_213716_dX()) {
            this.func_213750_eg();
        }
        super.func_70619_bc();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_213719_ec() > 0) {
            this.func_213720_r(this.func_213719_ec() - 1);
        }
        this.func_223343_eC();
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (itemstack.func_77973_b() != Items.field_196172_da && this.func_70089_S() && !this.func_213716_dX() && !this.func_70608_bn() && !p_230254_1_.func_226563_dT_()) {
            if (this.func_70631_g_()) {
                this.func_213756_es();
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            boolean flag = this.func_213706_dY().isEmpty();
            if (p_230254_2_ == Hand.MAIN_HAND) {
                if (flag && !this.field_70170_p.field_72995_K) {
                    this.func_213756_es();
                }
                p_230254_1_.func_195066_a(Stats.field_188074_H);
            }
            if (flag) {
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (!this.field_70170_p.field_72995_K && !this.field_213724_bz.isEmpty()) {
                this.func_213740_f(p_230254_1_);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    private void func_213756_es() {
        this.func_213720_r(40);
        if (!this.field_70170_p.func_201670_d()) {
            this.func_184185_a(SoundEvents.field_187913_gm, this.func_70599_aP(), this.func_70647_i());
        }
    }

    private void func_213740_f(PlayerEntity p_213740_1_) {
        this.func_213762_g(p_213740_1_);
        this.func_70932_a_(p_213740_1_);
        this.func_213707_a(p_213740_1_, this.func_145748_c_(), this.func_213700_eh().func_221132_c());
    }

    @Override
    public void func_70932_a_(@Nullable PlayerEntity p_70932_1_) {
        boolean flag = this.func_70931_l_() != null && p_70932_1_ == null;
        super.func_70932_a_(p_70932_1_);
        if (flag) {
            this.func_213750_eg();
        }
    }

    @Override
    protected void func_213750_eg() {
        super.func_213750_eg();
        this.func_213748_et();
    }

    private void func_213748_et() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222220_k();
        }
    }

    public boolean func_223340_ej() {
        return true;
    }

    public void func_213766_ei() {
        this.func_223715_ey();
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222203_h();
        }
        this.field_213785_bP = this.field_70170_p.func_82737_E();
        ++this.field_223725_bO;
    }

    private boolean func_223723_ev() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            if (!merchantoffer.func_226654_r_()) continue;
            return true;
        }
        return false;
    }

    private boolean func_223720_ew() {
        return this.field_223725_bO == 0 || this.field_223725_bO < 2 && this.field_70170_p.func_82737_E() > this.field_213785_bP + 2400L;
    }

    public boolean func_223721_ek() {
        long i = this.field_213785_bP + 12000L;
        long j = this.field_70170_p.func_82737_E();
        boolean flag = j > i;
        long k = this.field_70170_p.func_72820_D();
        if (this.field_223726_bP > 0L) {
            long i1 = k / 24000L;
            long l = this.field_223726_bP / 24000L;
            flag |= i1 > l;
        }
        this.field_223726_bP = k;
        if (flag) {
            this.field_213785_bP = j;
            this.func_223718_eH();
        }
        return this.func_223720_ew() && this.func_223723_ev();
    }

    private void func_223719_ex() {
        int i = 2 - this.field_223725_bO;
        if (i > 0) {
            for (MerchantOffer merchantoffer : this.func_213706_dY()) {
                merchantoffer.func_222203_h();
            }
        }
        for (int j = 0; j < i; ++j) {
            this.func_223715_ey();
        }
    }

    private void func_223715_ey() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222222_e();
        }
    }

    private void func_213762_g(PlayerEntity p_213762_1_) {
        int i = this.func_223107_f(p_213762_1_);
        if (i != 0) {
            for (MerchantOffer merchantoffer : this.func_213706_dY()) {
                merchantoffer.func_222207_a(-MathHelper.func_76141_d((float)((float)i * merchantoffer.func_222211_m())));
            }
        }
        if (p_213762_1_.func_70644_a(Effects.field_220310_F)) {
            EffectInstance effectinstance = p_213762_1_.func_70660_b(Effects.field_220310_F);
            int k = effectinstance.func_76458_c();
            for (MerchantOffer merchantoffer1 : this.func_213706_dY()) {
                double d0 = 0.3 + 0.0625 * (double)k;
                int j = (int)Math.floor(d0 * (double)merchantoffer1.func_222218_a().func_190916_E());
                merchantoffer1.func_222207_a(-Math.max(j, 1));
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_213775_bC, new VillagerData(VillagerType.field_221175_c, VillagerProfession.field_221151_a, 1));
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        VillagerData.field_234554_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.func_213700_eh()).resultOrPartial(arg_0 -> ((Logger)field_184243_a).error(arg_0)).ifPresent(p_234547_1_ -> p_213281_1_.func_218657_a("VillagerData", (INBT)p_234547_1_));
        p_213281_1_.func_74774_a("FoodLevel", this.field_213781_bL);
        p_213281_1_.func_218657_a("Gossips", (INBT)this.field_213782_bM.func_234058_a_((DynamicOps)NBTDynamicOps.field_210820_a).getValue());
        p_213281_1_.func_74768_a("Xp", this.field_213784_bO);
        p_213281_1_.func_74772_a("LastRestock", this.field_213785_bP);
        p_213281_1_.func_74772_a("LastGossipDecay", this.field_223362_bL);
        p_213281_1_.func_74768_a("RestocksToday", this.field_223725_bO);
        if (this.field_234542_bL_) {
            p_213281_1_.func_74757_a("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_150297_b("VillagerData", 10)) {
            DataResult dataresult = VillagerData.field_234554_a_.parse(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)p_70037_1_.func_74781_a("VillagerData")));
            dataresult.resultOrPartial(arg_0 -> ((Logger)field_184243_a).error(arg_0)).ifPresent(this::func_213753_a);
        }
        if (p_70037_1_.func_150297_b("Offers", 10)) {
            this.field_213724_bz = new MerchantOffers(p_70037_1_.func_74775_l("Offers"));
        }
        if (p_70037_1_.func_150297_b("FoodLevel", 1)) {
            this.field_213781_bL = p_70037_1_.func_74771_c("FoodLevel");
        }
        ListNBT listnbt = p_70037_1_.func_150295_c("Gossips", 10);
        this.field_213782_bM.func_234057_a_(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)listnbt));
        if (p_70037_1_.func_150297_b("Xp", 3)) {
            this.field_213784_bO = p_70037_1_.func_74762_e("Xp");
        }
        this.field_213785_bP = p_70037_1_.func_74763_f("LastRestock");
        this.field_223362_bL = p_70037_1_.func_74763_f("LastGossipDecay");
        this.func_98053_h(true);
        if (this.field_70170_p instanceof ServerWorld) {
            this.func_213770_a((ServerWorld)this.field_70170_p);
        }
        this.field_223725_bO = p_70037_1_.func_74762_e("RestocksToday");
        if (p_70037_1_.func_74764_b("AssignProfessionWhenSpawned")) {
            this.field_234542_bL_ = p_70037_1_.func_74767_n("AssignProfessionWhenSpawned");
        }
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_70608_bn()) {
            return null;
        }
        return this.func_213716_dX() ? SoundEvents.field_187914_gn : SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    public void func_213767_ej() {
        SoundEvent soundevent = this.func_213700_eh().func_221130_b().func_226558_e_();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void func_213753_a(VillagerData p_213753_1_) {
        VillagerData villagerdata = this.func_213700_eh();
        if (villagerdata.func_221130_b() != p_213753_1_.func_221130_b()) {
            this.field_213724_bz = null;
        }
        this.field_70180_af.func_187227_b(field_213775_bC, p_213753_1_);
    }

    public VillagerData func_213700_eh() {
        return this.field_70180_af.func_187225_a(field_213775_bC);
    }

    @Override
    protected void func_213713_b(MerchantOffer p_213713_1_) {
        int i = 3 + this.field_70146_Z.nextInt(4);
        this.field_213784_bO += p_213713_1_.func_222210_n();
        this.field_213778_bG = this.func_70931_l_();
        if (this.func_213741_eu()) {
            this.field_70961_j = 40;
            this.field_213777_bF = true;
            i += 5;
        }
        if (p_213713_1_.func_222221_q()) {
            this.field_70170_p.func_217376_c(new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    public void func_70604_c(@Nullable LivingEntity p_70604_1_) {
        if (p_70604_1_ != null && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217489_a(IReputationType.field_221031_c, p_70604_1_, this);
            if (this.func_70089_S() && p_70604_1_ instanceof PlayerEntity) {
                this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)13);
            }
        }
        super.func_70604_c(p_70604_1_);
    }

    @Override
    public void func_70645_a(DamageSource p_70645_1_) {
        field_184243_a.info("Villager {} died, message: '{}'", (Object)this, (Object)p_70645_1_.func_151519_b((LivingEntity)((Object)this)).getString());
        Entity entity = p_70645_1_.func_76346_g();
        if (entity != null) {
            this.func_223361_a(entity);
        }
        this.func_242369_fq();
        super.func_70645_a(p_70645_1_);
    }

    private void func_242369_fq() {
        this.func_213742_a(MemoryModuleType.field_220941_b);
        this.func_213742_a(MemoryModuleType.field_220942_c);
        this.func_213742_a(MemoryModuleType.field_234101_d_);
        this.func_213742_a(MemoryModuleType.field_220943_d);
    }

    private void func_223361_a(Entity p_223361_1_) {
        Optional optional;
        if (this.field_70170_p instanceof ServerWorld && (optional = this.field_213378_br.func_218207_c(MemoryModuleType.field_220946_g)).isPresent()) {
            ServerWorld serverworld = (ServerWorld)this.field_70170_p;
            ((List)optional.get()).stream().filter(p_223349_0_ -> p_223349_0_ instanceof IReputationTracking).forEach(p_223342_2_ -> serverworld.func_217489_a(IReputationType.field_221032_d, p_223361_1_, (IReputationTracking)p_223342_2_));
        }
    }

    public void func_213742_a(MemoryModuleType<GlobalPos> p_213742_1_) {
        if (this.field_70170_p instanceof ServerWorld) {
            MinecraftServer minecraftserver = ((ServerWorld)this.field_70170_p).func_73046_m();
            this.field_213378_br.func_218207_c(p_213742_1_).ifPresent(p_213752_3_ -> {
                ServerWorld serverworld = minecraftserver.func_71218_a(p_213752_3_.func_239646_a_());
                if (serverworld != null) {
                    PointOfInterestManager pointofinterestmanager = serverworld.func_217443_B();
                    Optional optional = pointofinterestmanager.func_219148_c(p_213752_3_.func_218180_b());
                    BiPredicate<VillagerEntity, PointOfInterestType> bipredicate = field_213774_bB.get(p_213742_1_);
                    if (optional.isPresent() && bipredicate.test(this, (PointOfInterestType)((Object)((Object)optional.get())))) {
                        pointofinterestmanager.func_219142_b(p_213752_3_.func_218180_b());
                        DebugPacketSender.func_218801_c((ServerWorld)serverworld, (BlockPos)p_213752_3_.func_218180_b());
                    }
                }
            });
        }
    }

    public boolean func_213743_em() {
        return this.field_213781_bL + this.func_213751_ew() >= 12 && this.func_70874_b() == 0;
    }

    private boolean func_223344_ex() {
        return this.field_213781_bL < 12;
    }

    private void func_213765_en() {
        if (this.func_223344_ex() && this.func_213751_ew() != 0) {
            for (int i = 0; i < this.func_213715_ed().func_70302_i_(); ++i) {
                int j;
                Integer integer;
                ItemStack itemstack = this.func_213715_ed().func_70301_a(i);
                if (itemstack.func_190926_b() || (integer = field_213788_bA.get((Object)itemstack.func_77973_b())) == null) continue;
                for (int k = j = itemstack.func_190916_E(); k > 0; --k) {
                    this.field_213781_bL = (byte)(this.field_213781_bL + integer);
                    this.func_213715_ed().func_70298_a(i, 1);
                    if (this.func_223344_ex()) continue;
                    return;
                }
            }
        }
    }

    public int func_223107_f(PlayerEntity p_223107_1_) {
        return this.field_213782_bM.func_220921_a(p_223107_1_.func_110124_au(), p_223103_0_ -> true);
    }

    private void func_213758_s(int p_213758_1_) {
        this.field_213781_bL = (byte)(this.field_213781_bL - p_213758_1_);
    }

    public void func_223346_ep() {
        this.func_213765_en();
        this.func_213758_s(12);
    }

    public void func_213768_b(MerchantOffers p_213768_1_) {
        this.field_213724_bz = p_213768_1_;
    }

    private boolean func_213741_eu() {
        int i = this.func_213700_eh().func_221132_c();
        return VillagerData.func_221128_d((int)i) && this.field_213784_bO >= VillagerData.func_221127_c((int)i);
    }

    private void func_175554_cu() {
        this.func_213753_a(this.func_213700_eh().func_221135_a(this.func_213700_eh().func_221132_c() + 1));
        this.func_213712_ef();
    }

    protected ITextComponent func_225513_by_() {
        ResourceLocation profName = this.func_213700_eh().func_221130_b().getRegistryName();
        return new TranslationTextComponent(this.func_200600_R().func_210760_d() + '.' + (!"minecraft".equals(profName.func_110624_b()) ? profName.func_110624_b() + '.' : "") + profName.func_110623_a());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 12) {
            this.func_213718_a((IParticleData)ParticleTypes.field_197633_z);
        } else if (p_70103_1_ == 13) {
            this.func_213718_a((IParticleData)ParticleTypes.field_197609_b);
        } else if (p_70103_1_ == 14) {
            this.func_213718_a((IParticleData)ParticleTypes.field_197632_y);
        } else if (p_70103_1_ == 42) {
            this.func_213718_a((IParticleData)ParticleTypes.field_218422_X);
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        if (p_213386_3_ == SpawnReason.BREEDING) {
            this.func_213753_a(this.func_213700_eh().func_221126_a(VillagerProfession.field_221151_a));
        }
        if (p_213386_3_ == SpawnReason.COMMAND || p_213386_3_ == SpawnReason.SPAWN_EGG || p_213386_3_ == SpawnReason.SPAWNER || p_213386_3_ == SpawnReason.DISPENSER) {
            this.func_213753_a(this.func_213700_eh().func_221134_a(VillagerType.func_242371_a((Optional)p_213386_1_.func_242406_i(this.func_233580_cy_()))));
        }
        if (p_213386_3_ == SpawnReason.STRUCTURE) {
            this.field_234542_bL_ = true;
        }
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    public VillagerEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        double d0 = this.field_70146_Z.nextDouble();
        VillagerType villagertype = d0 < 0.5 ? VillagerType.func_242371_a((Optional)p_241840_1_.func_242406_i(this.func_233580_cy_())) : (d0 < 0.75 ? this.func_213700_eh().func_221129_a() : ((VillagerEntity)p_241840_2_).func_213700_eh().func_221129_a());
        VillagerEntity villagerentity = new VillagerEntity(EntityType.field_200756_av, p_241840_1_, villagertype);
        villagerentity.func_213386_a((IServerWorld)p_241840_1_, p_241840_1_.func_175649_E(villagerentity.func_233580_cy_()), SpawnReason.BREEDING, null, null);
        return villagerentity;
    }

    public void func_241841_a(ServerWorld p_241841_1_, LightningBoltEntity p_241841_2_) {
        if (p_241841_1_.func_175659_aa() != Difficulty.PEACEFUL && ForgeEventFactory.canLivingConvert((LivingEntity)((Object)this), EntityType.field_200759_ay, timer -> {})) {
            field_184243_a.info("Villager {} was struck by lightning {}.", (Object)this, (Object)p_241841_2_);
            WitchEntity witchentity = EntityType.field_200759_ay.func_200721_a(p_241841_1_);
            witchentity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            witchentity.func_213386_a((IServerWorld)p_241841_1_, p_241841_1_.func_175649_E(witchentity.func_233580_cy_()), SpawnReason.CONVERSION, (ILivingEntityData)null, (CompoundNBT)null);
            witchentity.func_94061_f(this.func_175446_cd());
            if (this.func_145818_k_()) {
                witchentity.func_200203_b(this.func_200201_e());
                witchentity.func_174805_g(this.func_174833_aM());
            }
            witchentity.func_110163_bv();
            ForgeEventFactory.onLivingConvert((LivingEntity)((Object)this), (LivingEntity)witchentity);
            p_241841_1_.func_242417_l((Entity)witchentity);
            this.func_242369_fq();
            this.func_70106_y();
        } else {
            super.func_241841_a(p_241841_1_, p_241841_2_);
        }
    }

    protected void func_175445_a(ItemEntity p_175445_1_) {
        ItemStack itemstack = p_175445_1_.func_92059_d();
        if (this.func_230293_i_(itemstack)) {
            Inventory inventory = this.func_213715_ed();
            boolean flag = inventory.func_233541_b_(itemstack);
            if (!flag) {
                return;
            }
            this.func_233630_a_(p_175445_1_);
            this.func_71001_a(p_175445_1_, itemstack.func_190916_E());
            ItemStack itemstack1 = inventory.func_174894_a(itemstack);
            if (itemstack1.func_190926_b()) {
                p_175445_1_.func_70106_y();
            } else {
                itemstack.func_190920_e(itemstack1.func_190916_E());
            }
        }
    }

    public boolean func_230293_i_(ItemStack p_230293_1_) {
        Item item = p_230293_1_.func_77973_b();
        return (field_213776_bD.contains((Object)item) || this.func_213700_eh().func_221130_b().func_221146_c().contains((Object)item)) && this.func_213715_ed().func_233541_b_(p_230293_1_);
    }

    public boolean func_175555_cq() {
        return this.func_213751_ew() >= 24;
    }

    public boolean func_175557_cr() {
        return this.func_213751_ew() < 12;
    }

    private int func_213751_ew() {
        Inventory inventory = this.func_213715_ed();
        return field_213788_bA.entrySet().stream().mapToInt(p_226553_1_ -> inventory.func_213901_a((Item)((Object)((Object)p_226553_1_.getKey()))) * (Integer)p_226553_1_.getValue()).sum();
    }

    public boolean func_175556_cs() {
        return this.func_213715_ed().func_213902_a((Set)ImmutableSet.of((Object)((Object)Items.field_151014_N), (Object)((Object)Items.field_151174_bG), (Object)((Object)Items.field_151172_bF), (Object)((Object)Items.field_185163_cU)));
    }

    @Override
    protected void func_213712_ef() {
        VillagerTrades.ITrade[] avillagertrades$itrade;
        VillagerData villagerdata = this.func_213700_eh();
        Int2ObjectMap int2objectmap = (Int2ObjectMap)VillagerTrades.field_221239_a.get((Object)villagerdata.func_221130_b());
        if (int2objectmap != null && !int2objectmap.isEmpty() && (avillagertrades$itrade = (VillagerTrades.ITrade[])int2objectmap.get(villagerdata.func_221132_c())) != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.func_213717_a(merchantoffers, avillagertrades$itrade, 2);
        }
    }

    public void func_242368_a(ServerWorld p_242368_1_, VillagerEntity p_242368_2_, long p_242368_3_) {
        if (!(p_242368_3_ >= this.field_213783_bN && p_242368_3_ < this.field_213783_bN + 1200L || p_242368_3_ >= p_242368_2_.field_213783_bN && p_242368_3_ < p_242368_2_.field_213783_bN + 1200L)) {
            this.field_213782_bM.func_220912_a(p_242368_2_.field_213782_bM, this.field_70146_Z, 10);
            this.field_213783_bN = p_242368_3_;
            p_242368_2_.field_213783_bN = p_242368_3_;
            this.func_242367_a(p_242368_1_, p_242368_3_, 5);
        }
    }

    private void func_223343_eC() {
        long i = this.field_70170_p.func_82737_E();
        if (this.field_223362_bL == 0L) {
            this.field_223362_bL = i;
        } else if (i >= this.field_223362_bL + 24000L) {
            this.field_213782_bM.func_223538_b();
            this.field_223362_bL = i;
        }
    }

    public void func_242367_a(ServerWorld p_242367_1_, long p_242367_2_, int p_242367_4_) {
        IronGolemEntity irongolementity;
        AxisAlignedBB axisalignedbb;
        List list;
        List list1;
        if (this.func_223350_a(p_242367_2_) && (list1 = (list = p_242367_1_.func_217357_a(VillagerEntity.class, axisalignedbb = this.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0))).stream().filter(p_226554_2_ -> p_226554_2_.func_223350_a(p_242367_2_)).limit(5L).collect(Collectors.toList())).size() >= p_242367_4_ && (irongolementity = this.func_213759_ey(p_242367_1_)) != null) {
            list.forEach(GolemLastSeenSensor::func_242313_b);
        }
    }

    public boolean func_223350_a(long p_223350_1_) {
        if (!this.func_223352_d(this.field_70170_p.func_82737_E())) {
            return false;
        }
        return !this.field_213378_br.func_218191_a(MemoryModuleType.field_242309_E);
    }

    @Nullable
    private IronGolemEntity func_213759_ey(ServerWorld p_213759_1_) {
        BlockPos blockpos = this.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            IronGolemEntity irongolementity;
            double d1;
            double d0 = p_213759_1_.field_73012_v.nextInt(16) - 8;
            BlockPos blockpos1 = this.func_241433_a_(blockpos, d0, d1 = (double)(p_213759_1_.field_73012_v.nextInt(16) - 8));
            if (blockpos1 == null || (irongolementity = EntityType.field_200757_aw.func_220349_b(p_213759_1_, null, null, null, blockpos1, SpawnReason.MOB_SUMMONED, false, false)) == null) continue;
            if (irongolementity.func_213380_a(p_213759_1_, SpawnReason.MOB_SUMMONED) && irongolementity.func_205019_a((IWorldReader)((Object)p_213759_1_))) {
                p_213759_1_.func_242417_l((Entity)((Object)irongolementity));
                return irongolementity;
            }
            irongolementity.func_70106_y();
        }
        return null;
    }

    @Nullable
    private BlockPos func_241433_a_(BlockPos p_241433_1_, double p_241433_2_, double p_241433_4_) {
        int i = 6;
        BlockPos blockpos = p_241433_1_.func_177963_a(p_241433_2_, 6.0, p_241433_4_);
        BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
        for (int j = 6; j >= -6; --j) {
            BlockPos blockpos1 = blockpos;
            BlockState blockstate1 = blockstate;
            blockpos = blockpos.func_177977_b();
            blockstate = this.field_70170_p.func_180495_p(blockpos);
            if (!blockstate1.func_196958_f() && !blockstate1.func_185904_a().func_76224_d() || !blockstate.func_185904_a().func_76218_k()) continue;
            return blockpos1;
        }
        return null;
    }

    public void func_213739_a(IReputationType p_213739_1_, Entity p_213739_2_) {
        if (p_213739_1_ == IReputationType.field_221029_a) {
            this.field_213782_bM.func_220916_a(p_213739_2_.func_110124_au(), GossipType.MAJOR_POSITIVE, 20);
            this.field_213782_bM.func_220916_a(p_213739_2_.func_110124_au(), GossipType.MINOR_POSITIVE, 25);
        } else if (p_213739_1_ == IReputationType.field_221033_e) {
            this.field_213782_bM.func_220916_a(p_213739_2_.func_110124_au(), GossipType.TRADING, 2);
        } else if (p_213739_1_ == IReputationType.field_221031_c) {
            this.field_213782_bM.func_220916_a(p_213739_2_.func_110124_au(), GossipType.MINOR_NEGATIVE, 25);
        } else if (p_213739_1_ == IReputationType.field_221032_d) {
            this.field_213782_bM.func_220916_a(p_213739_2_.func_110124_au(), GossipType.MAJOR_NEGATIVE, 25);
        }
    }

    @Override
    public int func_213708_dV() {
        return this.field_213784_bO;
    }

    public void func_213761_t(int p_213761_1_) {
        this.field_213784_bO = p_213761_1_;
    }

    private void func_223718_eH() {
        this.func_223719_ex();
        this.field_223725_bO = 0;
    }

    public GossipManager func_223722_es() {
        return this.field_213782_bM;
    }

    public void func_223716_a(INBT p_223716_1_) {
        this.field_213782_bM.func_234057_a_(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)p_223716_1_));
    }

    protected void func_213387_K() {
        super.func_213387_K();
        DebugPacketSender.func_218798_a((LivingEntity)((Object)this));
    }

    public void func_213342_e(BlockPos p_213342_1_) {
        super.func_213342_e(p_213342_1_);
        this.field_213378_br.func_218205_a(MemoryModuleType.field_223543_y, (Object)this.field_70170_p.func_82737_E());
        this.field_213378_br.func_218189_b(MemoryModuleType.field_220950_k);
        this.field_213378_br.func_218189_b(MemoryModuleType.field_223021_x);
    }

    public void func_213366_dy() {
        super.func_213366_dy();
        this.field_213378_br.func_218205_a(MemoryModuleType.field_226332_A_, (Object)this.field_70170_p.func_82737_E());
    }

    private boolean func_223352_d(long p_223352_1_) {
        Optional optional = this.field_213378_br.func_218207_c(MemoryModuleType.field_223543_y);
        if (optional.isPresent()) {
            return p_223352_1_ - (Long)optional.get() < 24000L;
        }
        return false;
    }
}

