/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.fluid;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class LavaFluid
extends FlowingFluid {
    @Override
    public Fluid func_210197_e() {
        return Fluids.field_207213_d;
    }

    @Override
    public Fluid func_210198_f() {
        return Fluids.field_204547_b;
    }

    @Override
    public Item func_204524_b() {
        return Items.field_151129_at;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_204522_a(World p_204522_1_, BlockPos p_204522_2_, FluidState p_204522_3_, Random p_204522_4_) {
        BlockPos blockpos = p_204522_2_.func_177984_a();
        if (p_204522_1_.func_180495_p(blockpos).func_196958_f() && !p_204522_1_.func_180495_p(blockpos).func_200015_d((IBlockReader)((Object)p_204522_1_), blockpos)) {
            if (p_204522_4_.nextInt(100) == 0) {
                double d0 = (double)p_204522_2_.func_177958_n() + p_204522_4_.nextDouble();
                double d1 = (double)p_204522_2_.func_177956_o() + 1.0;
                double d2 = (double)p_204522_2_.func_177952_p() + p_204522_4_.nextDouble();
                p_204522_1_.func_195594_a((IParticleData)ParticleTypes.field_197595_F, d0, d1, d2, 0.0, 0.0, 0.0);
                p_204522_1_.func_184134_a(d0, d1, d2, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + p_204522_4_.nextFloat() * 0.2f, 0.9f + p_204522_4_.nextFloat() * 0.15f, false);
            }
            if (p_204522_4_.nextInt(200) == 0) {
                p_204522_1_.func_184134_a(p_204522_2_.func_177958_n(), p_204522_2_.func_177956_o(), p_204522_2_.func_177952_p(), SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + p_204522_4_.nextFloat() * 0.2f, 0.9f + p_204522_4_.nextFloat() * 0.15f, false);
            }
        }
    }

    @Override
    public void func_207186_b(World p_207186_1_, BlockPos p_207186_2_, FluidState p_207186_3_, Random p_207186_4_) {
        block7: {
            if (!p_207186_1_.func_82736_K().func_223586_b(GameRules.field_223598_a)) break block7;
            int i = p_207186_4_.nextInt(3);
            if (i > 0) {
                BlockPos blockpos = p_207186_2_;
                for (int j = 0; j < i; ++j) {
                    if (!p_207186_1_.func_195588_v(blockpos = blockpos.func_177982_a(p_207186_4_.nextInt(3) - 1, 1, p_207186_4_.nextInt(3) - 1))) {
                        return;
                    }
                    BlockState blockstate = p_207186_1_.func_180495_p(blockpos);
                    if (blockstate.func_196958_f()) {
                        if (!this.func_176369_e((IWorldReader)((Object)p_207186_1_), blockpos)) continue;
                        p_207186_1_.func_175656_a(blockpos, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)p_207186_1_, (BlockPos)blockpos, (BlockPos)p_207186_2_, (BlockState)Blocks.field_150480_ab.func_176223_P()));
                        return;
                    }
                    if (!blockstate.func_185904_a().func_76230_c()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos blockpos1 = p_207186_2_.func_177982_a(p_207186_4_.nextInt(3) - 1, 0, p_207186_4_.nextInt(3) - 1);
                    if (!p_207186_1_.func_195588_v(blockpos1)) {
                        return;
                    }
                    if (!p_207186_1_.func_175623_d(blockpos1.func_177984_a()) || !this.isFlammable((IWorldReader)((Object)p_207186_1_), blockpos1, Direction.UP)) continue;
                    p_207186_1_.func_175656_a(blockpos1.func_177984_a(), ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)p_207186_1_, (BlockPos)blockpos1.func_177984_a(), (BlockPos)p_207186_2_, (BlockState)Blocks.field_150480_ab.func_176223_P()));
                }
            }
        }
    }

    private boolean func_176369_e(IWorldReader p_176369_1_, BlockPos p_176369_2_) {
        for (Direction direction : Direction.values()) {
            if (!this.isFlammable(p_176369_1_, p_176369_2_.func_177972_a(direction), direction.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    private boolean func_176368_m(IWorldReader p_176368_1_, BlockPos p_176368_2_) {
        return p_176368_2_.func_177956_o() >= 0 && p_176368_2_.func_177956_o() < 256 && !p_176368_1_.func_175667_e(p_176368_2_) ? false : p_176368_1_.func_180495_p(p_176368_2_).func_185904_a().func_76217_h();
    }

    private boolean isFlammable(IWorldReader world, BlockPos pos, Direction face) {
        return pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && !world.func_175667_e(pos) ? false : world.func_180495_p(pos).isFlammable((IBlockReader)((Object)world), pos, face);
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IParticleData func_204521_c() {
        return ParticleTypes.field_197617_j;
    }

    @Override
    protected void func_205580_a(IWorld p_205580_1_, BlockPos p_205580_2_, BlockState p_205580_3_) {
        this.func_205581_a(p_205580_1_, p_205580_2_);
    }

    @Override
    public int func_185698_b(IWorldReader p_185698_1_) {
        return p_185698_1_.func_230315_m_().func_236040_e_() ? 4 : 2;
    }

    @Override
    public BlockState func_204527_a(FluidState p_204527_1_) {
        return (BlockState)((Object)Blocks.field_150353_l.func_176223_P().func_206870_a((Property)FlowingFluidBlock.field_176367_b, Integer.valueOf(LavaFluid.func_207205_e(p_204527_1_))));
    }

    @Override
    public boolean func_207187_a(Fluid p_207187_1_) {
        return p_207187_1_ == Fluids.field_204547_b || p_207187_1_ == Fluids.field_207213_d;
    }

    @Override
    public int func_204528_b(IWorldReader p_204528_1_) {
        return p_204528_1_.func_230315_m_().func_236040_e_() ? 1 : 2;
    }

    @Override
    public boolean func_215665_a(FluidState p_215665_1_, IBlockReader p_215665_2_, BlockPos p_215665_3_, Fluid p_215665_4_, Direction p_215665_5_) {
        return p_215665_1_.func_215679_a(p_215665_2_, p_215665_3_) >= 0.44444445f && p_215665_4_.func_207185_a(FluidTags.field_206959_a);
    }

    @Override
    public int func_205569_a(IWorldReader p_205569_1_) {
        return p_205569_1_.func_230315_m_().func_236040_e_() ? 10 : 30;
    }

    @Override
    public int func_215667_a(World p_215667_1_, BlockPos p_215667_2_, FluidState p_215667_3_, FluidState p_215667_4_) {
        int i = this.func_205569_a((IWorldReader)((Object)p_215667_1_));
        if (!(p_215667_3_.func_206888_e() || p_215667_4_.func_206888_e() || ((Boolean)p_215667_3_.func_177229_b((Property)field_207209_a)).booleanValue() || ((Boolean)p_215667_4_.func_177229_b((Property)field_207209_a)).booleanValue() || !(p_215667_4_.func_215679_a((IBlockReader)((Object)p_215667_1_), p_215667_2_) > p_215667_3_.func_215679_a((IBlockReader)((Object)p_215667_1_), p_215667_2_)) || p_215667_1_.func_201674_k().nextInt(4) == 0)) {
            i *= 4;
        }
        return i;
    }

    private void func_205581_a(IWorld p_205581_1_, BlockPos p_205581_2_) {
        p_205581_1_.func_217379_c(1501, p_205581_2_, 0);
    }

    @Override
    protected boolean func_205579_d() {
        return false;
    }

    @Override
    protected void func_205574_a(IWorld p_205574_1_, BlockPos p_205574_2_, BlockState p_205574_3_, Direction p_205574_4_, FluidState p_205574_5_) {
        if (p_205574_4_ == Direction.DOWN) {
            FluidState fluidstate = p_205574_1_.func_204610_c(p_205574_2_);
            if (this.func_207185_a(FluidTags.field_206960_b) && fluidstate.func_206884_a(FluidTags.field_206959_a)) {
                if (p_205574_3_.func_177230_c() instanceof FlowingFluidBlock) {
                    p_205574_1_.func_180501_a(p_205574_2_, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)p_205574_1_, (BlockPos)p_205574_2_, (BlockPos)p_205574_2_, (BlockState)Blocks.field_150348_b.func_176223_P()), 3);
                }
                this.func_205581_a(p_205574_1_, p_205574_2_);
                return;
            }
        }
        super.func_205574_a(p_205574_1_, p_205574_2_, p_205574_3_, p_205574_4_, p_205574_5_);
    }

    @Override
    protected boolean func_207196_h() {
        return true;
    }

    @Override
    protected float func_210195_d() {
        return 100.0f;
    }

    public static class Source
    extends LavaFluid {
        @Override
        public int func_207192_d(FluidState p_207192_1_) {
            return 8;
        }

        @Override
        public boolean func_207193_c(FluidState p_207193_1_) {
            return true;
        }
    }

    public static class Flowing
    extends LavaFluid {
        @Override
        protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> p_207184_1_) {
            super.func_207184_a(p_207184_1_);
            p_207184_1_.func_206894_a(new Property[]{field_207210_b});
        }

        @Override
        public int func_207192_d(FluidState p_207192_1_) {
            return (Integer)p_207192_1_.func_177229_b((Property)field_207210_b);
        }

        @Override
        public boolean func_207193_c(FluidState p_207193_1_) {
            return false;
        }
    }
}

