/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpawnEggItem
extends Item {
    private static final Map<EntityType<?>, SpawnEggItem> field_195987_b = Maps.newIdentityHashMap();
    private final int field_195988_c;
    private final int field_195989_d;
    private final EntityType<?> field_200890_d;

    @Deprecated
    public SpawnEggItem(EntityType<?> p_i48465_1_, int p_i48465_2_, int p_i48465_3_, Item.Properties p_i48465_4_) {
        super(p_i48465_4_);
        this.field_200890_d = p_i48465_1_;
        this.field_195988_c = p_i48465_2_;
        this.field_195989_d = p_i48465_3_;
        if (p_i48465_1_ != null) {
            field_195987_b.put(p_i48465_1_, this);
        }
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext p_195939_1_) {
        TileEntity tileentity;
        World world = p_195939_1_.func_195991_k();
        if (!(world instanceof ServerWorld)) {
            return ActionResultType.SUCCESS;
        }
        ItemStack itemstack = p_195939_1_.func_195996_i();
        BlockPos blockpos = p_195939_1_.func_195995_a();
        Direction direction = p_195939_1_.func_196000_l();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (blockstate.func_203425_a(Blocks.field_150474_ac) && (tileentity = world.func_175625_s(blockpos)) instanceof MobSpawnerTileEntity) {
            AbstractSpawner abstractspawner = ((MobSpawnerTileEntity)tileentity).func_145881_a();
            EntityType<?> entitytype1 = this.func_208076_b(itemstack.func_77978_p());
            abstractspawner.func_200876_a(entitytype1);
            tileentity.func_70296_d();
            world.func_184138_a(blockpos, blockstate, blockstate, 3);
            itemstack.func_190918_g(1);
            return ActionResultType.CONSUME;
        }
        BlockPos blockpos1 = blockstate.func_196952_d((IBlockReader)((Object)world), blockpos).func_197766_b() ? blockpos : blockpos.func_177972_a(direction);
        EntityType<?> entitytype = this.func_208076_b(itemstack.func_77978_p());
        if (entitytype.func_220331_a((ServerWorld)world, itemstack, p_195939_1_.func_195999_j(), blockpos1, SpawnReason.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP) != null) {
            itemstack.func_190918_g(1);
        }
        return ActionResultType.CONSUME;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World p_77659_1_, PlayerEntity p_77659_2_, Hand p_77659_3_) {
        ItemStack itemstack = p_77659_2_.func_184586_b(p_77659_3_);
        BlockRayTraceResult raytraceresult = SpawnEggItem.func_219968_a(p_77659_1_, p_77659_2_, RayTraceContext.FluidMode.SOURCE_ONLY);
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)((Object)itemstack));
        }
        if (!(p_77659_1_ instanceof ServerWorld)) {
            return ActionResult.func_226248_a_((Object)((Object)itemstack));
        }
        BlockRayTraceResult blockraytraceresult = raytraceresult;
        BlockPos blockpos = blockraytraceresult.func_216350_a();
        if (!(p_77659_1_.func_180495_p(blockpos).func_177230_c() instanceof FlowingFluidBlock)) {
            return ActionResult.func_226250_c_((Object)((Object)itemstack));
        }
        if (p_77659_1_.func_175660_a(p_77659_2_, blockpos) && p_77659_2_.func_175151_a(blockpos, blockraytraceresult.func_216354_b(), itemstack)) {
            EntityType<?> entitytype = this.func_208076_b(itemstack.func_77978_p());
            if (entitytype.func_220331_a((ServerWorld)p_77659_1_, itemstack, p_77659_2_, blockpos, SpawnReason.SPAWN_EGG, false, false) == null) {
                return ActionResult.func_226250_c_((Object)((Object)itemstack));
            }
            if (!p_77659_2_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            p_77659_2_.func_71029_a(Stats.field_75929_E.func_199076_b(this));
            return ActionResult.func_226249_b_((Object)((Object)itemstack));
        }
        return ActionResult.func_226251_d_((Object)((Object)itemstack));
    }

    public boolean func_208077_a(@Nullable CompoundNBT p_208077_1_, EntityType<?> p_208077_2_) {
        return Objects.equals(this.func_208076_b(p_208077_1_), p_208077_2_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_195983_a(int p_195983_1_) {
        return p_195983_1_ == 0 ? this.field_195988_c : this.field_195989_d;
    }

    @Deprecated
    @Nullable
    public static SpawnEggItem func_200889_b(@Nullable EntityType<?> p_200889_0_) {
        return field_195987_b.get(p_200889_0_);
    }

    public static Iterable<SpawnEggItem> func_195985_g() {
        return Iterables.unmodifiableIterable(field_195987_b.values());
    }

    public EntityType<?> func_208076_b(@Nullable CompoundNBT p_208076_1_) {
        CompoundNBT compoundnbt;
        if (p_208076_1_ != null && p_208076_1_.func_150297_b("EntityTag", 10) && (compoundnbt = p_208076_1_.func_74775_l("EntityTag")).func_150297_b("id", 8)) {
            return EntityType.func_220327_a(compoundnbt.func_74779_i("id")).orElse(this.field_200890_d);
        }
        return this.field_200890_d;
    }

    public Optional<MobEntity> func_234809_a_(PlayerEntity p_234809_1_, MobEntity p_234809_2_, EntityType<? extends MobEntity> p_234809_3_, ServerWorld p_234809_4_, Vector3d p_234809_5_, ItemStack p_234809_6_) {
        if (!this.func_208077_a(p_234809_6_.func_77978_p(), p_234809_3_)) {
            return Optional.empty();
        }
        MobEntity mobentity = p_234809_2_ instanceof AgeableEntity ? ((AgeableEntity)p_234809_2_).func_241840_a(p_234809_4_, (AgeableEntity)p_234809_2_) : p_234809_3_.func_200721_a(p_234809_4_);
        if (mobentity == null) {
            return Optional.empty();
        }
        mobentity.func_82227_f(true);
        if (!mobentity.func_70631_g_()) {
            return Optional.empty();
        }
        mobentity.func_70012_b(p_234809_5_.func_82615_a(), p_234809_5_.func_82617_b(), p_234809_5_.func_82616_c(), 0.0f, 0.0f);
        p_234809_4_.func_242417_l(mobentity);
        if (p_234809_6_.func_82837_s()) {
            mobentity.func_200203_b(p_234809_6_.func_200301_q());
        }
        if (!p_234809_1_.field_71075_bZ.field_75098_d) {
            p_234809_6_.func_190918_g(1);
        }
        return Optional.of(mobentity);
    }
}

