/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AbstractArrowEntity
extends ProjectileEntity {
    private static final DataParameter<Byte> field_184554_g = EntityDataManager.func_187226_a(AbstractArrowEntity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Byte> field_213876_as = EntityDataManager.func_187226_a(AbstractArrowEntity.class, DataSerializers.field_187191_a);
    @Nullable
    private BlockState field_195056_av;
    protected boolean field_70254_i;
    protected int field_184552_b;
    public PickupStatus field_70251_a = PickupStatus.DISALLOWED;
    public int field_70249_b;
    private int field_70252_j;
    private double field_70255_ao = 2.0;
    private int field_70256_ap;
    private SoundEvent field_213877_ay = this.func_213867_k();
    private IntOpenHashSet field_213878_az;
    private List<Entity> field_213875_aA;

    protected AbstractArrowEntity(EntityType<? extends AbstractArrowEntity> p_i48546_1_, World p_i48546_2_) {
        super(p_i48546_1_, p_i48546_2_);
    }

    protected AbstractArrowEntity(EntityType<? extends AbstractArrowEntity> p_i48547_1_, double p_i48547_2_, double p_i48547_4_, double p_i48547_6_, World p_i48547_8_) {
        this(p_i48547_1_, p_i48547_8_);
        this.func_70107_b(p_i48547_2_, p_i48547_4_, p_i48547_6_);
    }

    protected AbstractArrowEntity(EntityType<? extends AbstractArrowEntity> p_i48548_1_, LivingEntity p_i48548_2_, World p_i48548_3_) {
        this(p_i48548_1_, p_i48548_2_.func_226277_ct_(), p_i48548_2_.func_226280_cw_() - (double)0.1f, p_i48548_2_.func_226281_cx_(), p_i48548_3_);
        this.func_212361_a(p_i48548_2_);
        if (p_i48548_2_ instanceof PlayerEntity) {
            this.field_70251_a = PickupStatus.ALLOWED;
        }
    }

    public void func_213869_a(SoundEvent p_213869_1_) {
        this.field_213877_ay = p_213869_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return p_70112_1_ < (d0 = d0 * 64.0 * AbstractArrowEntity.func_184183_bd()) * d0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184554_g, (byte)0);
        this.field_70180_af.func_187214_a(field_213876_as, (byte)0);
    }

    public void func_70186_c(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        super.func_70186_c(p_70186_1_, p_70186_3_, p_70186_5_, p_70186_7_, p_70186_8_);
        this.field_70252_j = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double p_180426_1_, double p_180426_3_, double p_180426_5_, float p_180426_7_, float p_180426_8_, int p_180426_9_, boolean p_180426_10_) {
        this.func_70107_b(p_180426_1_, p_180426_3_, p_180426_5_);
        this.func_70101_b(p_180426_7_, p_180426_8_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
        super.func_70016_h(p_70016_1_, p_70016_3_, p_70016_5_);
        this.field_70252_j = 0;
    }

    public void func_70071_h_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        super.func_70071_h_();
        boolean flag = this.func_203047_q();
        Vector3d vector3d = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)AbstractArrowEntity.func_213296_b((Vector3d)vector3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((blockstate = this.field_70170_p.func_180495_p(blockpos = this.func_233580_cy_())).isAir((IBlockReader)((Object)this.field_70170_p), blockpos) || flag || (voxelshape = blockstate.func_196952_d((IBlockReader)((Object)this.field_70170_p), blockpos)).func_197766_b())) {
            Vector3d vector3d1 = this.func_213303_ch();
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(vector3d1)) continue;
                this.field_70254_i = true;
                break;
            }
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.field_70254_i && !flag) {
            if (this.field_195056_av != blockstate && this.func_234593_u_()) {
                this.func_234594_z_();
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_225516_i_();
            }
            ++this.field_184552_b;
        } else {
            Vector3d vector3d3;
            this.field_184552_b = 0;
            Vector3d vector3d2 = this.func_213303_ch();
            BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vector3d2, vector3d3 = vector3d2.func_178787_e(vector3d), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)((Object)this)));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                vector3d3 = raytraceresult.func_216347_e();
            }
            while (!this.field_70128_L) {
                EntityRayTraceResult entityraytraceresult = this.func_213866_a(vector3d2, vector3d3);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                    Entity entity1 = this.func_234616_v_();
                    if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((AbstractArrowEntity)this, (RayTraceResult)raytraceresult)) {
                    this.func_70227_a((RayTraceResult)raytraceresult);
                    this.field_70160_al = true;
                }
                if (entityraytraceresult == null || this.func_213874_s() <= 0) break;
                raytraceresult = null;
            }
            vector3d = this.func_213322_ci();
            double d3 = vector3d.field_72450_a;
            double d4 = vector3d.field_72448_b;
            double d0 = vector3d.field_72449_c;
            if (this.func_70241_g()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_() + d3 * (double)i / 4.0, this.func_226278_cu_() + d4 * (double)i / 4.0, this.func_226281_cx_() + d0 * (double)i / 4.0, -d3, -d4 + 0.2, -d0);
                }
            }
            double d5 = this.func_226277_ct_() + d3;
            double d1 = this.func_226278_cu_() + d4;
            double d2 = this.func_226281_cx_() + d0;
            float f1 = MathHelper.func_76133_a((double)AbstractArrowEntity.func_213296_b((Vector3d)vector3d));
            this.field_70177_z = flag ? (float)(MathHelper.func_181159_b((double)(-d3), (double)(-d0)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)d3, (double)d0) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)d4, (double)f1) * 57.2957763671875);
            this.field_70125_A = AbstractArrowEntity.func_234614_e_((float)this.field_70127_C, (float)this.field_70125_A);
            this.field_70177_z = AbstractArrowEntity.func_234614_e_((float)this.field_70126_B, (float)this.field_70177_z);
            float f2 = 0.99f;
            float f3 = 0.05f;
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    float f4 = 0.25f;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
                }
                f2 = this.func_203044_p();
            }
            this.func_213317_d(vector3d.func_186678_a(f2));
            if (!this.func_189652_ae() && !flag) {
                Vector3d vector3d4 = this.func_213322_ci();
                this.func_213293_j(vector3d4.field_72450_a, vector3d4.field_72448_b - (double)0.05f, vector3d4.field_72449_c);
            }
            this.func_70107_b(d5, d1, d2);
            this.func_145775_I();
        }
    }

    private boolean func_234593_u_() {
        return this.field_70254_i && this.field_70170_p.func_226664_a_(new AxisAlignedBB(this.func_213303_ch(), this.func_213303_ch()).func_186662_g(0.06));
    }

    private void func_234594_z_() {
        this.field_70254_i = false;
        Vector3d vector3d = this.func_213322_ci();
        this.func_213317_d(vector3d.func_216372_d(this.field_70146_Z.nextFloat() * 0.2f, this.field_70146_Z.nextFloat() * 0.2f, this.field_70146_Z.nextFloat() * 0.2f));
        this.field_70252_j = 0;
    }

    public void func_213315_a(MoverType p_213315_1_, Vector3d p_213315_2_) {
        super.func_213315_a(p_213315_1_, p_213315_2_);
        if (p_213315_1_ != MoverType.SELF && this.func_234593_u_()) {
            this.func_234594_z_();
        }
    }

    protected void func_225516_i_() {
        ++this.field_70252_j;
        if (this.field_70252_j >= 1200) {
            this.func_70106_y();
        }
    }

    private void func_213870_w() {
        if (this.field_213875_aA != null) {
            this.field_213875_aA.clear();
        }
        if (this.field_213878_az != null) {
            this.field_213878_az.clear();
        }
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        DamageSource damagesource;
        Entity entity1;
        super.func_213868_a(p_213868_1_);
        Entity entity = p_213868_1_.func_216348_a();
        float f = (float)this.func_213322_ci().func_72433_c();
        int i = MathHelper.func_76143_f((double)MathHelper.func_151237_a((double)((double)f * this.field_70255_ao), (double)0.0, (double)2.147483647E9));
        if (this.func_213874_s() > 0) {
            if (this.field_213878_az == null) {
                this.field_213878_az = new IntOpenHashSet(5);
            }
            if (this.field_213875_aA == null) {
                this.field_213875_aA = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.field_213878_az.size() >= this.func_213874_s() + 1) {
                this.func_70106_y();
                return;
            }
            this.field_213878_az.add(entity.func_145782_y());
        }
        if (this.func_70241_g()) {
            long j = this.field_70146_Z.nextInt(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if ((entity1 = this.func_234616_v_()) == null) {
            damagesource = DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)((Object)this));
        } else {
            damagesource = DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).func_130011_c(entity);
            }
        }
        boolean flag = entity.func_200600_R() == EntityType.field_200803_q;
        int k = entity.func_223314_ad();
        if (this.func_70027_ad() && !flag) {
            entity.func_70015_d(5);
        }
        if (entity.func_70097_a(damagesource, i)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Vector3d vector3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.field_70170_p.field_72995_K && this.func_213874_s() <= 0) {
                    livingentity.func_85034_r(livingentity.func_85035_bI() + 1);
                }
                if (this.field_70256_ap > 0 && (vector3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.field_70256_ap * 0.6)).func_189985_c() > 0.0) {
                    livingentity.func_70024_g(vector3d.field_72450_a, 0.1, vector3d.field_72449_c);
                }
                if (!this.field_70170_p.field_72995_K && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a(livingentity, entity1);
                    EnchantmentHelper.func_151385_b((LivingEntity)entity1, livingentity);
                }
                this.func_184548_a(livingentity);
                if (entity1 != null && livingentity != entity1 && livingentity instanceof PlayerEntity && entity1 instanceof ServerPlayerEntity && !this.func_174814_R()) {
                    ((ServerPlayerEntity)entity1).field_71135_a.func_147359_a((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241770_g_, 0.0f));
                }
                if (!entity.func_70089_S() && this.field_213875_aA != null) {
                    this.field_213875_aA.add(livingentity);
                }
                if (!this.field_70170_p.field_72995_K && entity1 instanceof ServerPlayerEntity) {
                    ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)entity1;
                    if (this.field_213875_aA != null && this.func_213873_r()) {
                        CriteriaTriggers.field_215100_G.func_234941_a_(serverplayerentity, this.field_213875_aA);
                    } else if (!entity.func_70089_S() && this.func_213873_r()) {
                        CriteriaTriggers.field_215100_G.func_234941_a_(serverplayerentity, Arrays.asList(entity));
                    }
                }
            }
            this.func_184185_a(this.field_213877_ay, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.func_213874_s() <= 0) {
                this.func_70106_y();
            }
        } else {
            entity.func_241209_g_(k);
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                if (this.field_70251_a == PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            }
        }
    }

    protected void func_230299_a_(BlockRayTraceResult p_230299_1_) {
        this.field_195056_av = this.field_70170_p.func_180495_p(p_230299_1_.func_216350_a());
        super.func_230299_a_(p_230299_1_);
        Vector3d vector3d = p_230299_1_.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213317_d(vector3d);
        Vector3d vector3d1 = vector3d.func_72432_b().func_186678_a(0.05f);
        this.func_226288_n_(this.func_226277_ct_() - vector3d1.field_72450_a, this.func_226278_cu_() - vector3d1.field_72448_b, this.func_226281_cx_() - vector3d1.field_72449_c);
        this.func_184185_a(this.func_203050_i(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        this.field_70254_i = true;
        this.field_70249_b = 7;
        this.func_70243_d(false);
        this.func_213872_b((byte)0);
        this.func_213869_a(SoundEvents.field_187731_t);
        this.func_213865_o(false);
        this.func_213870_w();
    }

    protected SoundEvent func_213867_k() {
        return SoundEvents.field_187731_t;
    }

    protected final SoundEvent func_203050_i() {
        return this.field_213877_ay;
    }

    protected void func_184548_a(LivingEntity p_184548_1_) {
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vector3d p_213866_1_, Vector3d p_213866_2_) {
        return ProjectileHelper.func_221269_a(this.field_70170_p, (Entity)((Object)this), p_213866_1_, p_213866_2_, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), this::func_230298_a_);
    }

    protected boolean func_230298_a_(Entity p_230298_1_) {
        return super.func_230298_a_(p_230298_1_) && (this.field_213878_az == null || !this.field_213878_az.contains(p_230298_1_.func_145782_y()));
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74777_a("life", (short)this.field_70252_j);
        if (this.field_195056_av != null) {
            p_213281_1_.func_218657_a("inBlockState", NBTUtil.func_190009_a((BlockState)this.field_195056_av));
        }
        p_213281_1_.func_74774_a("shake", (byte)this.field_70249_b);
        p_213281_1_.func_74757_a("inGround", this.field_70254_i);
        p_213281_1_.func_74774_a("pickup", (byte)this.field_70251_a.ordinal());
        p_213281_1_.func_74780_a("damage", this.field_70255_ao);
        p_213281_1_.func_74757_a("crit", this.func_70241_g());
        p_213281_1_.func_74774_a("PierceLevel", this.func_213874_s());
        p_213281_1_.func_74778_a("SoundEvent", Registry.field_212633_v.func_177774_c(this.field_213877_ay).toString());
        p_213281_1_.func_74757_a("ShotFromCrossbow", this.func_213873_r());
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.field_70252_j = p_70037_1_.func_74765_d("life");
        if (p_70037_1_.func_150297_b("inBlockState", 10)) {
            this.field_195056_av = NBTUtil.func_190008_d((CompoundNBT)p_70037_1_.func_74775_l("inBlockState"));
        }
        this.field_70249_b = p_70037_1_.func_74771_c("shake") & 0xFF;
        this.field_70254_i = p_70037_1_.func_74767_n("inGround");
        if (p_70037_1_.func_150297_b("damage", 99)) {
            this.field_70255_ao = p_70037_1_.func_74769_h("damage");
        }
        if (p_70037_1_.func_150297_b("pickup", 99)) {
            this.field_70251_a = PickupStatus.func_188795_a(p_70037_1_.func_74771_c("pickup"));
        } else if (p_70037_1_.func_150297_b("player", 99)) {
            this.field_70251_a = p_70037_1_.func_74767_n("player") ? PickupStatus.ALLOWED : PickupStatus.DISALLOWED;
        }
        this.func_70243_d(p_70037_1_.func_74767_n("crit"));
        this.func_213872_b(p_70037_1_.func_74771_c("PierceLevel"));
        if (p_70037_1_.func_150297_b("SoundEvent", 8)) {
            this.field_213877_ay = Registry.field_212633_v.func_241873_b(new ResourceLocation(p_70037_1_.func_74779_i("SoundEvent"))).orElse(this.func_213867_k());
        }
        this.func_213865_o(p_70037_1_.func_74767_n("ShotFromCrossbow"));
    }

    public void func_212361_a(@Nullable Entity p_212361_1_) {
        super.func_212361_a(p_212361_1_);
        if (p_212361_1_ instanceof PlayerEntity) {
            this.field_70251_a = ((PlayerEntity)p_212361_1_).field_71075_bZ.field_75098_d ? PickupStatus.CREATIVE_ONLY : PickupStatus.ALLOWED;
        }
    }

    public void func_70100_b_(PlayerEntity p_70100_1_) {
        if (!this.field_70170_p.field_72995_K && (this.field_70254_i || this.func_203047_q()) && this.field_70249_b <= 0) {
            boolean flag;
            boolean bl = flag = this.field_70251_a == PickupStatus.ALLOWED || this.field_70251_a == PickupStatus.CREATIVE_ONLY && p_70100_1_.field_71075_bZ.field_75098_d || this.func_203047_q() && this.func_234616_v_().func_110124_au() == p_70100_1_.func_110124_au();
            if (this.field_70251_a == PickupStatus.ALLOWED && !p_70100_1_.field_71071_by.func_70441_a(this.func_184550_j())) {
                flag = false;
            }
            if (flag) {
                p_70100_1_.func_71001_a((Entity)((Object)this), 1);
                this.func_70106_y();
            }
        }
    }

    protected abstract ItemStack func_184550_j();

    protected boolean func_225502_at_() {
        return false;
    }

    public void func_70239_b(double p_70239_1_) {
        this.field_70255_ao = p_70239_1_;
    }

    public double func_70242_d() {
        return this.field_70255_ao;
    }

    public void func_70240_a(int p_70240_1_) {
        this.field_70256_ap = p_70240_1_;
    }

    public boolean func_70075_an() {
        return false;
    }

    protected float func_213316_a(Pose p_213316_1_, EntitySize p_213316_2_) {
        return 0.13f;
    }

    public void func_70243_d(boolean p_70243_1_) {
        this.func_203049_a(1, p_70243_1_);
    }

    public void func_213872_b(byte p_213872_1_) {
        this.field_70180_af.func_187227_b(field_213876_as, p_213872_1_);
    }

    private void func_203049_a(int p_203049_1_, boolean p_203049_2_) {
        byte b0 = this.field_70180_af.func_187225_a(field_184554_g);
        if (p_203049_2_) {
            this.field_70180_af.func_187227_b(field_184554_g, (byte)(b0 | p_203049_1_));
        } else {
            this.field_70180_af.func_187227_b(field_184554_g, (byte)(b0 & ~p_203049_1_));
        }
    }

    public boolean func_70241_g() {
        byte b0 = this.field_70180_af.func_187225_a(field_184554_g);
        return (b0 & 1) != 0;
    }

    public boolean func_213873_r() {
        byte b0 = this.field_70180_af.func_187225_a(field_184554_g);
        return (b0 & 4) != 0;
    }

    public byte func_213874_s() {
        return this.field_70180_af.func_187225_a(field_213876_as);
    }

    public void func_190547_a(LivingEntity p_190547_1_, float p_190547_2_) {
        int i = EnchantmentHelper.func_185284_a(Enchantments.field_185309_u, p_190547_1_);
        int j = EnchantmentHelper.func_185284_a(Enchantments.field_185310_v, p_190547_1_);
        this.func_70239_b((double)(p_190547_2_ * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            this.func_70239_b(this.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            this.func_70240_a(j);
        }
        if (EnchantmentHelper.func_185284_a(Enchantments.field_185311_w, p_190547_1_) > 0) {
            this.func_70015_d(100);
        }
    }

    protected float func_203044_p() {
        return 0.6f;
    }

    public void func_203045_n(boolean p_203045_1_) {
        this.field_70145_X = p_203045_1_;
        this.func_203049_a(2, p_203045_1_);
    }

    public boolean func_203047_q() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70145_X;
        }
        return (this.field_70180_af.func_187225_a(field_184554_g) & 2) != 0;
    }

    public void func_213865_o(boolean p_213865_1_) {
        this.func_203049_a(4, p_213865_1_);
    }

    public IPacket<?> func_213297_N() {
        Entity entity = this.func_234616_v_();
        return new SSpawnObjectPacket((Entity)((Object)this), entity == null ? 0 : entity.func_145782_y());
    }

    public static enum PickupStatus {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY;


        public static PickupStatus func_188795_a(int p_188795_0_) {
            if (p_188795_0_ < 0 || p_188795_0_ > PickupStatus.values().length) {
                p_188795_0_ = 0;
            }
            return PickupStatus.values()[p_188795_0_];
        }
    }
}

