/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.apache.commons.lang3.tuple.Pair;

public class MultipartModelData
implements IModelData {
    public static final ModelProperty<MultipartModelData> MULTIPART_DATA = new ModelProperty();
    private final IModelData tileData;
    private final Map<IBakedModel, IModelData> partData = new HashMap<IBakedModel, IModelData>();

    public static IModelData create(List<Pair<Predicate<BlockState>, IBakedModel>> selectors, IBlockDisplayReader world, BlockPos pos, BlockState state, IModelData tileData) {
        MultipartModelData multipartData = new MultipartModelData(tileData);
        for (Pair<Predicate<BlockState>, IBakedModel> selector : selectors) {
            if (!((Predicate)selector.getLeft()).test(state)) continue;
            IBakedModel part = (IBakedModel)selector.getRight();
            IModelData partData = part.getModelData(world, pos, state, tileData);
            multipartData.setPartData(part, partData);
        }
        return multipartData;
    }

    public static IModelData resolve(IBakedModel part, IModelData modelData) {
        MultipartModelData multipartData = modelData.getData(MULTIPART_DATA);
        if (multipartData != null) {
            return multipartData.getPartData(part, modelData);
        }
        return modelData;
    }

    public MultipartModelData(IModelData tileData) {
        this.tileData = tileData;
    }

    public void setPartData(IBakedModel part, IModelData data) {
        this.partData.put(part, data);
    }

    @Nullable
    public IModelData getPartData(IBakedModel part, IModelData defaultData) {
        return this.partData.getOrDefault(part, defaultData);
    }

    @Override
    public boolean hasProperty(ModelProperty<?> prop) {
        return prop == MULTIPART_DATA || this.tileData.hasProperty(prop);
    }

    @Override
    @Nullable
    public <T> T getData(ModelProperty<T> prop) {
        if (prop == MULTIPART_DATA) {
            return (T)this;
        }
        return this.tileData.getData(prop);
    }

    @Override
    @Nullable
    public <T> T setData(ModelProperty<T> prop, T data) {
        if (prop == MULTIPART_DATA) {
            return (T)this;
        }
        return this.tileData.setData(prop, data);
    }
}

