/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IForgeEffectInstance {
    default public EffectInstance getEffectInstance() {
        return (EffectInstance)this;
    }

    default public boolean shouldRender() {
        return this.getEffectInstance().func_188419_a().shouldRender(this.getEffectInstance());
    }

    default public boolean shouldRenderInvText() {
        return this.getEffectInstance().func_188419_a().shouldRenderInvText(this.getEffectInstance());
    }

    default public boolean shouldRenderHUD() {
        return this.getEffectInstance().func_188419_a().shouldRenderHUD(this.getEffectInstance());
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderInventoryEffect(DisplayEffectsScreen<?> gui, MatrixStack mStack, int x, int y, float z) {
        this.getEffectInstance().func_188419_a().renderInventoryEffect(this.getEffectInstance(), gui, mStack, x, y, z);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderHUDEffect(AbstractGui gui, MatrixStack mStack, int x, int y, float z, float alpha) {
        this.getEffectInstance().func_188419_a().renderHUDEffect(this.getEffectInstance(), gui, mStack, x, y, z, alpha);
    }

    public List<ItemStack> getCurativeItems();

    default public boolean isCurativeItem(ItemStack stack) {
        return this.getCurativeItems().stream().anyMatch(e -> e.func_77969_a(stack));
    }

    public void setCurativeItems(List<ItemStack> var1);

    default public void addCurativeItem(ItemStack stack) {
        if (!this.isCurativeItem(stack)) {
            this.getCurativeItems().add(stack);
        }
    }

    default public void writeCurativeItems(CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        this.getCurativeItems().forEach(s -> list.add((Object)s.func_77955_b(new CompoundNBT())));
        nbt.func_218657_a("CurativeItems", (INBT)list);
    }
}

