/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.HopperBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.HopperContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.VanillaHopperItemHandler;
import net.minecraftforge.items.VanillaInventoryCodeHooks;

public class HopperTileEntity
extends LockableLootTileEntity
implements IHopper,
ITickableTileEntity {
    private NonNullList<ItemStack> field_145900_a = NonNullList.func_191197_a((int)5, (Object)((Object)ItemStack.field_190927_a));
    private int field_145901_j = -1;
    private long field_190578_g;

    public HopperTileEntity() {
        super(TileEntityType.field_200987_r);
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        this.field_145900_a = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)((Object)ItemStack.field_190927_a));
        if (!this.func_184283_b(p_230337_2_)) {
            ItemStackHelper.func_191283_b((CompoundNBT)p_230337_2_, this.field_145900_a);
        }
        this.field_145901_j = p_230337_2_.func_74762_e("TransferCooldown");
    }

    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        if (!this.func_184282_c(p_189515_1_)) {
            ItemStackHelper.func_191282_a((CompoundNBT)p_189515_1_, this.field_145900_a);
        }
        p_189515_1_.func_74768_a("TransferCooldown", this.field_145901_j);
        return p_189515_1_;
    }

    public int func_70302_i_() {
        return this.field_145900_a.size();
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        this.func_184281_d(null);
        return ItemStackHelper.func_188382_a(this.func_190576_q(), (int)p_70298_1_, (int)p_70298_2_);
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.func_184281_d(null);
        this.func_190576_q().set(p_70299_1_, (Object)p_70299_2_);
        if (p_70299_2_.func_190916_E() > this.func_70297_j_()) {
            p_70299_2_.func_190920_e(this.func_70297_j_());
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.hopper");
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.field_145901_j;
            this.field_190578_g = this.field_145850_b.func_82737_E();
            if (!this.func_145888_j()) {
                this.func_145896_c(0);
                this.func_200109_a(() -> HopperTileEntity.func_145891_a(this));
            }
        }
    }

    private boolean func_200109_a(Supplier<Boolean> p_200109_1_) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.func_145888_j() && ((Boolean)this.func_195044_w().func_177229_b((Property)HopperBlock.field_176429_b)).booleanValue()) {
                boolean flag = false;
                if (!this.func_191420_l()) {
                    flag = this.func_145883_k();
                }
                if (!this.func_152105_l()) {
                    flag |= p_200109_1_.get().booleanValue();
                }
                if (flag) {
                    this.func_145896_c(8);
                    this.func_70296_d();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean func_152105_l() {
        for (ItemStack itemstack : this.field_145900_a) {
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private boolean func_145883_k() {
        if (VanillaInventoryCodeHooks.insertHook((HopperTileEntity)this)) {
            return true;
        }
        IInventory iinventory = this.func_145895_l();
        if (iinventory == null) {
            return false;
        }
        Direction direction = ((Direction)((Object)this.func_195044_w().func_177229_b((Property)HopperBlock.field_176430_a))).func_176734_d();
        if (this.func_174919_a(iinventory, direction)) {
            return false;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            ItemStack itemstack = this.func_70301_a(i).func_77946_l();
            ItemStack itemstack1 = HopperTileEntity.func_174918_a((IInventory)this, iinventory, this.func_70298_a(i, 1), direction);
            if (itemstack1.func_190926_b()) {
                iinventory.func_70296_d();
                return true;
            }
            this.func_70299_a(i, itemstack);
        }
        return false;
    }

    private static IntStream func_213972_a(IInventory p_213972_0_, Direction p_213972_1_) {
        return p_213972_0_ instanceof ISidedInventory ? IntStream.of(((ISidedInventory)p_213972_0_).func_180463_a(p_213972_1_)) : IntStream.range(0, p_213972_0_.func_70302_i_());
    }

    private boolean func_174919_a(IInventory p_174919_1_, Direction p_174919_2_) {
        return HopperTileEntity.func_213972_a(p_174919_1_, p_174919_2_).allMatch(p_213970_1_ -> {
            ItemStack itemstack = p_174919_1_.func_70301_a(p_213970_1_);
            return itemstack.func_190916_E() >= itemstack.func_77976_d();
        });
    }

    private static boolean func_174917_b(IInventory p_174917_0_, Direction p_174917_1_) {
        return HopperTileEntity.func_213972_a(p_174917_0_, p_174917_1_).allMatch(p_213973_1_ -> p_174917_0_.func_70301_a(p_213973_1_).func_190926_b());
    }

    public static boolean func_145891_a(IHopper p_145891_0_) {
        Boolean ret = VanillaInventoryCodeHooks.extractHook((IHopper)p_145891_0_);
        if (ret != null) {
            return ret;
        }
        IInventory iinventory = HopperTileEntity.func_145884_b(p_145891_0_);
        if (iinventory != null) {
            Direction direction = Direction.DOWN;
            return HopperTileEntity.func_174917_b(iinventory, direction) ? false : HopperTileEntity.func_213972_a(iinventory, direction).anyMatch(p_213971_3_ -> HopperTileEntity.func_174915_a(p_145891_0_, iinventory, p_213971_3_, direction));
        }
        for (ItemEntity itementity : HopperTileEntity.func_200115_c(p_145891_0_)) {
            if (!HopperTileEntity.func_200114_a((IInventory)p_145891_0_, itementity)) continue;
            return true;
        }
        return false;
    }

    private static boolean func_174915_a(IHopper p_174915_0_, IInventory p_174915_1_, int p_174915_2_, Direction p_174915_3_) {
        ItemStack itemstack = p_174915_1_.func_70301_a(p_174915_2_);
        if (!itemstack.func_190926_b() && HopperTileEntity.func_174921_b(p_174915_1_, itemstack, p_174915_2_, p_174915_3_)) {
            ItemStack itemstack1 = itemstack.func_77946_l();
            ItemStack itemstack2 = HopperTileEntity.func_174918_a(p_174915_1_, (IInventory)p_174915_0_, p_174915_1_.func_70298_a(p_174915_2_, 1), null);
            if (itemstack2.func_190926_b()) {
                p_174915_1_.func_70296_d();
                return true;
            }
            p_174915_1_.func_70299_a(p_174915_2_, itemstack1);
        }
        return false;
    }

    public static boolean func_200114_a(IInventory p_200114_0_, ItemEntity p_200114_1_) {
        boolean flag = false;
        ItemStack itemstack = p_200114_1_.func_92059_d().func_77946_l();
        ItemStack itemstack1 = HopperTileEntity.func_174918_a(null, p_200114_0_, itemstack, null);
        if (itemstack1.func_190926_b()) {
            flag = true;
            p_200114_1_.func_70106_y();
        } else {
            p_200114_1_.func_92058_a(itemstack1);
        }
        return flag;
    }

    public static ItemStack func_174918_a(@Nullable IInventory p_174918_0_, IInventory p_174918_1_, ItemStack p_174918_2_, @Nullable Direction p_174918_3_) {
        if (p_174918_1_ instanceof ISidedInventory && p_174918_3_ != null) {
            ISidedInventory isidedinventory = (ISidedInventory)p_174918_1_;
            int[] aint = isidedinventory.func_180463_a(p_174918_3_);
            for (int k = 0; k < aint.length && !p_174918_2_.func_190926_b(); ++k) {
                p_174918_2_ = HopperTileEntity.func_174916_c(p_174918_0_, p_174918_1_, p_174918_2_, aint[k], p_174918_3_);
            }
        } else {
            int i = p_174918_1_.func_70302_i_();
            for (int j = 0; j < i && !p_174918_2_.func_190926_b(); ++j) {
                p_174918_2_ = HopperTileEntity.func_174916_c(p_174918_0_, p_174918_1_, p_174918_2_, j, p_174918_3_);
            }
        }
        return p_174918_2_;
    }

    private static boolean func_174920_a(IInventory p_174920_0_, ItemStack p_174920_1_, int p_174920_2_, @Nullable Direction p_174920_3_) {
        if (!p_174920_0_.func_94041_b(p_174920_2_, p_174920_1_)) {
            return false;
        }
        return !(p_174920_0_ instanceof ISidedInventory) || ((ISidedInventory)p_174920_0_).func_180462_a(p_174920_2_, p_174920_1_, p_174920_3_);
    }

    private static boolean func_174921_b(IInventory p_174921_0_, ItemStack p_174921_1_, int p_174921_2_, Direction p_174921_3_) {
        return !(p_174921_0_ instanceof ISidedInventory) || ((ISidedInventory)p_174921_0_).func_180461_b(p_174921_2_, p_174921_1_, p_174921_3_);
    }

    private static ItemStack func_174916_c(@Nullable IInventory p_174916_0_, IInventory p_174916_1_, ItemStack p_174916_2_, int p_174916_3_, @Nullable Direction p_174916_4_) {
        ItemStack itemstack = p_174916_1_.func_70301_a(p_174916_3_);
        if (HopperTileEntity.func_174920_a(p_174916_1_, p_174916_2_, p_174916_3_, p_174916_4_)) {
            boolean flag = false;
            boolean flag1 = p_174916_1_.func_191420_l();
            if (itemstack.func_190926_b()) {
                p_174916_1_.func_70299_a(p_174916_3_, p_174916_2_);
                p_174916_2_ = ItemStack.field_190927_a;
                flag = true;
            } else if (HopperTileEntity.func_145894_a(itemstack, p_174916_2_)) {
                int i = p_174916_2_.func_77976_d() - itemstack.func_190916_E();
                int j = Math.min(p_174916_2_.func_190916_E(), i);
                p_174916_2_.func_190918_g(j);
                itemstack.func_190917_f(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                HopperTileEntity hoppertileentity1;
                if (flag1 && p_174916_1_ instanceof HopperTileEntity && !(hoppertileentity1 = (HopperTileEntity)p_174916_1_).func_174914_o()) {
                    int k = 0;
                    if (p_174916_0_ instanceof HopperTileEntity) {
                        HopperTileEntity hoppertileentity = (HopperTileEntity)p_174916_0_;
                        if (hoppertileentity1.field_190578_g >= hoppertileentity.field_190578_g) {
                            k = 1;
                        }
                    }
                    hoppertileentity1.func_145896_c(8 - k);
                }
                p_174916_1_.func_70296_d();
            }
        }
        return p_174916_2_;
    }

    @Nullable
    private IInventory func_145895_l() {
        Direction direction = (Direction)((Object)this.func_195044_w().func_177229_b((Property)HopperBlock.field_176430_a));
        return HopperTileEntity.func_195484_a(this.func_145831_w(), this.field_174879_c.func_177972_a(direction));
    }

    @Nullable
    public static IInventory func_145884_b(IHopper p_145884_0_) {
        return HopperTileEntity.func_145893_b(p_145884_0_.func_145831_w(), p_145884_0_.func_96107_aA(), p_145884_0_.func_96109_aB() + 1.0, p_145884_0_.func_96108_aC());
    }

    public static List<ItemEntity> func_200115_c(IHopper p_200115_0_) {
        return p_200115_0_.func_200100_i().func_197756_d().stream().flatMap(p_200110_1_ -> p_200115_0_.func_145831_w().func_175647_a(ItemEntity.class, p_200110_1_.func_72317_d(p_200115_0_.func_96107_aA() - 0.5, p_200115_0_.func_96109_aB() - 0.5, p_200115_0_.func_96108_aC() - 0.5), EntityPredicates.field_94557_a).stream()).collect(Collectors.toList());
    }

    @Nullable
    public static IInventory func_195484_a(World p_195484_0_, BlockPos p_195484_1_) {
        return HopperTileEntity.func_145893_b(p_195484_0_, (double)p_195484_1_.func_177958_n() + 0.5, (double)p_195484_1_.func_177956_o() + 0.5, (double)p_195484_1_.func_177952_p() + 0.5);
    }

    @Nullable
    public static IInventory func_145893_b(World p_145893_0_, double p_145893_1_, double p_145893_3_, double p_145893_5_) {
        List<Entity> list;
        TileEntity tileentity;
        ISidedInventory iinventory = null;
        BlockPos blockpos = new BlockPos(p_145893_1_, p_145893_3_, p_145893_5_);
        BlockState blockstate = p_145893_0_.func_180495_p(blockpos);
        Block block = blockstate.func_177230_c();
        if (block instanceof ISidedInventoryProvider) {
            iinventory = ((ISidedInventoryProvider)block).func_219966_a(blockstate, (IWorld)p_145893_0_, blockpos);
        } else if (blockstate.hasTileEntity() && (tileentity = p_145893_0_.func_175625_s(blockpos)) instanceof IInventory && (iinventory = (IInventory)tileentity) instanceof ChestTileEntity && block instanceof ChestBlock) {
            iinventory = ChestBlock.func_226916_a_((ChestBlock)((ChestBlock)block), (BlockState)blockstate, (World)p_145893_0_, (BlockPos)blockpos, (boolean)true);
        }
        if (iinventory == null && !(list = p_145893_0_.func_175674_a(null, new AxisAlignedBB(p_145893_1_ - 0.5, p_145893_3_ - 0.5, p_145893_5_ - 0.5, p_145893_1_ + 0.5, p_145893_3_ + 0.5, p_145893_5_ + 0.5), EntityPredicates.field_96566_b)).isEmpty()) {
            iinventory = (IInventory)list.get(p_145893_0_.field_73012_v.nextInt(list.size()));
        }
        return iinventory;
    }

    private static boolean func_145894_a(ItemStack p_145894_0_, ItemStack p_145894_1_) {
        if (p_145894_0_.func_77973_b() != p_145894_1_.func_77973_b()) {
            return false;
        }
        if (p_145894_0_.func_77952_i() != p_145894_1_.func_77952_i()) {
            return false;
        }
        if (p_145894_0_.func_190916_E() > p_145894_0_.func_77976_d()) {
            return false;
        }
        return ItemStack.func_77970_a(p_145894_0_, p_145894_1_);
    }

    public double func_96107_aA() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    public double func_96109_aB() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    public double func_96108_aC() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    public void func_145896_c(int p_145896_1_) {
        this.field_145901_j = p_145896_1_;
    }

    private boolean func_145888_j() {
        return this.field_145901_j > 0;
    }

    public boolean func_174914_o() {
        return this.field_145901_j > 8;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.field_145900_a;
    }

    protected void func_199721_a(NonNullList<ItemStack> p_199721_1_) {
        this.field_145900_a = p_199721_1_;
    }

    public void func_200113_a(Entity p_200113_1_) {
        if (p_200113_1_ instanceof ItemEntity) {
            BlockPos blockpos = this.func_174877_v();
            if (VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)p_200113_1_.func_174813_aQ().func_72317_d((double)(-blockpos.func_177958_n()), (double)(-blockpos.func_177956_o()), (double)(-blockpos.func_177952_p()))), (VoxelShape)this.func_200100_i(), (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
                this.func_200109_a(() -> HopperTileEntity.func_200114_a((IInventory)this, (ItemEntity)p_200113_1_));
            }
        }
    }

    protected Container func_213906_a(int p_213906_1_, PlayerInventory p_213906_2_) {
        return new HopperContainer(p_213906_1_, p_213906_2_, (IInventory)this);
    }

    protected IItemHandler createUnSidedHandler() {
        return new VanillaHopperItemHandler(this);
    }

    public long getLastUpdateTime() {
        return this.field_190578_g;
    }
}

