/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RespawnAnchorBlock;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerAbilities;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.state.Property;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.CommandBlockLogic;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.JigsawTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.FoodStats;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Unit;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;

public abstract class PlayerEntity
extends LivingEntity {
    public static final String PERSISTED_NBT_TAG = "PlayerPersisted";
    public static final EntitySize field_213835_bs = EntitySize.func_220314_b((float)0.6f, (float)1.8f);
    private static final Map<Pose, EntitySize> field_213836_b = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)field_213835_bs).put((Object)Pose.SLEEPING, (Object)field_213377_as).put((Object)Pose.FALL_FLYING, (Object)EntitySize.func_220314_b((float)0.6f, (float)0.6f)).put((Object)Pose.SWIMMING, (Object)EntitySize.func_220314_b((float)0.6f, (float)0.6f)).put((Object)Pose.SPIN_ATTACK, (Object)EntitySize.func_220314_b((float)0.6f, (float)0.6f)).put((Object)Pose.CROUCHING, (Object)EntitySize.func_220314_b((float)0.6f, (float)1.5f)).put((Object)Pose.DYING, (Object)EntitySize.func_220311_c((float)0.2f, (float)0.2f)).build();
    private static final DataParameter<Float> field_184829_a = EntityDataManager.func_187226_a(PlayerEntity.class, DataSerializers.field_187193_c);
    private static final DataParameter<Integer> field_184830_b = EntityDataManager.func_187226_a(PlayerEntity.class, DataSerializers.field_187192_b);
    protected static final DataParameter<Byte> field_184827_bp = EntityDataManager.func_187226_a(PlayerEntity.class, DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> field_184828_bq = EntityDataManager.func_187226_a(PlayerEntity.class, DataSerializers.field_187191_a);
    protected static final DataParameter<CompoundNBT> field_192032_bt = EntityDataManager.func_187226_a(PlayerEntity.class, DataSerializers.field_192734_n);
    protected static final DataParameter<CompoundNBT> field_192033_bu = EntityDataManager.func_187226_a(PlayerEntity.class, DataSerializers.field_192734_n);
    private long field_223730_e;
    public final PlayerInventory field_71071_by = new PlayerInventory(this);
    protected EnderChestInventory field_71078_a = new EnderChestInventory();
    public final PlayerContainer field_71069_bz;
    public Container field_71070_bA;
    protected FoodStats field_71100_bB = new FoodStats();
    protected int field_71101_bC;
    public float field_71107_bF;
    public float field_71109_bG;
    public int field_71090_bL;
    public double field_71091_bM;
    public double field_71096_bN;
    public double field_71097_bO;
    public double field_71094_bP;
    public double field_71095_bQ;
    public double field_71085_bR;
    private int field_71076_b;
    protected boolean field_204230_bP;
    public final PlayerAbilities field_71075_bZ = new PlayerAbilities();
    public int field_71068_ca;
    public int field_71067_cb;
    public float field_71106_cc;
    protected int field_175152_f;
    protected final float field_71102_ce = 0.02f;
    private int field_82249_h;
    private final GameProfile field_146106_i;
    @OnlyIn(value=Dist.CLIENT)
    private boolean field_175153_bG;
    private ItemStack field_184831_bT = ItemStack.field_190927_a;
    private final CooldownTracker field_184832_bU = this.func_184815_l();
    @Nullable
    public FishingBobberEntity field_71104_cf;
    private final Collection<IFormattableTextComponent> prefixes = new LinkedList<IFormattableTextComponent>();
    private final Collection<IFormattableTextComponent> suffixes = new LinkedList<IFormattableTextComponent>();
    @Nullable
    private Pose forcedPose;
    private ITextComponent displayname = null;
    private final LazyOptional<IItemHandler> playerMainHandler = LazyOptional.of(() -> new PlayerMainInvWrapper(this.field_71071_by));
    private final LazyOptional<IItemHandler> playerEquipmentHandler = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{new PlayerArmorInvWrapper(this.field_71071_by), new PlayerOffhandInvWrapper(this.field_71071_by)}));
    private final LazyOptional<IItemHandler> playerJoinedHandler = LazyOptional.of(() -> new PlayerInvWrapper(this.field_71071_by));

    public PlayerEntity(World p_i241920_1_, BlockPos p_i241920_2_, float p_i241920_3_, GameProfile p_i241920_4_) {
        super((EntityType<? extends LivingEntity>)EntityType.field_200729_aH, p_i241920_1_);
        this.func_184221_a(PlayerEntity.func_146094_a(p_i241920_4_));
        this.field_146106_i = p_i241920_4_;
        this.field_71069_bz = new PlayerContainer(this.field_71071_by, !p_i241920_1_.field_72995_K, this);
        this.field_71070_bA = this.field_71069_bz;
        this.func_70012_b((double)p_i241920_2_.func_177958_n() + 0.5, p_i241920_2_.func_177956_o() + 1, (double)p_i241920_2_.func_177952_p() + 0.5, p_i241920_3_, 0.0f);
        this.field_70741_aB = 180.0f;
    }

    public boolean func_223729_a(World p_223729_1_, BlockPos p_223729_2_, GameType p_223729_3_) {
        if (!p_223729_3_.func_82752_c()) {
            return false;
        }
        if (p_223729_3_ == GameType.SPECTATOR) {
            return true;
        }
        if (this.func_175142_cm()) {
            return false;
        }
        ItemStack itemstack = this.func_184614_ca();
        return itemstack.func_190926_b() || !itemstack.func_206848_a(p_223729_1_.func_205772_D(), new CachedBlockInfo((IWorldReader)((Object)p_223729_1_), p_223729_2_, false));
    }

    public static AttributeModifierMap.MutableAttribute func_234570_el_() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233821_d_, 0.1f).func_233814_a_(Attributes.field_233825_h_).func_233814_a_(Attributes.field_233828_k_).func_233814_a_((Attribute)ForgeMod.REACH_DISTANCE.get());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184829_a, Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(field_184830_b, 0);
        this.field_70180_af.func_187214_a(field_184827_bp, (byte)0);
        this.field_70180_af.func_187214_a(field_184828_bq, (byte)1);
        this.field_70180_af.func_187214_a(field_192032_bt, new CompoundNBT());
        this.field_70180_af.func_187214_a(field_192033_bu, new CompoundNBT());
    }

    @Override
    public void func_70071_h_() {
        BasicEventHooks.onPlayerPreTick((PlayerEntity)this);
        this.field_70145_X = this.func_175149_v();
        if (this.func_175149_v()) {
            this.field_70122_E = false;
        }
        if (this.field_71090_bL > 0) {
            --this.field_71090_bL;
        }
        if (this.func_70608_bn()) {
            ++this.field_71076_b;
            if (this.field_71076_b > 100) {
                this.field_71076_b = 100;
            }
            if (!this.field_70170_p.field_72995_K && !ForgeEventFactory.fireSleepingTimeCheck((PlayerEntity)this, this.func_213374_dv())) {
                this.func_225652_a_(false, true);
            }
        } else if (this.field_71076_b > 0) {
            ++this.field_71076_b;
            if (this.field_71076_b >= 110) {
                this.field_71076_b = 0;
            }
        }
        this.func_204229_de();
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_71070_bA != null && !this.field_71070_bA.func_75145_c(this)) {
            this.func_71053_j();
            this.field_71070_bA = this.field_71069_bz;
        }
        this.func_184820_o();
        if (!this.field_70170_p.field_72995_K) {
            this.field_71100_bB.func_75118_a(this);
            this.func_195066_a(Stats.field_188097_g);
            if (this.func_70089_S()) {
                this.func_195066_a(Stats.field_188098_h);
            }
            if (this.func_226273_bm_()) {
                this.func_195066_a(Stats.field_226147_n_);
            }
            if (!this.func_70608_bn()) {
                this.func_195066_a(Stats.field_203284_n);
            }
        }
        int i = 29999999;
        double d0 = MathHelper.func_151237_a((double)this.func_226277_ct_(), (double)-2.9999999E7, (double)2.9999999E7);
        double d1 = MathHelper.func_151237_a((double)this.func_226281_cx_(), (double)-2.9999999E7, (double)2.9999999E7);
        if (d0 != this.func_226277_ct_() || d1 != this.func_226281_cx_()) {
            this.func_70107_b(d0, this.func_226278_cu_(), d1);
        }
        ++this.field_184617_aD;
        ItemStack itemstack = this.func_184614_ca();
        if (!ItemStack.func_77989_b(this.field_184831_bT, itemstack)) {
            if (!ItemStack.func_185132_d(this.field_184831_bT, itemstack)) {
                this.func_184821_cY();
            }
            this.field_184831_bT = itemstack.func_77946_l();
        }
        this.func_203041_m();
        this.field_184832_bU.func_185144_a();
        this.func_213832_dB();
        BasicEventHooks.onPlayerPostTick((PlayerEntity)this);
    }

    public boolean func_226563_dT_() {
        return this.func_225608_bj_();
    }

    protected boolean func_226564_dU_() {
        return this.func_225608_bj_();
    }

    protected boolean func_226565_dV_() {
        return this.func_225608_bj_();
    }

    protected boolean func_204229_de() {
        this.field_204230_bP = this.func_208600_a(FluidTags.field_206959_a);
        return this.field_204230_bP;
    }

    private void func_203041_m() {
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.HEAD);
        if (itemstack.func_77973_b() == Items.field_203179_ao && !this.func_208600_a(FluidTags.field_206959_a)) {
            this.func_195064_c(new EffectInstance(Effects.field_76427_o, 200, 0, false, false, true));
        }
    }

    protected CooldownTracker func_184815_l() {
        return new CooldownTracker();
    }

    private void func_184820_o() {
        this.field_71091_bM = this.field_71094_bP;
        this.field_71096_bN = this.field_71095_bQ;
        this.field_71097_bO = this.field_71085_bR;
        double d0 = this.func_226277_ct_() - this.field_71094_bP;
        double d1 = this.func_226278_cu_() - this.field_71095_bQ;
        double d2 = this.func_226281_cx_() - this.field_71085_bR;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.field_71091_bM = this.field_71094_bP = this.func_226277_ct_();
        }
        if (d2 > 10.0) {
            this.field_71097_bO = this.field_71085_bR = this.func_226281_cx_();
        }
        if (d1 > 10.0) {
            this.field_71096_bN = this.field_71095_bQ = this.func_226278_cu_();
        }
        if (d0 < -10.0) {
            this.field_71091_bM = this.field_71094_bP = this.func_226277_ct_();
        }
        if (d2 < -10.0) {
            this.field_71097_bO = this.field_71085_bR = this.func_226281_cx_();
        }
        if (d1 < -10.0) {
            this.field_71096_bN = this.field_71095_bQ = this.func_226278_cu_();
        }
        this.field_71094_bP += d0 * 0.25;
        this.field_71085_bR += d2 * 0.25;
        this.field_71095_bQ += d1 * 0.25;
    }

    protected void func_213832_dB() {
        if (this.forcedPose != null) {
            this.func_213301_b(this.forcedPose);
            return;
        }
        if (this.func_213298_c(Pose.SWIMMING)) {
            Pose pose = this.func_184613_cA() ? Pose.FALL_FLYING : (this.func_70608_bn() ? Pose.SLEEPING : (this.func_203007_ba() ? Pose.SWIMMING : (this.func_204805_cN() ? Pose.SPIN_ATTACK : (this.func_225608_bj_() && !this.field_71075_bZ.field_75100_b ? Pose.CROUCHING : Pose.STANDING))));
            Pose pose1 = !(this.func_175149_v() || this.func_184218_aH() || this.func_213298_c(pose)) ? (this.func_213298_c(Pose.CROUCHING) ? Pose.CROUCHING : Pose.SWIMMING) : pose;
            this.func_213301_b(pose1);
        }
    }

    @Override
    public int func_82145_z() {
        return this.field_71075_bZ.field_75102_a ? 1 : 80;
    }

    @Override
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187808_ef;
    }

    @Override
    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187806_ee;
    }

    @Override
    protected SoundEvent func_204208_ah() {
        return SoundEvents.field_204328_gh;
    }

    @Override
    public int func_82147_ab() {
        return 10;
    }

    @Override
    public void func_184185_a(SoundEvent p_184185_1_, float p_184185_2_, float p_184185_3_) {
        this.field_70170_p.func_184148_a(this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), p_184185_1_, this.func_184176_by(), p_184185_2_, p_184185_3_);
    }

    public void func_213823_a(SoundEvent p_213823_1_, SoundCategory p_213823_2_, float p_213823_3_, float p_213823_4_) {
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.PLAYERS;
    }

    @Override
    protected int func_190531_bD() {
        return 20;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 9) {
            this.func_71036_o();
        } else if (p_70103_1_ == 23) {
            this.field_175153_bG = false;
        } else if (p_70103_1_ == 22) {
            this.field_175153_bG = true;
        } else if (p_70103_1_ == 43) {
            this.func_213824_a((IParticleData)ParticleTypes.field_197613_f);
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void func_213824_a(IParticleData p_213824_1_) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a(p_213824_1_, this.func_226282_d_(1.0), this.func_226279_cv_() + 1.0, this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    public void func_71053_j() {
        this.field_71070_bA = this.field_71069_bz;
    }

    @Override
    public void func_70098_U() {
        if (this.func_226564_dU_() && this.func_184218_aH()) {
            this.func_184210_p();
            this.func_226284_e_(false);
        } else {
            double d0 = this.func_226277_ct_();
            double d1 = this.func_226278_cu_();
            double d2 = this.func_226281_cx_();
            super.func_70098_U();
            this.field_71107_bF = this.field_71109_bG;
            this.field_71109_bG = 0.0f;
            this.func_71015_k(this.func_226277_ct_() - d0, this.func_226278_cu_() - d1, this.func_226281_cx_() - d2);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70065_x() {
        this.func_213301_b(Pose.STANDING);
        super.func_70065_x();
        this.func_70606_j(this.func_110138_aP());
        this.field_70725_aQ = 0;
    }

    @Override
    protected void func_70626_be() {
        super.func_70626_be();
        this.func_82168_bl();
        this.field_70759_as = this.field_70177_z;
    }

    @Override
    public void func_70636_d() {
        if (this.field_71101_bC > 0) {
            --this.field_71101_bC;
        }
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223606_i)) {
            if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 20 == 0) {
                this.func_70691_i(1.0f);
            }
            if (this.field_71100_bB.func_75121_c() && this.field_70173_aa % 10 == 0) {
                this.field_71100_bB.func_75114_a(this.field_71100_bB.func_75116_a() + 1);
            }
        }
        this.field_71071_by.func_70429_k();
        this.field_71107_bF = this.field_71109_bG;
        super.func_70636_d();
        this.field_70747_aH = 0.02f;
        if (this.func_70051_ag()) {
            this.field_70747_aH = (float)((double)this.field_70747_aH + 0.005999999865889549);
        }
        this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_));
        float f = this.field_70122_E && !this.func_233643_dh_() && !this.func_203007_ba() ? Math.min(0.1f, MathHelper.func_76133_a((double)PlayerEntity.func_213296_b(this.func_213322_ci()))) : 0.0f;
        this.field_71109_bG += (f - this.field_71109_bG) * 0.4f;
        if (this.func_110143_aJ() > 0.0f && !this.func_175149_v()) {
            AxisAlignedBB axisalignedbb = this.func_184218_aH() && !this.func_184187_bx().field_70128_L ? this.func_174813_aQ().func_111270_a(this.func_184187_bx().func_174813_aQ()).func_72314_b(1.0, 0.0, 1.0) : this.func_174813_aQ().func_72314_b(1.0, 0.5, 1.0);
            List list = this.field_70170_p.func_72839_b(this, axisalignedbb);
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)((Object)list.get(i));
                if (entity.field_70128_L) continue;
                this.func_71044_o(entity);
            }
        }
        this.func_192028_j(this.func_192023_dk());
        this.func_192028_j(this.func_192025_dl());
        if (!this.field_70170_p.field_72995_K && (this.field_70143_R > 0.5f || this.func_70090_H()) || this.field_71075_bZ.field_75100_b || this.func_70608_bn()) {
            this.func_192030_dh();
        }
    }

    private void func_192028_j(@Nullable CompoundNBT p_192028_1_) {
        if (!(p_192028_1_ == null || p_192028_1_.func_74764_b("Silent") && p_192028_1_.func_74767_n("Silent") || this.field_70170_p.field_73012_v.nextInt(200) != 0)) {
            String s = p_192028_1_.func_74779_i("id");
            EntityType.func_220327_a(s).filter(p_213830_0_ -> p_213830_0_ == EntityType.field_200783_W).ifPresent(p_213834_1_ -> {
                if (!ParrotEntity.func_192006_b(this.field_70170_p, this)) {
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ParrotEntity.func_234212_a_(this.field_70170_p, this.field_70170_p.field_73012_v), this.func_184176_by(), 1.0f, ParrotEntity.func_192000_b(this.field_70170_p.field_73012_v));
                }
            });
        }
    }

    private void func_71044_o(Entity p_71044_1_) {
        p_71044_1_.func_70100_b_(this);
    }

    public int func_71037_bA() {
        return this.field_70180_af.func_187225_a(field_184830_b);
    }

    public void func_85040_s(int p_85040_1_) {
        this.field_70180_af.func_187227_b(field_184830_b, p_85040_1_);
    }

    public void func_85039_t(int p_85039_1_) {
        int i = this.func_71037_bA();
        this.field_70180_af.func_187227_b(field_184830_b, i + p_85039_1_);
    }

    @Override
    public void func_70645_a(DamageSource p_70645_1_) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)p_70645_1_)) {
            return;
        }
        super.func_70645_a(p_70645_1_);
        this.func_226264_Z_();
        if (!this.func_175149_v()) {
            this.func_213345_d(p_70645_1_);
        }
        if (p_70645_1_ != null) {
            this.func_213293_j(-MathHelper.func_76134_b((float)((this.field_70739_aP + this.field_70177_z) * ((float)Math.PI / 180))) * 0.1f, 0.1f, -MathHelper.func_76126_a((float)((this.field_70739_aP + this.field_70177_z) * ((float)Math.PI / 180))) * 0.1f);
        } else {
            this.func_213293_j(0.0, 0.1, 0.0);
        }
        this.func_195066_a(Stats.field_188069_A);
        this.func_175145_a(Stats.field_199092_j.func_199076_b(Stats.field_188098_h));
        this.func_175145_a(Stats.field_199092_j.func_199076_b(Stats.field_203284_n));
        this.func_70066_B();
        this.func_70052_a(0, false);
    }

    @Override
    protected void func_213337_cE() {
        super.func_213337_cE();
        if (!this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
            this.func_190776_cN();
            this.field_71071_by.func_70436_m();
        }
    }

    protected void func_190776_cN() {
        for (int i = 0; i < this.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = this.field_71071_by.func_70301_a(i);
            if (itemstack.func_190926_b() || !EnchantmentHelper.func_190939_c(itemstack)) continue;
            this.field_71071_by.func_70304_b(i);
        }
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        if (p_184601_1_ == DamageSource.field_76370_b) {
            return SoundEvents.field_193806_fH;
        }
        if (p_184601_1_ == DamageSource.field_76369_e) {
            return SoundEvents.field_193805_fG;
        }
        return p_184601_1_ == DamageSource.field_220302_v ? SoundEvents.field_219671_iL : SoundEvents.field_187800_eb;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187798_ea;
    }

    public boolean func_225609_n_(boolean p_225609_1_) {
        ItemStack stack = this.field_71071_by.func_70448_g();
        if (stack.func_190926_b() || !stack.onDroppedByPlayer(this)) {
            return false;
        }
        return ForgeHooks.onPlayerTossEvent((PlayerEntity)this, (ItemStack)this.field_71071_by.func_70298_a(this.field_71071_by.field_70461_c, p_225609_1_ && !this.field_71071_by.func_70448_g().func_190926_b() ? this.field_71071_by.func_70448_g().func_190916_E() : 1), (boolean)true) != null;
    }

    @Nullable
    public ItemEntity func_71019_a(ItemStack p_71019_1_, boolean p_71019_2_) {
        return ForgeHooks.onPlayerTossEvent((PlayerEntity)this, (ItemStack)p_71019_1_, (boolean)false);
    }

    @Nullable
    public ItemEntity func_146097_a(ItemStack p_146097_1_, boolean p_146097_2_, boolean p_146097_3_) {
        if (p_146097_1_.func_190926_b()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_184609_a(Hand.MAIN_HAND);
        }
        double d0 = this.func_226280_cw_() - (double)0.3f;
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), d0, this.func_226281_cx_(), p_146097_1_);
        itementity.func_174867_a(40);
        if (p_146097_3_) {
            itementity.func_200216_c(this.func_110124_au());
        }
        if (p_146097_2_) {
            float f = this.field_70146_Z.nextFloat() * 0.5f;
            float f1 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
            itementity.func_213293_j(-MathHelper.func_76126_a((float)f1) * f, 0.2f, MathHelper.func_76134_b((float)f1) * f);
        } else {
            float f7 = 0.3f;
            float f8 = MathHelper.func_76126_a((float)(this.field_70125_A * ((float)Math.PI / 180)));
            float f2 = MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)));
            float f3 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
            float f4 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
            float f5 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
            float f6 = 0.02f * this.field_70146_Z.nextFloat();
            itementity.func_213293_j((double)(-f3 * f2 * 0.3f) + Math.cos(f5) * (double)f6, -f8 * 0.3f + 0.1f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f, (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        }
        return itementity;
    }

    @Deprecated
    public float func_184813_a(BlockState p_184813_1_) {
        return this.getDigSpeed(p_184813_1_, null);
    }

    public float getDigSpeed(BlockState p_184813_1_, @Nullable BlockPos pos) {
        float f = this.field_71071_by.func_184438_a(p_184813_1_);
        if (f > 1.0f) {
            int i = EnchantmentHelper.func_185293_e(this);
            ItemStack itemstack = this.func_184614_ca();
            if (i > 0 && !itemstack.func_190926_b()) {
                f += (float)(i * i + 1);
            }
        }
        if (EffectUtils.func_205135_a((LivingEntity)this)) {
            f *= 1.0f + (float)(EffectUtils.func_205134_b((LivingEntity)this) + 1) * 0.2f;
        }
        if (this.func_70644_a(Effects.field_76419_f)) {
            float f1;
            switch (this.func_70660_b(Effects.field_76419_f).func_76458_c()) {
                case 0: {
                    f1 = 0.3f;
                    break;
                }
                case 1: {
                    f1 = 0.09f;
                    break;
                }
                case 2: {
                    f1 = 0.0027f;
                    break;
                }
                default: {
                    f1 = 8.1E-4f;
                }
            }
            f *= f1;
        }
        if (this.func_208600_a(FluidTags.field_206959_a) && !EnchantmentHelper.func_185287_i(this)) {
            f /= 5.0f;
        }
        if (!this.field_70122_E) {
            f /= 5.0f;
        }
        f = ForgeEventFactory.getBreakSpeed((PlayerEntity)this, (BlockState)p_184813_1_, (float)f, (BlockPos)pos);
        return f;
    }

    public boolean func_234569_d_(BlockState p_234569_1_) {
        return ForgeEventFactory.doPlayerHarvestCheck((PlayerEntity)this, (BlockState)p_234569_1_, (!p_234569_1_.func_235783_q_() || this.field_71071_by.func_70448_g().func_150998_b(p_234569_1_) ? 1 : 0) != 0);
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.func_184221_a(PlayerEntity.func_146094_a(this.field_146106_i));
        ListNBT listnbt = p_70037_1_.func_150295_c("Inventory", 10);
        this.field_71071_by.func_70443_b(listnbt);
        this.field_71071_by.field_70461_c = p_70037_1_.func_74762_e("SelectedItemSlot");
        this.field_71076_b = p_70037_1_.func_74765_d("SleepTimer");
        this.field_71106_cc = p_70037_1_.func_74760_g("XpP");
        this.field_71068_ca = p_70037_1_.func_74762_e("XpLevel");
        this.field_71067_cb = p_70037_1_.func_74762_e("XpTotal");
        this.field_175152_f = p_70037_1_.func_74762_e("XpSeed");
        if (this.field_175152_f == 0) {
            this.field_175152_f = this.field_70146_Z.nextInt();
        }
        this.func_85040_s(p_70037_1_.func_74762_e("Score"));
        this.field_71100_bB.func_75112_a(p_70037_1_);
        this.field_71075_bZ.func_75095_b(p_70037_1_);
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)this.field_71075_bZ.func_75094_b());
        if (p_70037_1_.func_150297_b("EnderItems", 9)) {
            this.field_71078_a.func_70486_a(p_70037_1_.func_150295_c("EnderItems", 10));
        }
        if (p_70037_1_.func_150297_b("ShoulderEntityLeft", 10)) {
            this.func_192029_h(p_70037_1_.func_74775_l("ShoulderEntityLeft"));
        }
        if (p_70037_1_.func_150297_b("ShoulderEntityRight", 10)) {
            this.func_192031_i(p_70037_1_.func_74775_l("ShoulderEntityRight"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("DataVersion", SharedConstants.func_215069_a().getWorldVersion());
        p_213281_1_.func_218657_a("Inventory", (INBT)this.field_71071_by.func_70442_a(new ListNBT()));
        p_213281_1_.func_74768_a("SelectedItemSlot", this.field_71071_by.field_70461_c);
        p_213281_1_.func_74777_a("SleepTimer", (short)this.field_71076_b);
        p_213281_1_.func_74776_a("XpP", this.field_71106_cc);
        p_213281_1_.func_74768_a("XpLevel", this.field_71068_ca);
        p_213281_1_.func_74768_a("XpTotal", this.field_71067_cb);
        p_213281_1_.func_74768_a("XpSeed", this.field_175152_f);
        p_213281_1_.func_74768_a("Score", this.func_71037_bA());
        this.field_71100_bB.func_75117_b(p_213281_1_);
        this.field_71075_bZ.func_75091_a(p_213281_1_);
        p_213281_1_.func_218657_a("EnderItems", (INBT)this.field_71078_a.func_70487_g());
        if (!this.func_192023_dk().isEmpty()) {
            p_213281_1_.func_218657_a("ShoulderEntityLeft", this.func_192023_dk());
        }
        if (!this.func_192025_dl().isEmpty()) {
            p_213281_1_.func_218657_a("ShoulderEntityRight", this.func_192025_dl());
        }
    }

    @Override
    public boolean func_180431_b(DamageSource p_180431_1_) {
        if (super.func_180431_b(p_180431_1_)) {
            return true;
        }
        if (p_180431_1_ == DamageSource.field_76369_e) {
            return !this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_226679_A_);
        }
        if (p_180431_1_ == DamageSource.field_76379_h) {
            return !this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_226680_B_);
        }
        if (p_180431_1_.func_76347_k()) {
            return !this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_226681_C_);
        }
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (!ForgeHooks.onPlayerAttack((LivingEntity)this, (DamageSource)p_70097_1_, (float)p_70097_2_)) {
            return false;
        }
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        if (this.field_71075_bZ.field_75102_a && !p_70097_1_.func_76357_e()) {
            return false;
        }
        this.field_70708_bq = 0;
        if (this.func_233643_dh_()) {
            return false;
        }
        this.func_192030_dh();
        if (p_70097_1_.func_76350_n()) {
            if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
                p_70097_2_ = 0.0f;
            }
            if (this.field_70170_p.func_175659_aa() == Difficulty.EASY) {
                p_70097_2_ = Math.min(p_70097_2_ / 2.0f + 1.0f, p_70097_2_);
            }
            if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                p_70097_2_ = p_70097_2_ * 3.0f / 2.0f;
            }
        }
        return p_70097_2_ == 0.0f ? false : super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    @Override
    protected void func_190629_c(LivingEntity p_190629_1_) {
        super.func_190629_c(p_190629_1_);
        if (p_190629_1_.func_184614_ca().canDisableShield(this.field_184627_bm, this, p_190629_1_)) {
            this.func_190777_m(true);
        }
    }

    public boolean func_96122_a(PlayerEntity p_96122_1_) {
        Team team = this.func_96124_cp();
        Team team1 = p_96122_1_.func_96124_cp();
        if (team == null) {
            return true;
        }
        return !team.func_142054_a(team1) ? true : team.func_96665_g();
    }

    @Override
    protected void func_230294_b_(DamageSource p_230294_1_, float p_230294_2_) {
        this.field_71071_by.func_234563_a_(p_230294_1_, p_230294_2_);
    }

    @Override
    protected void func_184590_k(float p_184590_1_) {
        if (this.field_184627_bm.isShield(this)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_71029_a(Stats.field_75929_E.func_199076_b(this.field_184627_bm.func_77973_b()));
            }
            if (p_184590_1_ >= 3.0f) {
                int i = 1 + MathHelper.func_76141_d((float)p_184590_1_);
                Hand hand = this.func_184600_cs();
                this.field_184627_bm.func_222118_a(i, this, p_213833_1_ -> {
                    p_213833_1_.func_213334_d(hand);
                    ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)this, (ItemStack)this.field_184627_bm, (Hand)hand);
                });
                if (this.field_184627_bm.func_190926_b()) {
                    if (hand == Hand.MAIN_HAND) {
                        this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                    } else {
                        this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                    }
                    this.field_184627_bm = ItemStack.field_190927_a;
                    this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                }
            }
        }
    }

    @Override
    protected void func_70665_d(DamageSource p_70665_1_, float p_70665_2_) {
        if (!this.func_180431_b(p_70665_1_)) {
            if ((p_70665_2_ = ForgeHooks.onLivingHurt((LivingEntity)this, (DamageSource)p_70665_1_, (float)p_70665_2_)) <= 0.0f) {
                return;
            }
            p_70665_2_ = this.func_70655_b(p_70665_1_, p_70665_2_);
            p_70665_2_ = this.func_70672_c(p_70665_1_, p_70665_2_);
            float f2 = Math.max(p_70665_2_ - this.func_110139_bj(), 0.0f);
            this.func_110149_m(this.func_110139_bj() - (p_70665_2_ - f2));
            f2 = ForgeHooks.onLivingDamage((LivingEntity)this, (DamageSource)p_70665_1_, (float)f2);
            float f = p_70665_2_ - f2;
            if (f > 0.0f && f < 3.4028235E37f) {
                this.func_195067_a(Stats.field_212738_J, Math.round(f * 10.0f));
            }
            if (f2 != 0.0f) {
                this.func_71020_j(p_70665_1_.func_76345_d());
                float f1 = this.func_110143_aJ();
                this.func_70606_j(this.func_110143_aJ() - f2);
                this.func_110142_aN().func_94547_a(p_70665_1_, f1, f2);
                if (f2 < 3.4028235E37f) {
                    this.func_195067_a(Stats.field_188112_z, Math.round(f2 * 10.0f));
                }
            }
        }
    }

    @Override
    protected boolean func_230296_cM_() {
        return !this.field_71075_bZ.field_75100_b && super.func_230296_cM_();
    }

    public void func_175141_a(SignTileEntity p_175141_1_) {
    }

    public void func_184809_a(CommandBlockLogic p_184809_1_) {
    }

    public void func_184824_a(CommandBlockTileEntity p_184824_1_) {
    }

    public void func_189807_a(StructureBlockTileEntity p_189807_1_) {
    }

    public void func_213826_a(JigsawTileEntity p_213826_1_) {
    }

    public void func_184826_a(AbstractHorseEntity p_184826_1_, IInventory p_184826_2_) {
    }

    public OptionalInt func_213829_a(@Nullable INamedContainerProvider p_213829_1_) {
        return OptionalInt.empty();
    }

    public void func_213818_a(int p_213818_1_, MerchantOffers p_213818_2_, int p_213818_3_, int p_213818_4_, boolean p_213818_5_, boolean p_213818_6_) {
    }

    public void func_184814_a(ItemStack p_184814_1_, Hand p_184814_2_) {
    }

    public ActionResultType func_190775_a(Entity p_190775_1_, Hand p_190775_2_) {
        if (this.func_175149_v()) {
            if (p_190775_1_ instanceof INamedContainerProvider) {
                this.func_213829_a((INamedContainerProvider)p_190775_1_);
            }
            return ActionResultType.PASS;
        }
        ActionResultType cancelResult = ForgeHooks.onInteractEntity((PlayerEntity)this, (Entity)p_190775_1_, (Hand)p_190775_2_);
        if (cancelResult != null) {
            return cancelResult;
        }
        ItemStack itemstack = this.func_184586_b(p_190775_2_);
        ItemStack itemstack1 = itemstack.func_77946_l();
        ActionResultType actionresulttype = p_190775_1_.func_184230_a(this, p_190775_2_);
        if (actionresulttype.func_226246_a_()) {
            if (this.field_71075_bZ.field_75098_d && itemstack == this.func_184586_b(p_190775_2_) && itemstack.func_190916_E() < itemstack1.func_190916_E()) {
                itemstack.func_190920_e(itemstack1.func_190916_E());
            }
            if (!this.field_71075_bZ.field_75098_d && itemstack.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)this, (ItemStack)itemstack1, (Hand)p_190775_2_);
            }
            return actionresulttype;
        }
        if (!itemstack.func_190926_b() && p_190775_1_ instanceof LivingEntity) {
            ActionResultType actionresulttype1;
            if (this.field_71075_bZ.field_75098_d) {
                itemstack = itemstack1;
            }
            if ((actionresulttype1 = itemstack.func_111282_a_(this, (LivingEntity)p_190775_1_, p_190775_2_)).func_226246_a_()) {
                if (itemstack.func_190926_b() && !this.field_71075_bZ.field_75098_d) {
                    ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)this, (ItemStack)itemstack1, (Hand)p_190775_2_);
                    this.func_184611_a(p_190775_2_, ItemStack.field_190927_a);
                }
                return actionresulttype1;
            }
        }
        return ActionResultType.PASS;
    }

    @Override
    public double func_70033_W() {
        return -0.35;
    }

    @Override
    public void func_233575_bb_() {
        super.func_233575_bb_();
        this.field_184245_j = 0;
    }

    @Override
    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.func_70608_bn();
    }

    @Override
    public boolean func_241208_cS_() {
        return !this.field_71075_bZ.field_75100_b;
    }

    @Override
    protected Vector3d func_225514_a_(Vector3d p_225514_1_, MoverType p_225514_2_) {
        if (!this.field_71075_bZ.field_75100_b && (p_225514_2_ == MoverType.SELF || p_225514_2_ == MoverType.PLAYER) && this.func_226565_dV_() && this.func_242375_q()) {
            double d0 = p_225514_1_.field_72450_a;
            double d1 = p_225514_1_.field_72449_c;
            double d2 = 0.05;
            while (d0 != 0.0 && this.field_70170_p.func_226665_a__(this, this.func_174813_aQ().func_72317_d(d0, (double)(-this.field_70138_W), 0.0))) {
                if (d0 < 0.05 && d0 >= -0.05) {
                    d0 = 0.0;
                    continue;
                }
                if (d0 > 0.0) {
                    d0 -= 0.05;
                    continue;
                }
                d0 += 0.05;
            }
            while (d1 != 0.0 && this.field_70170_p.func_226665_a__(this, this.func_174813_aQ().func_72317_d(0.0, (double)(-this.field_70138_W), d1))) {
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.field_70170_p.func_226665_a__(this, this.func_174813_aQ().func_72317_d(d0, (double)(-this.field_70138_W), d1))) {
                d0 = d0 < 0.05 && d0 >= -0.05 ? 0.0 : (d0 > 0.0 ? (d0 -= 0.05) : (d0 += 0.05));
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            p_225514_1_ = new Vector3d(d0, p_225514_1_.field_72448_b, d1);
        }
        return p_225514_1_;
    }

    private boolean func_242375_q() {
        return this.field_70122_E || this.field_70143_R < this.field_70138_W && !this.field_70170_p.func_226665_a__(this, this.func_174813_aQ().func_72317_d(0.0, (double)(this.field_70143_R - this.field_70138_W), 0.0));
    }

    public void func_71059_n(Entity p_71059_1_) {
        if (!ForgeHooks.onPlayerAttackTarget((PlayerEntity)this, (Entity)p_71059_1_)) {
            return;
        }
        if (p_71059_1_.func_70075_an() && !p_71059_1_.func_85031_j(this)) {
            float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
            float f1 = p_71059_1_ instanceof LivingEntity ? EnchantmentHelper.func_152377_a(this.func_184614_ca(), ((LivingEntity)p_71059_1_).func_70668_bt()) : EnchantmentHelper.func_152377_a(this.func_184614_ca(), CreatureAttribute.field_223222_a_);
            float f2 = this.func_184825_o(0.5f);
            f1 *= f2;
            this.func_184821_cY();
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                ItemStack itemstack;
                boolean flag = f2 > 0.9f;
                boolean flag1 = false;
                int i = 0;
                i += EnchantmentHelper.func_77501_a(this);
                if (this.func_70051_ag() && flag) {
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187721_dT, this.func_184176_by(), 1.0f, 1.0f);
                    ++i;
                    flag1 = true;
                }
                boolean flag2 = flag && this.field_70143_R > 0.0f && !this.field_70122_E && !this.func_70617_f_() && !this.func_70090_H() && !this.func_70644_a(Effects.field_76440_q) && !this.func_184218_aH() && p_71059_1_ instanceof LivingEntity;
                flag2 = flag2 && !this.func_70051_ag();
                CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((PlayerEntity)this, (Entity)p_71059_1_, (boolean)flag2, (float)(flag2 ? 1.5f : 1.0f));
                boolean bl = flag2 = hitResult != null;
                if (flag2) {
                    f *= hitResult.getDamageModifier();
                }
                f += f1;
                boolean flag3 = false;
                double d0 = this.field_70140_Q - this.field_70141_P;
                if (flag && !flag2 && !flag1 && this.field_70122_E && d0 < (double)this.func_70689_ay() && (itemstack = this.func_184586_b(Hand.MAIN_HAND)).func_77973_b() instanceof SwordItem) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.func_90036_a(this);
                if (p_71059_1_ instanceof LivingEntity) {
                    f4 = ((LivingEntity)p_71059_1_).func_110143_aJ();
                    if (j > 0 && !p_71059_1_.func_70027_ad()) {
                        flag4 = true;
                        p_71059_1_.func_70015_d(1);
                    }
                }
                Vector3d vector3d = p_71059_1_.func_213322_ci();
                boolean flag5 = p_71059_1_.func_70097_a(DamageSource.func_76365_a((PlayerEntity)this), f);
                if (flag5) {
                    if (i > 0) {
                        if (p_71059_1_ instanceof LivingEntity) {
                            ((LivingEntity)p_71059_1_).func_233627_a_((float)i * 0.5f, MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))));
                        } else {
                            p_71059_1_.func_70024_g(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f, 0.1, MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f);
                        }
                        this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                        this.func_70031_b(false);
                    }
                    if (flag3) {
                        float f3 = 1.0f + EnchantmentHelper.func_191527_a(this) * f;
                        for (LivingEntity livingentity : this.field_70170_p.func_217357_a(LivingEntity.class, p_71059_1_.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                            if (livingentity == this || livingentity == p_71059_1_ || this.func_184191_r(livingentity) || livingentity instanceof ArmorStandEntity && ((ArmorStandEntity)livingentity).func_181026_s() || !(this.func_70068_e(livingentity) < 9.0)) continue;
                            livingentity.func_233627_a_(0.4f, MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))));
                            livingentity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)this), f3);
                        }
                        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187730_dW, this.func_184176_by(), 1.0f, 1.0f);
                        this.func_184810_cG();
                    }
                    if (p_71059_1_ instanceof ServerPlayerEntity && p_71059_1_.field_70133_I) {
                        ((ServerPlayerEntity)p_71059_1_).field_71135_a.func_147359_a((IPacket<?>)new SEntityVelocityPacket(p_71059_1_));
                        p_71059_1_.field_70133_I = false;
                        p_71059_1_.func_213317_d(vector3d);
                    }
                    if (flag2) {
                        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187718_dS, this.func_184176_by(), 1.0f, 1.0f);
                        this.func_71009_b(p_71059_1_);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187727_dV, this.func_184176_by(), 1.0f, 1.0f);
                        } else {
                            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187733_dX, this.func_184176_by(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.func_71047_c(p_71059_1_);
                    }
                    this.func_130011_c(p_71059_1_);
                    if (p_71059_1_ instanceof LivingEntity) {
                        EnchantmentHelper.func_151384_a((LivingEntity)p_71059_1_, this);
                    }
                    EnchantmentHelper.func_151385_b(this, p_71059_1_);
                    ItemStack itemstack1 = this.func_184614_ca();
                    Entity entity = p_71059_1_;
                    if (p_71059_1_ instanceof PartEntity) {
                        entity = ((PartEntity)p_71059_1_).getParent();
                    }
                    if (!this.field_70170_p.field_72995_K && !itemstack1.func_190926_b() && entity instanceof LivingEntity) {
                        ItemStack copy = itemstack1.func_77946_l();
                        itemstack1.func_77961_a((LivingEntity)entity, this);
                        if (itemstack1.func_190926_b()) {
                            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)this, (ItemStack)copy, (Hand)Hand.MAIN_HAND);
                            this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                    if (p_71059_1_ instanceof LivingEntity) {
                        float f5 = f4 - ((LivingEntity)p_71059_1_).func_110143_aJ();
                        this.func_195067_a(Stats.field_188111_y, Math.round(f5 * 10.0f));
                        if (j > 0) {
                            p_71059_1_.func_70015_d(j * 4);
                        }
                        if (this.field_70170_p instanceof ServerWorld && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((ServerWorld)this.field_70170_p).func_195598_a(ParticleTypes.field_197615_h, p_71059_1_.func_226277_ct_(), p_71059_1_.func_226283_e_(0.5), p_71059_1_.func_226281_cx_(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.func_71020_j(0.1f);
                } else {
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187724_dU, this.func_184176_by(), 1.0f, 1.0f);
                    if (flag4) {
                        p_71059_1_.func_70066_B();
                    }
                }
            }
        }
    }

    @Override
    protected void func_204804_d(LivingEntity p_204804_1_) {
        this.func_71059_n(p_204804_1_);
    }

    public void func_190777_m(boolean p_190777_1_) {
        float f = 0.25f + (float)EnchantmentHelper.func_185293_e(this) * 0.05f;
        if (p_190777_1_) {
            f += 0.75f;
        }
        if (this.field_70146_Z.nextFloat() < f) {
            this.func_184811_cZ().func_185145_a(this.func_184607_cu().func_77973_b(), 100);
            this.func_184602_cy();
            this.field_70170_p.func_72960_a(this, (byte)30);
        }
    }

    public void func_71009_b(Entity p_71009_1_) {
    }

    public void func_71047_c(Entity p_71047_1_) {
    }

    public void func_184810_cG() {
        double d0 = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
        double d1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a(ParticleTypes.field_197603_N, this.func_226277_ct_() + d0, this.func_226283_e_(0.5), this.func_226281_cx_() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_71004_bE() {
    }

    @Override
    public void remove(boolean keepData) {
        super.remove(keepData);
        this.field_71069_bz.func_75134_a(this);
        if (this.field_71070_bA != null) {
            this.field_71070_bA.func_75134_a(this);
        }
    }

    public boolean func_175144_cb() {
        return false;
    }

    public GameProfile func_146103_bH() {
        return this.field_146106_i;
    }

    public Either<SleepResult, Unit> func_213819_a(BlockPos p_213819_1_) {
        this.func_213342_e(p_213819_1_);
        this.field_71076_b = 0;
        return Either.right((Object)Unit.INSTANCE);
    }

    public void func_225652_a_(boolean p_225652_1_, boolean p_225652_2_) {
        ForgeEventFactory.onPlayerWakeup((PlayerEntity)this, (boolean)p_225652_1_, (boolean)p_225652_2_);
        super.func_213366_dy();
        if (this.field_70170_p instanceof ServerWorld && p_225652_2_) {
            ((ServerWorld)this.field_70170_p).func_72854_c();
        }
        this.field_71076_b = p_225652_1_ ? 0 : 100;
    }

    @Override
    public void func_213366_dy() {
        this.func_225652_a_(true, true);
    }

    public static Optional<Vector3d> func_242374_a(ServerWorld p_242374_0_, BlockPos p_242374_1_, float p_242374_2_, boolean p_242374_3_, boolean p_242374_4_) {
        BlockState blockstate = p_242374_0_.func_180495_p(p_242374_1_);
        Block block = blockstate.func_177230_c();
        if (block instanceof RespawnAnchorBlock && (Integer)blockstate.func_177229_b((Property)RespawnAnchorBlock.field_235559_a_) > 0 && RespawnAnchorBlock.func_235562_a_((World)p_242374_0_)) {
            Optional optional = RespawnAnchorBlock.func_235560_a_(EntityType.field_200729_aH, (ICollisionReader)p_242374_0_, (BlockPos)p_242374_1_);
            if (!p_242374_4_ && optional.isPresent()) {
                p_242374_0_.func_180501_a(p_242374_1_, (BlockState)((Object)blockstate.func_206870_a((Property)RespawnAnchorBlock.field_235559_a_, Integer.valueOf((Integer)blockstate.func_177229_b((Property)RespawnAnchorBlock.field_235559_a_) - 1))), 3);
            }
            return optional;
        }
        if (blockstate.isBed((IBlockReader)((Object)p_242374_0_), p_242374_1_, null) && BedBlock.func_235330_a_((World)p_242374_0_)) {
            return blockstate.getBedSpawnPosition(EntityType.field_200729_aH, (IWorldReader)((Object)p_242374_0_), p_242374_1_, p_242374_2_, null);
        }
        if (!p_242374_3_) {
            return Optional.empty();
        }
        boolean flag = block.func_181623_g();
        boolean flag1 = p_242374_0_.func_180495_p(p_242374_1_.func_177984_a()).func_177230_c().func_181623_g();
        return flag && flag1 ? Optional.of(new Vector3d((double)p_242374_1_.func_177958_n() + 0.5, (double)p_242374_1_.func_177956_o() + 0.1, (double)p_242374_1_.func_177952_p() + 0.5)) : Optional.empty();
    }

    public boolean func_71026_bH() {
        return this.func_70608_bn() && this.field_71076_b >= 100;
    }

    public int func_71060_bI() {
        return this.field_71076_b;
    }

    public void func_146105_b(ITextComponent p_146105_1_, boolean p_146105_2_) {
    }

    public void func_195066_a(ResourceLocation p_195066_1_) {
        this.func_71029_a(Stats.field_199092_j.func_199076_b(p_195066_1_));
    }

    public void func_195067_a(ResourceLocation p_195067_1_, int p_195067_2_) {
        this.func_71064_a(Stats.field_199092_j.func_199076_b(p_195067_1_), p_195067_2_);
    }

    public void func_71029_a(Stat<?> p_71029_1_) {
        this.func_71064_a(p_71029_1_, 1);
    }

    public void func_71064_a(Stat<?> p_71064_1_, int p_71064_2_) {
    }

    public void func_175145_a(Stat<?> p_175145_1_) {
    }

    public int func_195065_a(Collection<IRecipe<?>> p_195065_1_) {
        return 0;
    }

    public void func_193102_a(ResourceLocation[] p_193102_1_) {
    }

    public int func_195069_b(Collection<IRecipe<?>> p_195069_1_) {
        return 0;
    }

    @Override
    public void func_70664_aZ() {
        super.func_70664_aZ();
        this.func_195066_a(Stats.field_75953_u);
        if (this.func_70051_ag()) {
            this.func_71020_j(0.2f);
        } else {
            this.func_71020_j(0.05f);
        }
    }

    @Override
    public void func_213352_e(Vector3d p_213352_1_) {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        if (this.func_203007_ba() && !this.func_184218_aH()) {
            double d4;
            double d3 = this.func_70040_Z().field_72448_b;
            double d = d4 = d3 < -0.2 ? 0.085 : 0.06;
            if (d3 <= 0.0 || this.field_70703_bu || !this.field_70170_p.func_180495_p(new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() + 1.0 - 0.1, this.func_226281_cx_())).func_204520_s().func_206888_e()) {
                Vector3d vector3d1 = this.func_213322_ci();
                this.func_213317_d(vector3d1.func_72441_c(0.0, (d3 - vector3d1.field_72448_b) * d4, 0.0));
            }
        }
        if (this.field_71075_bZ.field_75100_b && !this.func_184218_aH()) {
            double d5 = this.func_213322_ci().field_72448_b;
            float f = this.field_70747_aH;
            this.field_70747_aH = this.field_71075_bZ.func_75093_a() * (float)(this.func_70051_ag() ? 2 : 1);
            super.func_213352_e(p_213352_1_);
            Vector3d vector3d = this.func_213322_ci();
            this.func_213293_j(vector3d.field_72450_a, d5 * 0.6, vector3d.field_72449_c);
            this.field_70747_aH = f;
            this.field_70143_R = 0.0f;
            this.func_70052_a(7, false);
        } else {
            super.func_213352_e(p_213352_1_);
        }
        this.func_71000_j(this.func_226277_ct_() - d0, this.func_226278_cu_() - d1, this.func_226281_cx_() - d2);
    }

    @Override
    public void func_205343_av() {
        if (this.field_71075_bZ.field_75100_b) {
            this.func_204711_a(false);
        } else {
            super.func_205343_av();
        }
    }

    protected boolean func_207401_g(BlockPos p_207401_1_) {
        return !this.field_70170_p.func_180495_p(p_207401_1_).func_229980_m_((IBlockReader)((Object)this.field_70170_p), p_207401_1_);
    }

    @Override
    public float func_70689_ay() {
        return (float)this.func_233637_b_(Attributes.field_233821_d_);
    }

    public void func_71000_j(double p_71000_1_, double p_71000_3_, double p_71000_5_) {
        if (!this.func_184218_aH()) {
            if (this.func_203007_ba()) {
                int i = Math.round(MathHelper.func_76133_a((double)(p_71000_1_ * p_71000_1_ + p_71000_3_ * p_71000_3_ + p_71000_5_ * p_71000_5_)) * 100.0f);
                if (i > 0) {
                    this.func_195067_a(Stats.field_75946_m, i);
                    this.func_71020_j(0.01f * (float)i * 0.01f);
                }
            } else if (this.func_208600_a(FluidTags.field_206959_a)) {
                int j = Math.round(MathHelper.func_76133_a((double)(p_71000_1_ * p_71000_1_ + p_71000_3_ * p_71000_3_ + p_71000_5_ * p_71000_5_)) * 100.0f);
                if (j > 0) {
                    this.func_195067_a(Stats.field_211756_w, j);
                    this.func_71020_j(0.01f * (float)j * 0.01f);
                }
            } else if (this.func_70090_H()) {
                int k = Math.round(MathHelper.func_76133_a((double)(p_71000_1_ * p_71000_1_ + p_71000_5_ * p_71000_5_)) * 100.0f);
                if (k > 0) {
                    this.func_195067_a(Stats.field_211755_s, k);
                    this.func_71020_j(0.01f * (float)k * 0.01f);
                }
            } else if (this.func_70617_f_()) {
                if (p_71000_3_ > 0.0) {
                    this.func_195067_a(Stats.field_188103_o, (int)Math.round(p_71000_3_ * 100.0));
                }
            } else if (this.field_70122_E) {
                int l = Math.round(MathHelper.func_76133_a((double)(p_71000_1_ * p_71000_1_ + p_71000_5_ * p_71000_5_)) * 100.0f);
                if (l > 0) {
                    if (this.func_70051_ag()) {
                        this.func_195067_a(Stats.field_188102_l, l);
                        this.func_71020_j(0.1f * (float)l * 0.01f);
                    } else if (this.func_213453_ef()) {
                        this.func_195067_a(Stats.field_188101_k, l);
                        this.func_71020_j(0.0f * (float)l * 0.01f);
                    } else {
                        this.func_195067_a(Stats.field_188100_j, l);
                        this.func_71020_j(0.0f * (float)l * 0.01f);
                    }
                }
            } else if (this.func_184613_cA()) {
                int i1 = Math.round(MathHelper.func_76133_a((double)(p_71000_1_ * p_71000_1_ + p_71000_3_ * p_71000_3_ + p_71000_5_ * p_71000_5_)) * 100.0f);
                this.func_195067_a(Stats.field_188110_v, i1);
            } else {
                int j1 = Math.round(MathHelper.func_76133_a((double)(p_71000_1_ * p_71000_1_ + p_71000_5_ * p_71000_5_)) * 100.0f);
                if (j1 > 25) {
                    this.func_195067_a(Stats.field_188104_p, j1);
                }
            }
        }
    }

    private void func_71015_k(double p_71015_1_, double p_71015_3_, double p_71015_5_) {
        int i;
        if (this.func_184218_aH() && (i = Math.round(MathHelper.func_76133_a((double)(p_71015_1_ * p_71015_1_ + p_71015_3_ * p_71015_3_ + p_71015_5_ * p_71015_5_)) * 100.0f)) > 0) {
            Entity entity = this.func_184187_bx();
            if (entity instanceof AbstractMinecartEntity) {
                this.func_195067_a(Stats.field_188106_r, i);
            } else if (entity instanceof BoatEntity) {
                this.func_195067_a(Stats.field_188107_s, i);
            } else if (entity instanceof PigEntity) {
                this.func_195067_a(Stats.field_188108_t, i);
            } else if (entity instanceof AbstractHorseEntity) {
                this.func_195067_a(Stats.field_188109_u, i);
            } else if (entity instanceof StriderEntity) {
                this.func_195067_a(Stats.field_232862_C_, i);
            }
        }
    }

    @Override
    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        if (this.field_71075_bZ.field_75101_c) {
            ForgeEventFactory.onPlayerFall((PlayerEntity)this, (float)p_225503_1_, (float)p_225503_2_);
            return false;
        }
        if (p_225503_1_ >= 2.0f) {
            this.func_195067_a(Stats.field_75943_n, (int)Math.round((double)p_225503_1_ * 100.0));
        }
        return super.func_225503_b_(p_225503_1_, p_225503_2_);
    }

    public boolean func_226566_ei_() {
        ItemStack itemstack;
        if (!(this.field_70122_E || this.func_184613_cA() || this.func_70090_H() || this.func_70644_a(Effects.field_188424_y) || !(itemstack = this.func_184582_a(EquipmentSlotType.CHEST)).canElytraFly(this))) {
            this.func_226567_ej_();
            return true;
        }
        return false;
    }

    public void func_226567_ej_() {
        this.func_70052_a(7, true);
    }

    public void func_226568_ek_() {
        this.func_70052_a(7, true);
        this.func_70052_a(7, false);
    }

    @Override
    protected void func_71061_d_() {
        if (!this.func_175149_v()) {
            super.func_71061_d_();
        }
    }

    @Override
    protected SoundEvent func_184588_d(int p_184588_1_) {
        return p_184588_1_ > 4 ? SoundEvents.field_187736_dY : SoundEvents.field_187804_ed;
    }

    @Override
    public void func_241847_a(ServerWorld p_241847_1_, LivingEntity p_241847_2_) {
        this.func_71029_a(Stats.field_199090_h.func_199076_b(p_241847_2_.func_200600_R()));
    }

    @Override
    public void func_213295_a(BlockState p_213295_1_, Vector3d p_213295_2_) {
        if (!this.field_71075_bZ.field_75100_b) {
            super.func_213295_a(p_213295_1_, p_213295_2_);
        }
    }

    public void func_195068_e(int p_195068_1_) {
        PlayerXpEvent.XpChange event = new PlayerXpEvent.XpChange(this, p_195068_1_);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        p_195068_1_ = event.getAmount();
        this.func_85039_t(p_195068_1_);
        this.field_71106_cc += (float)p_195068_1_ / (float)this.func_71050_bK();
        this.field_71067_cb = MathHelper.func_76125_a((int)(this.field_71067_cb + p_195068_1_), (int)0, (int)Integer.MAX_VALUE);
        while (this.field_71106_cc < 0.0f) {
            float f = this.field_71106_cc * (float)this.func_71050_bK();
            if (this.field_71068_ca > 0) {
                this.func_82242_a(-1);
                this.field_71106_cc = 1.0f + f / (float)this.func_71050_bK();
                continue;
            }
            this.func_82242_a(-1);
            this.field_71106_cc = 0.0f;
        }
        while (this.field_71106_cc >= 1.0f) {
            this.field_71106_cc = (this.field_71106_cc - 1.0f) * (float)this.func_71050_bK();
            this.func_82242_a(1);
            this.field_71106_cc /= (float)this.func_71050_bK();
        }
    }

    public int func_175138_ci() {
        return this.field_175152_f;
    }

    public void func_192024_a(ItemStack p_192024_1_, int p_192024_2_) {
        this.func_82242_a(-p_192024_2_);
        if (this.field_71068_ca < 0) {
            this.field_71068_ca = 0;
            this.field_71106_cc = 0.0f;
            this.field_71067_cb = 0;
        }
        this.field_175152_f = this.field_70146_Z.nextInt();
    }

    public void func_82242_a(int p_82242_1_) {
        PlayerXpEvent.LevelChange event = new PlayerXpEvent.LevelChange(this, p_82242_1_);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        p_82242_1_ = event.getLevels();
        this.field_71068_ca += p_82242_1_;
        if (this.field_71068_ca < 0) {
            this.field_71068_ca = 0;
            this.field_71106_cc = 0.0f;
            this.field_71067_cb = 0;
        }
        if (p_82242_1_ > 0 && this.field_71068_ca % 5 == 0 && (float)this.field_82249_h < (float)this.field_70173_aa - 100.0f) {
            float f = this.field_71068_ca > 30 ? 1.0f : (float)this.field_71068_ca / 30.0f;
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187802_ec, this.func_184176_by(), f * 0.75f, 1.0f);
            this.field_82249_h = this.field_70173_aa;
        }
    }

    public int func_71050_bK() {
        if (this.field_71068_ca >= 30) {
            return 112 + (this.field_71068_ca - 30) * 9;
        }
        return this.field_71068_ca >= 15 ? 37 + (this.field_71068_ca - 15) * 5 : 7 + this.field_71068_ca * 2;
    }

    public void func_71020_j(float p_71020_1_) {
        if (!this.field_71075_bZ.field_75102_a && !this.field_70170_p.field_72995_K) {
            this.field_71100_bB.func_75113_a(p_71020_1_);
        }
    }

    public FoodStats func_71024_bL() {
        return this.field_71100_bB;
    }

    public boolean func_71043_e(boolean p_71043_1_) {
        return this.field_71075_bZ.field_75102_a || p_71043_1_ || this.field_71100_bB.func_75121_c();
    }

    public boolean func_70996_bM() {
        return this.func_110143_aJ() > 0.0f && this.func_110143_aJ() < this.func_110138_aP();
    }

    public boolean func_175142_cm() {
        return this.field_71075_bZ.field_75099_e;
    }

    public boolean func_175151_a(BlockPos p_175151_1_, Direction p_175151_2_, ItemStack p_175151_3_) {
        if (this.field_71075_bZ.field_75099_e) {
            return true;
        }
        BlockPos blockpos = p_175151_1_.func_177972_a(p_175151_2_.func_176734_d());
        CachedBlockInfo cachedblockinfo = new CachedBlockInfo((IWorldReader)((Object)this.field_70170_p), blockpos, false);
        return p_175151_3_.func_206847_b(this.field_70170_p.func_205772_D(), cachedblockinfo);
    }

    @Override
    protected int func_70693_a(PlayerEntity p_70693_1_) {
        if (!this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) && !this.func_175149_v()) {
            int i = this.field_71068_ca * 7;
            return i > 100 ? 100 : i;
        }
        return 0;
    }

    @Override
    protected boolean func_70684_aJ() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_94059_bO() {
        return true;
    }

    @Override
    protected boolean func_225502_at_() {
        return !this.field_71075_bZ.field_75100_b && (!this.field_70122_E || !this.func_226273_bm_());
    }

    public void func_71016_p() {
    }

    public void func_71033_a(GameType p_71033_1_) {
    }

    @Override
    public ITextComponent func_200200_C_() {
        return new StringTextComponent(this.field_146106_i.getName());
    }

    public EnderChestInventory func_71005_bN() {
        return this.field_71078_a;
    }

    @Override
    public ItemStack func_184582_a(EquipmentSlotType p_184582_1_) {
        if (p_184582_1_ == EquipmentSlotType.MAINHAND) {
            return this.field_71071_by.func_70448_g();
        }
        if (p_184582_1_ == EquipmentSlotType.OFFHAND) {
            return (ItemStack)((Object)this.field_71071_by.field_184439_c.get(0));
        }
        return p_184582_1_.func_188453_a() == EquipmentSlotType.Group.ARMOR ? (ItemStack)((Object)this.field_71071_by.field_70460_b.get(p_184582_1_.func_188454_b())) : ItemStack.field_190927_a;
    }

    @Override
    public void func_184201_a(EquipmentSlotType p_184201_1_, ItemStack p_184201_2_) {
        if (p_184201_1_ == EquipmentSlotType.MAINHAND) {
            this.func_184606_a_(p_184201_2_);
            this.field_71071_by.field_70462_a.set(this.field_71071_by.field_70461_c, (Object)p_184201_2_);
        } else if (p_184201_1_ == EquipmentSlotType.OFFHAND) {
            this.func_184606_a_(p_184201_2_);
            this.field_71071_by.field_184439_c.set(0, (Object)p_184201_2_);
        } else if (p_184201_1_.func_188453_a() == EquipmentSlotType.Group.ARMOR) {
            this.func_184606_a_(p_184201_2_);
            this.field_71071_by.field_70460_b.set(p_184201_1_.func_188454_b(), (Object)p_184201_2_);
        }
    }

    public boolean func_191521_c(ItemStack p_191521_1_) {
        this.func_184606_a_(p_191521_1_);
        return this.field_71071_by.func_70441_a(p_191521_1_);
    }

    @Override
    public Iterable<ItemStack> func_184214_aD() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.func_184614_ca(), this.func_184592_cb()});
    }

    @Override
    public Iterable<ItemStack> func_184193_aE() {
        return this.field_71071_by.field_70460_b;
    }

    public boolean func_192027_g(CompoundNBT p_192027_1_) {
        if (!this.func_184218_aH() && this.field_70122_E && !this.func_70090_H()) {
            if (this.func_192023_dk().isEmpty()) {
                this.func_192029_h(p_192027_1_);
                this.field_223730_e = this.field_70170_p.func_82737_E();
                return true;
            }
            if (this.func_192025_dl().isEmpty()) {
                this.func_192031_i(p_192027_1_);
                this.field_223730_e = this.field_70170_p.func_82737_E();
                return true;
            }
            return false;
        }
        return false;
    }

    protected void func_192030_dh() {
        if (this.field_223730_e + 20L < this.field_70170_p.func_82737_E()) {
            this.func_192026_k(this.func_192023_dk());
            this.func_192029_h(new CompoundNBT());
            this.func_192026_k(this.func_192025_dl());
            this.func_192031_i(new CompoundNBT());
        }
    }

    private void func_192026_k(CompoundNBT p_192026_1_) {
        if (!this.field_70170_p.field_72995_K && !p_192026_1_.isEmpty()) {
            EntityType.func_220330_a(p_192026_1_, this.field_70170_p).ifPresent(p_226562_1_ -> {
                if (p_226562_1_ instanceof TameableEntity) {
                    ((TameableEntity)p_226562_1_).func_184754_b(this.field_96093_i);
                }
                p_226562_1_.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)0.7f, this.func_226281_cx_());
                ((ServerWorld)this.field_70170_p).func_217470_d((Entity)((Object)p_226562_1_));
            });
        }
    }

    @Override
    public abstract boolean func_175149_v();

    @Override
    public boolean func_203007_ba() {
        return !this.field_71075_bZ.field_75100_b && !this.func_175149_v() && super.func_203007_ba();
    }

    public abstract boolean func_184812_l_();

    @Override
    public boolean func_96092_aw() {
        return !this.field_71075_bZ.field_75100_b;
    }

    public Scoreboard func_96123_co() {
        return this.field_70170_p.func_96441_U();
    }

    @Override
    public ITextComponent func_145748_c_() {
        if (this.displayname == null) {
            this.displayname = ForgeEventFactory.getPlayerDisplayName((PlayerEntity)this, (ITextComponent)this.func_200200_C_());
        }
        StringTextComponent iformattabletextcomponent = new StringTextComponent("");
        iformattabletextcomponent = this.prefixes.stream().reduce((IFormattableTextComponent)iformattabletextcomponent, IFormattableTextComponent::func_230529_a_);
        iformattabletextcomponent = iformattabletextcomponent.func_230529_a_((ITextComponent)ScorePlayerTeam.func_237500_a_((Team)this.func_96124_cp(), (ITextComponent)this.displayname));
        iformattabletextcomponent = this.suffixes.stream().reduce((IFormattableTextComponent)iformattabletextcomponent, IFormattableTextComponent::func_230529_a_);
        return this.func_208016_c((IFormattableTextComponent)iformattabletextcomponent);
    }

    private IFormattableTextComponent func_208016_c(IFormattableTextComponent p_208016_1_) {
        String s = this.func_146103_bH().getName();
        return p_208016_1_.func_240700_a_(p_234565_2_ -> p_234565_2_.func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tell " + s + " ")).func_240716_a_(this.func_174823_aP()).func_240714_a_(s));
    }

    @Override
    public String func_195047_I_() {
        return this.func_146103_bH().getName();
    }

    @Override
    public float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        switch (p_213348_1_) {
            case SWIMMING: 
            case FALL_FLYING: 
            case SPIN_ATTACK: {
                return 0.4f;
            }
            case CROUCHING: {
                return 1.27f;
            }
        }
        return 1.62f;
    }

    @Override
    public void func_110149_m(float p_110149_1_) {
        if (p_110149_1_ < 0.0f) {
            p_110149_1_ = 0.0f;
        }
        this.func_184212_Q().func_187227_b(field_184829_a, Float.valueOf(p_110149_1_));
    }

    @Override
    public float func_110139_bj() {
        return this.func_184212_Q().func_187225_a(field_184829_a).floatValue();
    }

    public static UUID func_146094_a(GameProfile p_146094_0_) {
        UUID uuid = p_146094_0_.getId();
        if (uuid == null) {
            uuid = PlayerEntity.func_175147_b(p_146094_0_.getName());
        }
        return uuid;
    }

    public static UUID func_175147_b(String p_175147_0_) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + p_175147_0_).getBytes(StandardCharsets.UTF_8));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_175148_a(PlayerModelPart p_175148_1_) {
        return (this.func_184212_Q().func_187225_a(field_184827_bp) & p_175148_1_.func_179327_a()) == p_175148_1_.func_179327_a();
    }

    @Override
    public boolean func_174820_d(int p_174820_1_, ItemStack p_174820_2_) {
        if (p_174820_1_ >= 0 && p_174820_1_ < this.field_71071_by.field_70462_a.size()) {
            this.field_71071_by.func_70299_a(p_174820_1_, p_174820_2_);
            return true;
        }
        Object equipmentslottype = p_174820_1_ == 100 + EquipmentSlotType.HEAD.func_188454_b() ? EquipmentSlotType.HEAD : (p_174820_1_ == 100 + EquipmentSlotType.CHEST.func_188454_b() ? EquipmentSlotType.CHEST : (p_174820_1_ == 100 + EquipmentSlotType.LEGS.func_188454_b() ? EquipmentSlotType.LEGS : (p_174820_1_ == 100 + EquipmentSlotType.FEET.func_188454_b() ? EquipmentSlotType.FEET : null)));
        if (p_174820_1_ == 98) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, p_174820_2_);
            return true;
        }
        if (p_174820_1_ == 99) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, p_174820_2_);
            return true;
        }
        if (equipmentslottype == null) {
            int i = p_174820_1_ - 200;
            if (i >= 0 && i < this.field_71078_a.func_70302_i_()) {
                this.field_71078_a.func_70299_a(i, p_174820_2_);
                return true;
            }
            return false;
        }
        if (!p_174820_2_.func_190926_b() && (!(p_174820_2_.func_77973_b() instanceof ArmorItem) && !(p_174820_2_.func_77973_b() instanceof ElytraItem) ? equipmentslottype != EquipmentSlotType.HEAD : MobEntity.func_184640_d(p_174820_2_) != equipmentslottype)) {
            return false;
        }
        this.field_71071_by.func_70299_a(equipmentslottype.func_188454_b() + this.field_71071_by.field_70462_a.size(), p_174820_2_);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_175140_cp() {
        return this.field_175153_bG;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_175150_k(boolean p_175150_1_) {
        this.field_175153_bG = p_175150_1_;
    }

    @Override
    public void func_241209_g_(int p_241209_1_) {
        super.func_241209_g_(this.field_71075_bZ.field_75102_a ? Math.min(p_241209_1_, 1) : p_241209_1_);
    }

    @Override
    public HandSide func_184591_cq() {
        return this.field_70180_af.func_187225_a(field_184828_bq) == 0 ? HandSide.LEFT : HandSide.RIGHT;
    }

    public void func_184819_a(HandSide p_184819_1_) {
        this.field_70180_af.func_187227_b(field_184828_bq, (byte)(p_184819_1_ != HandSide.LEFT ? 1 : 0));
    }

    public CompoundNBT func_192023_dk() {
        return this.field_70180_af.func_187225_a(field_192032_bt);
    }

    protected void func_192029_h(CompoundNBT p_192029_1_) {
        this.field_70180_af.func_187227_b(field_192032_bt, p_192029_1_);
    }

    public CompoundNBT func_192025_dl() {
        return this.field_70180_af.func_187225_a(field_192033_bu);
    }

    protected void func_192031_i(CompoundNBT p_192031_1_) {
        this.field_70180_af.func_187227_b(field_192033_bu, p_192031_1_);
    }

    public float func_184818_cX() {
        return (float)(1.0 / this.func_233637_b_(Attributes.field_233825_h_) * 20.0);
    }

    public float func_184825_o(float p_184825_1_) {
        return MathHelper.func_76131_a((float)(((float)this.field_184617_aD + p_184825_1_) / this.func_184818_cX()), (float)0.0f, (float)1.0f);
    }

    public void func_184821_cY() {
        this.field_184617_aD = 0;
    }

    public CooldownTracker func_184811_cZ() {
        return this.field_184832_bU;
    }

    @Override
    protected float func_225515_ai_() {
        return !this.field_71075_bZ.field_75100_b && !this.func_184613_cA() ? super.func_225515_ai_() : 1.0f;
    }

    public float func_184817_da() {
        return (float)this.func_233637_b_(Attributes.field_233828_k_);
    }

    public boolean func_195070_dx() {
        return this.field_71075_bZ.field_75098_d && this.func_184840_I() >= 2;
    }

    @Override
    public boolean func_213365_e(ItemStack p_213365_1_) {
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d(p_213365_1_);
        return this.func_184582_a(equipmentslottype).func_190926_b();
    }

    @Override
    public EntitySize func_213305_a(Pose p_213305_1_) {
        return field_213836_b.getOrDefault(p_213305_1_, field_213835_bs);
    }

    @Override
    public ImmutableList<Pose> func_230297_ef_() {
        return ImmutableList.of((Object)Pose.STANDING, (Object)Pose.CROUCHING, (Object)Pose.SWIMMING);
    }

    @Override
    public ItemStack func_213356_f(ItemStack p_213356_1_) {
        if (!(p_213356_1_.func_77973_b() instanceof ShootableItem)) {
            return ItemStack.field_190927_a;
        }
        Predicate predicate = ((ShootableItem)p_213356_1_.func_77973_b()).func_220006_d();
        ItemStack itemstack = ShootableItem.func_220005_a((LivingEntity)this, (Predicate)predicate);
        if (!itemstack.func_190926_b()) {
            return itemstack;
        }
        predicate = ((ShootableItem)p_213356_1_.func_77973_b()).func_220004_b();
        for (int i = 0; i < this.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack1 = this.field_71071_by.func_70301_a(i);
            if (!predicate.test(itemstack1)) continue;
            return itemstack1;
        }
        return this.field_71075_bZ.field_75098_d ? new ItemStack(Items.field_151032_g) : ItemStack.field_190927_a;
    }

    @Override
    public ItemStack func_213357_a(World p_213357_1_, ItemStack p_213357_2_) {
        this.func_71024_bL().func_221410_a(p_213357_2_.func_77973_b(), p_213357_2_);
        this.func_71029_a(Stats.field_75929_E.func_199076_b(p_213357_2_.func_77973_b()));
        p_213357_1_.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, p_213357_1_.field_73012_v.nextFloat() * 0.1f + 0.9f);
        if (this instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)this, p_213357_2_);
        }
        return super.func_213357_a(p_213357_1_, p_213357_2_);
    }

    @Override
    protected boolean func_230295_b_(BlockState p_230295_1_) {
        return this.field_71075_bZ.field_75100_b || super.func_230295_b_(p_230295_1_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241843_o(float p_241843_1_) {
        float f2;
        double d0 = 0.22 * (this.func_184591_cq() == HandSide.RIGHT ? -1.0 : 1.0);
        float f = MathHelper.func_219799_g((float)(p_241843_1_ * 0.5f), (float)this.field_70125_A, (float)this.field_70127_C) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_219799_g((float)p_241843_1_, (float)this.field_70760_ar, (float)this.field_70761_aq) * ((float)Math.PI / 180);
        if (!this.func_184613_cA() && !this.func_204805_cN()) {
            if (this.func_213314_bj()) {
                return this.func_242282_l(p_241843_1_).func_178787_e(new Vector3d(d0, 0.2, -0.15).func_178789_a(-f).func_178785_b(-f1));
            }
            double d5 = this.func_174813_aQ().func_216360_c() - 1.0;
            double d6 = this.func_213453_ef() ? -0.2 : 0.07;
            return this.func_242282_l(p_241843_1_).func_178787_e(new Vector3d(d0, d5, d6).func_178785_b(-f1));
        }
        Vector3d vector3d = this.func_70676_i(p_241843_1_);
        Vector3d vector3d1 = this.func_213322_ci();
        double d1 = Entity.func_213296_b(vector3d1);
        double d2 = Entity.func_213296_b(vector3d);
        if (d1 > 0.0 && d2 > 0.0) {
            double d3 = (vector3d1.field_72450_a * vector3d.field_72450_a + vector3d1.field_72449_c * vector3d.field_72449_c) / Math.sqrt(d1 * d2);
            double d4 = vector3d1.field_72450_a * vector3d.field_72449_c - vector3d1.field_72449_c * vector3d.field_72450_a;
            f2 = (float)(Math.signum(d4) * Math.acos(d3));
        } else {
            f2 = 0.0f;
        }
        return this.func_242282_l(p_241843_1_).func_178787_e(new Vector3d(d0, -0.11, 0.85).func_242988_c(-f2).func_178789_a(-f).func_178785_b(-f1));
    }

    public Collection<IFormattableTextComponent> getPrefixes() {
        return this.prefixes;
    }

    public Collection<IFormattableTextComponent> getSuffixes() {
        return this.suffixes;
    }

    public void refreshDisplayName() {
        this.displayname = ForgeEventFactory.getPlayerDisplayName((PlayerEntity)this, (ITextComponent)this.func_200200_C_());
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return this.playerJoinedHandler.cast();
            }
            if (facing.func_176740_k().func_200128_b()) {
                return this.playerMainHandler.cast();
            }
            if (facing.func_176740_k().func_176722_c()) {
                return this.playerEquipmentHandler.cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    public void setForcedPose(@Nullable Pose pose) {
        this.forcedPose = pose;
    }

    @Nullable
    public Pose getForcedPose() {
        return this.forcedPose;
    }

    public static enum SleepResult {
        NOT_POSSIBLE_HERE,
        NOT_POSSIBLE_NOW((ITextComponent)new TranslationTextComponent("block.minecraft.bed.no_sleep")),
        TOO_FAR_AWAY((ITextComponent)new TranslationTextComponent("block.minecraft.bed.too_far_away")),
        OBSTRUCTED((ITextComponent)new TranslationTextComponent("block.minecraft.bed.obstructed")),
        OTHER_PROBLEM,
        NOT_SAFE((ITextComponent)new TranslationTextComponent("block.minecraft.bed.not_safe"));

        @Nullable
        private final ITextComponent field_221260_g;

        private SleepResult() {
            this.field_221260_g = null;
        }

        private SleepResult(ITextComponent p_i50668_3_) {
            this.field_221260_g = p_i50668_3_;
        }

        @Nullable
        public ITextComponent func_221259_a() {
            return this.field_221260_g;
        }
    }
}

