/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public interface IForgeItemStack
extends ICapabilitySerializable<CompoundNBT> {
    default public ItemStack getStack() {
        return (ItemStack)this;
    }

    default public ItemStack getContainerItem() {
        return this.getStack().func_77973_b().getContainerItem(this.getStack());
    }

    default public boolean hasContainerItem() {
        return this.getStack().func_77973_b().hasContainerItem(this.getStack());
    }

    default public int getBurnTime() {
        return this.getStack().func_77973_b().getBurnTime(this.getStack());
    }

    default public int getHarvestLevel(ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState state) {
        return this.getStack().func_77973_b().getHarvestLevel(this.getStack(), tool, player, state);
    }

    default public Set<ToolType> getToolTypes() {
        return this.getStack().func_77973_b().getToolTypes(this.getStack());
    }

    default public ActionResultType onItemUseFirst(ItemUseContext context) {
        PlayerEntity entityplayer = context.func_195999_j();
        BlockPos blockpos = context.func_195995_a();
        CachedBlockInfo blockworldstate = new CachedBlockInfo((IWorldReader)context.func_195991_k(), blockpos, false);
        if (entityplayer != null && !entityplayer.field_71075_bZ.field_75099_e && !this.getStack().func_206847_b(context.func_195991_k().func_205772_D(), blockworldstate)) {
            return ActionResultType.PASS;
        }
        Item item = this.getStack().func_77973_b();
        ActionResultType enumactionresult = item.onItemUseFirst(this.getStack(), context);
        if (entityplayer != null && enumactionresult == ActionResultType.SUCCESS) {
            entityplayer.func_71029_a(Stats.field_75929_E.func_199076_b((Object)item));
        }
        return enumactionresult;
    }

    @Override
    default public CompoundNBT serializeNBT() {
        CompoundNBT ret = new CompoundNBT();
        this.getStack().func_77955_b(ret);
        return ret;
    }

    default public boolean onBlockStartBreak(BlockPos pos, PlayerEntity player) {
        return !this.getStack().func_190926_b() && this.getStack().func_77973_b().onBlockStartBreak(this.getStack(), pos, player);
    }

    default public boolean shouldCauseBlockBreakReset(ItemStack newStack) {
        return this.getStack().func_77973_b().shouldCauseBlockBreakReset(this.getStack(), newStack);
    }

    default public boolean canApplyAtEnchantingTable(Enchantment enchantment) {
        return this.getStack().func_77973_b().canApplyAtEnchantingTable(this.getStack(), enchantment);
    }

    default public int getItemEnchantability() {
        return this.getStack().func_77973_b().getItemEnchantability(this.getStack());
    }

    @Nullable
    default public EquipmentSlotType getEquipmentSlot() {
        return this.getStack().func_77973_b().getEquipmentSlot(this.getStack());
    }

    default public boolean canDisableShield(ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.getStack().func_77973_b().canDisableShield(this.getStack(), shield, entity, attacker);
    }

    default public boolean isShield(@Nullable LivingEntity entity) {
        return this.getStack().func_77973_b().isShield(this.getStack(), entity);
    }

    default public boolean onEntitySwing(LivingEntity entity) {
        return this.getStack().func_77973_b().onEntitySwing(this.getStack(), entity);
    }

    default public void onUsingTick(LivingEntity player, int count) {
        this.getStack().func_77973_b().onUsingTick(this.getStack(), player, count);
    }

    default public int getEntityLifespan(World world) {
        return this.getStack().func_77973_b().getEntityLifespan(this.getStack(), world);
    }

    default public boolean onEntityItemUpdate(ItemEntity entity) {
        return this.getStack().func_77973_b().onEntityItemUpdate(this.getStack(), entity);
    }

    default public float getXpRepairRatio() {
        return this.getStack().func_77973_b().getXpRepairRatio(this.getStack());
    }

    default public void onArmorTick(World world, PlayerEntity player) {
        this.getStack().func_77973_b().onArmorTick(this.getStack(), world, player);
    }

    default public void onHorseArmorTick(World world, MobEntity horse) {
        this.getStack().func_77973_b().onHorseArmorTick(this.getStack(), world, horse);
    }

    default public boolean canEquip(EquipmentSlotType armorType, Entity entity) {
        return this.getStack().func_77973_b().canEquip(this.getStack(), armorType, entity);
    }

    default public boolean isBookEnchantable(ItemStack book) {
        return this.getStack().func_77973_b().isBookEnchantable(this.getStack(), book);
    }

    default public boolean onDroppedByPlayer(PlayerEntity player) {
        return this.getStack().func_77973_b().onDroppedByPlayer(this.getStack(), player);
    }

    default public ITextComponent getHighlightTip(ITextComponent displayName) {
        return this.getStack().func_77973_b().getHighlightTip(this.getStack(), displayName);
    }

    @Nullable
    default public CompoundNBT getShareTag() {
        return this.getStack().func_77973_b().getShareTag(this.getStack());
    }

    default public void readShareTag(@Nullable CompoundNBT nbt) {
        this.getStack().func_77973_b().readShareTag(this.getStack(), nbt);
    }

    default public boolean doesSneakBypassUse(IWorldReader world, BlockPos pos, PlayerEntity player) {
        return this.getStack().func_190926_b() || this.getStack().func_77973_b().doesSneakBypassUse(this.getStack(), world, pos, player);
    }

    default public boolean areShareTagsEqual(ItemStack other) {
        CompoundNBT shareTagA = this.getStack().getShareTag();
        CompoundNBT shareTagB = other.getShareTag();
        if (shareTagA == null) {
            return shareTagB == null;
        }
        return shareTagB != null && shareTagA.equals((Object)shareTagB);
    }

    default public boolean equals(ItemStack other, boolean limitTags) {
        if (this.getStack().func_190926_b()) {
            return other.func_190926_b();
        }
        return !other.func_190926_b() && this.getStack().func_190916_E() == other.func_190916_E() && this.getStack().func_77973_b() == other.func_77973_b() && (limitTags ? this.getStack().areShareTagsEqual(other) : ItemStack.func_77970_a((ItemStack)this.getStack(), (ItemStack)other));
    }

    default public boolean isRepairable() {
        return this.getStack().func_77973_b().isRepairable(this.getStack());
    }

    default public boolean isPiglinCurrency() {
        return this.getStack().func_77973_b().isPiglinCurrency(this.getStack());
    }

    default public boolean makesPiglinsNeutral(LivingEntity wearer) {
        return this.getStack().func_77973_b().makesPiglinsNeutral(this.getStack(), wearer);
    }

    default public boolean isEnderMask(PlayerEntity player, EndermanEntity endermanEntity) {
        return this.getStack().func_77973_b().isEnderMask(this.getStack(), player, endermanEntity);
    }

    default public boolean canElytraFly(LivingEntity entity) {
        return this.getStack().func_77973_b().canElytraFly(this.getStack(), entity);
    }

    default public boolean elytraFlightTick(LivingEntity entity, int flightTicks) {
        return this.getStack().func_77973_b().elytraFlightTick(this.getStack(), entity, flightTicks);
    }
}

