/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.generators.loaders;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.MultiLayerModel;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class MultiLayerModelBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private final Map<String, T> childModels = new LinkedHashMap<String, T>();

    public static <T extends ModelBuilder<T>> MultiLayerModelBuilder<T> begin(T parent, ExistingFileHelper existingFileHelper) {
        return new MultiLayerModelBuilder<T>(parent, existingFileHelper);
    }

    protected MultiLayerModelBuilder(T parent, ExistingFileHelper existingFileHelper) {
        super(new ResourceLocation("forge:multi-layer"), parent, existingFileHelper);
    }

    public MultiLayerModelBuilder<T> submodel(RenderType layer, T modelBuilder) {
        Preconditions.checkNotNull((Object)layer, (Object)"layer must not be null");
        Preconditions.checkArgument((boolean)MultiLayerModel.Loader.BLOCK_LAYERS.containsValue((Object)layer), (Object)"layer must be supported by MultiLayerModel");
        Preconditions.checkNotNull(modelBuilder, (Object)"modelBuilder must not be null");
        this.childModels.put((String)MultiLayerModel.Loader.BLOCK_LAYERS.inverse().get((Object)layer), modelBuilder);
        return this;
    }

    @Override
    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        JsonObject parts = new JsonObject();
        for (Map.Entry<String, T> entry : this.childModels.entrySet()) {
            parts.add(entry.getKey(), (JsonElement)((ModelBuilder)entry.getValue()).toJson());
        }
        json.add("layers", (JsonElement)parts);
        return json;
    }
}

