/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistryCodec;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.LenientUnboundedMapCodec;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleRegistry<T>
extends MutableRegistry<T> {
    protected static final Logger field_148743_a = LogManager.getLogger();
    private final ObjectList<T> field_243533_bf = new ObjectArrayList(256);
    private final Object2IntMap<T> field_243534_bg = new Object2IntOpenCustomHashMap(Util.func_212443_g());
    private final BiMap<ResourceLocation, T> field_82596_a;
    private final BiMap<RegistryKey<T>, T> field_239649_bb_;
    private final Map<T, Lifecycle> field_243535_bj;
    private Lifecycle field_243536_bk;
    protected Object[] field_186802_b;
    private int field_195869_d;

    public SimpleRegistry(RegistryKey<? extends Registry<T>> registryKey, Lifecycle lifecycle) {
        super(registryKey, lifecycle);
        this.field_243534_bg.defaultReturnValue(-1);
        this.field_82596_a = HashBiMap.create();
        this.field_239649_bb_ = HashBiMap.create();
        this.field_243535_bj = Maps.newIdentityHashMap();
        this.field_243536_bk = lifecycle;
    }

    public static <T> MapCodec<Entry<T>> func_243541_a(RegistryKey<? extends Registry<T>> registryKey, MapCodec<T> mapCodec) {
        return RecordCodecBuilder.mapCodec(p_243542_2_ -> p_243542_2_.group((App)ResourceLocation.field_240908_a_.xmap(RegistryKey.func_240902_a_(registryKey), RegistryKey::func_240901_a_).fieldOf("name").forGetter(p_243545_0_ -> p_243545_0_.field_243546_a), (App)Codec.INT.fieldOf("id").forGetter(p_243543_0_ -> p_243543_0_.field_243547_b), (App)mapCodec.forGetter(p_243538_0_ -> p_243538_0_.field_243548_c)).apply((Applicative)p_243542_2_, Entry::new));
    }

    public <V extends T> V func_218382_a(int id, RegistryKey<T> name, V instance, Lifecycle lifecycle) {
        return this.func_243537_a(id, name, instance, lifecycle, true);
    }

    private <V extends T> V func_243537_a(int index, RegistryKey<T> registryKey, V value, Lifecycle lifecycle, boolean logDuplicateKeys) {
        Validate.notNull(registryKey);
        Validate.notNull(value);
        this.field_243533_bf.size(Math.max(this.field_243533_bf.size(), index + 1));
        this.field_243533_bf.set(index, value);
        this.field_243534_bg.put(value, index);
        this.field_186802_b = null;
        if (logDuplicateKeys && this.field_239649_bb_.containsKey(registryKey)) {
            field_148743_a.debug("Adding duplicate key '{}' to registry", registryKey);
        }
        if (this.field_82596_a.containsValue(value)) {
            field_148743_a.error("Adding duplicate value '{}' to registry", value);
        }
        this.field_82596_a.put((Object)registryKey.func_240901_a_(), value);
        this.field_239649_bb_.put(registryKey, value);
        this.field_243535_bj.put(value, lifecycle);
        this.field_243536_bk = this.field_243536_bk.add(lifecycle);
        if (this.field_195869_d <= index) {
            this.field_195869_d = index + 1;
        }
        return value;
    }

    public <V extends T> V func_218381_a(RegistryKey<T> name, V instance, Lifecycle lifecycle) {
        return this.func_218382_a(this.field_195869_d, name, instance, lifecycle);
    }

    public <V extends T> V func_241874_a(OptionalInt index, RegistryKey<T> registryKey, V value, Lifecycle lifecycle) {
        int i;
        Validate.notNull(registryKey);
        Validate.notNull(value);
        Object t = this.field_239649_bb_.get(registryKey);
        if (t == null) {
            i = index.isPresent() ? index.getAsInt() : this.field_195869_d;
        } else {
            i = this.field_243534_bg.getInt(t);
            if (index.isPresent() && index.getAsInt() != i) {
                throw new IllegalStateException("ID mismatch");
            }
            this.field_243534_bg.removeInt(t);
            this.field_243535_bj.remove(t);
        }
        return this.func_243537_a(i, registryKey, value, lifecycle, false);
    }

    @Nullable
    public ResourceLocation func_177774_c(T value) {
        return (ResourceLocation)this.field_82596_a.inverse().get(value);
    }

    public Optional<RegistryKey<T>> func_230519_c_(T value) {
        return Optional.ofNullable(this.field_239649_bb_.inverse().get(value));
    }

    public int func_148757_b(@Nullable T value) {
        return this.field_243534_bg.getInt(value);
    }

    @Nullable
    public T func_230516_a_(@Nullable RegistryKey<T> key) {
        return (T)this.field_239649_bb_.get(key);
    }

    @Nullable
    public T func_148745_a(int value) {
        return (T)(value >= 0 && value < this.field_243533_bf.size() ? this.field_243533_bf.get(value) : null);
    }

    public Lifecycle func_241876_d(T object) {
        return this.field_243535_bj.get(object);
    }

    public Lifecycle func_241875_b() {
        return this.field_243536_bk;
    }

    public Iterator<T> iterator() {
        return Iterators.filter((Iterator)this.field_243533_bf.iterator(), Objects::nonNull);
    }

    @Nullable
    public T func_82594_a(@Nullable ResourceLocation name) {
        return (T)this.field_82596_a.get((Object)name);
    }

    public Set<ResourceLocation> func_148742_b() {
        return Collections.unmodifiableSet(this.field_82596_a.keySet());
    }

    public Set<Map.Entry<RegistryKey<T>, T>> func_239659_c_() {
        return Collections.unmodifiableMap(this.field_239649_bb_).entrySet();
    }

    @Nullable
    public T func_186801_a(Random random) {
        if (this.field_186802_b == null) {
            Set collection = this.field_82596_a.values();
            if (collection.isEmpty()) {
                return null;
            }
            this.field_186802_b = collection.toArray(new Object[collection.size()]);
        }
        return (T)Util.func_240989_a_(this.field_186802_b, random);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_212607_c(ResourceLocation name) {
        return this.field_82596_a.containsKey((Object)name);
    }

    public static <T> Codec<SimpleRegistry<T>> func_243539_a(RegistryKey<? extends Registry<T>> registryKey, Lifecycle lifecycle, Codec<T> codec) {
        return SimpleRegistry.func_243541_a(registryKey, codec.fieldOf("element")).codec().listOf().xmap(p_243540_2_ -> {
            SimpleRegistry simpleregistry = new SimpleRegistry(registryKey, lifecycle);
            for (Entry entry : p_243540_2_) {
                simpleregistry.func_218382_a(entry.field_243547_b, entry.field_243546_a, entry.field_243548_c, lifecycle);
            }
            return simpleregistry;
        }, p_243544_0_ -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            Iterator iterator = p_243544_0_.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                builder.add(new Entry(p_243544_0_.func_230519_c_(t).get(), p_243544_0_.func_148757_b(t), t));
            }
            return builder.build();
        });
    }

    public static <T> Codec<SimpleRegistry<T>> func_241744_b_(RegistryKey<? extends Registry<T>> registryKey, Lifecycle lifecycle, Codec<T> mapCodec) {
        return SimpleRegistryCodec.func_241793_a_(registryKey, (Lifecycle)lifecycle, mapCodec);
    }

    public static <T> Codec<SimpleRegistry<T>> func_241745_c_(RegistryKey<? extends Registry<T>> registryKey, Lifecycle lifecycle, Codec<T> mapCodec) {
        return new LenientUnboundedMapCodec(ResourceLocation.field_240908_a_.xmap(RegistryKey.func_240902_a_(registryKey), RegistryKey::func_240901_a_), mapCodec).xmap(p_239656_2_ -> {
            SimpleRegistry simpleregistry = new SimpleRegistry(registryKey, lifecycle);
            p_239656_2_.forEach((p_239653_2_, p_239653_3_) -> simpleregistry.func_218381_a((RegistryKey)p_239653_2_, (Object)p_239653_3_, lifecycle));
            return simpleregistry;
        }, p_239651_0_ -> ImmutableMap.copyOf(p_239651_0_.field_239649_bb_));
    }

    public static class Entry<T> {
        public final RegistryKey<T> field_243546_a;
        public final int field_243547_b;
        public final T field_243548_c;

        public Entry(RegistryKey<T> name, int index, T value) {
            this.field_243546_a = name;
            this.field_243547_b = index;
            this.field_243548_c = value;
        }
    }
}

