/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.PackLoadingManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.ResourcePackList;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PackScreen
extends Screen {
    private static final Logger field_238883_a_ = LogManager.getLogger();
    private static final ITextComponent field_238884_b_ = new TranslationTextComponent("pack.dropInfo").func_240699_a_(TextFormatting.GRAY);
    private static final ITextComponent field_238885_c_ = new TranslationTextComponent("pack.folderInfo");
    private static final ResourceLocation field_243391_p = new ResourceLocation("textures/misc/unknown_pack.png");
    private final PackLoadingManager field_238887_q_;
    private final Screen field_238888_r_;
    @Nullable
    private PackDirectoryWatcher field_243392_s;
    private long field_243393_t;
    private ResourcePackList field_238891_u_;
    private ResourcePackList field_238892_v_;
    private final File field_241817_w_;
    private Button field_238894_x_;
    private final Map<String, ResourceLocation> field_243394_y = Maps.newHashMap();

    public PackScreen(Screen p_i242060_1_, net.minecraft.resources.ResourcePackList p_i242060_2_, Consumer<net.minecraft.resources.ResourcePackList> p_i242060_3_, File p_i242060_4_, ITextComponent p_i242060_5_) {
        super(p_i242060_5_);
        this.field_238888_r_ = p_i242060_1_;
        this.field_238887_q_ = new PackLoadingManager(this::func_238904_g_, this::func_243395_a, p_i242060_2_, p_i242060_3_);
        this.field_241817_w_ = p_i242060_4_;
        this.field_243392_s = PackDirectoryWatcher.func_243403_a(p_i242060_4_);
    }

    @Override
    public void func_231175_as__() {
        this.field_238887_q_.func_241618_c_();
        this.field_230706_i_.func_147108_a(this.field_238888_r_);
        this.func_243399_k();
    }

    private void func_243399_k() {
        if (this.field_243392_s != null) {
            try {
                this.field_243392_s.close();
                this.field_243392_s = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void func_231160_c_() {
        this.field_238894_x_ = this.func_230480_a_(new Button(this.field_230708_k_ / 2 + 4, this.field_230709_l_ - 48, 150, 20, DialogTexts.field_240632_c_, p_238903_1_ -> this.func_231175_as__()));
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 154, this.field_230709_l_ - 48, 150, 20, (ITextComponent)new TranslationTextComponent("pack.openFolder"), p_238896_1_ -> Util.func_110647_a().func_195641_a(this.field_241817_w_), (p_238897_1_, p_238897_2_, p_238897_3_, p_238897_4_) -> this.func_238652_a_(p_238897_2_, field_238885_c_, p_238897_3_, p_238897_4_)));
        this.field_238891_u_ = new ResourcePackList(this.field_230706_i_, 200, this.field_230709_l_, (ITextComponent)new TranslationTextComponent("pack.available.title"));
        this.field_238891_u_.func_230959_g_(this.field_230708_k_ / 2 - 4 - 200);
        this.field_230705_e_.add(this.field_238891_u_);
        this.field_238892_v_ = new ResourcePackList(this.field_230706_i_, 200, this.field_230709_l_, (ITextComponent)new TranslationTextComponent("pack.selected.title"));
        this.field_238892_v_.func_230959_g_(this.field_230708_k_ / 2 + 4);
        this.field_230705_e_.add(this.field_238892_v_);
        this.func_238906_l_();
    }

    @Override
    public void func_231023_e_() {
        if (this.field_243392_s != null) {
            try {
                if (this.field_243392_s.func_243402_a()) {
                    this.field_243393_t = 20L;
                }
            }
            catch (IOException ioexception) {
                field_238883_a_.warn("Failed to poll for directory {} changes, stopping", (Object)this.field_241817_w_);
                this.func_243399_k();
            }
        }
        if (this.field_243393_t > 0L && --this.field_243393_t == 0L) {
            this.func_238906_l_();
        }
    }

    private void func_238904_g_() {
        this.func_238899_a_(this.field_238892_v_, this.field_238887_q_.func_238869_b_());
        this.func_238899_a_(this.field_238891_u_, this.field_238887_q_.func_238865_a_());
        this.field_238894_x_.field_230693_o_ = !this.field_238892_v_.func_231039_at__().isEmpty();
    }

    private void func_238899_a_(ResourcePackList p_238899_1_, Stream<PackLoadingManager.IPack> p_238899_2_) {
        p_238899_1_.func_231039_at__().clear();
        p_238899_2_.filter(PackLoadingManager.IPack::notHidden).forEach(p_238898_2_ -> p_238899_1_.func_231039_at__().add(new ResourcePackList.ResourcePackEntry(this.field_230706_i_, p_238899_1_, (Screen)this, p_238898_2_)));
    }

    private void func_238906_l_() {
        this.field_238887_q_.func_241619_d_();
        this.func_238904_g_();
        this.field_243393_t = 0L;
        this.field_243394_y.clear();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_231165_f_(0);
        this.field_238891_u_.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.field_238892_v_.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        PackScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)8, (int)0xFFFFFF);
        PackScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)field_238884_b_, (int)(this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected static void func_238895_a_(Minecraft p_238895_0_, List<Path> p_238895_1_, Path p_238895_2_) {
        MutableBoolean mutableboolean = new MutableBoolean();
        p_238895_1_.forEach(p_238901_2_ -> {
            try (Stream<Path> stream = Files.walk(p_238901_2_, new FileVisitOption[0]);){
                stream.forEach(p_238900_3_ -> {
                    try {
                        Util.func_240984_a_(p_238901_2_.getParent(), p_238895_2_, p_238900_3_);
                    }
                    catch (IOException ioexception1) {
                        field_238883_a_.warn("Failed to copy datapack file  from {} to {}", p_238900_3_, (Object)p_238895_2_, (Object)ioexception1);
                        mutableboolean.setTrue();
                    }
                });
            }
            catch (IOException ioexception) {
                field_238883_a_.warn("Failed to copy datapack file from {} to {}", p_238901_2_, (Object)p_238895_2_);
                mutableboolean.setTrue();
            }
        });
        if (mutableboolean.isTrue()) {
            SystemToast.func_238539_c_((Minecraft)p_238895_0_, (String)p_238895_2_.toString());
        }
    }

    @Override
    public void func_230476_a_(List<Path> packs) {
        String s = packs.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
        this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(p_238902_2_ -> {
            if (p_238902_2_) {
                PackScreen.func_238895_a_(this.field_230706_i_, packs, this.field_241817_w_.toPath());
                this.func_238906_l_();
            }
            this.field_230706_i_.func_147108_a(this);
        }, (ITextComponent)new TranslationTextComponent("pack.dropConfirm"), (ITextComponent)new StringTextComponent(s)));
    }

    /*
     * Exception decompiling
     */
    private ResourceLocation func_243397_a(TextureManager p_243397_1_, ResourcePackInfo p_243397_2_) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ResourceLocation func_243395_a(ResourcePackInfo p_243395_1_) {
        return this.field_243394_y.computeIfAbsent(p_243395_1_.func_195790_f(), p_243396_2_ -> this.func_243397_a(this.field_230706_i_.func_110434_K(), p_243395_1_));
    }

    @OnlyIn(value=Dist.CLIENT)
    static class PackDirectoryWatcher
    implements AutoCloseable {
        private final WatchService field_243400_a;
        private final Path field_243401_b;

        public PackDirectoryWatcher(File p_i242061_1_) throws IOException {
            this.field_243401_b = p_i242061_1_.toPath();
            this.field_243400_a = this.field_243401_b.getFileSystem().newWatchService();
            try {
                this.func_243404_a(this.field_243401_b);
                try (DirectoryStream<Path> directorystream = Files.newDirectoryStream(this.field_243401_b);){
                    for (Path path : directorystream) {
                        if (!Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) continue;
                        this.func_243404_a(path);
                    }
                }
            }
            catch (Exception exception) {
                this.field_243400_a.close();
                throw exception;
            }
        }

        @Nullable
        public static PackDirectoryWatcher func_243403_a(File p_243403_0_) {
            try {
                return new PackDirectoryWatcher(p_243403_0_);
            }
            catch (IOException ioexception) {
                field_238883_a_.warn("Failed to initialize pack directory {} monitoring", (Object)p_243403_0_, (Object)ioexception);
                return null;
            }
        }

        private void func_243404_a(Path p_243404_1_) throws IOException {
            p_243404_1_.register(this.field_243400_a, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }

        public boolean func_243402_a() throws IOException {
            WatchKey watchkey;
            boolean flag = false;
            while ((watchkey = this.field_243400_a.poll()) != null) {
                for (WatchEvent<?> watchevent : watchkey.pollEvents()) {
                    Path path;
                    flag = true;
                    if (watchkey.watchable() != this.field_243401_b || watchevent.kind() != StandardWatchEventKinds.ENTRY_CREATE || !Files.isDirectory(path = this.field_243401_b.resolve((Path)watchevent.context()), LinkOption.NOFOLLOW_LINKS)) continue;
                    this.func_243404_a(path);
                }
                watchkey.reset();
            }
            return flag;
        }

        @Override
        public void close() throws IOException {
            this.field_243400_a.close();
        }
    }
}

