/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.jodah.typetools.TypeResolver;
import net.minecraftforge.eventbus.ASMEventHandler;
import net.minecraftforge.eventbus.EventBusErrorMessage;
import net.minecraftforge.eventbus.ListenerList;
import net.minecraftforge.eventbus.LogMarkers;
import net.minecraftforge.eventbus.NamedEventListener;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventListenerHelper;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.GenericEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.IEventBusInvokeDispatcher;
import net.minecraftforge.eventbus.api.IEventExceptionHandler;
import net.minecraftforge.eventbus.api.IEventListener;
import net.minecraftforge.eventbus.api.IGenericEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventBus
implements IEventExceptionHandler,
IEventBus {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean checkTypesOnDispatch = Boolean.parseBoolean(System.getProperty("eventbus.checkTypesOnDispatch", "false"));
    private static AtomicInteger maxID = new AtomicInteger(0);
    private final boolean trackPhases;
    private ConcurrentHashMap<Object, List<IEventListener>> listeners = new ConcurrentHashMap();
    private final int busID = maxID.getAndIncrement();
    private final IEventExceptionHandler exceptionHandler;
    private volatile boolean shutdown = false;
    private final Class<?> baseType;

    private EventBus() {
        ListenerList.resize(this.busID + 1);
        this.exceptionHandler = this;
        this.trackPhases = true;
        this.baseType = Event.class;
    }

    private EventBus(IEventExceptionHandler handler, boolean trackPhase, boolean startShutdown, Class<?> baseType) {
        ListenerList.resize(this.busID + 1);
        this.exceptionHandler = handler == null ? this : handler;
        this.trackPhases = trackPhase;
        this.shutdown = startShutdown;
        this.baseType = baseType;
    }

    public EventBus(BusBuilder busBuilder) {
        this(busBuilder.getExceptionHandler(), busBuilder.getTrackPhases(), busBuilder.isStartingShutdown(), busBuilder.getMarkerType());
    }

    private void registerClass(Class<?> clazz) {
        Arrays.stream(clazz.getMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> m.isAnnotationPresent(SubscribeEvent.class)).forEach(m -> this.registerListener(clazz, (Method)m, (Method)m));
    }

    private Optional<Method> getDeclMethod(Class<?> clz, Method in) {
        try {
            return Optional.of(clz.getDeclaredMethod(in.getName(), in.getParameterTypes()));
        }
        catch (NoSuchMethodException nse) {
            return Optional.empty();
        }
    }

    private void registerObject(Object obj) {
        HashSet classes = new HashSet();
        this.typesFor(obj.getClass(), classes);
        Arrays.stream(obj.getClass().getMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).forEach(m -> classes.stream().map(c -> this.getDeclMethod((Class<?>)c, (Method)m)).filter(rm -> rm.isPresent() && ((Method)rm.get()).isAnnotationPresent(SubscribeEvent.class)).findFirst().ifPresent(rm -> this.registerListener(obj, (Method)m, (Method)rm.get())));
    }

    private void typesFor(Class<?> clz, Set<Class<?>> visited) {
        if (clz.getSuperclass() == null) {
            return;
        }
        this.typesFor(clz.getSuperclass(), visited);
        Arrays.stream(clz.getInterfaces()).forEach(i -> this.typesFor((Class<?>)i, visited));
        visited.add(clz);
    }

    @Override
    public void register(Object target) {
        if (this.listeners.containsKey(target)) {
            return;
        }
        if (target.getClass() == Class.class) {
            this.registerClass((Class)target);
        } else {
            this.registerObject(target);
        }
    }

    private void registerListener(Object target, Method method, Method real) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation. It has " + parameterTypes.length + " arguments, but event handler methods require a single argument only.");
        }
        Class<?> eventType = parameterTypes[0];
        if (!Event.class.isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation, but takes an argument that is not an Event subtype : " + eventType);
        }
        if (this.baseType != Event.class && !this.baseType.isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation, but takes an argument that is not a subtype of the base type " + this.baseType + ": " + eventType);
        }
        this.register(eventType, target, real);
    }

    private <T extends Event> Predicate<T> passCancelled(boolean ignored) {
        return e -> ignored || !e.isCancelable() || !e.isCanceled();
    }

    private <T extends GenericEvent<? extends F>, F> Predicate<T> passGenericFilter(Class<F> type) {
        return e -> e.getGenericType() == type;
    }

    private void checkNotGeneric(Consumer<? extends Event> consumer) {
        this.checkNotGeneric(this.getEventClass(consumer));
    }

    private void checkNotGeneric(Class<? extends Event> eventType) {
        if (GenericEvent.class.isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("Cannot register a generic event listener with addListener, use addGenericListener");
        }
    }

    @Override
    public <T extends Event> void addListener(Consumer<T> consumer) {
        this.checkNotGeneric(consumer);
        this.addListener(EventPriority.NORMAL, consumer);
    }

    @Override
    public <T extends Event> void addListener(EventPriority priority, Consumer<T> consumer) {
        this.checkNotGeneric(consumer);
        this.addListener(priority, false, consumer);
    }

    @Override
    public <T extends Event> void addListener(EventPriority priority, boolean receiveCancelled, Consumer<T> consumer) {
        this.checkNotGeneric(consumer);
        this.addListener(priority, this.passCancelled(receiveCancelled), consumer);
    }

    @Override
    public <T extends Event> void addListener(EventPriority priority, boolean receiveCancelled, Class<T> eventType, Consumer<T> consumer) {
        this.checkNotGeneric(eventType);
        this.addListener(priority, this.passCancelled(receiveCancelled), eventType, consumer);
    }

    @Override
    public <T extends GenericEvent<? extends F>, F> void addGenericListener(Class<F> genericClassFilter, Consumer<T> consumer) {
        this.addGenericListener(genericClassFilter, EventPriority.NORMAL, consumer);
    }

    @Override
    public <T extends GenericEvent<? extends F>, F> void addGenericListener(Class<F> genericClassFilter, EventPriority priority, Consumer<T> consumer) {
        this.addGenericListener(genericClassFilter, priority, false, consumer);
    }

    @Override
    public <T extends GenericEvent<? extends F>, F> void addGenericListener(Class<F> genericClassFilter, EventPriority priority, boolean receiveCancelled, Consumer<T> consumer) {
        this.addListener(priority, this.passGenericFilter(genericClassFilter).and(this.passCancelled(receiveCancelled)), consumer);
    }

    @Override
    public <T extends GenericEvent<? extends F>, F> void addGenericListener(Class<F> genericClassFilter, EventPriority priority, boolean receiveCancelled, Class<T> eventType, Consumer<T> consumer) {
        this.addListener(priority, this.passGenericFilter(genericClassFilter).and(this.passCancelled(receiveCancelled)), eventType, consumer);
    }

    private <T extends Event> Class<T> getEventClass(Consumer<T> consumer) {
        Class eventClass = TypeResolver.resolveRawArgument(Consumer.class, consumer.getClass());
        if (eventClass == TypeResolver.Unknown.class) {
            LOGGER.error(LogMarkers.EVENTBUS, "Failed to resolve handler for \"{}\"", (Object)consumer.toString());
            throw new IllegalStateException("Failed to resolve consumer event type: " + consumer.toString());
        }
        return eventClass;
    }

    private <T extends Event> void addListener(EventPriority priority, Predicate<? super T> filter, Consumer<T> consumer) {
        Class<T> eventClass = this.getEventClass(consumer);
        if (Objects.equals(eventClass, Event.class)) {
            LOGGER.warn(LogMarkers.EVENTBUS, "Attempting to add a Lambda listener with computed generic type of Event. Are you sure this is what you meant? NOTE : there are complex lambda forms where the generic type information is erased and cannot be recovered at runtime.");
        }
        this.addListener(priority, filter, eventClass, consumer);
    }

    private <T extends Event> void addListener(EventPriority priority, Predicate<? super T> filter, Class<T> eventClass, Consumer<T> consumer) {
        if (this.baseType != Event.class && !this.baseType.isAssignableFrom(eventClass)) {
            throw new IllegalArgumentException("Listener for event " + eventClass + " takes an argument that is not a subtype of the base type " + this.baseType);
        }
        this.addToListeners(consumer, eventClass, NamedEventListener.namedWrapper(e -> this.doCastFilter(filter, eventClass, consumer, e), consumer.getClass()::getName), priority);
    }

    private <T extends Event> void doCastFilter(Predicate<? super T> filter, Class<T> eventClass, Consumer<T> consumer, Event e) {
        Event cast = e;
        if (filter.test(cast)) {
            consumer.accept(cast);
        }
    }

    private void register(Class<?> eventType, Object target, Method method) {
        try {
            ASMEventHandler asm = new ASMEventHandler(target, method, IGenericEvent.class.isAssignableFrom(eventType));
            this.addToListeners(target, eventType, asm, asm.getPriority());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error(LogMarkers.EVENTBUS, "Error registering event handler: {} {}", eventType, (Object)method, (Object)e);
        }
    }

    private void addToListeners(Object target, Class<?> eventType, IEventListener listener, EventPriority priority) {
        ListenerList listenerList = EventListenerHelper.getListenerList(eventType);
        listenerList.register(this.busID, priority, listener);
        List others = this.listeners.computeIfAbsent(target, k -> Collections.synchronizedList(new ArrayList()));
        others.add(listener);
    }

    @Override
    public void unregister(Object object) {
        List<IEventListener> list = this.listeners.remove(object);
        if (list == null) {
            return;
        }
        for (IEventListener listener : list) {
            ListenerList.unregisterAll(this.busID, listener);
        }
    }

    @Override
    public boolean post(Event event) {
        return this.post(event, IEventListener::invoke);
    }

    @Override
    public boolean post(Event event, IEventBusInvokeDispatcher wrapper) {
        int index;
        if (this.shutdown) {
            return false;
        }
        if (checkTypesOnDispatch && !this.baseType.isInstance(event)) {
            throw new IllegalArgumentException("Cannot post event of type " + event.getClass().getSimpleName() + " to this event. Must match type: " + this.baseType.getSimpleName());
        }
        IEventListener[] listeners = event.getListenerList().getListeners(this.busID);
        try {
            for (index = 0; index < listeners.length; ++index) {
                if (!this.trackPhases && Objects.equals(listeners[index].getClass(), EventPriority.class)) continue;
                wrapper.invoke(listeners[index], event);
            }
        }
        catch (Throwable throwable) {
            this.exceptionHandler.handleException(this, event, listeners, index, throwable);
            throw throwable;
        }
        return event.isCancelable() && event.isCanceled();
    }

    @Override
    public void handleException(IEventBus bus, Event event, IEventListener[] listeners, int index, Throwable throwable) {
        LOGGER.error(LogMarkers.EVENTBUS, () -> new EventBusErrorMessage(event, index, listeners, throwable));
    }

    @Override
    public void shutdown() {
        LOGGER.fatal(LogMarkers.EVENTBUS, "EventBus {} shutting down - future events will not be posted.", (Object)this.busID, (Object)new Exception("stacktrace"));
        this.shutdown = true;
    }

    @Override
    public void start() {
        this.shutdown = false;
    }
}

