/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.Size2i;
import net.minecraftforge.fml.ForgeI18n;
import net.minecraftforge.fml.MavenVersionStringHelper;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.client.ConfigGuiHandler;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.client.gui.widget.ModListWidget;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class ModListScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int PADDING = 6;
    private Screen parentScreen;
    private ModListWidget modList;
    private InfoPanel modInfo;
    private ModListWidget.ModEntry selected = null;
    private int listWidth;
    private List<ModInfo> mods;
    private final List<ModInfo> unsortedMods;
    private Button configButton;
    private Button openModsFolderButton;
    private int buttonMargin = 1;
    private int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private TextFieldWidget search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;

    private static String stripControlCodes(String value) {
        return StringUtils.func_76338_a((String)value);
    }

    public ModListScreen(Screen parentScreen) {
        super((ITextComponent)new TranslationTextComponent("fml.menu.mods.title"));
        this.parentScreen = parentScreen;
        this.mods = Collections.unmodifiableList(ModList.get().getMods());
        this.unsortedMods = Collections.unmodifiableList(this.mods);
    }

    public void func_231160_c_() {
        for (ModInfo mod : this.mods) {
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().func_78256_a(mod.getDisplayName()) + 10);
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().func_78256_a(MavenVersionStringHelper.artifactVersionToString(mod.getVersion())) + 5);
        }
        this.listWidth = Math.max(Math.min(this.listWidth, this.field_230708_k_ / 3), 100);
        this.listWidth += this.listWidth % this.numButtons != 0 ? this.numButtons - this.listWidth % this.numButtons : 0;
        int modInfoWidth = this.field_230708_k_ - this.listWidth - 18;
        int doneButtonWidth = Math.min(modInfoWidth, 200);
        int y = this.field_230709_l_ - 20 - 6;
        this.func_230480_a_((Widget)new Button((this.listWidth + 6 + this.field_230708_k_ - doneButtonWidth) / 2, y, doneButtonWidth, 20, (ITextComponent)new TranslationTextComponent("gui.done"), b -> this.func_231175_as__()));
        this.openModsFolderButton = new Button(6, y, this.listWidth, 20, (ITextComponent)new TranslationTextComponent("fml.menu.mods.openmodsfolder"), b -> Util.func_110647_a().func_195641_a(FMLPaths.MODSDIR.get().toFile()));
        this.func_230480_a_((Widget)this.openModsFolderButton);
        this.configButton = new Button(6, y -= 26, this.listWidth, 20, (ITextComponent)new TranslationTextComponent("fml.menu.mods.config"), b -> this.displayModConfig());
        this.func_230480_a_((Widget)this.configButton);
        this.configButton.field_230693_o_ = false;
        this.search = new TextFieldWidget(this.getFontRenderer(), 7, y -= 21, this.listWidth - 2, 14, (ITextComponent)new TranslationTextComponent("fml.menu.mods.search"));
        int fullButtonHeight = 32;
        int n = this.search.field_230691_m_;
        this.getFontRenderer().getClass();
        this.modList = new ModListWidget(this, this.listWidth, fullButtonHeight, n - 9 - 6);
        this.modList.func_230959_g_(6);
        this.modInfo = new InfoPanel(this.field_230706_i_, modInfoWidth, this.field_230709_l_ - 6 - fullButtonHeight, 6);
        this.field_230705_e_.add(this.search);
        this.field_230705_e_.add(this.modList);
        this.field_230705_e_.add(this.modInfo);
        this.search.func_146195_b(false);
        this.search.func_146205_d(true);
        int width = this.listWidth / this.numButtons;
        int x = 6;
        SortType.NORMAL.button = new Button(x, 6, width - this.buttonMargin, 20, SortType.NORMAL.getButtonText(), b -> this.resortMods(SortType.NORMAL));
        this.func_230480_a_((Widget)SortType.NORMAL.button);
        SortType.A_TO_Z.button = new Button(x += width + this.buttonMargin, 6, width - this.buttonMargin, 20, SortType.A_TO_Z.getButtonText(), b -> this.resortMods(SortType.A_TO_Z));
        this.func_230480_a_((Widget)SortType.A_TO_Z.button);
        SortType.Z_TO_A.button = new Button(x += width + this.buttonMargin, 6, width - this.buttonMargin, 20, SortType.Z_TO_A.getButtonText(), b -> this.resortMods(SortType.Z_TO_A));
        this.func_230480_a_((Widget)SortType.Z_TO_A.button);
        this.resortMods(SortType.NORMAL);
        this.updateCache();
    }

    private void displayModConfig() {
        if (this.selected == null) {
            return;
        }
        try {
            ConfigGuiHandler.getGuiFactoryFor(this.selected.getInfo()).map(f -> (Screen)f.apply(this.field_230706_i_, this)).ifPresent(newScreen -> this.field_230706_i_.func_147108_a(newScreen));
        }
        catch (Exception e) {
            LOGGER.error("There was a critical issue trying to build the config GUI for {}", (Object)this.selected.getInfo().getModId(), (Object)e);
        }
    }

    public void func_231023_e_() {
        this.search.func_146178_a();
        this.modList.func_241215_a_((AbstractList.AbstractListEntry)this.selected);
        if (!this.search.func_146179_b().equals(this.lastFilterText)) {
            this.reloadMods();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadMods();
            this.mods.sort(this.sortType);
            this.modList.refreshList();
            if (this.selected != null) {
                this.selected = this.modList.func_231039_at__().stream().filter(e -> e.getInfo() == this.selected.getInfo()).findFirst().orElse(null);
                this.updateCache();
            }
            this.sorted = true;
        }
    }

    public <T extends ExtendedList.AbstractListEntry<T>> void buildModList(Consumer<T> modListViewConsumer, Function<ModInfo, T> newEntry) {
        this.mods.forEach(mod -> modListViewConsumer.accept(newEntry.apply((ModInfo)mod)));
    }

    private void reloadMods() {
        this.mods = this.unsortedMods.stream().filter(mi -> net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)ModListScreen.stripControlCodes(mi.getDisplayName())).contains(net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)this.search.func_146179_b()))).collect(Collectors.toList());
        this.lastFilterText = this.search.func_146179_b();
    }

    private void resortMods(SortType newSort) {
        this.sortType = newSort;
        for (SortType sort : SortType.values()) {
            if (sort.button == null) continue;
            sort.button.field_230693_o_ = this.sortType != sort;
        }
        this.sorted = false;
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.modList.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        if (this.modInfo != null) {
            this.modInfo.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        }
        TranslationTextComponent text = new TranslationTextComponent("fml.menu.mods.search");
        int x = this.modList.getLeft() + (this.modList.getRight() - this.modList.getLeft()) / 2 - this.getFontRenderer().func_238414_a_((ITextProperties)text) / 2;
        FontRenderer fontRenderer = this.getFontRenderer();
        IReorderingProcessor iReorderingProcessor = text.func_241878_f();
        float f = x;
        int n = this.search.field_230691_m_;
        this.getFontRenderer().getClass();
        fontRenderer.func_238422_b_(mStack, iReorderingProcessor, f, (float)(n - 9), 0xFFFFFF);
        this.search.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
    }

    public Minecraft getMinecraftInstance() {
        return this.field_230706_i_;
    }

    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }

    public void setSelected(ModListWidget.ModEntry entry) {
        this.selected = entry == this.selected ? null : entry;
        this.updateCache();
    }

    private void updateCache() {
        if (this.selected == null) {
            this.configButton.field_230693_o_ = false;
            this.modInfo.clearInfo();
            return;
        }
        final ModInfo selectedMod = this.selected.getInfo();
        this.configButton.field_230693_o_ = ConfigGuiHandler.getGuiFactoryFor(selectedMod).isPresent();
        ArrayList<String> lines = new ArrayList<String>();
        VersionChecker.CheckResult vercheck = VersionChecker.getResult((IModInfo)selectedMod);
        Pair logoData = selectedMod.getLogoFile().map(logoFile -> {
            TextureManager tm = this.field_230706_i_.func_110434_K();
            ModFileResourcePack resourcePack = ResourcePackLoader.getResourcePackFor(selectedMod.getModId()).orElse(ResourcePackLoader.getResourcePackFor("forge").orElseThrow(() -> new RuntimeException("Can't find forge, WHAT!")));
            try {
                NativeImage logo = null;
                InputStream logoResource = resourcePack.func_195763_b((String)logoFile);
                if (logoResource != null) {
                    logo = NativeImage.func_195713_a((InputStream)logoResource);
                }
                if (logo != null) {
                    return Pair.of((Object)tm.func_110578_a("modlogo", new DynamicTexture(logo){

                        public void func_110564_a() {
                            this.func_229148_d_();
                            NativeImage td = this.func_195414_e();
                            this.func_195414_e().func_227789_a_(0, 0, 0, 0, 0, td.func_195702_a(), td.func_195714_b(), selectedMod.getLogoBlur(), false, false, false);
                        }
                    }), (Object)new Size2i(logo.func_195702_a(), logo.func_195714_b()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Pair.of(null, (Object)new Size2i(0, 0));
        }).orElse(Pair.of(null, (Object)new Size2i(0, 0)));
        lines.add(selectedMod.getDisplayName());
        lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.version", MavenVersionStringHelper.artifactVersionToString(selectedMod.getVersion())));
        lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.idstate", selectedMod.getModId(), ModList.get().getModContainerById(selectedMod.getModId()).map(ModContainer::getCurrentState).map(Object::toString).orElse("NONE")));
        selectedMod.getConfigElement(new String[]{"credits"}).ifPresent(credits -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.credits", credits)));
        selectedMod.getConfigElement(new String[]{"authors"}).ifPresent(authors -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.authors", authors)));
        selectedMod.getConfigElement(new String[]{"displayURL"}).ifPresent(displayURL -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.displayurl", displayURL)));
        if (selectedMod.getOwningFile() == null || selectedMod.getOwningFile().getMods().size() == 1) {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.nochildmods", new Object[0]));
        } else {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.childmods", selectedMod.getOwningFile().getMods().stream().map(IModInfo::getDisplayName).collect(Collectors.joining(","))));
        }
        if (vercheck.status == VersionChecker.Status.OUTDATED || vercheck.status == VersionChecker.Status.BETA_OUTDATED) {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.updateavailable", vercheck.url == null ? "" : vercheck.url));
        }
        lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.license", selectedMod.getOwningFile().getLicense()));
        lines.add(null);
        lines.add(selectedMod.getDescription());
        if ((vercheck.status == VersionChecker.Status.OUTDATED || vercheck.status == VersionChecker.Status.BETA_OUTDATED) && vercheck.changes.size() > 0) {
            lines.add(null);
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.changelogheader", new Object[0]));
            for (Map.Entry<ComparableVersion, String> entry : vercheck.changes.entrySet()) {
                lines.add("  " + entry.getKey() + ":");
                lines.add(entry.getValue());
                lines.add(null);
            }
        }
        this.modInfo.setInfo(lines, (ResourceLocation)logoData.getLeft(), (Size2i)logoData.getRight());
    }

    public void func_231152_a_(Minecraft mc, int width, int height) {
        String s = this.search.func_146179_b();
        SortType sort = this.sortType;
        ModListWidget.ModEntry selected = this.selected;
        this.func_231158_b_(mc, width, height);
        this.search.func_146180_a(s);
        this.selected = selected;
        if (!this.search.func_146179_b().isEmpty()) {
            this.reloadMods();
        }
        if (sort != SortType.NORMAL) {
            this.resortMods(sort);
        }
        this.updateCache();
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(this.parentScreen);
    }

    class InfoPanel
    extends ScrollPanel {
        private ResourceLocation logoPath;
        private Size2i logoDims;
        private List<IReorderingProcessor> lines;

        InfoPanel(Minecraft mcIn, int widthIn, int heightIn, int topIn) {
            super(mcIn, widthIn, heightIn, topIn, ModListScreen.this.modList.getRight() + 6);
            this.logoDims = new Size2i(0, 0);
            this.lines = Collections.emptyList();
        }

        void setInfo(List<String> lines, ResourceLocation logoPath, Size2i logoDims) {
            this.logoPath = logoPath;
            this.logoDims = logoDims;
            this.lines = this.resizeContent(lines);
        }

        void clearInfo() {
            this.logoPath = null;
            this.logoDims = new Size2i(0, 0);
            this.lines = Collections.emptyList();
        }

        private List<IReorderingProcessor> resizeContent(List<String> lines) {
            ArrayList<IReorderingProcessor> ret = new ArrayList<IReorderingProcessor>();
            for (String line : lines) {
                if (line == null) {
                    ret.add(null);
                    continue;
                }
                ITextComponent chat = ForgeHooks.newChatWithLinks(line, false);
                int maxTextLength = this.width - 12;
                if (maxTextLength < 0) continue;
                ret.addAll(LanguageMap.func_74808_a().func_244260_a(ModListScreen.this.field_230712_o_.func_238420_b_().func_238362_b_((ITextProperties)chat, maxTextLength, Style.field_240709_b_)));
            }
            return ret;
        }

        @Override
        public int getContentHeight() {
            int height = 50;
            int n = this.lines.size();
            ModListScreen.this.field_230712_o_.getClass();
            if ((height += n * 9) < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        @Override
        protected int getScrollAmount() {
            ModListScreen.this.field_230712_o_.getClass();
            return 9 * 3;
        }

        @Override
        protected void drawPanel(MatrixStack mStack, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
            if (this.logoPath != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.logoPath);
                RenderSystem.enableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int headerHeight = 50;
                GuiUtils.drawInscribedRect(mStack, this.left + 6, relativeY, this.width - 12, headerHeight, this.logoDims.width, this.logoDims.height, false, true);
                relativeY += headerHeight + 6;
            }
            for (IReorderingProcessor line : this.lines) {
                if (line != null) {
                    RenderSystem.enableBlend();
                    ModListScreen.this.field_230712_o_.func_238407_a_(mStack, line, (float)(this.left + 6), (float)relativeY, 0xFFFFFF);
                    RenderSystem.disableAlphaTest();
                    RenderSystem.disableBlend();
                }
                ModListScreen.this.field_230712_o_.getClass();
                relativeY += 9;
            }
            Style component = this.findTextLine(mouseX, mouseY);
            if (component != null) {
                ModListScreen.this.func_238653_a_(mStack, component, mouseX, mouseY);
            }
        }

        private Style findTextLine(int mouseX, int mouseY) {
            double offset = (float)(mouseY - this.top + 4) + this.scrollDistance + 1.0f;
            if (this.logoPath != null) {
                offset -= 50.0;
            }
            if (offset <= 0.0) {
                return null;
            }
            ModListScreen.this.field_230712_o_.getClass();
            int lineIdx = (int)(offset / 9.0);
            if (lineIdx >= this.lines.size() || lineIdx < 1) {
                return null;
            }
            IReorderingProcessor line = this.lines.get(lineIdx - 1);
            if (line != null) {
                return ModListScreen.this.field_230712_o_.func_238420_b_().func_243239_a(line, mouseX - this.left - 4);
            }
            return null;
        }

        @Override
        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            Style component = this.findTextLine((int)mouseX, (int)mouseY);
            if (component != null) {
                ModListScreen.this.func_230455_a_(component);
                return true;
            }
            return super.func_231044_a_(mouseX, mouseY, button);
        }

        @Override
        protected void drawBackground() {
        }
    }

    private static enum SortType implements Comparator<ModInfo>
    {
        NORMAL,
        A_TO_Z{

            @Override
            protected int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        }
        ,
        Z_TO_A{

            @Override
            protected int compare(String name1, String name2) {
                return name2.compareTo(name1);
            }
        };

        Button button;

        @Override
        protected int compare(String name1, String name2) {
            return 0;
        }

        @Override
        public int compare(ModInfo o1, ModInfo o2) {
            String name1 = net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)ModListScreen.stripControlCodes(o1.getDisplayName()));
            String name2 = net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)ModListScreen.stripControlCodes(o2.getDisplayName()));
            return this.compare(name1, name2);
        }

        ITextComponent getButtonText() {
            return new TranslationTextComponent("fml.menu.mods." + net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)this.name()));
        }
    }
}

