/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HoneyBlock;
import net.minecraft.block.PortalInfo;
import net.minecraft.block.PortalSize;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.PushReaction;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.Mirror;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.extensions.IForgeEntity;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Entity
extends CapabilityProvider<Entity>
implements INameable,
ICommandSource,
IForgeEntity {
    protected static final Logger field_184243_a = LogManager.getLogger();
    private static final AtomicInteger field_213331_b = new AtomicInteger();
    private static final List<ItemStack> field_190535_b = Collections.emptyList();
    private static final AxisAlignedBB field_174836_a = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static double field_70155_l = 1.0;
    @Deprecated
    private final EntityType<?> field_200606_g;
    private int field_145783_c = field_213331_b.incrementAndGet();
    public boolean field_70156_m;
    private final List<Entity> field_184244_h = Lists.newArrayList();
    protected int field_184245_j;
    @Nullable
    private Entity field_184239_as;
    public boolean field_98038_p;
    public World field_70170_p;
    public double field_70169_q;
    public double field_70167_r;
    public double field_70166_s;
    private Vector3d field_233557_ao_;
    private BlockPos field_233558_ap_;
    private Vector3d field_213327_at = Vector3d.field_186680_a;
    public float field_70177_z;
    public float field_70125_A;
    public float field_70126_B;
    public float field_70127_C;
    private AxisAlignedBB field_70121_D = field_174836_a;
    protected boolean field_70122_E;
    public boolean field_70123_F;
    public boolean field_70124_G;
    public boolean field_70133_I;
    protected Vector3d field_213328_B = Vector3d.field_186680_a;
    @Deprecated
    public boolean field_70128_L;
    public float field_70141_P;
    public float field_70140_Q;
    public float field_82151_R;
    public float field_70143_R;
    private float field_70150_b = 1.0f;
    private float field_191959_ay = 1.0f;
    public double field_70142_S;
    public double field_70137_T;
    public double field_70136_U;
    public float field_70138_W;
    public boolean field_70145_X;
    public float field_70144_Y;
    protected final Random field_70146_Z = new Random();
    public int field_70173_aa;
    private int field_190534_ay = -this.func_190531_bD();
    protected boolean field_70171_ac;
    protected Object2DoubleMap<ITag<Fluid>> field_233554_M_ = new Object2DoubleArrayMap(2);
    protected boolean field_205013_W;
    @Nullable
    protected ITag<Fluid> field_241335_O_;
    public int field_70172_ad;
    protected boolean field_70148_d = true;
    protected final EntityDataManager field_70180_af;
    protected static final DataParameter<Byte> field_184240_ax = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Integer> field_184241_ay = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Optional<ITextComponent>> field_184242_az = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_200544_f);
    private static final DataParameter<Boolean> field_184233_aA = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_184234_aB = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_189655_aD = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_187198_h);
    protected static final DataParameter<Pose> field_213330_X = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_218815_s);
    public boolean field_70175_ag;
    public int field_70176_ah;
    public int field_70162_ai;
    public int field_70164_aj;
    private boolean field_233555_aA_;
    private Vector3d field_242272_av;
    public boolean field_70158_ak;
    public boolean field_70160_al;
    private int field_242273_aw;
    protected boolean field_71087_bX;
    protected int field_82153_h;
    protected BlockPos field_242271_ac;
    private boolean field_83001_bt;
    protected UUID field_96093_i = MathHelper.func_180182_a((Random)this.field_70146_Z);
    protected String field_189513_ar = this.field_96093_i.toString();
    protected boolean field_184238_ar;
    private final Set<String> field_184236_aF = Sets.newHashSet();
    private boolean field_184237_aG;
    private final double[] field_191505_aI = new double[]{0.0, 0.0, 0.0};
    private long field_191506_aJ;
    private EntitySize field_213325_aI;
    private float field_213326_aJ;
    private boolean canUpdate = true;
    private Collection<ItemEntity> captureDrops = null;
    private CompoundNBT persistentData;
    private boolean isAddedToWorld;

    public Entity(EntityType<?> p_i48580_1_, World p_i48580_2_) {
        super(Entity.class);
        this.field_200606_g = p_i48580_1_;
        this.field_70170_p = p_i48580_2_;
        this.field_213325_aI = p_i48580_1_.func_220334_j();
        this.field_233557_ao_ = Vector3d.field_186680_a;
        this.field_233558_ap_ = BlockPos.field_177992_a;
        this.field_242272_av = Vector3d.field_186680_a;
        this.func_70107_b(0.0, 0.0, 0.0);
        this.field_70180_af = new EntityDataManager(this);
        this.field_70180_af.func_187214_a(field_184240_ax, (byte)0);
        this.field_70180_af.func_187214_a(field_184241_ay, this.func_205010_bg());
        this.field_70180_af.func_187214_a(field_184233_aA, false);
        this.field_70180_af.func_187214_a(field_184242_az, Optional.empty());
        this.field_70180_af.func_187214_a(field_184234_aB, false);
        this.field_70180_af.func_187214_a(field_189655_aD, false);
        this.field_70180_af.func_187214_a(field_213330_X, Pose.STANDING);
        this.func_70088_a();
        EntityEvent.Size sizeEvent = ForgeEventFactory.getEntitySizeForge((Entity)this, (Pose)Pose.STANDING, (EntitySize)this.field_213325_aI, (float)this.func_213316_a(Pose.STANDING, this.field_213325_aI));
        this.field_213325_aI = sizeEvent.getNewSize();
        this.field_213326_aJ = sizeEvent.getNewEyeHeight();
        MinecraftForge.EVENT_BUS.post((Event)new EntityEvent.EntityConstructing(this));
        this.gatherCapabilities();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_242278_a(BlockPos p_242278_1_, BlockState p_242278_2_) {
        VoxelShape voxelshape = p_242278_2_.func_215685_b((IBlockReader)((Object)this.field_70170_p), p_242278_1_, ISelectionContext.func_216374_a(this));
        VoxelShape voxelshape1 = voxelshape.func_197751_a((double)p_242278_1_.func_177958_n(), (double)p_242278_1_.func_177956_o(), (double)p_242278_1_.func_177952_p());
        return VoxelShapes.func_197879_c((VoxelShape)voxelshape1, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)this.func_174813_aQ()), (IBooleanFunction)IBooleanFunction.field_223238_i_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_226263_P_() {
        Team team = this.func_96124_cp();
        return team != null && team.func_178775_l().func_211163_e() != null ? team.func_178775_l().func_211163_e() : 0xFFFFFF;
    }

    public boolean func_175149_v() {
        return false;
    }

    public final void func_213319_R() {
        if (this.func_184207_aI()) {
            this.func_184226_ay();
        }
        if (this.func_184218_aH()) {
            this.func_184210_p();
        }
    }

    public void func_213312_b(double p_213312_1_, double p_213312_3_, double p_213312_5_) {
        this.func_242277_a(new Vector3d(p_213312_1_, p_213312_3_, p_213312_5_));
    }

    public void func_242277_a(Vector3d p_242277_1_) {
        this.field_242272_av = p_242277_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_242274_V() {
        return this.field_242272_av;
    }

    public EntityType<?> func_200600_R() {
        return this.field_200606_g;
    }

    public int func_145782_y() {
        return this.field_145783_c;
    }

    public void func_145769_d(int p_145769_1_) {
        this.field_145783_c = p_145769_1_;
    }

    public Set<String> func_184216_O() {
        return this.field_184236_aF;
    }

    public boolean func_184211_a(String p_184211_1_) {
        return this.field_184236_aF.size() >= 1024 ? false : this.field_184236_aF.add(p_184211_1_);
    }

    public boolean func_184197_b(String p_184197_1_) {
        return this.field_184236_aF.remove(p_184197_1_);
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    protected abstract void func_70088_a();

    public EntityDataManager func_184212_Q() {
        return this.field_70180_af;
    }

    public boolean equals(Object p_equals_1_) {
        if (p_equals_1_ instanceof Entity) {
            return ((Entity)((Object)p_equals_1_)).field_145783_c == this.field_145783_c;
        }
        return false;
    }

    public int hashCode() {
        return this.field_145783_c;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void func_70065_x() {
        if (this.field_70170_p != null) {
            for (double d0 = this.func_226278_cu_(); d0 > 0.0 && d0 < 256.0; d0 += 1.0) {
                this.func_70107_b(this.func_226277_ct_(), d0, this.func_226281_cx_());
                if (this.field_70170_p.func_226669_j_(this)) break;
            }
            this.func_213317_d(Vector3d.field_186680_a);
            this.field_70125_A = 0.0f;
        }
    }

    public void func_70106_y() {
        this.remove(false);
    }

    public void remove(boolean keepData) {
        this.field_70128_L = true;
        if (!keepData) {
            this.invalidateCaps();
        }
    }

    public void func_213301_b(Pose p_213301_1_) {
        this.field_70180_af.func_187227_b(field_213330_X, p_213301_1_);
    }

    public Pose func_213283_Z() {
        return this.field_70180_af.func_187225_a(field_213330_X);
    }

    public boolean func_233562_a_(Entity p_233562_1_, double p_233562_2_) {
        double d2;
        double d1;
        double d0 = p_233562_1_.field_233557_ao_.field_72450_a - this.field_233557_ao_.field_72450_a;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217464_b(this);
        }
        return d0 * d0 + (d1 = p_233562_1_.field_233557_ao_.field_72448_b - this.field_233557_ao_.field_72448_b) * d1 + (d2 = p_233562_1_.field_233557_ao_.field_72449_c - this.field_233557_ao_.field_72449_c) * d2 < p_233562_2_ * p_233562_2_;
    }

    protected void func_70101_b(float p_70101_1_, float p_70101_2_) {
        this.field_70177_z = p_70101_1_ % 360.0f;
        this.field_70125_A = p_70101_2_ % 360.0f;
    }

    public void func_70107_b(double p_70107_1_, double p_70107_3_, double p_70107_5_) {
        this.func_226288_n_(p_70107_1_, p_70107_3_, p_70107_5_);
        this.func_174826_a(this.field_213325_aI.func_242285_a(p_70107_1_, p_70107_3_, p_70107_5_));
    }

    protected void func_226264_Z_() {
        this.func_70107_b(this.field_233557_ao_.field_72450_a, this.field_233557_ao_.field_72448_b, this.field_233557_ao_.field_72449_c);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_195049_a(double p_195049_1_, double p_195049_3_) {
        double d0 = p_195049_3_ * 0.15;
        double d1 = p_195049_1_ * 0.15;
        this.field_70125_A = (float)((double)this.field_70125_A + d0);
        this.field_70177_z = (float)((double)this.field_70177_z + d1);
        this.field_70125_A = MathHelper.func_76131_a((float)this.field_70125_A, (float)-90.0f, (float)90.0f);
        this.field_70127_C = (float)((double)this.field_70127_C + d0);
        this.field_70126_B = (float)((double)this.field_70126_B + d1);
        this.field_70127_C = MathHelper.func_76131_a((float)this.field_70127_C, (float)-90.0f, (float)90.0f);
        if (this.field_184239_as != null) {
            this.field_184239_as.func_184190_l(this);
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_225510_bt_());
        }
        this.func_70030_z();
    }

    public void func_70030_z() {
        this.field_70170_p.func_217381_Z().func_76320_a("entityBaseTick");
        if (this.func_184218_aH() && this.func_184187_bx().field_70128_L) {
            this.func_184210_p();
        }
        if (this.field_184245_j > 0) {
            --this.field_184245_j;
        }
        this.field_70141_P = this.field_70140_Q;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.func_213284_aV();
        if (this.func_230269_aK_()) {
            this.func_233569_aL_();
        }
        this.func_233566_aG_();
        this.func_205012_q();
        this.func_205343_av();
        if (this.field_70170_p.field_72995_K) {
            this.func_70066_B();
        } else if (this.field_190534_ay > 0) {
            if (this.func_230279_az_()) {
                this.func_241209_g_(this.field_190534_ay - 4);
                if (this.field_190534_ay < 0) {
                    this.func_70066_B();
                }
            } else {
                if (this.field_190534_ay % 20 == 0 && !this.func_180799_ab()) {
                    this.func_70097_a(DamageSource.field_76370_b, 1.0f);
                }
                this.func_241209_g_(this.field_190534_ay - 1);
            }
        }
        if (this.func_180799_ab()) {
            this.func_70044_A();
            this.field_70143_R *= 0.5f;
        }
        if (this.func_226278_cu_() < -64.0) {
            this.func_70076_C();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(0, this.field_190534_ay > 0);
        }
        this.field_70148_d = false;
        this.field_70170_p.func_217381_Z().func_76319_b();
    }

    public void func_242279_ag() {
        this.field_242273_aw = this.func_82147_ab();
    }

    public boolean func_242280_ah() {
        return this.field_242273_aw > 0;
    }

    protected void func_184173_H() {
        if (this.func_242280_ah()) {
            --this.field_242273_aw;
        }
    }

    public int func_82145_z() {
        return 0;
    }

    protected void func_70044_A() {
        if (!this.func_230279_az_()) {
            this.func_70015_d(15);
            this.func_70097_a(DamageSource.field_76371_c, 4.0f);
        }
    }

    public void func_70015_d(int p_70015_1_) {
        int i = p_70015_1_ * 20;
        if (this instanceof LivingEntity) {
            i = ProtectionEnchantment.func_92093_a((LivingEntity)((LivingEntity)this), (int)i);
        }
        if (this.field_190534_ay < i) {
            this.func_241209_g_(i);
        }
    }

    public void func_241209_g_(int p_241209_1_) {
        this.field_190534_ay = p_241209_1_;
    }

    public int func_223314_ad() {
        return this.field_190534_ay;
    }

    public void func_70066_B() {
        this.func_241209_g_(0);
    }

    protected void func_70076_C() {
        this.func_70106_y();
    }

    public boolean func_70038_c(double p_70038_1_, double p_70038_3_, double p_70038_5_) {
        return this.func_174809_b(this.func_174813_aQ().func_72317_d(p_70038_1_, p_70038_3_, p_70038_5_));
    }

    private boolean func_174809_b(AxisAlignedBB p_174809_1_) {
        return this.field_70170_p.func_226665_a__(this, p_174809_1_) && !this.field_70170_p.func_72953_d(p_174809_1_);
    }

    public void func_230245_c_(boolean p_230245_1_) {
        this.field_70122_E = p_230245_1_;
    }

    public boolean func_233570_aj_() {
        return this.field_70122_E;
    }

    public void func_213315_a(MoverType p_213315_1_, Vector3d p_213315_2_) {
        if (this.field_70145_X) {
            this.func_174826_a(this.func_174813_aQ().func_191194_a(p_213315_2_));
            this.func_174829_m();
        } else {
            Vector3d vector3d;
            if (p_213315_1_ == MoverType.PISTON && (p_213315_2_ = this.func_213308_a(p_213315_2_)).equals(Vector3d.field_186680_a)) {
                return;
            }
            this.field_70170_p.func_217381_Z().func_76320_a("move");
            if (this.field_213328_B.func_189985_c() > 1.0E-7) {
                p_213315_2_ = p_213315_2_.func_216369_h(this.field_213328_B);
                this.field_213328_B = Vector3d.field_186680_a;
                this.func_213317_d(Vector3d.field_186680_a);
            }
            if ((vector3d = this.func_213306_e(p_213315_2_ = this.func_225514_a_(p_213315_2_, p_213315_1_))).func_189985_c() > 1.0E-7) {
                this.func_174826_a(this.func_174813_aQ().func_191194_a(vector3d));
                this.func_174829_m();
            }
            this.field_70170_p.func_217381_Z().func_76319_b();
            this.field_70170_p.func_217381_Z().func_76320_a("rest");
            this.field_70123_F = !MathHelper.func_219806_b((double)p_213315_2_.field_72450_a, (double)vector3d.field_72450_a) || !MathHelper.func_219806_b((double)p_213315_2_.field_72449_c, (double)vector3d.field_72449_c);
            this.field_70124_G = p_213315_2_.field_72448_b != vector3d.field_72448_b;
            this.field_70122_E = this.field_70124_G && p_213315_2_.field_72448_b < 0.0;
            BlockPos blockpos = this.func_226268_ag_();
            BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
            this.func_184231_a(vector3d.field_72448_b, this.field_70122_E, blockstate, blockpos);
            Vector3d vector3d1 = this.func_213322_ci();
            if (p_213315_2_.field_72450_a != vector3d.field_72450_a) {
                this.func_213293_j(0.0, vector3d1.field_72448_b, vector3d1.field_72449_c);
            }
            if (p_213315_2_.field_72449_c != vector3d.field_72449_c) {
                this.func_213293_j(vector3d1.field_72450_a, vector3d1.field_72448_b, 0.0);
            }
            Block block = blockstate.func_177230_c();
            if (p_213315_2_.field_72448_b != vector3d.field_72448_b) {
                block.func_176216_a((IBlockReader)((Object)this.field_70170_p), this);
            }
            if (this.field_70122_E && !this.func_226271_bk_()) {
                block.func_176199_a(this.field_70170_p, blockpos, this);
            }
            if (this.func_225502_at_() && !this.func_184218_aH()) {
                double d0 = vector3d.field_72450_a;
                double d1 = vector3d.field_72448_b;
                double d2 = vector3d.field_72449_c;
                if (!block.func_203417_a(BlockTags.field_232878_as_)) {
                    d1 = 0.0;
                }
                this.field_70140_Q = (float)((double)this.field_70140_Q + (double)MathHelper.func_76133_a((double)Entity.func_213296_b(vector3d)) * 0.6);
                this.field_82151_R = (float)((double)this.field_82151_R + (double)MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2)) * 0.6);
                if (this.field_82151_R > this.field_70150_b && !blockstate.isAir((IBlockReader)((Object)this.field_70170_p), blockpos)) {
                    this.field_70150_b = this.func_203009_ad();
                    if (this.func_70090_H()) {
                        Entity entity = this.func_184207_aI() && this.func_184179_bs() != null ? this.func_184179_bs() : this;
                        float f = entity == this ? 0.35f : 0.4f;
                        Vector3d vector3d2 = entity.func_213322_ci();
                        float f1 = MathHelper.func_76133_a((double)(vector3d2.field_72450_a * vector3d2.field_72450_a * (double)0.2f + vector3d2.field_72448_b * vector3d2.field_72448_b + vector3d2.field_72449_c * vector3d2.field_72449_c * (double)0.2f)) * f;
                        if (f1 > 1.0f) {
                            f1 = 1.0f;
                        }
                        this.func_203006_d(f1);
                    } else {
                        this.func_180429_a(blockpos, blockstate);
                    }
                } else if (this.field_82151_R > this.field_191959_ay && this.func_191957_ae() && blockstate.isAir((IBlockReader)((Object)this.field_70170_p), blockpos)) {
                    this.field_191959_ay = this.func_191954_d(this.field_82151_R);
                }
            }
            try {
                this.func_145775_I();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Checking entity block collision");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
                this.func_85029_a(crashreportcategory);
                throw new ReportedException(crashreport);
            }
            float f2 = this.func_225515_ai_();
            this.func_213317_d(this.func_213322_ci().func_216372_d(f2, 1.0, f2));
            if (BlockPos.func_239581_a_((AxisAlignedBB)this.func_174813_aQ().func_186664_h(0.001)).noneMatch(p_233572_0_ -> {
                BlockState state = this.field_70170_p.func_180495_p((BlockPos)p_233572_0_);
                return state.func_235714_a_(BlockTags.field_232872_am_) || state.func_203425_a(Blocks.field_150353_l) || state.isBurning((IBlockReader)((Object)this.field_70170_p), (BlockPos)p_233572_0_);
            }) && this.field_190534_ay <= 0) {
                this.func_241209_g_(-this.func_190531_bD());
            }
            if (this.func_203008_ap() && this.func_70027_ad()) {
                this.func_184185_a(SoundEvents.field_187541_bC, 0.7f, 1.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                this.func_241209_g_(-this.func_190531_bD());
            }
            this.field_70170_p.func_217381_Z().func_76319_b();
        }
    }

    protected BlockPos func_226268_ag_() {
        BlockPos blockpos1;
        BlockState blockstate;
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_233557_ao_.field_72450_a);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)(this.field_233557_ao_.field_72448_b - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_233557_ao_.field_72449_c));
        if (this.field_70170_p.func_175623_d(blockpos) && (blockstate = this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).collisionExtendsVertically((IBlockReader)((Object)this.field_70170_p), blockpos1, this)) {
            return blockpos1;
        }
        return blockpos;
    }

    protected float func_226269_ah_() {
        float f = this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_177230_c().func_226892_n_();
        float f1 = this.field_70170_p.func_180495_p(this.func_226270_aj_()).func_177230_c().func_226892_n_();
        return (double)f == 1.0 ? f1 : f;
    }

    protected float func_225515_ai_() {
        Block block = this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_177230_c();
        float f = block.func_226891_m_();
        if (block != Blocks.field_150355_j && block != Blocks.field_203203_C) {
            return (double)f == 1.0 ? this.field_70170_p.func_180495_p(this.func_226270_aj_()).func_177230_c().func_226891_m_() : f;
        }
        return f;
    }

    protected BlockPos func_226270_aj_() {
        return new BlockPos(this.field_233557_ao_.field_72450_a, this.func_174813_aQ().field_72338_b - 0.5000001, this.field_233557_ao_.field_72449_c);
    }

    protected Vector3d func_225514_a_(Vector3d p_225514_1_, MoverType p_225514_2_) {
        return p_225514_1_;
    }

    protected Vector3d func_213308_a(Vector3d p_213308_1_) {
        if (p_213308_1_.func_189985_c() <= 1.0E-7) {
            return p_213308_1_;
        }
        long i = this.field_70170_p.func_82737_E();
        if (i != this.field_191506_aJ) {
            Arrays.fill(this.field_191505_aI, 0.0);
            this.field_191506_aJ = i;
        }
        if (p_213308_1_.field_72450_a != 0.0) {
            double d2 = this.func_213304_a(Direction.Axis.X, p_213308_1_.field_72450_a);
            return Math.abs(d2) <= (double)1.0E-5f ? Vector3d.field_186680_a : new Vector3d(d2, 0.0, 0.0);
        }
        if (p_213308_1_.field_72448_b != 0.0) {
            double d1 = this.func_213304_a(Direction.Axis.Y, p_213308_1_.field_72448_b);
            return Math.abs(d1) <= (double)1.0E-5f ? Vector3d.field_186680_a : new Vector3d(0.0, d1, 0.0);
        }
        if (p_213308_1_.field_72449_c != 0.0) {
            double d0 = this.func_213304_a(Direction.Axis.Z, p_213308_1_.field_72449_c);
            return Math.abs(d0) <= (double)1.0E-5f ? Vector3d.field_186680_a : new Vector3d(0.0, 0.0, d0);
        }
        return Vector3d.field_186680_a;
    }

    private double func_213304_a(Direction.Axis p_213304_1_, double p_213304_2_) {
        int i = p_213304_1_.ordinal();
        double d0 = MathHelper.func_151237_a((double)(p_213304_2_ + this.field_191505_aI[i]), (double)-0.51, (double)0.51);
        p_213304_2_ = d0 - this.field_191505_aI[i];
        this.field_191505_aI[i] = d0;
        return p_213304_2_;
    }

    private Vector3d func_213306_e(Vector3d p_213306_1_) {
        boolean flag3;
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        ISelectionContext iselectioncontext = ISelectionContext.func_216374_a(this);
        VoxelShape voxelshape = this.field_70170_p.func_175723_af().func_222521_a();
        Stream<Object> stream = VoxelShapes.func_197879_c((VoxelShape)voxelshape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb.func_186664_h(1.0E-7)), (IBooleanFunction)IBooleanFunction.field_223238_i_) ? Stream.empty() : Stream.of(voxelshape);
        Stream stream1 = this.field_70170_p.func_230318_c_(this, axisalignedbb.func_216361_a(p_213306_1_), p_233561_0_ -> true);
        ReuseableStream reuseablestream = new ReuseableStream(Stream.concat(stream1, stream));
        Vector3d vector3d = p_213306_1_.func_189985_c() == 0.0 ? p_213306_1_ : Entity.func_223307_a(this, p_213306_1_, axisalignedbb, this.field_70170_p, iselectioncontext, (ReuseableStream<VoxelShape>)reuseablestream);
        boolean flag = p_213306_1_.field_72450_a != vector3d.field_72450_a;
        boolean flag1 = p_213306_1_.field_72448_b != vector3d.field_72448_b;
        boolean flag2 = p_213306_1_.field_72449_c != vector3d.field_72449_c;
        boolean bl = flag3 = this.field_70122_E || flag1 && p_213306_1_.field_72448_b < 0.0;
        if (this.field_70138_W > 0.0f && flag3 && (flag || flag2)) {
            Vector3d vector3d3;
            Vector3d vector3d1 = Entity.func_223307_a(this, new Vector3d(p_213306_1_.field_72450_a, this.field_70138_W, p_213306_1_.field_72449_c), axisalignedbb, this.field_70170_p, iselectioncontext, (ReuseableStream<VoxelShape>)reuseablestream);
            Vector3d vector3d2 = Entity.func_223307_a(this, new Vector3d(0.0, this.field_70138_W, 0.0), axisalignedbb.func_72321_a(p_213306_1_.field_72450_a, 0.0, p_213306_1_.field_72449_c), this.field_70170_p, iselectioncontext, (ReuseableStream<VoxelShape>)reuseablestream);
            if (vector3d2.field_72448_b < (double)this.field_70138_W && Entity.func_213296_b(vector3d3 = Entity.func_223307_a(this, new Vector3d(p_213306_1_.field_72450_a, 0.0, p_213306_1_.field_72449_c), axisalignedbb.func_191194_a(vector3d2), this.field_70170_p, iselectioncontext, (ReuseableStream<VoxelShape>)reuseablestream).func_178787_e(vector3d2)) > Entity.func_213296_b(vector3d1)) {
                vector3d1 = vector3d3;
            }
            if (Entity.func_213296_b(vector3d1) > Entity.func_213296_b(vector3d)) {
                return vector3d1.func_178787_e(Entity.func_223307_a(this, new Vector3d(0.0, -vector3d1.field_72448_b + p_213306_1_.field_72448_b, 0.0), axisalignedbb.func_191194_a(vector3d1), this.field_70170_p, iselectioncontext, (ReuseableStream<VoxelShape>)reuseablestream));
            }
        }
        return vector3d;
    }

    public static double func_213296_b(Vector3d p_213296_0_) {
        return p_213296_0_.field_72450_a * p_213296_0_.field_72450_a + p_213296_0_.field_72449_c * p_213296_0_.field_72449_c;
    }

    public static Vector3d func_223307_a(@Nullable Entity p_223307_0_, Vector3d p_223307_1_, AxisAlignedBB p_223307_2_, World p_223307_3_, ISelectionContext p_223307_4_, ReuseableStream<VoxelShape> p_223307_5_) {
        boolean flag2;
        boolean flag = p_223307_1_.field_72450_a == 0.0;
        boolean flag1 = p_223307_1_.field_72448_b == 0.0;
        boolean bl = flag2 = p_223307_1_.field_72449_c == 0.0;
        if (!(flag && flag1 || flag && flag2 || flag1 && flag2)) {
            ReuseableStream reuseablestream = new ReuseableStream(Stream.concat(p_223307_5_.func_212761_a(), p_223307_3_.func_226666_b_(p_223307_0_, p_223307_2_.func_216361_a(p_223307_1_))));
            return Entity.func_223310_a(p_223307_1_, p_223307_2_, (ReuseableStream<VoxelShape>)reuseablestream);
        }
        return Entity.func_213313_a(p_223307_1_, p_223307_2_, (IWorldReader)((Object)p_223307_3_), p_223307_4_, p_223307_5_);
    }

    public static Vector3d func_223310_a(Vector3d p_223310_0_, AxisAlignedBB p_223310_1_, ReuseableStream<VoxelShape> p_223310_2_) {
        boolean flag;
        double d0 = p_223310_0_.field_72450_a;
        double d1 = p_223310_0_.field_72448_b;
        double d2 = p_223310_0_.field_72449_c;
        if (d1 != 0.0 && (d1 = VoxelShapes.func_212437_a((Direction.Axis)Direction.Axis.Y, (AxisAlignedBB)p_223310_1_, (Stream)p_223310_2_.func_212761_a(), (double)d1)) != 0.0) {
            p_223310_1_ = p_223310_1_.func_72317_d(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d0) < Math.abs(d2);
        if (flag && d2 != 0.0 && (d2 = VoxelShapes.func_212437_a((Direction.Axis)Direction.Axis.Z, (AxisAlignedBB)p_223310_1_, (Stream)p_223310_2_.func_212761_a(), (double)d2)) != 0.0) {
            p_223310_1_ = p_223310_1_.func_72317_d(0.0, 0.0, d2);
        }
        if (d0 != 0.0) {
            d0 = VoxelShapes.func_212437_a((Direction.Axis)Direction.Axis.X, (AxisAlignedBB)p_223310_1_, (Stream)p_223310_2_.func_212761_a(), (double)d0);
            if (!flag && d0 != 0.0) {
                p_223310_1_ = p_223310_1_.func_72317_d(d0, 0.0, 0.0);
            }
        }
        if (!flag && d2 != 0.0) {
            d2 = VoxelShapes.func_212437_a((Direction.Axis)Direction.Axis.Z, (AxisAlignedBB)p_223310_1_, (Stream)p_223310_2_.func_212761_a(), (double)d2);
        }
        return new Vector3d(d0, d1, d2);
    }

    public static Vector3d func_213313_a(Vector3d p_213313_0_, AxisAlignedBB p_213313_1_, IWorldReader p_213313_2_, ISelectionContext p_213313_3_, ReuseableStream<VoxelShape> p_213313_4_) {
        boolean flag;
        double d0 = p_213313_0_.field_72450_a;
        double d1 = p_213313_0_.field_72448_b;
        double d2 = p_213313_0_.field_72449_c;
        if (d1 != 0.0 && (d1 = VoxelShapes.func_216383_a((Direction.Axis)Direction.Axis.Y, (AxisAlignedBB)p_213313_1_, (IWorldReader)p_213313_2_, (double)d1, (ISelectionContext)p_213313_3_, (Stream)p_213313_4_.func_212761_a())) != 0.0) {
            p_213313_1_ = p_213313_1_.func_72317_d(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d0) < Math.abs(d2);
        if (flag && d2 != 0.0 && (d2 = VoxelShapes.func_216383_a((Direction.Axis)Direction.Axis.Z, (AxisAlignedBB)p_213313_1_, (IWorldReader)p_213313_2_, (double)d2, (ISelectionContext)p_213313_3_, (Stream)p_213313_4_.func_212761_a())) != 0.0) {
            p_213313_1_ = p_213313_1_.func_72317_d(0.0, 0.0, d2);
        }
        if (d0 != 0.0) {
            d0 = VoxelShapes.func_216383_a((Direction.Axis)Direction.Axis.X, (AxisAlignedBB)p_213313_1_, (IWorldReader)p_213313_2_, (double)d0, (ISelectionContext)p_213313_3_, (Stream)p_213313_4_.func_212761_a());
            if (!flag && d0 != 0.0) {
                p_213313_1_ = p_213313_1_.func_72317_d(d0, 0.0, 0.0);
            }
        }
        if (!flag && d2 != 0.0) {
            d2 = VoxelShapes.func_216383_a((Direction.Axis)Direction.Axis.Z, (AxisAlignedBB)p_213313_1_, (IWorldReader)p_213313_2_, (double)d2, (ISelectionContext)p_213313_3_, (Stream)p_213313_4_.func_212761_a());
        }
        return new Vector3d(d0, d1, d2);
    }

    protected float func_203009_ad() {
        return (int)this.field_82151_R + 1;
    }

    public void func_174829_m() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.func_226288_n_((axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0, axisalignedbb.field_72338_b, (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0);
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217464_b(this);
        }
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187549_bG;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187547_bF;
    }

    protected SoundEvent func_204208_ah() {
        return SoundEvents.field_187547_bF;
    }

    protected void func_145775_I() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        BlockPos blockpos = new BlockPos(axisalignedbb.field_72340_a + 0.001, axisalignedbb.field_72338_b + 0.001, axisalignedbb.field_72339_c + 0.001);
        BlockPos blockpos1 = new BlockPos(axisalignedbb.field_72336_d - 0.001, axisalignedbb.field_72337_e - 0.001, axisalignedbb.field_72334_f - 0.001);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        if (this.field_70170_p.func_175707_a(blockpos, blockpos1)) {
            for (int i = blockpos.func_177958_n(); i <= blockpos1.func_177958_n(); ++i) {
                for (int j = blockpos.func_177956_o(); j <= blockpos1.func_177956_o(); ++j) {
                    for (int k = blockpos.func_177952_p(); k <= blockpos1.func_177952_p(); ++k) {
                        blockpos$mutable.func_181079_c(i, j, k);
                        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
                        try {
                            blockstate.func_196950_a(this.field_70170_p, (BlockPos)blockpos$mutable, this);
                            this.func_191955_a(blockstate);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Colliding entity with block");
                            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being collided with");
                            CrashReportCategory.func_175750_a(crashreportcategory, (BlockPos)blockpos$mutable, blockstate);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
    }

    protected void func_191955_a(BlockState p_191955_1_) {
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        if (!p_180429_2_.func_185904_a().func_76224_d()) {
            BlockState blockstate = this.field_70170_p.func_180495_p(p_180429_1_.func_177984_a());
            SoundType soundtype = blockstate.func_203425_a(Blocks.field_150433_aE) ? blockstate.getSoundType((IWorldReader)((Object)this.field_70170_p), p_180429_1_, this) : p_180429_2_.getSoundType((IWorldReader)((Object)this.field_70170_p), p_180429_1_, this);
            this.func_184185_a(soundtype.func_185844_d(), soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
        }
    }

    protected void func_203006_d(float p_203006_1_) {
        this.func_184185_a(this.func_184184_Z(), p_203006_1_, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
    }

    protected float func_191954_d(float p_191954_1_) {
        return 0.0f;
    }

    protected boolean func_191957_ae() {
        return false;
    }

    public void func_184185_a(SoundEvent p_184185_1_, float p_184185_2_, float p_184185_3_) {
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), p_184185_1_, this.func_184176_by(), p_184185_2_, p_184185_3_);
        }
    }

    public boolean func_174814_R() {
        return this.field_70180_af.func_187225_a(field_184234_aB);
    }

    public void func_174810_b(boolean p_174810_1_) {
        this.field_70180_af.func_187227_b(field_184234_aB, p_174810_1_);
    }

    public boolean func_189652_ae() {
        return this.field_70180_af.func_187225_a(field_189655_aD);
    }

    public void func_189654_d(boolean p_189654_1_) {
        this.field_70180_af.func_187227_b(field_189655_aD, p_189654_1_);
    }

    protected boolean func_225502_at_() {
        return true;
    }

    protected void func_184231_a(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
        if (p_184231_3_) {
            if (this.field_70143_R > 0.0f) {
                p_184231_4_.func_177230_c().func_180658_a(this.field_70170_p, p_184231_5_, this, this.field_70143_R);
            }
            this.field_70143_R = 0.0f;
        } else if (p_184231_1_ < 0.0) {
            this.field_70143_R = (float)((double)this.field_70143_R - p_184231_1_);
        }
    }

    public boolean func_230279_az_() {
        return this.func_200600_R().func_220338_c();
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        if (this.func_184207_aI()) {
            for (Entity entity : this.func_184188_bt()) {
                entity.func_225503_b_(p_225503_1_, p_225503_2_);
            }
        }
        return false;
    }

    public boolean func_70090_H() {
        return this.field_70171_ac;
    }

    private boolean func_209511_p() {
        BlockPos blockpos = this.func_233580_cy_();
        return this.field_70170_p.func_175727_C(blockpos) || this.field_70170_p.func_175727_C(new BlockPos((double)blockpos.func_177958_n(), this.func_174813_aQ().field_72337_e, (double)blockpos.func_177952_p()));
    }

    private boolean func_209512_q() {
        return this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_203425_a(Blocks.field_203203_C);
    }

    public boolean func_70026_G() {
        return this.func_70090_H() || this.func_209511_p();
    }

    public boolean func_203008_ap() {
        return this.func_70090_H() || this.func_209511_p() || this.func_209512_q();
    }

    public boolean func_203005_aq() {
        return this.func_70090_H() || this.func_209512_q();
    }

    public boolean func_204231_K() {
        return this.field_205013_W && this.func_70090_H();
    }

    public void func_205343_av() {
        if (this.func_203007_ba()) {
            this.func_204711_a(this.func_70051_ag() && this.func_70090_H() && !this.func_184218_aH());
        } else {
            this.func_204711_a(this.func_70051_ag() && this.func_204231_K() && !this.func_184218_aH());
        }
    }

    protected boolean func_233566_aG_() {
        this.field_233554_M_.clear();
        this.func_233567_aH_();
        double d0 = this.field_70170_p.func_230315_m_().func_236040_e_() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.func_210500_b(FluidTags.field_206960_b, d0);
        return this.func_70090_H() || flag;
    }

    void func_233567_aH_() {
        if (this.func_184187_bx() instanceof BoatEntity) {
            this.field_70171_ac = false;
        } else if (this.func_210500_b(FluidTags.field_206959_a, 0.014)) {
            if (!this.field_70171_ac && !this.field_70148_d) {
                this.func_71061_d_();
            }
            this.field_70143_R = 0.0f;
            this.field_70171_ac = true;
            this.func_70066_B();
        } else {
            this.field_70171_ac = false;
        }
    }

    private void func_205012_q() {
        BoatEntity boatentity;
        this.field_205013_W = this.func_208600_a(FluidTags.field_206959_a);
        this.field_241335_O_ = null;
        double d0 = this.func_226280_cw_() - 0.1111111119389534;
        Entity entity = this.func_184187_bx();
        if (entity instanceof BoatEntity && !(boatentity = (BoatEntity)entity).func_204231_K() && boatentity.func_174813_aQ().field_72337_e >= d0 && boatentity.func_174813_aQ().field_72338_b <= d0) {
            return;
        }
        BlockPos blockpos = new BlockPos(this.func_226277_ct_(), d0, this.func_226281_cx_());
        FluidState fluidstate = this.field_70170_p.func_204610_c(blockpos);
        for (ITag iTag : FluidTags.func_241280_c_()) {
            if (!fluidstate.func_206884_a(iTag)) continue;
            double d1 = (float)blockpos.func_177956_o() + fluidstate.func_215679_a((IBlockReader)((Object)this.field_70170_p), blockpos);
            if (d1 > d0) {
                this.field_241335_O_ = iTag;
            }
            return;
        }
    }

    protected void func_71061_d_() {
        Entity entity = this.func_184207_aI() && this.func_184179_bs() != null ? this.func_184179_bs() : this;
        float f = entity == this ? 0.2f : 0.9f;
        Vector3d vector3d = entity.func_213322_ci();
        float f1 = MathHelper.func_76133_a((double)(vector3d.field_72450_a * vector3d.field_72450_a * (double)0.2f + vector3d.field_72448_b * vector3d.field_72448_b + vector3d.field_72449_c * vector3d.field_72449_c * (double)0.2f)) * f;
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        if ((double)f1 < 0.25) {
            this.func_184185_a(this.func_184181_aa(), f1, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
        } else {
            this.func_184185_a(this.func_204208_ah(), f1, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
        }
        float f2 = MathHelper.func_76128_c((double)this.func_226278_cu_());
        int i = 0;
        while ((float)i < 1.0f + this.field_213325_aI.field_220315_a * 20.0f) {
            double d0 = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_213325_aI.field_220315_a;
            double d1 = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_213325_aI.field_220315_a;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() + d0, f2 + 1.0f, this.func_226281_cx_() + d1, vector3d.field_72450_a, vector3d.field_72448_b - this.field_70146_Z.nextDouble() * (double)0.2f, vector3d.field_72449_c);
            ++i;
        }
        int j = 0;
        while ((float)j < 1.0f + this.field_213325_aI.field_220315_a * 20.0f) {
            double d2 = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_213325_aI.field_220315_a;
            double d3 = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_213325_aI.field_220315_a;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() + d2, f2 + 1.0f, this.func_226281_cx_() + d3, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
            ++j;
        }
    }

    protected BlockState func_233568_aJ_() {
        return this.field_70170_p.func_180495_p(this.func_226268_ag_());
    }

    public boolean func_230269_aK_() {
        return this.func_70051_ag() && !this.func_70090_H() && !this.func_175149_v() && !this.func_213453_ef() && !this.func_180799_ab() && this.func_70089_S();
    }

    protected void func_233569_aL_() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f)), k = MathHelper.func_76128_c((double)this.func_226281_cx_()));
        BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
        if (!blockstate.addRunningEffects(this.field_70170_p, blockpos, this) && blockstate.func_185901_i() != BlockRenderType.INVISIBLE) {
            Vector3d vector3d = this.func_213322_ci();
            this.field_70170_p.func_195594_a(new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(blockpos), this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_213325_aI.field_220315_a, this.func_226278_cu_() + 0.1, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_213325_aI.field_220315_a, vector3d.field_72450_a * -4.0, 1.5, vector3d.field_72449_c * -4.0);
        }
    }

    public boolean func_208600_a(ITag<Fluid> p_208600_1_) {
        return this.field_241335_O_ == p_208600_1_;
    }

    public boolean func_180799_ab() {
        return !this.field_70148_d && this.field_233554_M_.getDouble(FluidTags.field_206960_b) > 0.0;
    }

    public void func_213309_a(float p_213309_1_, Vector3d p_213309_2_) {
        Vector3d vector3d = Entity.func_213299_a(p_213309_2_, p_213309_1_, this.field_70177_z);
        this.func_213317_d(this.func_213322_ci().func_178787_e(vector3d));
    }

    private static Vector3d func_213299_a(Vector3d p_213299_0_, float p_213299_1_, float p_213299_2_) {
        double d0 = p_213299_0_.func_189985_c();
        if (d0 < 1.0E-7) {
            return Vector3d.field_186680_a;
        }
        Vector3d vector3d = (d0 > 1.0 ? p_213299_0_.func_72432_b() : p_213299_0_).func_186678_a(p_213299_1_);
        float f = MathHelper.func_76126_a((float)(p_213299_2_ * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(p_213299_2_ * ((float)Math.PI / 180)));
        return new Vector3d(vector3d.field_72450_a * (double)f1 - vector3d.field_72449_c * (double)f, vector3d.field_72448_b, vector3d.field_72449_c * (double)f1 + vector3d.field_72450_a * (double)f);
    }

    public float func_70013_c() {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(this.func_226277_ct_(), 0.0, this.func_226281_cx_());
        if (this.field_70170_p.func_175667_e((BlockPos)blockpos$mutable)) {
            blockpos$mutable.func_185336_p(MathHelper.func_76128_c((double)this.func_226280_cw_()));
            return this.field_70170_p.func_205052_D((BlockPos)blockpos$mutable);
        }
        return 0.0f;
    }

    public void func_70029_a(World p_70029_1_) {
        this.field_70170_p = p_70029_1_;
    }

    public void func_70080_a(double p_70080_1_, double p_70080_3_, double p_70080_5_, float p_70080_7_, float p_70080_8_) {
        this.func_242281_f(p_70080_1_, p_70080_3_, p_70080_5_);
        this.field_70177_z = p_70080_7_ % 360.0f;
        this.field_70125_A = MathHelper.func_76131_a((float)p_70080_8_, (float)-90.0f, (float)90.0f) % 360.0f;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void func_242281_f(double p_242281_1_, double p_242281_3_, double p_242281_5_) {
        double d0 = MathHelper.func_151237_a((double)p_242281_1_, (double)-3.0E7, (double)3.0E7);
        double d1 = MathHelper.func_151237_a((double)p_242281_5_, (double)-3.0E7, (double)3.0E7);
        this.field_70169_q = d0;
        this.field_70167_r = p_242281_3_;
        this.field_70166_s = d1;
        this.func_70107_b(d0, p_242281_3_, d1);
    }

    public void func_233576_c_(Vector3d p_233576_1_) {
        this.func_225653_b_(p_233576_1_.field_72450_a, p_233576_1_.field_72448_b, p_233576_1_.field_72449_c);
    }

    public void func_225653_b_(double p_225653_1_, double p_225653_3_, double p_225653_5_) {
        this.func_70012_b(p_225653_1_, p_225653_3_, p_225653_5_, this.field_70177_z, this.field_70125_A);
    }

    public void func_174828_a(BlockPos p_174828_1_, float p_174828_2_, float p_174828_3_) {
        this.func_70012_b((double)p_174828_1_.func_177958_n() + 0.5, p_174828_1_.func_177956_o(), (double)p_174828_1_.func_177952_p() + 0.5, p_174828_2_, p_174828_3_);
    }

    public void func_70012_b(double p_70012_1_, double p_70012_3_, double p_70012_5_, float p_70012_7_, float p_70012_8_) {
        this.func_226286_f_(p_70012_1_, p_70012_3_, p_70012_5_);
        this.field_70177_z = p_70012_7_;
        this.field_70125_A = p_70012_8_;
        this.func_226264_Z_();
    }

    public void func_226286_f_(double p_226286_1_, double p_226286_3_, double p_226286_5_) {
        this.func_226288_n_(p_226286_1_, p_226286_3_, p_226286_5_);
        this.field_70169_q = p_226286_1_;
        this.field_70167_r = p_226286_3_;
        this.field_70166_s = p_226286_5_;
        this.field_70142_S = p_226286_1_;
        this.field_70137_T = p_226286_3_;
        this.field_70136_U = p_226286_5_;
    }

    public float func_70032_d(Entity p_70032_1_) {
        float f = (float)(this.func_226277_ct_() - p_70032_1_.func_226277_ct_());
        float f1 = (float)(this.func_226278_cu_() - p_70032_1_.func_226278_cu_());
        float f2 = (float)(this.func_226281_cx_() - p_70032_1_.func_226281_cx_());
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public double func_70092_e(double p_70092_1_, double p_70092_3_, double p_70092_5_) {
        double d0 = this.func_226277_ct_() - p_70092_1_;
        double d1 = this.func_226278_cu_() - p_70092_3_;
        double d2 = this.func_226281_cx_() - p_70092_5_;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double func_70068_e(Entity p_70068_1_) {
        return this.func_195048_a(p_70068_1_.func_213303_ch());
    }

    public double func_195048_a(Vector3d p_195048_1_) {
        double d0 = this.func_226277_ct_() - p_195048_1_.field_72450_a;
        double d1 = this.func_226278_cu_() - p_195048_1_.field_72448_b;
        double d2 = this.func_226281_cx_() - p_195048_1_.field_72449_c;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void func_70100_b_(PlayerEntity p_70100_1_) {
    }

    public void func_70108_f(Entity p_70108_1_) {
        double d1;
        double d0;
        double d2;
        if (!this.func_184223_x(p_70108_1_) && !p_70108_1_.field_70145_X && !this.field_70145_X && (d2 = MathHelper.func_76132_a((double)(d0 = p_70108_1_.func_226277_ct_() - this.func_226277_ct_()), (double)(d1 = p_70108_1_.func_226281_cx_() - this.func_226281_cx_()))) >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            d0 *= (double)(1.0f - this.field_70144_Y);
            d1 *= (double)(1.0f - this.field_70144_Y);
            if (!this.func_184207_aI()) {
                this.func_70024_g(-d0, 0.0, -d1);
            }
            if (!p_70108_1_.func_184207_aI()) {
                p_70108_1_.func_70024_g(d0, 0.0, d1);
            }
        }
    }

    public void func_70024_g(double p_70024_1_, double p_70024_3_, double p_70024_5_) {
        this.func_213317_d(this.func_213322_ci().func_72441_c(p_70024_1_, p_70024_3_, p_70024_5_));
        this.field_70160_al = true;
    }

    protected void func_70018_K() {
        this.field_70133_I = true;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        this.func_70018_K();
        return false;
    }

    public final Vector3d func_70676_i(float p_70676_1_) {
        return this.func_174806_f(this.func_195050_f(p_70676_1_), this.func_195046_g(p_70676_1_));
    }

    public float func_195050_f(float p_195050_1_) {
        return p_195050_1_ == 1.0f ? this.field_70125_A : MathHelper.func_219799_g((float)p_195050_1_, (float)this.field_70127_C, (float)this.field_70125_A);
    }

    public float func_195046_g(float p_195046_1_) {
        return p_195046_1_ == 1.0f ? this.field_70177_z : MathHelper.func_219799_g((float)p_195046_1_, (float)this.field_70126_B, (float)this.field_70177_z);
    }

    protected final Vector3d func_174806_f(float p_174806_1_, float p_174806_2_) {
        float f = p_174806_1_ * ((float)Math.PI / 180);
        float f1 = -p_174806_2_ * ((float)Math.PI / 180);
        float f2 = MathHelper.func_76134_b((float)f1);
        float f3 = MathHelper.func_76126_a((float)f1);
        float f4 = MathHelper.func_76134_b((float)f);
        float f5 = MathHelper.func_76126_a((float)f);
        return new Vector3d(f3 * f4, -f5, f2 * f4);
    }

    public final Vector3d func_213286_i(float p_213286_1_) {
        return this.func_213320_d(this.func_195050_f(p_213286_1_), this.func_195046_g(p_213286_1_));
    }

    protected final Vector3d func_213320_d(float p_213320_1_, float p_213320_2_) {
        return this.func_174806_f(p_213320_1_ - 90.0f, p_213320_2_);
    }

    public final Vector3d func_174824_e(float p_174824_1_) {
        if (p_174824_1_ == 1.0f) {
            return new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        }
        double d0 = MathHelper.func_219803_d((double)p_174824_1_, (double)this.field_70169_q, (double)this.func_226277_ct_());
        double d1 = MathHelper.func_219803_d((double)p_174824_1_, (double)this.field_70167_r, (double)this.func_226278_cu_()) + (double)this.func_70047_e();
        double d2 = MathHelper.func_219803_d((double)p_174824_1_, (double)this.field_70166_s, (double)this.func_226281_cx_());
        return new Vector3d(d0, d1, d2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241842_k(float p_241842_1_) {
        return this.func_174824_e(p_241842_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public final Vector3d func_242282_l(float p_242282_1_) {
        double d0 = MathHelper.func_219803_d((double)p_242282_1_, (double)this.field_70169_q, (double)this.func_226277_ct_());
        double d1 = MathHelper.func_219803_d((double)p_242282_1_, (double)this.field_70167_r, (double)this.func_226278_cu_());
        double d2 = MathHelper.func_219803_d((double)p_242282_1_, (double)this.field_70166_s, (double)this.func_226281_cx_());
        return new Vector3d(d0, d1, d2);
    }

    public RayTraceResult func_213324_a(double p_213324_1_, float p_213324_3_, boolean p_213324_4_) {
        Vector3d vector3d = this.func_174824_e(p_213324_3_);
        Vector3d vector3d1 = this.func_70676_i(p_213324_3_);
        Vector3d vector3d2 = vector3d.func_72441_c(vector3d1.field_72450_a * p_213324_1_, vector3d1.field_72448_b * p_213324_1_, vector3d1.field_72449_c * p_213324_1_);
        return this.field_70170_p.func_217299_a(new RayTraceContext(vector3d, vector3d2, RayTraceContext.BlockMode.OUTLINE, p_213324_4_ ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE, this));
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_191956_a(Entity p_191956_1_, int p_191956_2_, DamageSource p_191956_3_) {
        if (p_191956_1_ instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_192123_c.func_192211_a((ServerPlayerEntity)p_191956_1_, this, p_191956_3_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        double d0 = this.func_226277_ct_() - p_145770_1_;
        double d1 = this.func_226278_cu_() - p_145770_3_;
        double d2 = this.func_226281_cx_() - p_145770_5_;
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        return this.func_70112_a(d3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return p_70112_1_ < (d0 = d0 * 64.0 * field_70155_l) * d0;
    }

    public boolean func_184198_c(CompoundNBT p_184198_1_) {
        String s = this.func_70022_Q();
        if (!this.field_70128_L && s != null) {
            p_184198_1_.func_74778_a("id", s);
            this.func_189511_e(p_184198_1_);
            return true;
        }
        return false;
    }

    public boolean func_70039_c(CompoundNBT p_70039_1_) {
        return this.func_184218_aH() ? false : this.func_184198_c(p_70039_1_);
    }

    public CompoundNBT func_189511_e(CompoundNBT p_189511_1_) {
        try {
            CompoundNBT caps;
            if (this.field_184239_as != null) {
                p_189511_1_.func_218657_a("Pos", (INBT)this.func_70087_a(this.field_184239_as.func_226277_ct_(), this.func_226278_cu_(), this.field_184239_as.func_226281_cx_()));
            } else {
                p_189511_1_.func_218657_a("Pos", (INBT)this.func_70087_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
            }
            Vector3d vector3d = this.func_213322_ci();
            p_189511_1_.func_218657_a("Motion", (INBT)this.func_70087_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c));
            p_189511_1_.func_218657_a("Rotation", (INBT)this.func_70049_a(this.field_70177_z, this.field_70125_A));
            p_189511_1_.func_74776_a("FallDistance", this.field_70143_R);
            p_189511_1_.func_74777_a("Fire", (short)this.field_190534_ay);
            p_189511_1_.func_74777_a("Air", (short)this.func_70086_ai());
            p_189511_1_.func_74757_a("OnGround", this.field_70122_E);
            p_189511_1_.func_74757_a("Invulnerable", this.field_83001_bt);
            p_189511_1_.func_74768_a("PortalCooldown", this.field_242273_aw);
            p_189511_1_.func_186854_a("UUID", this.func_110124_au());
            ITextComponent itextcomponent = this.func_200201_e();
            if (itextcomponent != null) {
                p_189511_1_.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)itextcomponent));
            }
            if (this.func_174833_aM()) {
                p_189511_1_.func_74757_a("CustomNameVisible", this.func_174833_aM());
            }
            if (this.func_174814_R()) {
                p_189511_1_.func_74757_a("Silent", this.func_174814_R());
            }
            if (this.func_189652_ae()) {
                p_189511_1_.func_74757_a("NoGravity", this.func_189652_ae());
            }
            if (this.field_184238_ar) {
                p_189511_1_.func_74757_a("Glowing", this.field_184238_ar);
            }
            p_189511_1_.func_74757_a("CanUpdate", this.canUpdate);
            if (!this.field_184236_aF.isEmpty()) {
                ListNBT listnbt = new ListNBT();
                for (String s : this.field_184236_aF) {
                    listnbt.add((Object)StringNBT.func_229705_a_(s));
                }
                p_189511_1_.func_218657_a("Tags", (INBT)listnbt);
            }
            if ((caps = this.serializeCaps()) != null) {
                p_189511_1_.func_218657_a("ForgeCaps", caps);
            }
            if (this.persistentData != null) {
                p_189511_1_.func_218657_a("ForgeData", this.persistentData);
            }
            this.func_213281_b(p_189511_1_);
            if (this.func_184207_aI()) {
                ListNBT listnbt1 = new ListNBT();
                for (Entity entity : this.func_184188_bt()) {
                    CompoundNBT compoundnbt;
                    if (!entity.func_184198_c(compoundnbt = new CompoundNBT())) continue;
                    listnbt1.add((Object)compoundnbt);
                }
                if (!listnbt1.isEmpty()) {
                    p_189511_1_.func_218657_a("Passengers", (INBT)listnbt1);
                }
            }
            return p_189511_1_;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Saving entity NBT");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being saved");
            this.func_85029_a(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    public void func_70020_e(CompoundNBT p_70020_1_) {
        block14: {
            try {
                ListNBT listnbt = p_70020_1_.func_150295_c("Pos", 6);
                ListNBT listnbt1 = p_70020_1_.func_150295_c("Motion", 6);
                ListNBT listnbt2 = p_70020_1_.func_150295_c("Rotation", 5);
                double d0 = listnbt1.func_150309_d(0);
                double d1 = listnbt1.func_150309_d(1);
                double d2 = listnbt1.func_150309_d(2);
                this.func_213293_j(Math.abs(d0) > 10.0 ? 0.0 : d0, Math.abs(d1) > 10.0 ? 0.0 : d1, Math.abs(d2) > 10.0 ? 0.0 : d2);
                this.func_226286_f_(listnbt.func_150309_d(0), listnbt.func_150309_d(1), listnbt.func_150309_d(2));
                this.field_70177_z = listnbt2.func_150308_e(0);
                this.field_70125_A = listnbt2.func_150308_e(1);
                this.field_70126_B = this.field_70177_z;
                this.field_70127_C = this.field_70125_A;
                this.func_70034_d(this.field_70177_z);
                this.func_181013_g(this.field_70177_z);
                this.field_70143_R = p_70020_1_.func_74760_g("FallDistance");
                this.field_190534_ay = p_70020_1_.func_74765_d("Fire");
                this.func_70050_g(p_70020_1_.func_74765_d("Air"));
                this.field_70122_E = p_70020_1_.func_74767_n("OnGround");
                this.field_83001_bt = p_70020_1_.func_74767_n("Invulnerable");
                this.field_242273_aw = p_70020_1_.func_74762_e("PortalCooldown");
                if (p_70020_1_.func_186855_b("UUID")) {
                    this.field_96093_i = p_70020_1_.func_186857_a("UUID");
                    this.field_189513_ar = this.field_96093_i.toString();
                }
                if (Double.isFinite(this.func_226277_ct_()) && Double.isFinite(this.func_226278_cu_()) && Double.isFinite(this.func_226281_cx_())) {
                    if (Double.isFinite(this.field_70177_z) && Double.isFinite(this.field_70125_A)) {
                        this.func_226264_Z_();
                        this.func_70101_b(this.field_70177_z, this.field_70125_A);
                        if (p_70020_1_.func_150297_b("CustomName", 8)) {
                            String s = p_70020_1_.func_74779_i("CustomName");
                            try {
                                this.func_200203_b((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)s));
                            }
                            catch (Exception exception) {
                                field_184243_a.warn("Failed to parse entity custom name {}", (Object)s, (Object)exception);
                            }
                        }
                        this.func_174805_g(p_70020_1_.func_74767_n("CustomNameVisible"));
                        this.func_174810_b(p_70020_1_.func_74767_n("Silent"));
                        this.func_189654_d(p_70020_1_.func_74767_n("NoGravity"));
                        this.func_184195_f(p_70020_1_.func_74767_n("Glowing"));
                        if (p_70020_1_.func_150297_b("ForgeData", 10)) {
                            this.persistentData = p_70020_1_.func_74775_l("ForgeData");
                        }
                        if (p_70020_1_.func_150297_b("CanUpdate", 99)) {
                            this.canUpdate(p_70020_1_.func_74767_n("CanUpdate"));
                        }
                        if (p_70020_1_.func_150297_b("ForgeCaps", 10)) {
                            this.deserializeCaps(p_70020_1_.func_74775_l("ForgeCaps"));
                        }
                        if (p_70020_1_.func_150297_b("Tags", 9)) {
                            this.field_184236_aF.clear();
                            ListNBT listnbt3 = p_70020_1_.func_150295_c("Tags", 8);
                            int i = Math.min(listnbt3.size(), 1024);
                            for (int j = 0; j < i; ++j) {
                                this.field_184236_aF.add(listnbt3.func_150307_f(j));
                            }
                        }
                        this.func_70037_a(p_70020_1_);
                        if (this.func_142008_O()) {
                            this.func_226264_Z_();
                        }
                        break block14;
                    }
                    throw new IllegalStateException("Entity has invalid rotation");
                }
                throw new IllegalStateException("Entity has invalid position");
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Loading entity NBT");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being loaded");
                this.func_85029_a(crashreportcategory);
                throw new ReportedException(crashreport);
            }
        }
    }

    protected boolean func_142008_O() {
        return true;
    }

    @Nullable
    public final String func_70022_Q() {
        EntityType<?> entitytype = this.func_200600_R();
        ResourceLocation resourcelocation = EntityType.func_200718_a(entitytype);
        return entitytype.func_200715_a() && resourcelocation != null ? resourcelocation.toString() : null;
    }

    protected abstract void func_70037_a(CompoundNBT var1);

    protected abstract void func_213281_b(CompoundNBT var1);

    protected ListNBT func_70087_a(double ... p_70087_1_) {
        ListNBT listnbt = new ListNBT();
        for (double d0 : p_70087_1_) {
            listnbt.add((Object)DoubleNBT.func_229684_a_((double)d0));
        }
        return listnbt;
    }

    protected ListNBT func_70049_a(float ... p_70049_1_) {
        ListNBT listnbt = new ListNBT();
        for (float f : p_70049_1_) {
            listnbt.add((Object)FloatNBT.func_229689_a_((float)f));
        }
        return listnbt;
    }

    @Nullable
    public ItemEntity func_199703_a(IItemProvider p_199703_1_) {
        return this.func_199702_a(p_199703_1_, 0);
    }

    @Nullable
    public ItemEntity func_199702_a(IItemProvider p_199702_1_, int p_199702_2_) {
        return this.func_70099_a(new ItemStack(p_199702_1_), p_199702_2_);
    }

    @Nullable
    public ItemEntity func_199701_a_(ItemStack p_199701_1_) {
        return this.func_70099_a(p_199701_1_, 0.0f);
    }

    @Nullable
    public ItemEntity func_70099_a(ItemStack p_70099_1_, float p_70099_2_) {
        if (p_70099_1_.func_190926_b()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + (double)p_70099_2_, this.func_226281_cx_(), p_70099_1_);
        itementity.func_174869_p();
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.field_70170_p.func_217376_c(itementity);
        }
        return itementity;
    }

    public boolean func_70089_S() {
        return !this.field_70128_L;
    }

    public boolean func_70094_T() {
        if (this.field_70145_X) {
            return false;
        }
        float f = 0.1f;
        float f1 = this.field_213325_aI.field_220315_a * 0.8f;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_241550_g_((double)f1, (double)0.1f, (double)f1).func_72317_d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_241457_a_(this, axisalignedbb, (p_241338_1_, p_241338_2_) -> p_241338_1_.func_229980_m_((IBlockReader)((Object)this.field_70170_p), (BlockPos)p_241338_2_)).findAny().isPresent();
    }

    public ActionResultType func_184230_a(PlayerEntity p_184230_1_, Hand p_184230_2_) {
        return ActionResultType.PASS;
    }

    public boolean func_241849_j(Entity p_241849_1_) {
        return p_241849_1_.func_241845_aY() && !this.func_184223_x(p_241849_1_);
    }

    public boolean func_241845_aY() {
        return false;
    }

    public void func_70098_U() {
        this.func_213317_d(Vector3d.field_186680_a);
        if (this.canUpdate()) {
            this.func_70071_h_();
        }
        if (this.func_184218_aH()) {
            this.func_184187_bx().func_184232_k(this);
        }
    }

    public void func_184232_k(Entity p_184232_1_) {
        this.func_226266_a_(p_184232_1_, Entity::func_70107_b);
    }

    private void func_226266_a_(Entity p_226266_1_, IMoveCallback p_226266_2_) {
        if (this.func_184196_w(p_226266_1_)) {
            double d0 = this.func_226278_cu_() + this.func_70042_X() + p_226266_1_.func_70033_W();
            p_226266_2_.accept(p_226266_1_, this.func_226277_ct_(), d0, this.func_226281_cx_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity p_184190_1_) {
    }

    public double func_70033_W() {
        return 0.0;
    }

    public double func_70042_X() {
        return (double)this.field_213325_aI.field_220316_b * 0.75;
    }

    public boolean func_184220_m(Entity p_184220_1_) {
        return this.func_184205_a(p_184220_1_, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_203003_aK() {
        return this instanceof LivingEntity;
    }

    public boolean func_184205_a(Entity p_184205_1_, boolean p_184205_2_) {
        Entity entity = p_184205_1_;
        while (entity.field_184239_as != null) {
            if (entity.field_184239_as == this) {
                return false;
            }
            entity = entity.field_184239_as;
        }
        if (!ForgeEventFactory.canMountEntity((Entity)this, (Entity)p_184205_1_, (boolean)true)) {
            return false;
        }
        if (p_184205_2_ || this.func_184228_n(p_184205_1_) && p_184205_1_.func_184219_q(this)) {
            if (this.func_184218_aH()) {
                this.func_184210_p();
            }
            this.func_213301_b(Pose.STANDING);
            this.field_184239_as = p_184205_1_;
            this.field_184239_as.func_184200_o(this);
            return true;
        }
        return false;
    }

    protected boolean func_184228_n(Entity p_184228_1_) {
        return !this.func_225608_bj_() && this.field_184245_j <= 0;
    }

    protected boolean func_213298_c(Pose p_213298_1_) {
        return this.field_70170_p.func_226665_a__(this, this.func_213321_d(p_213298_1_).func_186664_h(1.0E-7));
    }

    public void func_184226_ay() {
        for (int i = this.field_184244_h.size() - 1; i >= 0; --i) {
            this.field_184244_h.get(i).func_184210_p();
        }
    }

    public void func_233575_bb_() {
        if (this.field_184239_as != null) {
            Entity entity = this.field_184239_as;
            if (!ForgeEventFactory.canMountEntity((Entity)this, (Entity)entity, (boolean)false)) {
                return;
            }
            this.field_184239_as = null;
            entity.func_184225_p(this);
        }
    }

    public void func_184210_p() {
        this.func_233575_bb_();
    }

    protected void func_184200_o(Entity p_184200_1_) {
        if (p_184200_1_.func_184187_bx() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (!this.field_70170_p.field_72995_K && p_184200_1_ instanceof PlayerEntity && !(this.func_184179_bs() instanceof PlayerEntity)) {
            this.field_184244_h.add(0, p_184200_1_);
        } else {
            this.field_184244_h.add(p_184200_1_);
        }
    }

    protected void func_184225_p(Entity p_184225_1_) {
        if (p_184225_1_.func_184187_bx() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        this.field_184244_h.remove((Object)p_184225_1_);
        p_184225_1_.field_184245_j = 60;
    }

    protected boolean func_184219_q(Entity p_184219_1_) {
        return this.func_184188_bt().size() < 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double p_180426_1_, double p_180426_3_, double p_180426_5_, float p_180426_7_, float p_180426_8_, int p_180426_9_, boolean p_180426_10_) {
        this.func_70107_b(p_180426_1_, p_180426_3_, p_180426_5_);
        this.func_70101_b(p_180426_7_, p_180426_8_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_208000_a(float p_208000_1_, int p_208000_2_) {
        this.func_70034_d(p_208000_1_);
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public Vector3d func_70040_Z() {
        return this.func_174806_f(this.field_70125_A, this.field_70177_z);
    }

    public Vector2f func_189653_aC() {
        return new Vector2f(this.field_70125_A, this.field_70177_z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_189651_aD() {
        return Vector3d.func_189984_a(this.func_189653_aC());
    }

    public void func_181015_d(BlockPos p_181015_1_) {
        if (this.func_242280_ah()) {
            this.func_242279_ag();
        } else {
            if (!this.field_70170_p.field_72995_K && !p_181015_1_.equals((Object)this.field_242271_ac)) {
                this.field_242271_ac = p_181015_1_.func_185334_h();
            }
            this.field_71087_bX = true;
        }
    }

    protected void func_213284_aV() {
        if (this.field_70170_p instanceof ServerWorld) {
            int i = this.func_82145_z();
            ServerWorld serverworld = (ServerWorld)this.field_70170_p;
            if (this.field_71087_bX) {
                RegistryKey<World> registrykey;
                MinecraftServer minecraftserver = serverworld.func_73046_m();
                ServerWorld serverworld1 = minecraftserver.func_71218_a(registrykey = this.field_70170_p.func_234923_W_() == World.field_234919_h_ ? World.field_234918_g_ : World.field_234919_h_);
                if (serverworld1 != null && minecraftserver.func_71255_r() && !this.func_184218_aH() && this.field_82153_h++ >= i) {
                    this.field_70170_p.func_217381_Z().func_76320_a("portal");
                    this.field_82153_h = i;
                    this.func_242279_ag();
                    this.func_241206_a_(serverworld1);
                    this.field_70170_p.func_217381_Z().func_76319_b();
                }
                this.field_71087_bX = false;
            } else {
                if (this.field_82153_h > 0) {
                    this.field_82153_h -= 4;
                }
                if (this.field_82153_h < 0) {
                    this.field_82153_h = 0;
                }
            }
            this.func_184173_H();
        }
    }

    public int func_82147_ab() {
        return 300;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
        this.func_213293_j(p_70016_1_, p_70016_3_, p_70016_5_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        switch (p_70103_1_) {
            case 53: {
                HoneyBlock.func_226931_a_((Entity)this);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
    }

    public Iterable<ItemStack> func_184214_aD() {
        return field_190535_b;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return field_190535_b;
    }

    public Iterable<ItemStack> func_184209_aF() {
        return Iterables.concat(this.func_184214_aD(), this.func_184193_aE());
    }

    public void func_184201_a(EquipmentSlotType p_184201_1_, ItemStack p_184201_2_) {
    }

    public boolean func_70027_ad() {
        boolean flag = this.field_70170_p != null && this.field_70170_p.field_72995_K;
        return !this.func_230279_az_() && (this.field_190534_ay > 0 || flag && this.func_70083_f(0));
    }

    public boolean func_184218_aH() {
        return this.func_184187_bx() != null;
    }

    public boolean func_184207_aI() {
        return !this.func_184188_bt().isEmpty();
    }

    @Deprecated
    public boolean func_205710_ba() {
        return true;
    }

    public void func_226284_e_(boolean p_226284_1_) {
        this.func_70052_a(1, p_226284_1_);
    }

    public boolean func_225608_bj_() {
        return this.func_70083_f(1);
    }

    public boolean func_226271_bk_() {
        return this.func_225608_bj_();
    }

    public boolean func_226272_bl_() {
        return this.func_225608_bj_();
    }

    public boolean func_226273_bm_() {
        return this.func_225608_bj_();
    }

    public boolean func_226274_bn_() {
        return this.func_225608_bj_();
    }

    public boolean func_213453_ef() {
        return this.func_213283_Z() == Pose.CROUCHING;
    }

    public boolean func_70051_ag() {
        return this.func_70083_f(3);
    }

    public void func_70031_b(boolean p_70031_1_) {
        this.func_70052_a(3, p_70031_1_);
    }

    public boolean func_203007_ba() {
        return this.func_70083_f(4);
    }

    public boolean func_213314_bj() {
        return this.func_213283_Z() == Pose.SWIMMING;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_213300_bk() {
        return this.func_213314_bj() && !this.func_70090_H();
    }

    public void func_204711_a(boolean p_204711_1_) {
        this.func_70052_a(4, p_204711_1_);
    }

    public boolean func_225510_bt_() {
        return this.field_184238_ar || this.field_70170_p.field_72995_K && this.func_70083_f(6);
    }

    public void func_184195_f(boolean p_184195_1_) {
        this.field_184238_ar = p_184195_1_;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.field_184238_ar);
        }
    }

    public boolean func_82150_aj() {
        return this.func_70083_f(5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_98034_c(PlayerEntity p_98034_1_) {
        if (p_98034_1_.func_175149_v()) {
            return false;
        }
        Team team = this.func_96124_cp();
        return team != null && p_98034_1_ != null && p_98034_1_.func_96124_cp() == team && team.func_98297_h() ? false : this.func_82150_aj();
    }

    @Nullable
    public Team func_96124_cp() {
        return this.field_70170_p.func_96441_U().func_96509_i(this.func_195047_I_());
    }

    public boolean func_184191_r(Entity p_184191_1_) {
        return this.func_184194_a(p_184191_1_.func_96124_cp());
    }

    public boolean func_184194_a(Team p_184194_1_) {
        return this.func_96124_cp() != null ? this.func_96124_cp().func_142054_a(p_184194_1_) : false;
    }

    public void func_82142_c(boolean p_82142_1_) {
        this.func_70052_a(5, p_82142_1_);
    }

    protected boolean func_70083_f(int p_70083_1_) {
        return (this.field_70180_af.func_187225_a(field_184240_ax) & 1 << p_70083_1_) != 0;
    }

    protected void func_70052_a(int p_70052_1_, boolean p_70052_2_) {
        byte b0 = this.field_70180_af.func_187225_a(field_184240_ax);
        if (p_70052_2_) {
            this.field_70180_af.func_187227_b(field_184240_ax, (byte)(b0 | 1 << p_70052_1_));
        } else {
            this.field_70180_af.func_187227_b(field_184240_ax, (byte)(b0 & ~(1 << p_70052_1_)));
        }
    }

    public int func_205010_bg() {
        return 300;
    }

    public int func_70086_ai() {
        return this.field_70180_af.func_187225_a(field_184241_ay);
    }

    public void func_70050_g(int p_70050_1_) {
        this.field_70180_af.func_187227_b(field_184241_ay, p_70050_1_);
    }

    public void func_241841_a(ServerWorld p_241841_1_, LightningBoltEntity p_241841_2_) {
        this.func_241209_g_(this.field_190534_ay + 1);
        if (this.field_190534_ay == 0) {
            this.func_70015_d(8);
        }
        this.func_70097_a(DamageSource.field_180137_b, 5.0f);
    }

    public void func_203002_i(boolean p_203002_1_) {
        Vector3d vector3d = this.func_213322_ci();
        double d0 = p_203002_1_ ? Math.max(-0.9, vector3d.field_72448_b - 0.03) : Math.min(1.8, vector3d.field_72448_b + 0.1);
        this.func_213293_j(vector3d.field_72450_a, d0, vector3d.field_72449_c);
    }

    public void func_203004_j(boolean p_203004_1_) {
        Vector3d vector3d = this.func_213322_ci();
        double d0 = p_203004_1_ ? Math.max(-0.3, vector3d.field_72448_b - 0.03) : Math.min(0.7, vector3d.field_72448_b + 0.06);
        this.func_213293_j(vector3d.field_72450_a, d0, vector3d.field_72449_c);
        this.field_70143_R = 0.0f;
    }

    public void func_241847_a(ServerWorld p_241847_1_, LivingEntity p_241847_2_) {
    }

    protected void func_213282_i(double p_213282_1_, double p_213282_3_, double p_213282_5_) {
        BlockPos blockpos = new BlockPos(p_213282_1_, p_213282_3_, p_213282_5_);
        Vector3d vector3d = new Vector3d(p_213282_1_ - (double)blockpos.func_177958_n(), p_213282_3_ - (double)blockpos.func_177956_o(), p_213282_5_ - (double)blockpos.func_177952_p());
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        Direction direction = Direction.UP;
        double d0 = Double.MAX_VALUE;
        for (Direction direction1 : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double d2;
            blockpos$mutable.func_239622_a_((Vector3i)blockpos, direction1);
            if (this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_235785_r_((IBlockReader)((Object)this.field_70170_p), (BlockPos)blockpos$mutable)) continue;
            double d1 = vector3d.func_216370_a(direction1.func_176740_k());
            double d = d2 = direction1.func_176743_c() == Direction.AxisDirection.POSITIVE ? 1.0 - d1 : d1;
            if (!(d2 < d0)) continue;
            d0 = d2;
            direction = direction1;
        }
        float f = this.field_70146_Z.nextFloat() * 0.2f + 0.1f;
        float f1 = direction.func_176743_c().func_179524_a();
        Vector3d vector3d1 = this.func_213322_ci().func_186678_a(0.75);
        if (direction.func_176740_k() == Direction.Axis.X) {
            this.func_213293_j(f1 * f, vector3d1.field_72448_b, vector3d1.field_72449_c);
        } else if (direction.func_176740_k() == Direction.Axis.Y) {
            this.func_213293_j(vector3d1.field_72450_a, f1 * f, vector3d1.field_72449_c);
        } else if (direction.func_176740_k() == Direction.Axis.Z) {
            this.func_213293_j(vector3d1.field_72450_a, vector3d1.field_72448_b, f1 * f);
        }
    }

    public void func_213295_a(BlockState p_213295_1_, Vector3d p_213295_2_) {
        this.field_70143_R = 0.0f;
        this.field_213328_B = p_213295_2_;
    }

    private static ITextComponent func_233573_b_(ITextComponent p_233573_0_) {
        IFormattableTextComponent iformattabletextcomponent = p_233573_0_.func_230531_f_().func_230530_a_(p_233573_0_.func_150256_b().func_240715_a_(null));
        for (ITextComponent itextcomponent : p_233573_0_.func_150253_a()) {
            iformattabletextcomponent.func_230529_a_(Entity.func_233573_b_(itextcomponent));
        }
        return iformattabletextcomponent;
    }

    public ITextComponent func_200200_C_() {
        ITextComponent itextcomponent = this.func_200201_e();
        return itextcomponent != null ? Entity.func_233573_b_(itextcomponent) : this.func_225513_by_();
    }

    protected ITextComponent func_225513_by_() {
        return this.func_200600_R().func_212546_e();
    }

    public boolean func_70028_i(Entity p_70028_1_) {
        return this == p_70028_1_;
    }

    public float func_70079_am() {
        return 0.0f;
    }

    public void func_70034_d(float p_70034_1_) {
    }

    public void func_181013_g(float p_181013_1_) {
    }

    public boolean func_70075_an() {
        return true;
    }

    public boolean func_85031_j(Entity p_85031_1_) {
        return false;
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", ((Object)((Object)this)).getClass().getSimpleName(), this.func_200200_C_().getString(), this.field_145783_c, this.field_70170_p == null ? "~NULL~" : this.field_70170_p.toString(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    public boolean func_180431_b(DamageSource p_180431_1_) {
        return this.field_83001_bt && p_180431_1_ != DamageSource.field_76380_i && !p_180431_1_.func_180136_u();
    }

    public boolean func_190530_aW() {
        return this.field_83001_bt;
    }

    public void func_184224_h(boolean p_184224_1_) {
        this.field_83001_bt = p_184224_1_;
    }

    public void func_82149_j(Entity p_82149_1_) {
        this.func_70012_b(p_82149_1_.func_226277_ct_(), p_82149_1_.func_226278_cu_(), p_82149_1_.func_226281_cx_(), p_82149_1_.field_70177_z, p_82149_1_.field_70125_A);
    }

    public void func_180432_n(Entity p_180432_1_) {
        CompoundNBT compoundnbt = p_180432_1_.func_189511_e(new CompoundNBT());
        compoundnbt.func_82580_o("Dimension");
        this.func_70020_e(compoundnbt);
        this.field_242273_aw = p_180432_1_.field_242273_aw;
        this.field_242271_ac = p_180432_1_.field_242271_ac;
    }

    @Nullable
    public Entity func_241206_a_(ServerWorld p_241206_1_) {
        return this.changeDimension(p_241206_1_, p_241206_1_.func_85176_s());
    }

    @Nullable
    public Entity changeDimension(ServerWorld p_241206_1_, ITeleporter teleporter) {
        if (this.field_70170_p instanceof ServerWorld && !this.field_70128_L) {
            this.field_70170_p.func_217381_Z().func_76320_a("changeDimension");
            this.func_213319_R();
            this.field_70170_p.func_217381_Z().func_76320_a("reposition");
            PortalInfo portalinfo = teleporter.getPortalInfo(this, p_241206_1_, this::func_241829_a);
            if (portalinfo == null) {
                return null;
            }
            Entity transportedEntity = teleporter.placeEntity(this, (ServerWorld)this.field_70170_p, p_241206_1_, this.field_70177_z, spawnPortal -> {
                this.field_70170_p.func_217381_Z().func_219895_b("reloading");
                Object entity = this.func_200600_R().func_200721_a(p_241206_1_);
                if (entity != null) {
                    ((Entity)((Object)((Object)entity))).func_180432_n(this);
                    ((Entity)((Object)((Object)entity))).func_70012_b(portalinfo.field_222505_a.field_72450_a, portalinfo.field_222505_a.field_72448_b, portalinfo.field_222505_a.field_72449_c, portalinfo.field_242960_c, ((Entity)((Object)((Object)entity))).field_70125_A);
                    ((Entity)((Object)((Object)entity))).func_213317_d(portalinfo.field_222506_b);
                    p_241206_1_.func_217460_e((Entity)((Object)((Object)entity)));
                    if (spawnPortal.booleanValue() && p_241206_1_.func_234923_W_() == World.field_234920_i_) {
                        ServerWorld.func_241121_a_(p_241206_1_);
                    }
                }
                return entity;
            });
            this.func_241204_bJ_();
            this.field_70170_p.func_217381_Z().func_76319_b();
            ((ServerWorld)this.field_70170_p).func_82742_i();
            p_241206_1_.func_82742_i();
            this.field_70170_p.func_217381_Z().func_76319_b();
            return transportedEntity;
        }
        return null;
    }

    protected void func_241204_bJ_() {
        this.field_70128_L = true;
    }

    @Nullable
    protected PortalInfo func_241829_a(ServerWorld p_241829_1_) {
        boolean flag1;
        boolean flag = this.field_70170_p.func_234923_W_() == World.field_234920_i_ && p_241829_1_.func_234923_W_() == World.field_234918_g_;
        boolean bl = flag1 = p_241829_1_.func_234923_W_() == World.field_234920_i_;
        if (!flag && !flag1) {
            boolean flag2;
            boolean bl2 = flag2 = p_241829_1_.func_234923_W_() == World.field_234919_h_;
            if (this.field_70170_p.func_234923_W_() != World.field_234919_h_ && !flag2) {
                return null;
            }
            WorldBorder worldborder = p_241829_1_.func_175723_af();
            double d0 = Math.max(-2.9999872E7, worldborder.func_177726_b() + 16.0);
            double d1 = Math.max(-2.9999872E7, worldborder.func_177736_c() + 16.0);
            double d2 = Math.min(2.9999872E7, worldborder.func_177728_d() - 16.0);
            double d3 = Math.min(2.9999872E7, worldborder.func_177733_e() - 16.0);
            double d4 = DimensionType.func_242715_a((DimensionType)this.field_70170_p.func_230315_m_(), (DimensionType)p_241829_1_.func_230315_m_());
            BlockPos blockpos1 = new BlockPos(MathHelper.func_151237_a((double)(this.func_226277_ct_() * d4), (double)d0, (double)d2), this.func_226278_cu_(), MathHelper.func_151237_a((double)(this.func_226281_cx_() * d4), (double)d1, (double)d3));
            return this.func_241830_a(p_241829_1_, blockpos1, flag2).map(p_242275_2_ -> {
                Vector3d vector3d;
                Direction.Axis direction$axis;
                BlockState blockstate = this.field_70170_p.func_180495_p(this.field_242271_ac);
                if (blockstate.func_235901_b_((Property)BlockStateProperties.field_208199_z)) {
                    direction$axis = (Direction.Axis)((Object)blockstate.func_177229_b((Property)BlockStateProperties.field_208199_z));
                    TeleportationRepositioner.Result teleportationrepositioner$result = TeleportationRepositioner.func_243676_a((BlockPos)this.field_242271_ac, (Direction.Axis)direction$axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p_242276_2_ -> this.field_70170_p.func_180495_p((BlockPos)p_242276_2_) == blockstate);
                    vector3d = this.func_241839_a(direction$axis, teleportationrepositioner$result);
                } else {
                    direction$axis = Direction.Axis.X;
                    vector3d = new Vector3d(0.5, 0.0, 0.0);
                }
                return PortalSize.func_242963_a(p_241829_1_, p_242275_2_, direction$axis, vector3d, this.func_213305_a(this.func_213283_Z()), this.func_213322_ci(), this.field_70177_z, this.field_70125_A);
            }).orElse(null);
        }
        BlockPos blockpos = flag1 ? ServerWorld.field_241108_a_ : p_241829_1_.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, p_241829_1_.func_241135_u_());
        return new PortalInfo(new Vector3d((double)blockpos.func_177958_n() + 0.5, blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5), this.func_213322_ci(), this.field_70177_z, this.field_70125_A);
    }

    protected Vector3d func_241839_a(Direction.Axis p_241839_1_, TeleportationRepositioner.Result p_241839_2_) {
        return PortalSize.func_242973_a(p_241839_2_, p_241839_1_, this.func_213303_ch(), this.func_213305_a(this.func_213283_Z()));
    }

    protected Optional<TeleportationRepositioner.Result> func_241830_a(ServerWorld p_241830_1_, BlockPos p_241830_2_, boolean p_241830_3_) {
        return p_241830_1_.func_85176_s().func_242957_a(p_241830_2_, p_241830_3_);
    }

    public boolean func_184222_aU() {
        return true;
    }

    public float func_180428_a(Explosion p_180428_1_, IBlockReader p_180428_2_, BlockPos p_180428_3_, BlockState p_180428_4_, FluidState p_180428_5_, float p_180428_6_) {
        return p_180428_6_;
    }

    public boolean func_174816_a(Explosion p_174816_1_, IBlockReader p_174816_2_, BlockPos p_174816_3_, BlockState p_174816_4_, float p_174816_5_) {
        return true;
    }

    public int func_82143_as() {
        return 3;
    }

    public boolean func_145773_az() {
        return false;
    }

    public void func_85029_a(CrashReportCategory p_85029_1_) {
        p_85029_1_.func_189529_a("Entity Type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> EntityType.func_200718_a(this.func_200600_R()) + " (" + ((Object)((Object)this)).getClass().getCanonicalName() + ")"));
        p_85029_1_.func_71507_a("Entity ID", this.field_145783_c);
        p_85029_1_.func_189529_a("Entity Name", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.func_200200_C_().getString()));
        p_85029_1_.func_71507_a("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
        p_85029_1_.func_71507_a("Entity's Block location", CrashReportCategory.func_184876_a(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)this.func_226278_cu_()), MathHelper.func_76128_c((double)this.func_226281_cx_())));
        Vector3d vector3d = this.func_213322_ci();
        p_85029_1_.func_71507_a("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c));
        p_85029_1_.func_189529_a("Entity's Passengers", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.func_184188_bt().toString()));
        p_85029_1_.func_189529_a("Entity's Vehicle", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.func_184187_bx().toString()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return this.func_70027_ad() && !this.func_175149_v();
    }

    public void func_184221_a(UUID p_184221_1_) {
        this.field_96093_i = p_184221_1_;
        this.field_189513_ar = this.field_96093_i.toString();
    }

    public UUID func_110124_au() {
        return this.field_96093_i;
    }

    public String func_189512_bd() {
        return this.field_189513_ar;
    }

    public String func_195047_I_() {
        return this.field_189513_ar;
    }

    public boolean func_96092_aw() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static double func_184183_bd() {
        return field_70155_l;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void func_184227_b(double p_184227_0_) {
        field_70155_l = p_184227_0_;
    }

    public ITextComponent func_145748_c_() {
        return ScorePlayerTeam.func_237500_a_((Team)this.func_96124_cp(), (ITextComponent)this.func_200200_C_()).func_240700_a_(p_211516_1_ -> p_211516_1_.func_240716_a_(this.func_174823_aP()).func_240714_a_(this.func_189512_bd()));
    }

    public void func_200203_b(@Nullable ITextComponent p_200203_1_) {
        this.field_70180_af.func_187227_b(field_184242_az, Optional.ofNullable(p_200203_1_));
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.field_70180_af.func_187225_a(field_184242_az).orElse(null);
    }

    public boolean func_145818_k_() {
        return this.field_70180_af.func_187225_a(field_184242_az).isPresent();
    }

    public void func_174805_g(boolean p_174805_1_) {
        this.field_70180_af.func_187227_b(field_184233_aA, p_174805_1_);
    }

    public boolean func_174833_aM() {
        return this.field_70180_af.func_187225_a(field_184233_aA);
    }

    public final void func_223102_j(double p_223102_1_, double p_223102_3_, double p_223102_5_) {
        if (this.field_70170_p instanceof ServerWorld) {
            ChunkPos chunkpos = new ChunkPos(new BlockPos(p_223102_1_, p_223102_3_, p_223102_5_));
            ((ServerWorld)this.field_70170_p).func_72863_F().func_217228_a(TicketType.field_223185_g, chunkpos, 0, this.func_145782_y());
            this.field_70170_p.func_212866_a_(chunkpos.field_77276_a, chunkpos.field_77275_b);
            this.func_70634_a(p_223102_1_, p_223102_3_, p_223102_5_);
        }
    }

    public void func_70634_a(double p_70634_1_, double p_70634_3_, double p_70634_5_) {
        if (this.field_70170_p instanceof ServerWorld) {
            ServerWorld serverworld = (ServerWorld)this.field_70170_p;
            this.func_70012_b(p_70634_1_, p_70634_3_, p_70634_5_, this.field_70177_z, this.field_70125_A);
            this.func_226276_cg_().forEach(p_233565_1_ -> {
                serverworld.func_217464_b((Entity)((Object)p_233565_1_));
                p_233565_1_.field_184237_aG = true;
                for (Entity entity : p_233565_1_.field_184244_h) {
                    p_233565_1_.func_226266_a_(entity, Entity::func_225653_b_);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_94059_bO() {
        return this.func_174833_aM();
    }

    public void func_184206_a(DataParameter<?> p_184206_1_) {
        if (field_213330_X.equals(p_184206_1_)) {
            this.func_213323_x_();
        }
    }

    public void func_213323_x_() {
        EntitySize entitysize = this.field_213325_aI;
        Pose pose = this.func_213283_Z();
        EntitySize entitysize1 = this.func_213305_a(pose);
        EntityEvent.Size sizeEvent = ForgeEventFactory.getEntitySizeForge((Entity)this, (Pose)pose, (EntitySize)entitysize, (EntitySize)entitysize1, (float)this.func_213316_a(pose, entitysize1));
        this.field_213325_aI = entitysize1 = sizeEvent.getNewSize();
        this.field_213326_aJ = sizeEvent.getNewEyeHeight();
        if (entitysize1.field_220315_a < entitysize.field_220315_a) {
            double d0 = (double)entitysize1.field_220315_a / 2.0;
            this.func_174826_a(new AxisAlignedBB(this.func_226277_ct_() - d0, this.func_226278_cu_(), this.func_226281_cx_() - d0, this.func_226277_ct_() + d0, this.func_226278_cu_() + (double)entitysize1.field_220316_b, this.func_226281_cx_() + d0));
        } else {
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)entitysize1.field_220315_a, axisalignedbb.field_72338_b + (double)entitysize1.field_220316_b, axisalignedbb.field_72339_c + (double)entitysize1.field_220315_a));
            if (entitysize1.field_220315_a > entitysize.field_220315_a && !this.field_70148_d && !this.field_70170_p.field_72995_K) {
                float f = entitysize.field_220315_a - entitysize1.field_220315_a;
                this.func_213315_a(MoverType.SELF, new Vector3d(f, 0.0, f));
            }
        }
    }

    public Direction func_174811_aO() {
        return Direction.func_176733_a(this.field_70177_z);
    }

    public Direction func_184172_bi() {
        return this.func_174811_aO();
    }

    protected HoverEvent func_174823_aP() {
        return new HoverEvent(HoverEvent.Action.field_230552_c_, (Object)new HoverEvent.EntityHover(this.func_200600_R(), this.func_110124_au(), this.func_200200_C_()));
    }

    public boolean func_174827_a(ServerPlayerEntity p_174827_1_) {
        return true;
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.field_70121_D;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ();
    }

    protected AxisAlignedBB func_213321_d(Pose p_213321_1_) {
        EntitySize entitysize = this.func_213305_a(p_213321_1_);
        float f = entitysize.field_220315_a / 2.0f;
        Vector3d vector3d = new Vector3d(this.func_226277_ct_() - (double)f, this.func_226278_cu_(), this.func_226281_cx_() - (double)f);
        Vector3d vector3d1 = new Vector3d(this.func_226277_ct_() + (double)f, this.func_226278_cu_() + (double)entitysize.field_220316_b, this.func_226281_cx_() + (double)f);
        return new AxisAlignedBB(vector3d, vector3d1);
    }

    public void func_174826_a(AxisAlignedBB p_174826_1_) {
        this.field_70121_D = p_174826_1_;
    }

    protected float func_213316_a(Pose p_213316_1_, EntitySize p_213316_2_) {
        return p_213316_2_.field_220316_b * 0.85f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_213307_e(Pose p_213307_1_) {
        return this.func_213316_a(p_213307_1_, this.func_213305_a(p_213307_1_));
    }

    public final float func_70047_e() {
        return this.field_213326_aJ;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, this.func_70047_e(), this.func_213311_cf() * 0.4f);
    }

    public boolean func_174820_d(int p_174820_1_, ItemStack p_174820_2_) {
        return false;
    }

    public void func_145747_a(ITextComponent p_145747_1_, UUID p_145747_2_) {
    }

    public World func_130014_f_() {
        return this.field_70170_p;
    }

    @Nullable
    public MinecraftServer func_184102_h() {
        return this.field_70170_p.func_73046_m();
    }

    public ActionResultType func_184199_a(PlayerEntity p_184199_1_, Vector3d p_184199_2_, Hand p_184199_3_) {
        return ActionResultType.PASS;
    }

    public boolean func_180427_aV() {
        return false;
    }

    public void func_174815_a(LivingEntity p_174815_1_, Entity p_174815_2_) {
        if (p_174815_2_ instanceof LivingEntity) {
            EnchantmentHelper.func_151384_a((LivingEntity)p_174815_2_, p_174815_1_);
        }
        EnchantmentHelper.func_151385_b(p_174815_1_, p_174815_2_);
    }

    public void func_184178_b(ServerPlayerEntity p_184178_1_) {
    }

    public void func_184203_c(ServerPlayerEntity p_184203_1_) {
    }

    public float func_184229_a(Rotation p_184229_1_) {
        float f = MathHelper.func_76142_g((float)this.field_70177_z);
        switch (p_184229_1_) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 270.0f;
            }
            case CLOCKWISE_90: {
                return f + 90.0f;
            }
        }
        return f;
    }

    public float func_184217_a(Mirror p_184217_1_) {
        float f = MathHelper.func_76142_g((float)this.field_70177_z);
        switch (p_184217_1_) {
            case LEFT_RIGHT: {
                return -f;
            }
            case FRONT_BACK: {
                return 180.0f - f;
            }
        }
        return f;
    }

    public boolean func_184213_bq() {
        return false;
    }

    public boolean func_233577_ch_() {
        boolean flag = this.field_184237_aG;
        this.field_184237_aG = false;
        return flag;
    }

    public boolean func_233578_ci_() {
        boolean flag = this.field_233555_aA_;
        this.field_233555_aA_ = false;
        return flag;
    }

    @Nullable
    public Entity func_184179_bs() {
        return null;
    }

    public List<Entity> func_184188_bt() {
        return this.field_184244_h.isEmpty() ? Collections.emptyList() : Lists.newArrayList(this.field_184244_h);
    }

    public boolean func_184196_w(Entity p_184196_1_) {
        for (Entity entity : this.func_184188_bt()) {
            if (!entity.equals((Object)p_184196_1_)) continue;
            return true;
        }
        return false;
    }

    public boolean func_205708_a(Class<? extends Entity> p_205708_1_) {
        for (Entity entity : this.func_184188_bt()) {
            if (!p_205708_1_.isAssignableFrom(((Object)((Object)entity)).getClass())) continue;
            return true;
        }
        return false;
    }

    public Collection<Entity> func_184182_bu() {
        HashSet set = Sets.newHashSet();
        for (Entity entity : this.func_184188_bt()) {
            set.add(entity);
            entity.func_200604_a(false, set);
        }
        return set;
    }

    public Stream<Entity> func_226276_cg_() {
        return Stream.concat(Stream.of(this), this.field_184244_h.stream().flatMap(Entity::func_226276_cg_));
    }

    public boolean func_200601_bK() {
        HashSet set = Sets.newHashSet();
        this.func_200604_a(true, set);
        return set.size() == 1;
    }

    private void func_200604_a(boolean p_200604_1_, Set<Entity> p_200604_2_) {
        for (Entity entity : this.func_184188_bt()) {
            if (!p_200604_1_ || ServerPlayerEntity.class.isAssignableFrom(((Object)((Object)entity)).getClass())) {
                p_200604_2_.add(entity);
            }
            entity.func_200604_a(p_200604_1_, p_200604_2_);
        }
    }

    public Entity func_184208_bv() {
        Entity entity = this;
        while (entity.func_184218_aH()) {
            entity = entity.func_184187_bx();
        }
        return entity;
    }

    public boolean func_184223_x(Entity p_184223_1_) {
        return this.func_184208_bv() == p_184223_1_.func_184208_bv();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_184215_y(Entity p_184215_1_) {
        for (Entity entity : this.func_184188_bt()) {
            if (entity.equals((Object)p_184215_1_)) {
                return true;
            }
            if (!entity.func_184215_y(p_184215_1_)) continue;
            return true;
        }
        return false;
    }

    public boolean func_184186_bw() {
        Entity entity = this.func_184179_bs();
        if (entity instanceof PlayerEntity) {
            return ((PlayerEntity)entity).func_175144_cb();
        }
        return !this.field_70170_p.field_72995_K;
    }

    protected static Vector3d func_233559_a_(double p_233559_0_, double p_233559_2_, float p_233559_4_) {
        double d0 = (p_233559_0_ + p_233559_2_ + (double)1.0E-5f) / 2.0;
        float f = -MathHelper.func_76126_a((float)(p_233559_4_ * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(p_233559_4_ * ((float)Math.PI / 180)));
        float f2 = Math.max(Math.abs(f), Math.abs(f1));
        return new Vector3d((double)f * d0 / (double)f2, 0.0, (double)f1 * d0 / (double)f2);
    }

    public Vector3d func_230268_c_(LivingEntity p_230268_1_) {
        return new Vector3d(this.func_226277_ct_(), this.func_174813_aQ().field_72337_e, this.func_226281_cx_());
    }

    @Nullable
    public Entity func_184187_bx() {
        return this.field_184239_as;
    }

    public PushReaction func_184192_z() {
        return PushReaction.NORMAL;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    protected int func_190531_bD() {
        return 1;
    }

    public CommandSource func_195051_bN() {
        return new CommandSource((ICommandSource)this, this.func_213303_ch(), this.func_189653_aC(), this.field_70170_p instanceof ServerWorld ? (ServerWorld)this.field_70170_p : null, this.func_184840_I(), this.func_200200_C_().getString(), this.func_145748_c_(), this.field_70170_p.func_73046_m(), this);
    }

    protected int func_184840_I() {
        return 0;
    }

    public boolean func_211513_k(int p_211513_1_) {
        return this.func_184840_I() >= p_211513_1_;
    }

    public boolean func_195039_a() {
        return this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223611_n);
    }

    public boolean func_195040_b() {
        return true;
    }

    public boolean func_195041_r_() {
        return true;
    }

    public void func_200602_a(EntityAnchorArgument.Type p_200602_1_, Vector3d p_200602_2_) {
        Vector3d vector3d = p_200602_1_.func_201017_a(this);
        double d0 = p_200602_2_.field_72450_a - vector3d.field_72450_a;
        double d1 = p_200602_2_.field_72448_b - vector3d.field_72448_b;
        double d2 = p_200602_2_.field_72449_c - vector3d.field_72449_c;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        this.field_70125_A = MathHelper.func_76142_g((float)((float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875))));
        this.field_70177_z = MathHelper.func_76142_g((float)((float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
        this.func_70034_d(this.field_70177_z);
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
    }

    public boolean func_210500_b(ITag<Fluid> p_210500_1_, double p_210500_2_) {
        int j1;
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186664_h(0.001);
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)axisalignedbb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        if (!this.field_70170_p.func_217344_a(i, k, i1, j, l, j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f))) {
            return false;
        }
        double d0 = 0.0;
        boolean flag = this.func_96092_aw();
        boolean flag1 = false;
        Vector3d vector3d = Vector3d.field_186680_a;
        int k1 = 0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = k; i2 < l; ++i2) {
                for (int j2 = i1; j2 < j1; ++j2) {
                    double d1;
                    blockpos$mutable.func_181079_c(l1, i2, j2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a(p_210500_1_) || !((d1 = (double)((float)i2 + fluidstate.func_215679_a((IBlockReader)((Object)this.field_70170_p), (BlockPos)blockpos$mutable))) >= axisalignedbb.field_72338_b)) continue;
                    flag1 = true;
                    d0 = Math.max(d1 - axisalignedbb.field_72338_b, d0);
                    if (!flag) continue;
                    Vector3d vector3d1 = fluidstate.func_215673_c((IBlockReader)((Object)this.field_70170_p), (BlockPos)blockpos$mutable);
                    if (d0 < 0.4) {
                        vector3d1 = vector3d1.func_186678_a(d0);
                    }
                    vector3d = vector3d.func_178787_e(vector3d1);
                    ++k1;
                }
            }
        }
        if (vector3d.func_72433_c() > 0.0) {
            if (k1 > 0) {
                vector3d = vector3d.func_186678_a(1.0 / (double)k1);
            }
            if (!(this instanceof PlayerEntity)) {
                vector3d = vector3d.func_72432_b();
            }
            Vector3d vector3d2 = this.func_213322_ci();
            vector3d = vector3d.func_186678_a(p_210500_2_ * 1.0);
            double d2 = 0.003;
            if (Math.abs(vector3d2.field_72450_a) < 0.003 && Math.abs(vector3d2.field_72449_c) < 0.003 && vector3d.func_72433_c() < 0.0045000000000000005) {
                vector3d = vector3d.func_72432_b().func_186678_a(0.0045000000000000005);
            }
            this.func_213317_d(this.func_213322_ci().func_178787_e(vector3d));
        }
        this.field_233554_M_.put(p_210500_1_, d0);
        return flag1;
    }

    public double func_233571_b_(ITag<Fluid> p_233571_1_) {
        return this.field_233554_M_.getDouble(p_233571_1_);
    }

    public double func_233579_cu_() {
        return (double)this.func_70047_e() < 0.4 ? 0.0 : 0.4;
    }

    public final float func_213311_cf() {
        return this.field_213325_aI.field_220315_a;
    }

    public final float func_213302_cg() {
        return this.field_213325_aI.field_220316_b;
    }

    public abstract IPacket<?> func_213297_N();

    public EntitySize func_213305_a(Pose p_213305_1_) {
        return this.field_200606_g.func_220334_j();
    }

    public Vector3d func_213303_ch() {
        return this.field_233557_ao_;
    }

    public BlockPos func_233580_cy_() {
        return this.field_233558_ap_;
    }

    public Vector3d func_213322_ci() {
        return this.field_213327_at;
    }

    public void func_213317_d(Vector3d p_213317_1_) {
        this.field_213327_at = p_213317_1_;
    }

    public void func_213293_j(double p_213293_1_, double p_213293_3_, double p_213293_5_) {
        this.func_213317_d(new Vector3d(p_213293_1_, p_213293_3_, p_213293_5_));
    }

    public final double func_226277_ct_() {
        return this.field_233557_ao_.field_72450_a;
    }

    public double func_226275_c_(double p_226275_1_) {
        return this.field_233557_ao_.field_72450_a + (double)this.func_213311_cf() * p_226275_1_;
    }

    public double func_226282_d_(double p_226282_1_) {
        return this.func_226275_c_((2.0 * this.field_70146_Z.nextDouble() - 1.0) * p_226282_1_);
    }

    public final double func_226278_cu_() {
        return this.field_233557_ao_.field_72448_b;
    }

    public double func_226283_e_(double p_226283_1_) {
        return this.field_233557_ao_.field_72448_b + (double)this.func_213302_cg() * p_226283_1_;
    }

    public double func_226279_cv_() {
        return this.func_226283_e_(this.field_70146_Z.nextDouble());
    }

    public double func_226280_cw_() {
        return this.field_233557_ao_.field_72448_b + (double)this.field_213326_aJ;
    }

    public final double func_226281_cx_() {
        return this.field_233557_ao_.field_72449_c;
    }

    public double func_226285_f_(double p_226285_1_) {
        return this.field_233557_ao_.field_72449_c + (double)this.func_213311_cf() * p_226285_1_;
    }

    public double func_226287_g_(double p_226287_1_) {
        return this.func_226285_f_((2.0 * this.field_70146_Z.nextDouble() - 1.0) * p_226287_1_);
    }

    public void func_226288_n_(double p_226288_1_, double p_226288_3_, double p_226288_5_) {
        if (this.field_233557_ao_.field_72450_a != p_226288_1_ || this.field_233557_ao_.field_72448_b != p_226288_3_ || this.field_233557_ao_.field_72449_c != p_226288_5_) {
            this.field_233557_ao_ = new Vector3d(p_226288_1_, p_226288_3_, p_226288_5_);
            int i = MathHelper.func_76128_c((double)p_226288_1_);
            int j = MathHelper.func_76128_c((double)p_226288_3_);
            int k = MathHelper.func_76128_c((double)p_226288_5_);
            if (i != this.field_233558_ap_.func_177958_n() || j != this.field_233558_ap_.func_177956_o() || k != this.field_233558_ap_.func_177952_p()) {
                this.field_233558_ap_ = new BlockPos(i, j, k);
            }
            this.field_233555_aA_ = true;
        }
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.field_70170_p.func_212866_a_((int)Math.floor(p_226288_1_) >> 4, (int)Math.floor(p_226288_5_) >> 4);
        }
    }

    public void func_70623_bb() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241843_o(float p_241843_1_) {
        return this.func_242282_l(p_241843_1_).func_72441_c(0.0, (double)this.field_213326_aJ * 0.7, 0.0);
    }

    public void canUpdate(boolean value) {
        this.canUpdate = value;
    }

    public boolean canUpdate() {
        return this.canUpdate;
    }

    public Collection<ItemEntity> captureDrops() {
        return this.captureDrops;
    }

    public Collection<ItemEntity> captureDrops(Collection<ItemEntity> value) {
        Collection<ItemEntity> ret = this.captureDrops;
        this.captureDrops = value;
        return ret;
    }

    public CompoundNBT getPersistentData() {
        if (this.persistentData == null) {
            this.persistentData = new CompoundNBT();
        }
        return this.persistentData;
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return this.field_70170_p.field_73012_v.nextFloat() < fallDistance - 0.5f && this instanceof LivingEntity && (this instanceof PlayerEntity || ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) && this.func_213311_cf() * this.func_213311_cf() * this.func_213302_cg() > 0.512f;
    }

    public final boolean isAddedToWorld() {
        return this.isAddedToWorld;
    }

    public void onAddedToWorld() {
        this.isAddedToWorld = true;
    }

    public void onRemovedFromWorld() {
        this.isAddedToWorld = false;
    }

    public void revive() {
        this.field_70128_L = false;
        this.reviveCaps();
    }

    public float getEyeHeightAccess(Pose pose, EntitySize size) {
        return this.func_213316_a(pose, size);
    }

    @FunctionalInterface
    public static interface IMoveCallback {
        public void accept(Entity var1, double var2, double var4, double var6);
    }
}

