/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IStructureReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import org.apache.logging.log4j.LogManager;

public interface IChunk
extends IBlockReader,
IStructureReader {
    @Nullable
    public BlockState func_177436_a(BlockPos var1, BlockState var2, boolean var3);

    public void func_177426_a(BlockPos var1, TileEntity var2);

    public void func_76612_a(Entity var1);

    @Nullable
    default public ChunkSection func_186031_y() {
        ChunkSection[] achunksection = this.func_76587_i();
        for (int i = achunksection.length - 1; i >= 0; --i) {
            ChunkSection chunksection = achunksection[i];
            if (ChunkSection.func_222628_a((ChunkSection)chunksection)) continue;
            return chunksection;
        }
        return null;
    }

    default public int func_76625_h() {
        ChunkSection chunksection = this.func_186031_y();
        return chunksection == null ? 0 : chunksection.func_222632_g();
    }

    public Set<BlockPos> func_203066_o();

    public ChunkSection[] func_76587_i();

    public Collection<Map.Entry<Heightmap.Type, Heightmap>> func_217311_f();

    public void func_201607_a(Heightmap.Type var1, long[] var2);

    public Heightmap func_217303_b(Heightmap.Type var1);

    public int func_201576_a(Heightmap.Type var1, int var2, int var3);

    public ChunkPos func_76632_l();

    public void func_177432_b(long var1);

    public Map<Structure<?>, StructureStart<?>> func_201609_c();

    public void func_201612_a(Map<Structure<?>, StructureStart<?>> var1);

    default public boolean func_76606_c(int startY, int endY) {
        if (startY < 0) {
            startY = 0;
        }
        if (endY >= 256) {
            endY = 255;
        }
        for (int i = startY; i <= endY; i += 16) {
            if (ChunkSection.func_222628_a((ChunkSection)this.func_76587_i()[i >> 4])) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public BiomeContainer func_225549_i_();

    public void func_177427_f(boolean var1);

    public boolean func_201593_f();

    public ChunkStatus func_201589_g();

    public void func_177425_e(BlockPos var1);

    default public void func_201594_d(BlockPos pos) {
        LogManager.getLogger().warn("Trying to mark a block for PostProcessing @ {}, but this operation is not supported.", (Object)pos);
    }

    public ShortList[] func_201614_D();

    default public void func_201636_b(short packedPosition, int index) {
        IChunk.func_217308_a(this.func_201614_D(), index).add(packedPosition);
    }

    default public void func_201591_a(CompoundNBT nbt) {
        LogManager.getLogger().warn("Trying to set a BlockEntity, but this operation is not supported.");
    }

    @Nullable
    public CompoundNBT func_201579_g(BlockPos var1);

    @Nullable
    public CompoundNBT func_223134_j(BlockPos var1);

    public Stream<BlockPos> func_217304_m();

    public ITickList<Block> func_205218_i_();

    public ITickList<Fluid> func_212247_j();

    public UpgradeData func_196966_y();

    public void func_177415_c(long var1);

    public long func_177416_w();

    public static ShortList func_217308_a(ShortList[] packedPositions, int index) {
        if (packedPositions[index] == null) {
            packedPositions[index] = new ShortArrayList();
        }
        return packedPositions[index];
    }

    public boolean func_217310_r();

    public void func_217305_b(boolean var1);

    @Nullable
    default public IWorld getWorldForge() {
        return null;
    }
}

