/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import org.apache.commons.lang3.tuple.Pair;

public enum BannerPattern {
    BASE("base", "b", false),
    SQUARE_BOTTOM_LEFT("square_bottom_left", "bl"),
    SQUARE_BOTTOM_RIGHT("square_bottom_right", "br"),
    SQUARE_TOP_LEFT("square_top_left", "tl"),
    SQUARE_TOP_RIGHT("square_top_right", "tr"),
    STRIPE_BOTTOM("stripe_bottom", "bs"),
    STRIPE_TOP("stripe_top", "ts"),
    STRIPE_LEFT("stripe_left", "ls"),
    STRIPE_RIGHT("stripe_right", "rs"),
    STRIPE_CENTER("stripe_center", "cs"),
    STRIPE_MIDDLE("stripe_middle", "ms"),
    STRIPE_DOWNRIGHT("stripe_downright", "drs"),
    STRIPE_DOWNLEFT("stripe_downleft", "dls"),
    STRIPE_SMALL("small_stripes", "ss"),
    CROSS("cross", "cr"),
    STRAIGHT_CROSS("straight_cross", "sc"),
    TRIANGLE_BOTTOM("triangle_bottom", "bt"),
    TRIANGLE_TOP("triangle_top", "tt"),
    TRIANGLES_BOTTOM("triangles_bottom", "bts"),
    TRIANGLES_TOP("triangles_top", "tts"),
    DIAGONAL_LEFT("diagonal_left", "ld"),
    DIAGONAL_RIGHT("diagonal_up_right", "rd"),
    DIAGONAL_LEFT_MIRROR("diagonal_up_left", "lud"),
    DIAGONAL_RIGHT_MIRROR("diagonal_right", "rud"),
    CIRCLE_MIDDLE("circle", "mc"),
    RHOMBUS_MIDDLE("rhombus", "mr"),
    HALF_VERTICAL("half_vertical", "vh"),
    HALF_HORIZONTAL("half_horizontal", "hh"),
    HALF_VERTICAL_MIRROR("half_vertical_right", "vhr"),
    HALF_HORIZONTAL_MIRROR("half_horizontal_bottom", "hhb"),
    BORDER("border", "bo"),
    CURLY_BORDER("curly_border", "cbo"),
    GRADIENT("gradient", "gra"),
    GRADIENT_UP("gradient_up", "gru"),
    BRICKS("bricks", "bri"),
    GLOBE("globe", "glb", true),
    CREEPER("creeper", "cre", true),
    SKULL("skull", "sku", true),
    FLOWER("flower", "flo", true),
    MOJANG("mojang", "moj", true),
    PIGLIN("piglin", "pig", true);

    private static final BannerPattern[] field_235647_S_;
    public static final int field_222480_O;
    public static final int field_235646_Q_;
    public static final int field_222481_P;
    private final boolean field_235648_T_;
    private final String field_191014_N;
    private final String field_191015_O;

    private BannerPattern(String string2, String string3) {
        this(string2, string3, false);
    }

    private BannerPattern(String string2, String string3, boolean bl) {
        this.field_191014_N = string2;
        this.field_191015_O = string3;
        this.field_235648_T_ = bl;
    }

    public String func_190993_b() {
        return this.field_191015_O;
    }

    static {
        field_235647_S_ = BannerPattern.values();
        field_222480_O = field_235647_S_.length;
        field_235646_Q_ = (int)Arrays.stream(field_235647_S_).filter(bannerPattern -> bannerPattern.field_235648_T_).count();
        field_222481_P = field_222480_O - field_235646_Q_ - 1;
    }

    public static class Builder {
        private final List<Pair<BannerPattern, DyeColor>> field_222478_a = Lists.newArrayList();

        public Builder func_222477_a(BannerPattern bannerPattern, DyeColor dyeColor) {
            this.field_222478_a.add((Pair<BannerPattern, DyeColor>)Pair.of((Object)((Object)bannerPattern), (Object)dyeColor));
            return this;
        }

        public ListNBT func_222476_a() {
            ListNBT listNBT = new ListNBT();
            for (Pair<BannerPattern, DyeColor> pair : this.field_222478_a) {
                CompoundNBT compoundNBT = new CompoundNBT();
                compoundNBT.func_74778_a("Pattern", ((BannerPattern)((Object)pair.getLeft())).field_191015_O);
                compoundNBT.func_74768_a("Color", ((DyeColor)pair.getRight()).func_196059_a());
                listNBT.add(compoundNBT);
            }
            return listNBT;
        }
    }
}

