/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.test;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LecternBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.test.ITestCallback;
import net.minecraft.test.ITestLogger;
import net.minecraft.test.StructureHelper;
import net.minecraft.test.TestBatch;
import net.minecraft.test.TestBlockPosException;
import net.minecraft.test.TestCollection;
import net.minecraft.test.TestExecutor;
import net.minecraft.test.TestFunctionInfo;
import net.minecraft.test.TestLogger;
import net.minecraft.test.TestRegistry;
import net.minecraft.test.TestTracker;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.mutable.MutableInt;

public class TestUtils {
    public static ITestLogger field_229539_a_ = new TestLogger();

    public static void func_240553_a_(TestTracker testTracker, BlockPos blockPos, TestCollection testCollection) {
        testTracker.func_229501_a_();
        testCollection.func_229573_a_(testTracker);
        testTracker.func_229504_a_(new ITestCallback(){

            @Override
            public void func_225644_a_(TestTracker testTracker) {
                TestUtils.func_229559_b_(testTracker, Blocks.field_196816_gr);
            }

            @Override
            public void func_225645_c_(TestTracker testTracker) {
                TestUtils.func_229559_b_(testTracker, testTracker.func_229520_q_() ? Blocks.field_196823_gx : Blocks.field_196808_gk);
                TestUtils.func_229560_b_(testTracker, Util.func_229758_d_(testTracker.func_229519_n_()));
                TestUtils.func_229563_c_(testTracker);
            }
        });
        testTracker.func_240543_a_(blockPos, 2);
    }

    public static Collection<TestTracker> func_240552_a_(Collection<TestBatch> collection, BlockPos blockPos, Rotation rotation, ServerWorld serverWorld, TestCollection testCollection, int n) {
        TestExecutor testExecutor = new TestExecutor(collection, blockPos, rotation, serverWorld, testCollection, n);
        testExecutor.func_229482_b_();
        return testExecutor.func_229476_a_();
    }

    public static Collection<TestTracker> func_240554_b_(Collection<TestFunctionInfo> collection, BlockPos blockPos, Rotation rotation, ServerWorld serverWorld, TestCollection testCollection, int n) {
        return TestUtils.func_240552_a_(TestUtils.func_229548_a_(collection), blockPos, rotation, serverWorld, testCollection, n);
    }

    public static Collection<TestBatch> func_229548_a_(Collection<TestFunctionInfo> collection) {
        HashMap hashMap = Maps.newHashMap();
        collection.forEach(testFunctionInfo -> {
            String string2 = testFunctionInfo.func_229662_e_();
            Collection \u26032 = hashMap.computeIfAbsent(string2, string -> Lists.newArrayList());
            \u26032.add(testFunctionInfo);
        });
        return hashMap.keySet().stream().flatMap(string -> {
            Collection collection = (Collection)hashMap.get(string);
            Consumer<ServerWorld> \u26032 = TestRegistry.func_229536_c_(string);
            MutableInt \u26033 = new MutableInt();
            return Streams.stream((Iterable)Iterables.partition((Iterable)collection, (int)100)).map(list -> new TestBatch(string + ":" + \u26033.incrementAndGet(), collection, \u26032));
        }).collect(Collectors.toList());
    }

    private static void func_229563_c_(TestTracker testTracker2) {
        TestTracker testTracker2;
        Throwable throwable = testTracker2.func_229519_n_();
        String \u26032 = (testTracker2.func_229520_q_() ? "" : "(optional) ") + testTracker2.func_229510_c_() + " failed! " + Util.func_229758_d_(throwable);
        TestUtils.func_229556_a_(testTracker2.func_229514_g_(), testTracker2.func_229520_q_() ? TextFormatting.RED : TextFormatting.YELLOW, \u26032);
        if (throwable instanceof TestBlockPosException) {
            TestBlockPosException testBlockPosException = (TestBlockPosException)throwable;
            TestUtils.func_229554_a_(testTracker2.func_229514_g_(), testBlockPosException.func_229459_c_(), testBlockPosException.func_229458_a_());
        }
        field_229539_a_.func_225646_a_(testTracker2);
    }

    private static void func_229559_b_(TestTracker testTracker, Block block) {
        ServerWorld serverWorld = testTracker.func_229514_g_();
        BlockPos \u26032 = testTracker.func_229512_d_();
        BlockPos \u26033 = new BlockPos(-1, -1, -1);
        BlockPos \u26034 = Template.func_207669_a(\u26032.func_177971_a(\u26033), Mirror.NONE, testTracker.func_240545_t_(), \u26032);
        serverWorld.func_175656_a(\u26034, Blocks.field_150461_bJ.func_176223_P().func_185907_a(testTracker.func_240545_t_()));
        BlockPos \u26035 = \u26034.func_177982_a(0, 1, 0);
        serverWorld.func_175656_a(\u26035, block.func_176223_P());
        for (int i = -1; i <= 1; ++i) {
            for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                BlockPos blockPos = \u26034.func_177982_a(i, -1, \u2603);
                serverWorld.func_175656_a(blockPos, Blocks.field_150339_S.func_176223_P());
            }
        }
    }

    private static void func_229560_b_(TestTracker testTracker, String string) {
        ServerWorld serverWorld = testTracker.func_229514_g_();
        BlockPos \u26032 = testTracker.func_229512_d_();
        BlockPos \u26033 = new BlockPos(-1, 1, -1);
        BlockPos \u26034 = Template.func_207669_a(\u26032.func_177971_a(\u26033), Mirror.NONE, testTracker.func_240545_t_(), \u26032);
        serverWorld.func_175656_a(\u26034, Blocks.field_222428_lQ.func_176223_P().func_185907_a(testTracker.func_240545_t_()));
        BlockState \u26035 = serverWorld.func_180495_p(\u26034);
        ItemStack \u26036 = TestUtils.func_229546_a_(testTracker.func_229510_c_(), testTracker.func_229520_q_(), string);
        LecternBlock.func_220151_a(serverWorld, \u26034, \u26035, \u26036);
    }

    private static ItemStack func_229546_a_(String string2, boolean bl, String string3) {
        ItemStack itemStack = new ItemStack(Items.field_151099_bA);
        ListNBT \u26032 = new ListNBT();
        StringBuffer \u26033 = new StringBuffer();
        Arrays.stream(string2.split("\\.")).forEach(string -> \u26033.append((String)string).append('\n'));
        if (!bl) {
            \u26033.append("(optional)\n");
        }
        \u26033.append("-------------------\n");
        \u26032.add(StringNBT.func_229705_a_(\u26033.toString() + string3));
        itemStack.func_77983_a("pages", \u26032);
        return itemStack;
    }

    private static void func_229556_a_(ServerWorld serverWorld, TextFormatting textFormatting, String string) {
        serverWorld.func_217490_a(serverPlayerEntity -> true).forEach(serverPlayerEntity -> serverPlayerEntity.func_145747_a(new StringTextComponent(string).func_240699_a_(textFormatting), Util.field_240973_b_));
    }

    public static void func_229552_a_(ServerWorld serverWorld) {
        DebugPacketSender.func_229751_a_(serverWorld);
    }

    private static void func_229554_a_(ServerWorld serverWorld, BlockPos blockPos, String string) {
        DebugPacketSender.func_229752_a_(serverWorld, blockPos, string, -2130771968, Integer.MAX_VALUE);
    }

    public static void func_229555_a_(ServerWorld serverWorld, BlockPos blockPos2, TestCollection testCollection, int n) {
        testCollection.func_229572_a_();
        BlockPos blockPos3 = blockPos2.func_177982_a(-n, 0, -n);
        \u2603 = blockPos2.func_177982_a(n, 0, n);
        BlockPos.func_218281_b(blockPos3, \u2603).filter(blockPos -> serverWorld.func_180495_p((BlockPos)blockPos).func_203425_a(Blocks.field_185779_df)).forEach(blockPos -> {
            StructureBlockTileEntity structureBlockTileEntity = (StructureBlockTileEntity)serverWorld.func_175625_s((BlockPos)blockPos);
            BlockPos \u26032 = structureBlockTileEntity.func_174877_v();
            MutableBoundingBox \u26033 = StructureHelper.func_240568_b_(structureBlockTileEntity);
            StructureHelper.func_229595_a_(\u26033, \u26032.func_177956_o(), serverWorld);
        });
    }
}

